package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceListBuilder extends ServiceListFluentImpl<ServiceListBuilder> implements VisitableBuilder<ServiceList,io.fabric8.kubernetes.api.model.ServiceListBuilder>{
  public ServiceListBuilder() {
    this(false);
  }
  public ServiceListBuilder(Boolean validationEnabled) {
    this(new ServiceList(), validationEnabled);
  }
  public ServiceListBuilder(io.fabric8.kubernetes.api.model.ServiceListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceListBuilder(io.fabric8.kubernetes.api.model.ServiceListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceList(), validationEnabled);
  }
  public ServiceListBuilder(io.fabric8.kubernetes.api.model.ServiceListFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceList instance) {
    this(fluent, instance, false);
  }
  public ServiceListBuilder(io.fabric8.kubernetes.api.model.ServiceListFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceListBuilder(io.fabric8.kubernetes.api.model.ServiceList instance) {
    this(instance,false);
  }
  public ServiceListBuilder(io.fabric8.kubernetes.api.model.ServiceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ServiceListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ServiceList build() {
    ServiceList buildable = new ServiceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}