package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceReferenceBuilder extends ServiceReferenceFluentImpl<ServiceReferenceBuilder> implements VisitableBuilder<ServiceReference,io.fabric8.kubernetes.api.model.ServiceReferenceBuilder>{
  public ServiceReferenceBuilder() {
    this(false);
  }
  public ServiceReferenceBuilder(Boolean validationEnabled) {
    this(new ServiceReference(), validationEnabled);
  }
  public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.ServiceReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.ServiceReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceReference(), validationEnabled);
  }
  public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.ServiceReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceReference instance) {
    this(fluent, instance, false);
  }
  public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.ServiceReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withPort(instance.getPort()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.ServiceReference instance) {
    this(instance,false);
  }
  public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.ServiceReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPort(instance.getPort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ServiceReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ServiceReference build() {
    ServiceReference buildable = new ServiceReference(fluent.getName(),fluent.getNamespace(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}