package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ServiceSpecFluent<A extends ServiceSpecFluent<A>> extends Fluent<A>{
  public Boolean getAllocateLoadBalancerNodePorts();
  public A withAllocateLoadBalancerNodePorts(java.lang.Boolean allocateLoadBalancerNodePorts);
  public java.lang.Boolean hasAllocateLoadBalancerNodePorts();
  public String getClusterIP();
  public A withClusterIP(java.lang.String clusterIP);
  public java.lang.Boolean hasClusterIP();
  public A addToClusterIPs(Integer index,java.lang.String item);
  public A setToClusterIPs(java.lang.Integer index,java.lang.String item);
  public A addToClusterIPs(java.lang.String... items);
  public A addAllToClusterIPs(Collection<java.lang.String> items);
  public A removeFromClusterIPs(java.lang.String... items);
  public A removeAllFromClusterIPs(java.util.Collection<java.lang.String> items);
  public List<java.lang.String> getClusterIPs();
  public java.lang.String getClusterIP(java.lang.Integer index);
  public java.lang.String getFirstClusterIP();
  public java.lang.String getLastClusterIP();
  public java.lang.String getMatchingClusterIP(Predicate<java.lang.String> predicate);
  public java.lang.Boolean hasMatchingClusterIP(java.util.function.Predicate<java.lang.String> predicate);
  public A withClusterIPs(java.util.List<java.lang.String> clusterIPs);
  public A withClusterIPs(java.lang.String... clusterIPs);
  public java.lang.Boolean hasClusterIPs();
  public A addToExternalIPs(java.lang.Integer index,java.lang.String item);
  public A setToExternalIPs(java.lang.Integer index,java.lang.String item);
  public A addToExternalIPs(java.lang.String... items);
  public A addAllToExternalIPs(java.util.Collection<java.lang.String> items);
  public A removeFromExternalIPs(java.lang.String... items);
  public A removeAllFromExternalIPs(java.util.Collection<java.lang.String> items);
  public java.util.List<java.lang.String> getExternalIPs();
  public java.lang.String getExternalIP(java.lang.Integer index);
  public java.lang.String getFirstExternalIP();
  public java.lang.String getLastExternalIP();
  public java.lang.String getMatchingExternalIP(java.util.function.Predicate<java.lang.String> predicate);
  public java.lang.Boolean hasMatchingExternalIP(java.util.function.Predicate<java.lang.String> predicate);
  public A withExternalIPs(java.util.List<java.lang.String> externalIPs);
  public A withExternalIPs(java.lang.String... externalIPs);
  public java.lang.Boolean hasExternalIPs();
  public java.lang.String getExternalName();
  public A withExternalName(java.lang.String externalName);
  public java.lang.Boolean hasExternalName();
  public java.lang.String getExternalTrafficPolicy();
  public A withExternalTrafficPolicy(java.lang.String externalTrafficPolicy);
  public java.lang.Boolean hasExternalTrafficPolicy();
  public java.lang.Integer getHealthCheckNodePort();
  public A withHealthCheckNodePort(java.lang.Integer healthCheckNodePort);
  public java.lang.Boolean hasHealthCheckNodePort();
  public java.lang.String getInternalTrafficPolicy();
  public A withInternalTrafficPolicy(java.lang.String internalTrafficPolicy);
  public java.lang.Boolean hasInternalTrafficPolicy();
  public A addToIpFamilies(java.lang.Integer index,java.lang.String item);
  public A setToIpFamilies(java.lang.Integer index,java.lang.String item);
  public A addToIpFamilies(java.lang.String... items);
  public A addAllToIpFamilies(java.util.Collection<java.lang.String> items);
  public A removeFromIpFamilies(java.lang.String... items);
  public A removeAllFromIpFamilies(java.util.Collection<java.lang.String> items);
  public java.util.List<java.lang.String> getIpFamilies();
  public java.lang.String getIpFamily(java.lang.Integer index);
  public java.lang.String getFirstIpFamily();
  public java.lang.String getLastIpFamily();
  public java.lang.String getMatchingIpFamily(java.util.function.Predicate<java.lang.String> predicate);
  public java.lang.Boolean hasMatchingIpFamily(java.util.function.Predicate<java.lang.String> predicate);
  public A withIpFamilies(java.util.List<java.lang.String> ipFamilies);
  public A withIpFamilies(java.lang.String... ipFamilies);
  public java.lang.Boolean hasIpFamilies();
  public java.lang.String getIpFamilyPolicy();
  public A withIpFamilyPolicy(java.lang.String ipFamilyPolicy);
  public java.lang.Boolean hasIpFamilyPolicy();
  public java.lang.String getLoadBalancerClass();
  public A withLoadBalancerClass(java.lang.String loadBalancerClass);
  public java.lang.Boolean hasLoadBalancerClass();
  public java.lang.String getLoadBalancerIP();
  public A withLoadBalancerIP(java.lang.String loadBalancerIP);
  public java.lang.Boolean hasLoadBalancerIP();
  public A addToLoadBalancerSourceRanges(java.lang.Integer index,java.lang.String item);
  public A setToLoadBalancerSourceRanges(java.lang.Integer index,java.lang.String item);
  public A addToLoadBalancerSourceRanges(java.lang.String... items);
  public A addAllToLoadBalancerSourceRanges(java.util.Collection<java.lang.String> items);
  public A removeFromLoadBalancerSourceRanges(java.lang.String... items);
  public A removeAllFromLoadBalancerSourceRanges(java.util.Collection<java.lang.String> items);
  public java.util.List<java.lang.String> getLoadBalancerSourceRanges();
  public java.lang.String getLoadBalancerSourceRange(java.lang.Integer index);
  public java.lang.String getFirstLoadBalancerSourceRange();
  public java.lang.String getLastLoadBalancerSourceRange();
  public java.lang.String getMatchingLoadBalancerSourceRange(java.util.function.Predicate<java.lang.String> predicate);
  public java.lang.Boolean hasMatchingLoadBalancerSourceRange(java.util.function.Predicate<java.lang.String> predicate);
  public A withLoadBalancerSourceRanges(java.util.List<java.lang.String> loadBalancerSourceRanges);
  public A withLoadBalancerSourceRanges(java.lang.String... loadBalancerSourceRanges);
  public java.lang.Boolean hasLoadBalancerSourceRanges();
  public A addToPorts(java.lang.Integer index,ServicePort item);
  public A setToPorts(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServicePort item);
  public A addToPorts(io.fabric8.kubernetes.api.model.ServicePort... items);
  public A addAllToPorts(java.util.Collection<io.fabric8.kubernetes.api.model.ServicePort> items);
  public A removeFromPorts(io.fabric8.kubernetes.api.model.ServicePort... items);
  public A removeAllFromPorts(java.util.Collection<io.fabric8.kubernetes.api.model.ServicePort> items);
  public A removeMatchingFromPorts(java.util.function.Predicate<ServicePortBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPorts instead.
   * @return The buildable object.
   */
  @Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.ServicePort> getPorts();
  public java.util.List<io.fabric8.kubernetes.api.model.ServicePort> buildPorts();
  public io.fabric8.kubernetes.api.model.ServicePort buildPort(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.ServicePort buildFirstPort();
  public io.fabric8.kubernetes.api.model.ServicePort buildLastPort();
  public io.fabric8.kubernetes.api.model.ServicePort buildMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ServicePortBuilder> predicate);
  public java.lang.Boolean hasMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ServicePortBuilder> predicate);
  public A withPorts(java.util.List<io.fabric8.kubernetes.api.model.ServicePort> ports);
  public A withPorts(io.fabric8.kubernetes.api.model.ServicePort... ports);
  public java.lang.Boolean hasPorts();
  public ServiceSpecFluent.PortsNested<A> addNewPort();
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> addNewPortLike(io.fabric8.kubernetes.api.model.ServicePort item);
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> setNewPortLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServicePort item);
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> editPort(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> editFirstPort();
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> editLastPort();
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> editMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ServicePortBuilder> predicate);
  public java.lang.Boolean getPublishNotReadyAddresses();
  public A withPublishNotReadyAddresses(java.lang.Boolean publishNotReadyAddresses);
  public java.lang.Boolean hasPublishNotReadyAddresses();
  public A addToSelector(java.lang.String key,java.lang.String value);
  public A addToSelector(Map<java.lang.String,java.lang.String> map);
  public A removeFromSelector(java.lang.String key);
  public A removeFromSelector(java.util.Map<java.lang.String,java.lang.String> map);
  public java.util.Map<java.lang.String,java.lang.String> getSelector();
  public <K,V>A withSelector(java.util.Map<java.lang.String,java.lang.String> selector);
  public java.lang.Boolean hasSelector();
  public java.lang.String getSessionAffinity();
  public A withSessionAffinity(java.lang.String sessionAffinity);
  public java.lang.Boolean hasSessionAffinity();
  
  /**
   * This method has been deprecated, please use method buildSessionAffinityConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public SessionAffinityConfig getSessionAffinityConfig();
  public io.fabric8.kubernetes.api.model.SessionAffinityConfig buildSessionAffinityConfig();
  public A withSessionAffinityConfig(io.fabric8.kubernetes.api.model.SessionAffinityConfig sessionAffinityConfig);
  public java.lang.Boolean hasSessionAffinityConfig();
  public ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfig();
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfigLike(io.fabric8.kubernetes.api.model.SessionAffinityConfig item);
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.SessionAffinityConfigNested<A> editSessionAffinityConfig();
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfig();
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfigLike(io.fabric8.kubernetes.api.model.SessionAffinityConfig item);
  public java.lang.String getType();
  public A withType(java.lang.String type);
  public java.lang.Boolean hasType();
  public A addToAdditionalProperties(java.lang.String key,Object value);
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map);
  public A removeFromAdditionalProperties(java.lang.String key);
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map);
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties);
  public java.lang.Boolean hasAdditionalProperties();
  public A withAllocateLoadBalancerNodePorts();
  public A withPublishNotReadyAddresses();
  public interface PortsNested<N> extends Nested<N>,ServicePortFluent<ServiceSpecFluent.PortsNested<N>>{
    public N and();
    public N endPort();
    
  }
  public interface SessionAffinityConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SessionAffinityConfigFluent<ServiceSpecFluent.SessionAffinityConfigNested<N>>{
    public N and();
    public N endSessionAffinityConfig();
    
  }
  
}