package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceSpecFluentImpl<A extends ServiceSpecFluent<A>> extends BaseFluent<A> implements ServiceSpecFluent<A>{
  public ServiceSpecFluentImpl() {
  }
  public ServiceSpecFluentImpl(io.fabric8.kubernetes.api.model.ServiceSpec instance) {
    this.withAllocateLoadBalancerNodePorts(instance.getAllocateLoadBalancerNodePorts()); 
    this.withClusterIP(instance.getClusterIP()); 
    this.withClusterIPs(instance.getClusterIPs()); 
    this.withExternalIPs(instance.getExternalIPs()); 
    this.withExternalName(instance.getExternalName()); 
    this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy()); 
    this.withHealthCheckNodePort(instance.getHealthCheckNodePort()); 
    this.withInternalTrafficPolicy(instance.getInternalTrafficPolicy()); 
    this.withIpFamilies(instance.getIpFamilies()); 
    this.withIpFamilyPolicy(instance.getIpFamilyPolicy()); 
    this.withLoadBalancerClass(instance.getLoadBalancerClass()); 
    this.withLoadBalancerIP(instance.getLoadBalancerIP()); 
    this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges()); 
    this.withPorts(instance.getPorts()); 
    this.withPublishNotReadyAddresses(instance.getPublishNotReadyAddresses()); 
    this.withSelector(instance.getSelector()); 
    this.withSessionAffinity(instance.getSessionAffinity()); 
    this.withSessionAffinityConfig(instance.getSessionAffinityConfig()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Boolean allocateLoadBalancerNodePorts;
  private String clusterIP;
  private List<java.lang.String> clusterIPs = new ArrayList<java.lang.String>();
  private java.util.List<java.lang.String> externalIPs = new java.util.ArrayList<java.lang.String>();
  private java.lang.String externalName;
  private java.lang.String externalTrafficPolicy;
  private Integer healthCheckNodePort;
  private java.lang.String internalTrafficPolicy;
  private java.util.List<java.lang.String> ipFamilies = new java.util.ArrayList<java.lang.String>();
  private java.lang.String ipFamilyPolicy;
  private java.lang.String loadBalancerClass;
  private java.lang.String loadBalancerIP;
  private java.util.List<java.lang.String> loadBalancerSourceRanges = new java.util.ArrayList<java.lang.String>();
  private java.util.ArrayList<ServicePortBuilder> ports = new java.util.ArrayList<ServicePortBuilder>();
  private java.lang.Boolean publishNotReadyAddresses;
  private Map<java.lang.String,java.lang.String> selector;
  private java.lang.String sessionAffinity;
  private SessionAffinityConfigBuilder sessionAffinityConfig;
  private java.lang.String type;
  private java.util.Map<java.lang.String,Object> additionalProperties;
  public java.lang.Boolean getAllocateLoadBalancerNodePorts() {
    return this.allocateLoadBalancerNodePorts;
  }
  public A withAllocateLoadBalancerNodePorts(java.lang.Boolean allocateLoadBalancerNodePorts) {
    this.allocateLoadBalancerNodePorts=allocateLoadBalancerNodePorts; return (A) this;
  }
  public java.lang.Boolean hasAllocateLoadBalancerNodePorts() {
    return this.allocateLoadBalancerNodePorts != null;
  }
  public java.lang.String getClusterIP() {
    return this.clusterIP;
  }
  public A withClusterIP(java.lang.String clusterIP) {
    this.clusterIP=clusterIP; return (A) this;
  }
  public java.lang.Boolean hasClusterIP() {
    return this.clusterIP != null;
  }
  public A addToClusterIPs(java.lang.Integer index,java.lang.String item) {
    if (this.clusterIPs == null) {this.clusterIPs = new java.util.ArrayList<java.lang.String>();}
    this.clusterIPs.add(index, item);
    return (A)this;
  }
  public A setToClusterIPs(java.lang.Integer index,java.lang.String item) {
    if (this.clusterIPs == null) {this.clusterIPs = new java.util.ArrayList<java.lang.String>();}
    this.clusterIPs.set(index, item); return (A)this;
  }
  public A addToClusterIPs(java.lang.String... items) {
    if (this.clusterIPs == null) {this.clusterIPs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.clusterIPs.add(item);} return (A)this;
  }
  public A addAllToClusterIPs(Collection<java.lang.String> items) {
    if (this.clusterIPs == null) {this.clusterIPs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.clusterIPs.add(item);} return (A)this;
  }
  public A removeFromClusterIPs(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.clusterIPs!= null){ this.clusterIPs.remove(item);}} return (A)this;
  }
  public A removeAllFromClusterIPs(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.clusterIPs!= null){ this.clusterIPs.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getClusterIPs() {
    return this.clusterIPs;
  }
  public java.lang.String getClusterIP(java.lang.Integer index) {
    return this.clusterIPs.get(index);
  }
  public java.lang.String getFirstClusterIP() {
    return this.clusterIPs.get(0);
  }
  public java.lang.String getLastClusterIP() {
    return this.clusterIPs.get(clusterIPs.size() - 1);
  }
  public java.lang.String getMatchingClusterIP(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: clusterIPs) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingClusterIP(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: clusterIPs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterIPs(java.util.List<java.lang.String> clusterIPs) {
    if (clusterIPs != null) {this.clusterIPs = new java.util.ArrayList(); for (java.lang.String item : clusterIPs){this.addToClusterIPs(item);}} else { this.clusterIPs = null;} return (A) this;
  }
  public A withClusterIPs(java.lang.String... clusterIPs) {
    if (this.clusterIPs != null) {this.clusterIPs.clear();}
    if (clusterIPs != null) {for (java.lang.String item :clusterIPs){ this.addToClusterIPs(item);}} return (A) this;
  }
  public java.lang.Boolean hasClusterIPs() {
    return clusterIPs != null && !clusterIPs.isEmpty();
  }
  public A addToExternalIPs(java.lang.Integer index,java.lang.String item) {
    if (this.externalIPs == null) {this.externalIPs = new java.util.ArrayList<java.lang.String>();}
    this.externalIPs.add(index, item);
    return (A)this;
  }
  public A setToExternalIPs(java.lang.Integer index,java.lang.String item) {
    if (this.externalIPs == null) {this.externalIPs = new java.util.ArrayList<java.lang.String>();}
    this.externalIPs.set(index, item); return (A)this;
  }
  public A addToExternalIPs(java.lang.String... items) {
    if (this.externalIPs == null) {this.externalIPs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.externalIPs.add(item);} return (A)this;
  }
  public A addAllToExternalIPs(java.util.Collection<java.lang.String> items) {
    if (this.externalIPs == null) {this.externalIPs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.externalIPs.add(item);} return (A)this;
  }
  public A removeFromExternalIPs(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.externalIPs!= null){ this.externalIPs.remove(item);}} return (A)this;
  }
  public A removeAllFromExternalIPs(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.externalIPs!= null){ this.externalIPs.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getExternalIPs() {
    return this.externalIPs;
  }
  public java.lang.String getExternalIP(java.lang.Integer index) {
    return this.externalIPs.get(index);
  }
  public java.lang.String getFirstExternalIP() {
    return this.externalIPs.get(0);
  }
  public java.lang.String getLastExternalIP() {
    return this.externalIPs.get(externalIPs.size() - 1);
  }
  public java.lang.String getMatchingExternalIP(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: externalIPs) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingExternalIP(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: externalIPs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExternalIPs(java.util.List<java.lang.String> externalIPs) {
    if (externalIPs != null) {this.externalIPs = new java.util.ArrayList(); for (java.lang.String item : externalIPs){this.addToExternalIPs(item);}} else { this.externalIPs = null;} return (A) this;
  }
  public A withExternalIPs(java.lang.String... externalIPs) {
    if (this.externalIPs != null) {this.externalIPs.clear();}
    if (externalIPs != null) {for (java.lang.String item :externalIPs){ this.addToExternalIPs(item);}} return (A) this;
  }
  public java.lang.Boolean hasExternalIPs() {
    return externalIPs != null && !externalIPs.isEmpty();
  }
  public java.lang.String getExternalName() {
    return this.externalName;
  }
  public A withExternalName(java.lang.String externalName) {
    this.externalName=externalName; return (A) this;
  }
  public java.lang.Boolean hasExternalName() {
    return this.externalName != null;
  }
  public java.lang.String getExternalTrafficPolicy() {
    return this.externalTrafficPolicy;
  }
  public A withExternalTrafficPolicy(java.lang.String externalTrafficPolicy) {
    this.externalTrafficPolicy=externalTrafficPolicy; return (A) this;
  }
  public java.lang.Boolean hasExternalTrafficPolicy() {
    return this.externalTrafficPolicy != null;
  }
  public java.lang.Integer getHealthCheckNodePort() {
    return this.healthCheckNodePort;
  }
  public A withHealthCheckNodePort(java.lang.Integer healthCheckNodePort) {
    this.healthCheckNodePort=healthCheckNodePort; return (A) this;
  }
  public java.lang.Boolean hasHealthCheckNodePort() {
    return this.healthCheckNodePort != null;
  }
  public java.lang.String getInternalTrafficPolicy() {
    return this.internalTrafficPolicy;
  }
  public A withInternalTrafficPolicy(java.lang.String internalTrafficPolicy) {
    this.internalTrafficPolicy=internalTrafficPolicy; return (A) this;
  }
  public java.lang.Boolean hasInternalTrafficPolicy() {
    return this.internalTrafficPolicy != null;
  }
  public A addToIpFamilies(java.lang.Integer index,java.lang.String item) {
    if (this.ipFamilies == null) {this.ipFamilies = new java.util.ArrayList<java.lang.String>();}
    this.ipFamilies.add(index, item);
    return (A)this;
  }
  public A setToIpFamilies(java.lang.Integer index,java.lang.String item) {
    if (this.ipFamilies == null) {this.ipFamilies = new java.util.ArrayList<java.lang.String>();}
    this.ipFamilies.set(index, item); return (A)this;
  }
  public A addToIpFamilies(java.lang.String... items) {
    if (this.ipFamilies == null) {this.ipFamilies = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.ipFamilies.add(item);} return (A)this;
  }
  public A addAllToIpFamilies(java.util.Collection<java.lang.String> items) {
    if (this.ipFamilies == null) {this.ipFamilies = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.ipFamilies.add(item);} return (A)this;
  }
  public A removeFromIpFamilies(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.ipFamilies!= null){ this.ipFamilies.remove(item);}} return (A)this;
  }
  public A removeAllFromIpFamilies(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.ipFamilies!= null){ this.ipFamilies.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getIpFamilies() {
    return this.ipFamilies;
  }
  public java.lang.String getIpFamily(java.lang.Integer index) {
    return this.ipFamilies.get(index);
  }
  public java.lang.String getFirstIpFamily() {
    return this.ipFamilies.get(0);
  }
  public java.lang.String getLastIpFamily() {
    return this.ipFamilies.get(ipFamilies.size() - 1);
  }
  public java.lang.String getMatchingIpFamily(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: ipFamilies) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingIpFamily(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: ipFamilies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIpFamilies(java.util.List<java.lang.String> ipFamilies) {
    if (ipFamilies != null) {this.ipFamilies = new java.util.ArrayList(); for (java.lang.String item : ipFamilies){this.addToIpFamilies(item);}} else { this.ipFamilies = null;} return (A) this;
  }
  public A withIpFamilies(java.lang.String... ipFamilies) {
    if (this.ipFamilies != null) {this.ipFamilies.clear();}
    if (ipFamilies != null) {for (java.lang.String item :ipFamilies){ this.addToIpFamilies(item);}} return (A) this;
  }
  public java.lang.Boolean hasIpFamilies() {
    return ipFamilies != null && !ipFamilies.isEmpty();
  }
  public java.lang.String getIpFamilyPolicy() {
    return this.ipFamilyPolicy;
  }
  public A withIpFamilyPolicy(java.lang.String ipFamilyPolicy) {
    this.ipFamilyPolicy=ipFamilyPolicy; return (A) this;
  }
  public java.lang.Boolean hasIpFamilyPolicy() {
    return this.ipFamilyPolicy != null;
  }
  public java.lang.String getLoadBalancerClass() {
    return this.loadBalancerClass;
  }
  public A withLoadBalancerClass(java.lang.String loadBalancerClass) {
    this.loadBalancerClass=loadBalancerClass; return (A) this;
  }
  public java.lang.Boolean hasLoadBalancerClass() {
    return this.loadBalancerClass != null;
  }
  public java.lang.String getLoadBalancerIP() {
    return this.loadBalancerIP;
  }
  public A withLoadBalancerIP(java.lang.String loadBalancerIP) {
    this.loadBalancerIP=loadBalancerIP; return (A) this;
  }
  public java.lang.Boolean hasLoadBalancerIP() {
    return this.loadBalancerIP != null;
  }
  public A addToLoadBalancerSourceRanges(java.lang.Integer index,java.lang.String item) {
    if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new java.util.ArrayList<java.lang.String>();}
    this.loadBalancerSourceRanges.add(index, item);
    return (A)this;
  }
  public A setToLoadBalancerSourceRanges(java.lang.Integer index,java.lang.String item) {
    if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new java.util.ArrayList<java.lang.String>();}
    this.loadBalancerSourceRanges.set(index, item); return (A)this;
  }
  public A addToLoadBalancerSourceRanges(java.lang.String... items) {
    if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.loadBalancerSourceRanges.add(item);} return (A)this;
  }
  public A addAllToLoadBalancerSourceRanges(java.util.Collection<java.lang.String> items) {
    if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.loadBalancerSourceRanges.add(item);} return (A)this;
  }
  public A removeFromLoadBalancerSourceRanges(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.loadBalancerSourceRanges!= null){ this.loadBalancerSourceRanges.remove(item);}} return (A)this;
  }
  public A removeAllFromLoadBalancerSourceRanges(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.loadBalancerSourceRanges!= null){ this.loadBalancerSourceRanges.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getLoadBalancerSourceRanges() {
    return this.loadBalancerSourceRanges;
  }
  public java.lang.String getLoadBalancerSourceRange(java.lang.Integer index) {
    return this.loadBalancerSourceRanges.get(index);
  }
  public java.lang.String getFirstLoadBalancerSourceRange() {
    return this.loadBalancerSourceRanges.get(0);
  }
  public java.lang.String getLastLoadBalancerSourceRange() {
    return this.loadBalancerSourceRanges.get(loadBalancerSourceRanges.size() - 1);
  }
  public java.lang.String getMatchingLoadBalancerSourceRange(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: loadBalancerSourceRanges) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingLoadBalancerSourceRange(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: loadBalancerSourceRanges) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLoadBalancerSourceRanges(java.util.List<java.lang.String> loadBalancerSourceRanges) {
    if (loadBalancerSourceRanges != null) {this.loadBalancerSourceRanges = new java.util.ArrayList(); for (java.lang.String item : loadBalancerSourceRanges){this.addToLoadBalancerSourceRanges(item);}} else { this.loadBalancerSourceRanges = null;} return (A) this;
  }
  public A withLoadBalancerSourceRanges(java.lang.String... loadBalancerSourceRanges) {
    if (this.loadBalancerSourceRanges != null) {this.loadBalancerSourceRanges.clear();}
    if (loadBalancerSourceRanges != null) {for (java.lang.String item :loadBalancerSourceRanges){ this.addToLoadBalancerSourceRanges(item);}} return (A) this;
  }
  public java.lang.Boolean hasLoadBalancerSourceRanges() {
    return loadBalancerSourceRanges != null && !loadBalancerSourceRanges.isEmpty();
  }
  public A addToPorts(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServicePort item) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ServicePortBuilder>();}
    io.fabric8.kubernetes.api.model.ServicePortBuilder builder = new io.fabric8.kubernetes.api.model.ServicePortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
  }
  public A setToPorts(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServicePort item) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ServicePortBuilder>();}
    io.fabric8.kubernetes.api.model.ServicePortBuilder builder = new io.fabric8.kubernetes.api.model.ServicePortBuilder(item);
    if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
    if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
     return (A)this;
  }
  public A addToPorts(io.fabric8.kubernetes.api.model.ServicePort... items) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ServicePortBuilder>();}
    for (io.fabric8.kubernetes.api.model.ServicePort item : items) {io.fabric8.kubernetes.api.model.ServicePortBuilder builder = new io.fabric8.kubernetes.api.model.ServicePortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A addAllToPorts(java.util.Collection<io.fabric8.kubernetes.api.model.ServicePort> items) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ServicePortBuilder>();}
    for (io.fabric8.kubernetes.api.model.ServicePort item : items) {io.fabric8.kubernetes.api.model.ServicePortBuilder builder = new io.fabric8.kubernetes.api.model.ServicePortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A removeFromPorts(io.fabric8.kubernetes.api.model.ServicePort... items) {
    for (io.fabric8.kubernetes.api.model.ServicePort item : items) {io.fabric8.kubernetes.api.model.ServicePortBuilder builder = new io.fabric8.kubernetes.api.model.ServicePortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeAllFromPorts(java.util.Collection<io.fabric8.kubernetes.api.model.ServicePort> items) {
    for (io.fabric8.kubernetes.api.model.ServicePort item : items) {io.fabric8.kubernetes.api.model.ServicePortBuilder builder = new io.fabric8.kubernetes.api.model.ServicePortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPorts(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ServicePortBuilder> predicate) {
    if (ports == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ServicePortBuilder> each = ports.iterator();
    final List visitables = _visitables.get("ports");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ServicePortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPorts instead.
   * @return The buildable object.
   */
  @Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.ServicePort> getPorts() {
    return ports != null ? build(ports) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.ServicePort> buildPorts() {
    return ports != null ? build(ports) : null;
  }
  public io.fabric8.kubernetes.api.model.ServicePort buildPort(java.lang.Integer index) {
    return this.ports.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.ServicePort buildFirstPort() {
    return this.ports.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.ServicePort buildLastPort() {
    return this.ports.get(ports.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.ServicePort buildMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ServicePortBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ServicePortBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ServicePortBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ServicePortBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPorts(java.util.List<io.fabric8.kubernetes.api.model.ServicePort> ports) {
    if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
    if (ports != null) {this.ports = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.ServicePort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
  }
  public A withPorts(io.fabric8.kubernetes.api.model.ServicePort... ports) {
    if (this.ports != null) {this.ports.clear();}
    if (ports != null) {for (io.fabric8.kubernetes.api.model.ServicePort item :ports){ this.addToPorts(item);}} return (A) this;
  }
  public java.lang.Boolean hasPorts() {
    return ports != null && !ports.isEmpty();
  }
  public ServiceSpecFluent.PortsNested<A> addNewPort() {
    return new ServiceSpecFluentImpl.PortsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> addNewPortLike(io.fabric8.kubernetes.api.model.ServicePort item) {
    return new ServiceSpecFluentImpl.PortsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> setNewPortLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServicePort item) {
    return new io.fabric8.kubernetes.api.model.ServiceSpecFluentImpl.PortsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> editPort(java.lang.Integer index) {
    if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
    return setNewPortLike(index, buildPort(index));
  }
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> editFirstPort() {
    if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
    return setNewPortLike(0, buildPort(0));
  }
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> editLastPort() {
    int index = ports.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
    return setNewPortLike(index, buildPort(index));
  }
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> editMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ServicePortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ports.size();i++) { 
    if (predicate.test(ports.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
    return setNewPortLike(index, buildPort(index));
  }
  public java.lang.Boolean getPublishNotReadyAddresses() {
    return this.publishNotReadyAddresses;
  }
  public A withPublishNotReadyAddresses(java.lang.Boolean publishNotReadyAddresses) {
    this.publishNotReadyAddresses=publishNotReadyAddresses; return (A) this;
  }
  public java.lang.Boolean hasPublishNotReadyAddresses() {
    return this.publishNotReadyAddresses != null;
  }
  public A addToSelector(java.lang.String key,java.lang.String value) {
    if(this.selector == null && key != null && value != null) { this.selector = new LinkedHashMap(); }
    if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
  }
  public A addToSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.selector == null && map != null) { this.selector = new java.util.LinkedHashMap(); }
    if(map != null) { this.selector.putAll(map);} return (A)this;
  }
  public A removeFromSelector(java.lang.String key) {
    if(this.selector == null) { return (A) this; }
    if(key != null && this.selector != null) {this.selector.remove(key);} return (A)this;
  }
  public A removeFromSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.selector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.selector != null){this.selector.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getSelector() {
    return this.selector;
  }
  public <K,V>A withSelector(java.util.Map<java.lang.String,java.lang.String> selector) {
    if (selector == null) { this.selector =  null;} else {this.selector = new java.util.LinkedHashMap(selector);} return (A) this;
  }
  public java.lang.Boolean hasSelector() {
    return this.selector != null;
  }
  public java.lang.String getSessionAffinity() {
    return this.sessionAffinity;
  }
  public A withSessionAffinity(java.lang.String sessionAffinity) {
    this.sessionAffinity=sessionAffinity; return (A) this;
  }
  public java.lang.Boolean hasSessionAffinity() {
    return this.sessionAffinity != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSessionAffinityConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.SessionAffinityConfig getSessionAffinityConfig() {
    return this.sessionAffinityConfig!=null ?this.sessionAffinityConfig.build():null;
  }
  public io.fabric8.kubernetes.api.model.SessionAffinityConfig buildSessionAffinityConfig() {
    return this.sessionAffinityConfig!=null ?this.sessionAffinityConfig.build():null;
  }
  public A withSessionAffinityConfig(io.fabric8.kubernetes.api.model.SessionAffinityConfig sessionAffinityConfig) {
    _visitables.get("sessionAffinityConfig").remove(this.sessionAffinityConfig);
    if (sessionAffinityConfig!=null){ this.sessionAffinityConfig= new SessionAffinityConfigBuilder(sessionAffinityConfig); _visitables.get("sessionAffinityConfig").add(this.sessionAffinityConfig);} return (A) this;
  }
  public java.lang.Boolean hasSessionAffinityConfig() {
    return this.sessionAffinityConfig != null;
  }
  public ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfig() {
    return new ServiceSpecFluentImpl.SessionAffinityConfigNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfigLike(io.fabric8.kubernetes.api.model.SessionAffinityConfig item) {
    return new io.fabric8.kubernetes.api.model.ServiceSpecFluentImpl.SessionAffinityConfigNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.SessionAffinityConfigNested<A> editSessionAffinityConfig() {
    return withNewSessionAffinityConfigLike(getSessionAffinityConfig());
  }
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfig() {
    return withNewSessionAffinityConfigLike(getSessionAffinityConfig() != null ? getSessionAffinityConfig(): new io.fabric8.kubernetes.api.model.SessionAffinityConfigBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfigLike(io.fabric8.kubernetes.api.model.SessionAffinityConfig item) {
    return withNewSessionAffinityConfigLike(getSessionAffinityConfig() != null ? getSessionAffinityConfig(): item);
  }
  public java.lang.String getType() {
    return this.type;
  }
  public A withType(java.lang.String type) {
    this.type=type; return (A) this;
  }
  public java.lang.Boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceSpecFluentImpl that = (ServiceSpecFluentImpl) o;
    if (allocateLoadBalancerNodePorts != null ? !allocateLoadBalancerNodePorts.equals(that.allocateLoadBalancerNodePorts) :that.allocateLoadBalancerNodePorts != null) return false;
    if (clusterIP != null ? !clusterIP.equals(that.clusterIP) :that.clusterIP != null) return false;
    if (clusterIPs != null ? !clusterIPs.equals(that.clusterIPs) :that.clusterIPs != null) return false;
    if (externalIPs != null ? !externalIPs.equals(that.externalIPs) :that.externalIPs != null) return false;
    if (externalName != null ? !externalName.equals(that.externalName) :that.externalName != null) return false;
    if (externalTrafficPolicy != null ? !externalTrafficPolicy.equals(that.externalTrafficPolicy) :that.externalTrafficPolicy != null) return false;
    if (healthCheckNodePort != null ? !healthCheckNodePort.equals(that.healthCheckNodePort) :that.healthCheckNodePort != null) return false;
    if (internalTrafficPolicy != null ? !internalTrafficPolicy.equals(that.internalTrafficPolicy) :that.internalTrafficPolicy != null) return false;
    if (ipFamilies != null ? !ipFamilies.equals(that.ipFamilies) :that.ipFamilies != null) return false;
    if (ipFamilyPolicy != null ? !ipFamilyPolicy.equals(that.ipFamilyPolicy) :that.ipFamilyPolicy != null) return false;
    if (loadBalancerClass != null ? !loadBalancerClass.equals(that.loadBalancerClass) :that.loadBalancerClass != null) return false;
    if (loadBalancerIP != null ? !loadBalancerIP.equals(that.loadBalancerIP) :that.loadBalancerIP != null) return false;
    if (loadBalancerSourceRanges != null ? !loadBalancerSourceRanges.equals(that.loadBalancerSourceRanges) :that.loadBalancerSourceRanges != null) return false;
    if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
    if (publishNotReadyAddresses != null ? !publishNotReadyAddresses.equals(that.publishNotReadyAddresses) :that.publishNotReadyAddresses != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (sessionAffinity != null ? !sessionAffinity.equals(that.sessionAffinity) :that.sessionAffinity != null) return false;
    if (sessionAffinityConfig != null ? !sessionAffinityConfig.equals(that.sessionAffinityConfig) :that.sessionAffinityConfig != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allocateLoadBalancerNodePorts,  clusterIP,  clusterIPs,  externalIPs,  externalName,  externalTrafficPolicy,  healthCheckNodePort,  internalTrafficPolicy,  ipFamilies,  ipFamilyPolicy,  loadBalancerClass,  loadBalancerIP,  loadBalancerSourceRanges,  ports,  publishNotReadyAddresses,  selector,  sessionAffinity,  sessionAffinityConfig,  type,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allocateLoadBalancerNodePorts != null) { sb.append("allocateLoadBalancerNodePorts:"); sb.append(allocateLoadBalancerNodePorts + ","); }
    if (clusterIP != null) { sb.append("clusterIP:"); sb.append(clusterIP + ","); }
    if (clusterIPs != null && !clusterIPs.isEmpty()) { sb.append("clusterIPs:"); sb.append(clusterIPs + ","); }
    if (externalIPs != null && !externalIPs.isEmpty()) { sb.append("externalIPs:"); sb.append(externalIPs + ","); }
    if (externalName != null) { sb.append("externalName:"); sb.append(externalName + ","); }
    if (externalTrafficPolicy != null) { sb.append("externalTrafficPolicy:"); sb.append(externalTrafficPolicy + ","); }
    if (healthCheckNodePort != null) { sb.append("healthCheckNodePort:"); sb.append(healthCheckNodePort + ","); }
    if (internalTrafficPolicy != null) { sb.append("internalTrafficPolicy:"); sb.append(internalTrafficPolicy + ","); }
    if (ipFamilies != null && !ipFamilies.isEmpty()) { sb.append("ipFamilies:"); sb.append(ipFamilies + ","); }
    if (ipFamilyPolicy != null) { sb.append("ipFamilyPolicy:"); sb.append(ipFamilyPolicy + ","); }
    if (loadBalancerClass != null) { sb.append("loadBalancerClass:"); sb.append(loadBalancerClass + ","); }
    if (loadBalancerIP != null) { sb.append("loadBalancerIP:"); sb.append(loadBalancerIP + ","); }
    if (loadBalancerSourceRanges != null && !loadBalancerSourceRanges.isEmpty()) { sb.append("loadBalancerSourceRanges:"); sb.append(loadBalancerSourceRanges + ","); }
    if (ports != null && !ports.isEmpty()) { sb.append("ports:"); sb.append(ports + ","); }
    if (publishNotReadyAddresses != null) { sb.append("publishNotReadyAddresses:"); sb.append(publishNotReadyAddresses + ","); }
    if (selector != null && !selector.isEmpty()) { sb.append("selector:"); sb.append(selector + ","); }
    if (sessionAffinity != null) { sb.append("sessionAffinity:"); sb.append(sessionAffinity + ","); }
    if (sessionAffinityConfig != null) { sb.append("sessionAffinityConfig:"); sb.append(sessionAffinityConfig + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withAllocateLoadBalancerNodePorts() {
    return withAllocateLoadBalancerNodePorts(true);
  }
  public A withPublishNotReadyAddresses() {
    return withPublishNotReadyAddresses(true);
  }
  class PortsNestedImpl<N> extends ServicePortFluentImpl<ServiceSpecFluent.PortsNested<N>> implements io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<N>,Nested<N>{
    PortsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServicePort item) {
      this.index = index;
      this.builder = new ServicePortBuilder(this, item);
    }
    PortsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ServicePortBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ServicePortBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ServiceSpecFluentImpl.this.setToPorts(index,builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  class SessionAffinityConfigNestedImpl<N> extends SessionAffinityConfigFluentImpl<ServiceSpecFluent.SessionAffinityConfigNested<N>> implements io.fabric8.kubernetes.api.model.ServiceSpecFluent.SessionAffinityConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SessionAffinityConfigNestedImpl(SessionAffinityConfig item) {
      this.builder = new SessionAffinityConfigBuilder(this, item);
    }
    SessionAffinityConfigNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.SessionAffinityConfigBuilder(this);
    }
    io.fabric8.kubernetes.api.model.SessionAffinityConfigBuilder builder;
    public N and() {
      return (N) ServiceSpecFluentImpl.this.withSessionAffinityConfig(builder.build());
    }
    public N endSessionAffinityConfig() {
      return and();
    }
    
  }
  
}