package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceStatusBuilder extends ServiceStatusFluentImpl<ServiceStatusBuilder> implements VisitableBuilder<ServiceStatus,io.fabric8.kubernetes.api.model.ServiceStatusBuilder>{
  public ServiceStatusBuilder() {
    this(false);
  }
  public ServiceStatusBuilder(Boolean validationEnabled) {
    this(new ServiceStatus(), validationEnabled);
  }
  public ServiceStatusBuilder(io.fabric8.kubernetes.api.model.ServiceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceStatusBuilder(io.fabric8.kubernetes.api.model.ServiceStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceStatus(), validationEnabled);
  }
  public ServiceStatusBuilder(io.fabric8.kubernetes.api.model.ServiceStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceStatus instance) {
    this(fluent, instance, false);
  }
  public ServiceStatusBuilder(io.fabric8.kubernetes.api.model.ServiceStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withLoadBalancer(instance.getLoadBalancer()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceStatusBuilder(io.fabric8.kubernetes.api.model.ServiceStatus instance) {
    this(instance,false);
  }
  public ServiceStatusBuilder(io.fabric8.kubernetes.api.model.ServiceStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withLoadBalancer(instance.getLoadBalancer()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ServiceStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ServiceStatus build() {
    ServiceStatus buildable = new ServiceStatus(fluent.getConditions(),fluent.getLoadBalancer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}