package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SessionAffinityConfigBuilder extends SessionAffinityConfigFluentImpl<SessionAffinityConfigBuilder> implements VisitableBuilder<SessionAffinityConfig,io.fabric8.kubernetes.api.model.SessionAffinityConfigBuilder>{
  public SessionAffinityConfigBuilder() {
    this(false);
  }
  public SessionAffinityConfigBuilder(Boolean validationEnabled) {
    this(new SessionAffinityConfig(), validationEnabled);
  }
  public SessionAffinityConfigBuilder(io.fabric8.kubernetes.api.model.SessionAffinityConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public SessionAffinityConfigBuilder(io.fabric8.kubernetes.api.model.SessionAffinityConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SessionAffinityConfig(), validationEnabled);
  }
  public SessionAffinityConfigBuilder(io.fabric8.kubernetes.api.model.SessionAffinityConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.SessionAffinityConfig instance) {
    this(fluent, instance, false);
  }
  public SessionAffinityConfigBuilder(io.fabric8.kubernetes.api.model.SessionAffinityConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.SessionAffinityConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClientIP(instance.getClientIP()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SessionAffinityConfigBuilder(io.fabric8.kubernetes.api.model.SessionAffinityConfig instance) {
    this(instance,false);
  }
  public SessionAffinityConfigBuilder(io.fabric8.kubernetes.api.model.SessionAffinityConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClientIP(instance.getClientIP()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.SessionAffinityConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.SessionAffinityConfig build() {
    SessionAffinityConfig buildable = new SessionAffinityConfig(fluent.getClientIP());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}