package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatusBuilder extends StatusFluentImpl<StatusBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.Status,io.fabric8.kubernetes.api.model.StatusBuilder>{
  public StatusBuilder() {
    this(false);
  }
  public StatusBuilder(Boolean validationEnabled) {
    this(new Status(), validationEnabled);
  }
  public StatusBuilder(StatusFluent<?> fluent) {
    this(fluent, false);
  }
  public StatusBuilder(io.fabric8.kubernetes.api.model.StatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Status(), validationEnabled);
  }
  public StatusBuilder(io.fabric8.kubernetes.api.model.StatusFluent<?> fluent,io.fabric8.kubernetes.api.model.Status instance) {
    this(fluent, instance, false);
  }
  public StatusBuilder(io.fabric8.kubernetes.api.model.StatusFluent<?> fluent,io.fabric8.kubernetes.api.model.Status instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withCode(instance.getCode()); 
    fluent.withDetails(instance.getDetails()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StatusBuilder(io.fabric8.kubernetes.api.model.Status instance) {
    this(instance,false);
  }
  public StatusBuilder(io.fabric8.kubernetes.api.model.Status instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withCode(instance.getCode()); 
    this.withDetails(instance.getDetails()); 
    this.withKind(instance.getKind()); 
    this.withMessage(instance.getMessage()); 
    this.withMetadata(instance.getMetadata()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.StatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Status build() {
    Status buildable = new Status(fluent.getApiVersion(),fluent.getCode(),fluent.getDetails(),fluent.getKind(),fluent.getMessage(),fluent.getMetadata(),fluent.getReason(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}