package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class StatusDetailsFluentImpl<A extends StatusDetailsFluent<A>> extends BaseFluent<A> implements StatusDetailsFluent<A>{
  public StatusDetailsFluentImpl() {
  }
  public StatusDetailsFluentImpl(io.fabric8.kubernetes.api.model.StatusDetails instance) {
    this.withCauses(instance.getCauses()); 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withRetryAfterSeconds(instance.getRetryAfterSeconds()); 
    this.withUid(instance.getUid()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<StatusCauseBuilder> causes = new java.util.ArrayList<StatusCauseBuilder>();
  private String group;
  private java.lang.String kind;
  private java.lang.String name;
  private Integer retryAfterSeconds;
  private java.lang.String uid;
  private Map<java.lang.String,Object> additionalProperties;
  public A addToCauses(java.lang.Integer index,io.fabric8.kubernetes.api.model.StatusCause item) {
    if (this.causes == null) {this.causes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.StatusCauseBuilder>();}
    io.fabric8.kubernetes.api.model.StatusCauseBuilder builder = new io.fabric8.kubernetes.api.model.StatusCauseBuilder(item);_visitables.get("causes").add(index >= 0 ? index : _visitables.get("causes").size(), builder);this.causes.add(index >= 0 ? index : causes.size(), builder); return (A)this;
  }
  public A setToCauses(java.lang.Integer index,io.fabric8.kubernetes.api.model.StatusCause item) {
    if (this.causes == null) {this.causes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.StatusCauseBuilder>();}
    io.fabric8.kubernetes.api.model.StatusCauseBuilder builder = new io.fabric8.kubernetes.api.model.StatusCauseBuilder(item);
    if (index < 0 || index >= _visitables.get("causes").size()) { _visitables.get("causes").add(builder); } else { _visitables.get("causes").set(index, builder);}
    if (index < 0 || index >= causes.size()) { causes.add(builder); } else { causes.set(index, builder);}
     return (A)this;
  }
  public A addToCauses(io.fabric8.kubernetes.api.model.StatusCause... items) {
    if (this.causes == null) {this.causes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.StatusCauseBuilder>();}
    for (io.fabric8.kubernetes.api.model.StatusCause item : items) {io.fabric8.kubernetes.api.model.StatusCauseBuilder builder = new io.fabric8.kubernetes.api.model.StatusCauseBuilder(item);_visitables.get("causes").add(builder);this.causes.add(builder);} return (A)this;
  }
  public A addAllToCauses(Collection<io.fabric8.kubernetes.api.model.StatusCause> items) {
    if (this.causes == null) {this.causes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.StatusCauseBuilder>();}
    for (io.fabric8.kubernetes.api.model.StatusCause item : items) {io.fabric8.kubernetes.api.model.StatusCauseBuilder builder = new io.fabric8.kubernetes.api.model.StatusCauseBuilder(item);_visitables.get("causes").add(builder);this.causes.add(builder);} return (A)this;
  }
  public A removeFromCauses(io.fabric8.kubernetes.api.model.StatusCause... items) {
    for (io.fabric8.kubernetes.api.model.StatusCause item : items) {io.fabric8.kubernetes.api.model.StatusCauseBuilder builder = new io.fabric8.kubernetes.api.model.StatusCauseBuilder(item);_visitables.get("causes").remove(builder);if (this.causes != null) {this.causes.remove(builder);}} return (A)this;
  }
  public A removeAllFromCauses(java.util.Collection<io.fabric8.kubernetes.api.model.StatusCause> items) {
    for (io.fabric8.kubernetes.api.model.StatusCause item : items) {io.fabric8.kubernetes.api.model.StatusCauseBuilder builder = new io.fabric8.kubernetes.api.model.StatusCauseBuilder(item);_visitables.get("causes").remove(builder);if (this.causes != null) {this.causes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCauses(Predicate<io.fabric8.kubernetes.api.model.StatusCauseBuilder> predicate) {
    if (causes == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.StatusCauseBuilder> each = causes.iterator();
    final List visitables = _visitables.get("causes");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.StatusCauseBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildCauses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.kubernetes.api.model.StatusCause> getCauses() {
    return causes != null ? build(causes) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.StatusCause> buildCauses() {
    return causes != null ? build(causes) : null;
  }
  public io.fabric8.kubernetes.api.model.StatusCause buildCause(java.lang.Integer index) {
    return this.causes.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.StatusCause buildFirstCause() {
    return this.causes.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.StatusCause buildLastCause() {
    return this.causes.get(causes.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.StatusCause buildMatchingCause(java.util.function.Predicate<io.fabric8.kubernetes.api.model.StatusCauseBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.StatusCauseBuilder item: causes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCause(java.util.function.Predicate<io.fabric8.kubernetes.api.model.StatusCauseBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.StatusCauseBuilder item: causes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCauses(java.util.List<io.fabric8.kubernetes.api.model.StatusCause> causes) {
    if (this.causes != null) { _visitables.get("causes").removeAll(this.causes);}
    if (causes != null) {this.causes = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.StatusCause item : causes){this.addToCauses(item);}} else { this.causes = null;} return (A) this;
  }
  public A withCauses(io.fabric8.kubernetes.api.model.StatusCause... causes) {
    if (this.causes != null) {this.causes.clear();}
    if (causes != null) {for (io.fabric8.kubernetes.api.model.StatusCause item :causes){ this.addToCauses(item);}} return (A) this;
  }
  public java.lang.Boolean hasCauses() {
    return causes != null && !causes.isEmpty();
  }
  public A addNewCause(java.lang.String field,java.lang.String message,java.lang.String reason) {
    return (A)addToCauses(new StatusCause(field, message, reason));
  }
  public StatusDetailsFluent.CausesNested<A> addNewCause() {
    return new StatusDetailsFluentImpl.CausesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.StatusDetailsFluent.CausesNested<A> addNewCauseLike(io.fabric8.kubernetes.api.model.StatusCause item) {
    return new StatusDetailsFluentImpl.CausesNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.StatusDetailsFluent.CausesNested<A> setNewCauseLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.StatusCause item) {
    return new io.fabric8.kubernetes.api.model.StatusDetailsFluentImpl.CausesNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.StatusDetailsFluent.CausesNested<A> editCause(java.lang.Integer index) {
    if (causes.size() <= index) throw new RuntimeException("Can't edit causes. Index exceeds size.");
    return setNewCauseLike(index, buildCause(index));
  }
  public io.fabric8.kubernetes.api.model.StatusDetailsFluent.CausesNested<A> editFirstCause() {
    if (causes.size() == 0) throw new RuntimeException("Can't edit first causes. The list is empty.");
    return setNewCauseLike(0, buildCause(0));
  }
  public io.fabric8.kubernetes.api.model.StatusDetailsFluent.CausesNested<A> editLastCause() {
    int index = causes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last causes. The list is empty.");
    return setNewCauseLike(index, buildCause(index));
  }
  public io.fabric8.kubernetes.api.model.StatusDetailsFluent.CausesNested<A> editMatchingCause(java.util.function.Predicate<io.fabric8.kubernetes.api.model.StatusCauseBuilder> predicate) {
    int index = -1;
    for (int i=0;i<causes.size();i++) { 
    if (predicate.test(causes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching causes. No match found.");
    return setNewCauseLike(index, buildCause(index));
  }
  public java.lang.String getGroup() {
    return this.group;
  }
  public A withGroup(java.lang.String group) {
    this.group=group; return (A) this;
  }
  public java.lang.Boolean hasGroup() {
    return this.group != null;
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  public java.lang.String getName() {
    return this.name;
  }
  public A withName(java.lang.String name) {
    this.name=name; return (A) this;
  }
  public java.lang.Boolean hasName() {
    return this.name != null;
  }
  public java.lang.Integer getRetryAfterSeconds() {
    return this.retryAfterSeconds;
  }
  public A withRetryAfterSeconds(java.lang.Integer retryAfterSeconds) {
    this.retryAfterSeconds=retryAfterSeconds; return (A) this;
  }
  public java.lang.Boolean hasRetryAfterSeconds() {
    return this.retryAfterSeconds != null;
  }
  public java.lang.String getUid() {
    return this.uid;
  }
  public A withUid(java.lang.String uid) {
    this.uid=uid; return (A) this;
  }
  public java.lang.Boolean hasUid() {
    return this.uid != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StatusDetailsFluentImpl that = (StatusDetailsFluentImpl) o;
    if (causes != null ? !causes.equals(that.causes) :that.causes != null) return false;
    if (group != null ? !group.equals(that.group) :that.group != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (retryAfterSeconds != null ? !retryAfterSeconds.equals(that.retryAfterSeconds) :that.retryAfterSeconds != null) return false;
    if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(causes,  group,  kind,  name,  retryAfterSeconds,  uid,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (causes != null && !causes.isEmpty()) { sb.append("causes:"); sb.append(causes + ","); }
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (retryAfterSeconds != null) { sb.append("retryAfterSeconds:"); sb.append(retryAfterSeconds + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CausesNestedImpl<N> extends StatusCauseFluentImpl<StatusDetailsFluent.CausesNested<N>> implements io.fabric8.kubernetes.api.model.StatusDetailsFluent.CausesNested<N>,Nested<N>{
    CausesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.StatusCause item) {
      this.index = index;
      this.builder = new StatusCauseBuilder(this, item);
    }
    CausesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.StatusCauseBuilder(this);
    }
    io.fabric8.kubernetes.api.model.StatusCauseBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) StatusDetailsFluentImpl.this.setToCauses(index,builder.build());
    }
    public N endCause() {
      return and();
    }
    
  }
  
}