package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class StorageOSVolumeSourceFluentImpl<A extends StorageOSVolumeSourceFluent<A>> extends BaseFluent<A> implements StorageOSVolumeSourceFluent<A>{
  public StorageOSVolumeSourceFluentImpl() {
  }
  public StorageOSVolumeSourceFluentImpl(io.fabric8.kubernetes.api.model.StorageOSVolumeSource instance) {
    this.withFsType(instance.getFsType()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withVolumeName(instance.getVolumeName()); 
    this.withVolumeNamespace(instance.getVolumeNamespace()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String fsType;
  private Boolean readOnly;
  private LocalObjectReferenceBuilder secretRef;
  private java.lang.String volumeName;
  private java.lang.String volumeNamespace;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getFsType() {
    return this.fsType;
  }
  public A withFsType(java.lang.String fsType) {
    this.fsType=fsType; return (A) this;
  }
  public java.lang.Boolean hasFsType() {
    return this.fsType != null;
  }
  public java.lang.Boolean getReadOnly() {
    return this.readOnly;
  }
  public A withReadOnly(java.lang.Boolean readOnly) {
    this.readOnly=readOnly; return (A) this;
  }
  public java.lang.Boolean hasReadOnly() {
    return this.readOnly != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public A withSecretRef(io.fabric8.kubernetes.api.model.LocalObjectReference secretRef) {
    _visitables.get("secretRef").remove(this.secretRef);
    if (secretRef!=null){ this.secretRef= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} return (A) this;
  }
  public java.lang.Boolean hasSecretRef() {
    return this.secretRef != null;
  }
  public A withNewSecretRef(java.lang.String name) {
    return (A)withSecretRef(new LocalObjectReference(name));
  }
  public StorageOSVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
    return new StorageOSVolumeSourceFluentImpl.SecretRefNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.StorageOSVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return new StorageOSVolumeSourceFluentImpl.SecretRefNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.StorageOSVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(getSecretRef());
  }
  public io.fabric8.kubernetes.api.model.StorageOSVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.StorageOSVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
  }
  public java.lang.String getVolumeName() {
    return this.volumeName;
  }
  public A withVolumeName(java.lang.String volumeName) {
    this.volumeName=volumeName; return (A) this;
  }
  public java.lang.Boolean hasVolumeName() {
    return this.volumeName != null;
  }
  public java.lang.String getVolumeNamespace() {
    return this.volumeNamespace;
  }
  public A withVolumeNamespace(java.lang.String volumeNamespace) {
    this.volumeNamespace=volumeNamespace; return (A) this;
  }
  public java.lang.Boolean hasVolumeNamespace() {
    return this.volumeNamespace != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StorageOSVolumeSourceFluentImpl that = (StorageOSVolumeSourceFluentImpl) o;
    if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
    if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
    if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
    if (volumeName != null ? !volumeName.equals(that.volumeName) :that.volumeName != null) return false;
    if (volumeNamespace != null ? !volumeNamespace.equals(that.volumeNamespace) :that.volumeNamespace != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fsType,  readOnly,  secretRef,  volumeName,  volumeNamespace,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fsType != null) { sb.append("fsType:"); sb.append(fsType + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef + ","); }
    if (volumeName != null) { sb.append("volumeName:"); sb.append(volumeName + ","); }
    if (volumeNamespace != null) { sb.append("volumeNamespace:"); sb.append(volumeNamespace + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withReadOnly() {
    return withReadOnly(true);
  }
  class SecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<StorageOSVolumeSourceFluent.SecretRefNested<N>> implements io.fabric8.kubernetes.api.model.StorageOSVolumeSourceFluent.SecretRefNested<N>,Nested<N>{
    SecretRefNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    SecretRefNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) StorageOSVolumeSourceFluentImpl.this.withSecretRef(builder.build());
    }
    public N endSecretRef() {
      return and();
    }
    
  }
  
}