package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TCPSocketActionBuilder extends TCPSocketActionFluentImpl<TCPSocketActionBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.TCPSocketAction,io.fabric8.kubernetes.api.model.TCPSocketActionBuilder>{
  public TCPSocketActionBuilder() {
    this(false);
  }
  public TCPSocketActionBuilder(Boolean validationEnabled) {
    this(new TCPSocketAction(), validationEnabled);
  }
  public TCPSocketActionBuilder(TCPSocketActionFluent<?> fluent) {
    this(fluent, false);
  }
  public TCPSocketActionBuilder(io.fabric8.kubernetes.api.model.TCPSocketActionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new TCPSocketAction(), validationEnabled);
  }
  public TCPSocketActionBuilder(io.fabric8.kubernetes.api.model.TCPSocketActionFluent<?> fluent,io.fabric8.kubernetes.api.model.TCPSocketAction instance) {
    this(fluent, instance, false);
  }
  public TCPSocketActionBuilder(io.fabric8.kubernetes.api.model.TCPSocketActionFluent<?> fluent,io.fabric8.kubernetes.api.model.TCPSocketAction instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHost(instance.getHost()); 
    fluent.withPort(instance.getPort()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TCPSocketActionBuilder(io.fabric8.kubernetes.api.model.TCPSocketAction instance) {
    this(instance,false);
  }
  public TCPSocketActionBuilder(io.fabric8.kubernetes.api.model.TCPSocketAction instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHost(instance.getHost()); 
    this.withPort(instance.getPort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.TCPSocketActionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.TCPSocketAction build() {
    TCPSocketAction buildable = new TCPSocketAction(fluent.getHost(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}