package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TaintBuilder extends TaintFluentImpl<TaintBuilder> implements VisitableBuilder<Taint,io.fabric8.kubernetes.api.model.TaintBuilder>{
  public TaintBuilder() {
    this(false);
  }
  public TaintBuilder(Boolean validationEnabled) {
    this(new Taint(), validationEnabled);
  }
  public TaintBuilder(TaintFluent<?> fluent) {
    this(fluent, false);
  }
  public TaintBuilder(io.fabric8.kubernetes.api.model.TaintFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Taint(), validationEnabled);
  }
  public TaintBuilder(io.fabric8.kubernetes.api.model.TaintFluent<?> fluent,io.fabric8.kubernetes.api.model.Taint instance) {
    this(fluent, instance, false);
  }
  public TaintBuilder(io.fabric8.kubernetes.api.model.TaintFluent<?> fluent,io.fabric8.kubernetes.api.model.Taint instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEffect(instance.getEffect()); 
    fluent.withKey(instance.getKey()); 
    fluent.withTimeAdded(instance.getTimeAdded()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TaintBuilder(io.fabric8.kubernetes.api.model.Taint instance) {
    this(instance,false);
  }
  public TaintBuilder(io.fabric8.kubernetes.api.model.Taint instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEffect(instance.getEffect()); 
    this.withKey(instance.getKey()); 
    this.withTimeAdded(instance.getTimeAdded()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.TaintFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Taint build() {
    Taint buildable = new Taint(fluent.getEffect(),fluent.getKey(),fluent.getTimeAdded(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}