package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TolerationBuilder extends TolerationFluentImpl<TolerationBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.Toleration,io.fabric8.kubernetes.api.model.TolerationBuilder>{
  public TolerationBuilder() {
    this(false);
  }
  public TolerationBuilder(Boolean validationEnabled) {
    this(new Toleration(), validationEnabled);
  }
  public TolerationBuilder(TolerationFluent<?> fluent) {
    this(fluent, false);
  }
  public TolerationBuilder(io.fabric8.kubernetes.api.model.TolerationFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Toleration(), validationEnabled);
  }
  public TolerationBuilder(io.fabric8.kubernetes.api.model.TolerationFluent<?> fluent,io.fabric8.kubernetes.api.model.Toleration instance) {
    this(fluent, instance, false);
  }
  public TolerationBuilder(io.fabric8.kubernetes.api.model.TolerationFluent<?> fluent,io.fabric8.kubernetes.api.model.Toleration instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEffect(instance.getEffect()); 
    fluent.withKey(instance.getKey()); 
    fluent.withOperator(instance.getOperator()); 
    fluent.withTolerationSeconds(instance.getTolerationSeconds()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TolerationBuilder(io.fabric8.kubernetes.api.model.Toleration instance) {
    this(instance,false);
  }
  public TolerationBuilder(io.fabric8.kubernetes.api.model.Toleration instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEffect(instance.getEffect()); 
    this.withKey(instance.getKey()); 
    this.withOperator(instance.getOperator()); 
    this.withTolerationSeconds(instance.getTolerationSeconds()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.TolerationFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Toleration build() {
    Toleration buildable = new Toleration(fluent.getEffect(),fluent.getKey(),fluent.getOperator(),fluent.getTolerationSeconds(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}