package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TopologySpreadConstraintBuilder extends TopologySpreadConstraintFluentImpl<TopologySpreadConstraintBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.TopologySpreadConstraint,TopologySpreadConstraintBuilder>{
  public TopologySpreadConstraintBuilder() {
    this(false);
  }
  public TopologySpreadConstraintBuilder(Boolean validationEnabled) {
    this(new TopologySpreadConstraint(), validationEnabled);
  }
  public TopologySpreadConstraintBuilder(io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent<?> fluent) {
    this(fluent, false);
  }
  public TopologySpreadConstraintBuilder(io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new TopologySpreadConstraint(), validationEnabled);
  }
  public TopologySpreadConstraintBuilder(io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent<?> fluent,io.fabric8.kubernetes.api.model.TopologySpreadConstraint instance) {
    this(fluent, instance, false);
  }
  public TopologySpreadConstraintBuilder(io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent<?> fluent,io.fabric8.kubernetes.api.model.TopologySpreadConstraint instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLabelSelector(instance.getLabelSelector()); 
    fluent.withMaxSkew(instance.getMaxSkew()); 
    fluent.withMinDomains(instance.getMinDomains()); 
    fluent.withTopologyKey(instance.getTopologyKey()); 
    fluent.withWhenUnsatisfiable(instance.getWhenUnsatisfiable()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TopologySpreadConstraintBuilder(io.fabric8.kubernetes.api.model.TopologySpreadConstraint instance) {
    this(instance,false);
  }
  public TopologySpreadConstraintBuilder(io.fabric8.kubernetes.api.model.TopologySpreadConstraint instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLabelSelector(instance.getLabelSelector()); 
    this.withMaxSkew(instance.getMaxSkew()); 
    this.withMinDomains(instance.getMinDomains()); 
    this.withTopologyKey(instance.getTopologyKey()); 
    this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.TopologySpreadConstraint build() {
    TopologySpreadConstraint buildable = new TopologySpreadConstraint(fluent.getLabelSelector(),fluent.getMaxSkew(),fluent.getMinDomains(),fluent.getTopologyKey(),fluent.getWhenUnsatisfiable());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}