package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TypedLocalObjectReferenceBuilder extends TypedLocalObjectReferenceFluentImpl<TypedLocalObjectReferenceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.TypedLocalObjectReference,TypedLocalObjectReferenceBuilder>{
  public TypedLocalObjectReferenceBuilder() {
    this(false);
  }
  public TypedLocalObjectReferenceBuilder(Boolean validationEnabled) {
    this(new TypedLocalObjectReference(), validationEnabled);
  }
  public TypedLocalObjectReferenceBuilder(TypedLocalObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public TypedLocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new TypedLocalObjectReference(), validationEnabled);
  }
  public TypedLocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.TypedLocalObjectReference instance) {
    this(fluent, instance, false);
  }
  public TypedLocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.TypedLocalObjectReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiGroup(instance.getApiGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TypedLocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.TypedLocalObjectReference instance) {
    this(instance,false);
  }
  public TypedLocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.TypedLocalObjectReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiGroup(instance.getApiGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.TypedLocalObjectReference build() {
    TypedLocalObjectReference buildable = new TypedLocalObjectReference(fluent.getApiGroup(),fluent.getKind(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}