package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UpdateOptionsBuilder extends UpdateOptionsFluentImpl<UpdateOptionsBuilder> implements VisitableBuilder<UpdateOptions,io.fabric8.kubernetes.api.model.UpdateOptionsBuilder>{
  public UpdateOptionsBuilder() {
    this(false);
  }
  public UpdateOptionsBuilder(Boolean validationEnabled) {
    this(new UpdateOptions(), validationEnabled);
  }
  public UpdateOptionsBuilder(UpdateOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public UpdateOptionsBuilder(io.fabric8.kubernetes.api.model.UpdateOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new UpdateOptions(), validationEnabled);
  }
  public UpdateOptionsBuilder(io.fabric8.kubernetes.api.model.UpdateOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.UpdateOptions instance) {
    this(fluent, instance, false);
  }
  public UpdateOptionsBuilder(io.fabric8.kubernetes.api.model.UpdateOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.UpdateOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withDryRun(instance.getDryRun()); 
    fluent.withFieldManager(instance.getFieldManager()); 
    fluent.withFieldValidation(instance.getFieldValidation()); 
    fluent.withKind(instance.getKind()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public UpdateOptionsBuilder(io.fabric8.kubernetes.api.model.UpdateOptions instance) {
    this(instance,false);
  }
  public UpdateOptionsBuilder(io.fabric8.kubernetes.api.model.UpdateOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withDryRun(instance.getDryRun()); 
    this.withFieldManager(instance.getFieldManager()); 
    this.withFieldValidation(instance.getFieldValidation()); 
    this.withKind(instance.getKind()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.UpdateOptionsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.UpdateOptions build() {
    UpdateOptions buildable = new UpdateOptions(fluent.getApiVersion(),fluent.getDryRun(),fluent.getFieldManager(),fluent.getFieldValidation(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}