package io.fabric8.kubernetes.api.model;

import java.lang.String;
import java.lang.Deprecated;
import java.lang.Long;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.version.Info;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.version.InfoBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.version.InfoFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ValidationSchemaFluentImpl<A extends ValidationSchemaFluent<A>> extends BaseFluent<A> implements ValidationSchemaFluent<A>{
  public ValidationSchemaFluentImpl() {
  }
  public ValidationSchemaFluentImpl(io.fabric8.kubernetes.api.model.ValidationSchema instance) {
    this.withAPIGroup(instance.getAPIGroup()); 
    this.withAPIGroupList(instance.getAPIGroupList()); 
    this.withAPIResource(instance.getAPIResource()); 
    this.withAPIResourceList(instance.getAPIResourceList()); 
    this.withAPIService(instance.getAPIService()); 
    this.withAPIServiceList(instance.getAPIServiceList()); 
    this.withBaseKubernetesList(instance.getBaseKubernetesList()); 
    this.withBinding(instance.getBinding()); 
    this.withComponentStatus(instance.getComponentStatus()); 
    this.withComponentStatusList(instance.getComponentStatusList()); 
    this.withCondition(instance.getCondition()); 
    this.withConfig(instance.getConfig()); 
    this.withConfigMap(instance.getConfigMap()); 
    this.withConfigMapList(instance.getConfigMapList()); 
    this.withContainerStatus(instance.getContainerStatus()); 
    this.withCreateOptions(instance.getCreateOptions()); 
    this.withDeleteOptions(instance.getDeleteOptions()); 
    this.withEndpointPort(instance.getEndpointPort()); 
    this.withEndpoints(instance.getEndpoints()); 
    this.withEndpointsList(instance.getEndpointsList()); 
    this.withEnvVar(instance.getEnvVar()); 
    this.withEvent(instance.getEvent()); 
    this.withEventList(instance.getEventList()); 
    this.withEventSeries(instance.getEventSeries()); 
    this.withEventSource(instance.getEventSource()); 
    this.withGetOptions(instance.getGetOptions()); 
    this.withGroupKind(instance.getGroupKind()); 
    this.withGroupVersionKind(instance.getGroupVersionKind()); 
    this.withGroupVersionResource(instance.getGroupVersionResource()); 
    this.withInfo(instance.getInfo()); 
    this.withLimitRangeList(instance.getLimitRangeList()); 
    this.withListOptions(instance.getListOptions()); 
    this.withMicroTime(instance.getMicroTime()); 
    this.withNamespace(instance.getNamespace()); 
    this.withNamespaceList(instance.getNamespaceList()); 
    this.withNode(instance.getNode()); 
    this.withNodeList(instance.getNodeList()); 
    this.withObjectMeta(instance.getObjectMeta()); 
    this.withPatch(instance.getPatch()); 
    this.withPatchOptions(instance.getPatchOptions()); 
    this.withPersistentVolume(instance.getPersistentVolume()); 
    this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
    this.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList()); 
    this.withPersistentVolumeList(instance.getPersistentVolumeList()); 
    this.withPodExecOptions(instance.getPodExecOptions()); 
    this.withPodList(instance.getPodList()); 
    this.withPodTemplateList(instance.getPodTemplateList()); 
    this.withQuantity(instance.getQuantity()); 
    this.withReplicationControllerList(instance.getReplicationControllerList()); 
    this.withResourceQuota(instance.getResourceQuota()); 
    this.withResourceQuotaList(instance.getResourceQuotaList()); 
    this.withRootPaths(instance.getRootPaths()); 
    this.withSecret(instance.getSecret()); 
    this.withSecretList(instance.getSecretList()); 
    this.withServiceAccount(instance.getServiceAccount()); 
    this.withServiceAccountList(instance.getServiceAccountList()); 
    this.withServiceList(instance.getServiceList()); 
    this.withStatus(instance.getStatus()); 
    this.withTime(instance.getTime()); 
    this.withToleration(instance.getToleration()); 
    this.withTopologySelectorTerm(instance.getTopologySelectorTerm()); 
    this.withTypeMeta(instance.getTypeMeta()); 
    this.withUpdateOptions(instance.getUpdateOptions()); 
    this.withWatchEvent(instance.getWatchEvent()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private APIGroupBuilder aPIGroup;
  private APIGroupListBuilder aPIGroupList;
  private APIResourceBuilder aPIResource;
  private APIResourceListBuilder aPIResourceList;
  private APIServiceBuilder aPIService;
  private APIServiceListBuilder aPIServiceList;
  private BaseKubernetesListBuilder baseKubernetesList;
  private BindingBuilder binding;
  private ComponentStatusBuilder componentStatus;
  private ComponentStatusListBuilder componentStatusList;
  private ConditionBuilder condition;
  private ConfigBuilder config;
  private ConfigMapBuilder configMap;
  private ConfigMapListBuilder configMapList;
  private ContainerStatusBuilder containerStatus;
  private CreateOptionsBuilder createOptions;
  private DeleteOptionsBuilder deleteOptions;
  private EndpointPortBuilder endpointPort;
  private EndpointsBuilder endpoints;
  private EndpointsListBuilder endpointsList;
  private EnvVarBuilder envVar;
  private EventBuilder event;
  private EventListBuilder eventList;
  private EventSeriesBuilder eventSeries;
  private EventSourceBuilder eventSource;
  private GetOptionsBuilder getOptions;
  private GroupKindBuilder groupKind;
  private GroupVersionKindBuilder groupVersionKind;
  private GroupVersionResourceBuilder groupVersionResource;
  private InfoBuilder info;
  private LimitRangeListBuilder limitRangeList;
  private ListOptionsBuilder listOptions;
  private MicroTimeBuilder microTime;
  private NamespaceBuilder namespace;
  private NamespaceListBuilder namespaceList;
  private NodeBuilder node;
  private NodeListBuilder nodeList;
  private ObjectMetaBuilder objectMeta;
  private PatchBuilder patch;
  private PatchOptionsBuilder patchOptions;
  private PersistentVolumeBuilder persistentVolume;
  private PersistentVolumeClaimBuilder persistentVolumeClaim;
  private PersistentVolumeClaimListBuilder persistentVolumeClaimList;
  private PersistentVolumeListBuilder persistentVolumeList;
  private PodExecOptionsBuilder podExecOptions;
  private PodListBuilder podList;
  private PodTemplateListBuilder podTemplateList;
  private QuantityBuilder quantity;
  private ReplicationControllerListBuilder replicationControllerList;
  private ResourceQuotaBuilder resourceQuota;
  private ResourceQuotaListBuilder resourceQuotaList;
  private RootPathsBuilder rootPaths;
  private SecretBuilder secret;
  private SecretListBuilder secretList;
  private ServiceAccountBuilder serviceAccount;
  private ServiceAccountListBuilder serviceAccountList;
  private ServiceListBuilder serviceList;
  private StatusBuilder status;
  private String time;
  private TolerationBuilder toleration;
  private TopologySelectorTermBuilder topologySelectorTerm;
  private TypeMetaBuilder typeMeta;
  private UpdateOptionsBuilder updateOptions;
  private WatchEventBuilder watchEvent;
  private Map<java.lang.String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAPIGroup instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.APIGroup getAPIGroup() {
    return this.aPIGroup!=null ?this.aPIGroup.build():null;
  }
  public io.fabric8.kubernetes.api.model.APIGroup buildAPIGroup() {
    return this.aPIGroup!=null ?this.aPIGroup.build():null;
  }
  public A withAPIGroup(io.fabric8.kubernetes.api.model.APIGroup aPIGroup) {
    _visitables.get("aPIGroup").remove(this.aPIGroup);
    if (aPIGroup!=null){ this.aPIGroup= new APIGroupBuilder(aPIGroup); _visitables.get("aPIGroup").add(this.aPIGroup);} return (A) this;
  }
  public Boolean hasAPIGroup() {
    return this.aPIGroup != null;
  }
  public ValidationSchemaFluent.APIGroupNested<A> withNewAPIGroup() {
    return new ValidationSchemaFluentImpl.APIGroupNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIGroupNested<A> withNewAPIGroupLike(io.fabric8.kubernetes.api.model.APIGroup item) {
    return new ValidationSchemaFluentImpl.APIGroupNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIGroupNested<A> editAPIGroup() {
    return withNewAPIGroupLike(getAPIGroup());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIGroupNested<A> editOrNewAPIGroup() {
    return withNewAPIGroupLike(getAPIGroup() != null ? getAPIGroup(): new io.fabric8.kubernetes.api.model.APIGroupBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIGroupNested<A> editOrNewAPIGroupLike(io.fabric8.kubernetes.api.model.APIGroup item) {
    return withNewAPIGroupLike(getAPIGroup() != null ? getAPIGroup(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAPIGroupList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public APIGroupList getAPIGroupList() {
    return this.aPIGroupList!=null ?this.aPIGroupList.build():null;
  }
  public io.fabric8.kubernetes.api.model.APIGroupList buildAPIGroupList() {
    return this.aPIGroupList!=null ?this.aPIGroupList.build():null;
  }
  public A withAPIGroupList(io.fabric8.kubernetes.api.model.APIGroupList aPIGroupList) {
    _visitables.get("aPIGroupList").remove(this.aPIGroupList);
    if (aPIGroupList!=null){ this.aPIGroupList= new io.fabric8.kubernetes.api.model.APIGroupListBuilder(aPIGroupList); _visitables.get("aPIGroupList").add(this.aPIGroupList);} return (A) this;
  }
  public java.lang.Boolean hasAPIGroupList() {
    return this.aPIGroupList != null;
  }
  public ValidationSchemaFluent.APIGroupListNested<A> withNewAPIGroupList() {
    return new ValidationSchemaFluentImpl.APIGroupListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIGroupListNested<A> withNewAPIGroupListLike(io.fabric8.kubernetes.api.model.APIGroupList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.APIGroupListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIGroupListNested<A> editAPIGroupList() {
    return withNewAPIGroupListLike(getAPIGroupList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIGroupListNested<A> editOrNewAPIGroupList() {
    return withNewAPIGroupListLike(getAPIGroupList() != null ? getAPIGroupList(): new io.fabric8.kubernetes.api.model.APIGroupListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIGroupListNested<A> editOrNewAPIGroupListLike(io.fabric8.kubernetes.api.model.APIGroupList item) {
    return withNewAPIGroupListLike(getAPIGroupList() != null ? getAPIGroupList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAPIResource instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.APIResource getAPIResource() {
    return this.aPIResource!=null ?this.aPIResource.build():null;
  }
  public io.fabric8.kubernetes.api.model.APIResource buildAPIResource() {
    return this.aPIResource!=null ?this.aPIResource.build():null;
  }
  public A withAPIResource(io.fabric8.kubernetes.api.model.APIResource aPIResource) {
    _visitables.get("aPIResource").remove(this.aPIResource);
    if (aPIResource!=null){ this.aPIResource= new APIResourceBuilder(aPIResource); _visitables.get("aPIResource").add(this.aPIResource);} return (A) this;
  }
  public java.lang.Boolean hasAPIResource() {
    return this.aPIResource != null;
  }
  public ValidationSchemaFluent.APIResourceNested<A> withNewAPIResource() {
    return new ValidationSchemaFluentImpl.APIResourceNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIResourceNested<A> withNewAPIResourceLike(io.fabric8.kubernetes.api.model.APIResource item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.APIResourceNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIResourceNested<A> editAPIResource() {
    return withNewAPIResourceLike(getAPIResource());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIResourceNested<A> editOrNewAPIResource() {
    return withNewAPIResourceLike(getAPIResource() != null ? getAPIResource(): new io.fabric8.kubernetes.api.model.APIResourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIResourceNested<A> editOrNewAPIResourceLike(io.fabric8.kubernetes.api.model.APIResource item) {
    return withNewAPIResourceLike(getAPIResource() != null ? getAPIResource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAPIResourceList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.APIResourceList getAPIResourceList() {
    return this.aPIResourceList!=null ?this.aPIResourceList.build():null;
  }
  public io.fabric8.kubernetes.api.model.APIResourceList buildAPIResourceList() {
    return this.aPIResourceList!=null ?this.aPIResourceList.build():null;
  }
  public A withAPIResourceList(io.fabric8.kubernetes.api.model.APIResourceList aPIResourceList) {
    _visitables.get("aPIResourceList").remove(this.aPIResourceList);
    if (aPIResourceList!=null){ this.aPIResourceList= new APIResourceListBuilder(aPIResourceList); _visitables.get("aPIResourceList").add(this.aPIResourceList);} return (A) this;
  }
  public java.lang.Boolean hasAPIResourceList() {
    return this.aPIResourceList != null;
  }
  public ValidationSchemaFluent.APIResourceListNested<A> withNewAPIResourceList() {
    return new ValidationSchemaFluentImpl.APIResourceListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIResourceListNested<A> withNewAPIResourceListLike(io.fabric8.kubernetes.api.model.APIResourceList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.APIResourceListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIResourceListNested<A> editAPIResourceList() {
    return withNewAPIResourceListLike(getAPIResourceList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIResourceListNested<A> editOrNewAPIResourceList() {
    return withNewAPIResourceListLike(getAPIResourceList() != null ? getAPIResourceList(): new io.fabric8.kubernetes.api.model.APIResourceListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIResourceListNested<A> editOrNewAPIResourceListLike(io.fabric8.kubernetes.api.model.APIResourceList item) {
    return withNewAPIResourceListLike(getAPIResourceList() != null ? getAPIResourceList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAPIService instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public APIService getAPIService() {
    return this.aPIService!=null ?this.aPIService.build():null;
  }
  public io.fabric8.kubernetes.api.model.APIService buildAPIService() {
    return this.aPIService!=null ?this.aPIService.build():null;
  }
  public A withAPIService(io.fabric8.kubernetes.api.model.APIService aPIService) {
    _visitables.get("aPIService").remove(this.aPIService);
    if (aPIService!=null){ this.aPIService= new io.fabric8.kubernetes.api.model.APIServiceBuilder(aPIService); _visitables.get("aPIService").add(this.aPIService);} return (A) this;
  }
  public java.lang.Boolean hasAPIService() {
    return this.aPIService != null;
  }
  public ValidationSchemaFluent.APIServiceNested<A> withNewAPIService() {
    return new ValidationSchemaFluentImpl.APIServiceNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIServiceNested<A> withNewAPIServiceLike(io.fabric8.kubernetes.api.model.APIService item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.APIServiceNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIServiceNested<A> editAPIService() {
    return withNewAPIServiceLike(getAPIService());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIServiceNested<A> editOrNewAPIService() {
    return withNewAPIServiceLike(getAPIService() != null ? getAPIService(): new io.fabric8.kubernetes.api.model.APIServiceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIServiceNested<A> editOrNewAPIServiceLike(io.fabric8.kubernetes.api.model.APIService item) {
    return withNewAPIServiceLike(getAPIService() != null ? getAPIService(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAPIServiceList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public APIServiceList getAPIServiceList() {
    return this.aPIServiceList!=null ?this.aPIServiceList.build():null;
  }
  public io.fabric8.kubernetes.api.model.APIServiceList buildAPIServiceList() {
    return this.aPIServiceList!=null ?this.aPIServiceList.build():null;
  }
  public A withAPIServiceList(io.fabric8.kubernetes.api.model.APIServiceList aPIServiceList) {
    _visitables.get("aPIServiceList").remove(this.aPIServiceList);
    if (aPIServiceList!=null){ this.aPIServiceList= new io.fabric8.kubernetes.api.model.APIServiceListBuilder(aPIServiceList); _visitables.get("aPIServiceList").add(this.aPIServiceList);} return (A) this;
  }
  public java.lang.Boolean hasAPIServiceList() {
    return this.aPIServiceList != null;
  }
  public ValidationSchemaFluent.APIServiceListNested<A> withNewAPIServiceList() {
    return new ValidationSchemaFluentImpl.APIServiceListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIServiceListNested<A> withNewAPIServiceListLike(io.fabric8.kubernetes.api.model.APIServiceList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.APIServiceListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIServiceListNested<A> editAPIServiceList() {
    return withNewAPIServiceListLike(getAPIServiceList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIServiceListNested<A> editOrNewAPIServiceList() {
    return withNewAPIServiceListLike(getAPIServiceList() != null ? getAPIServiceList(): new io.fabric8.kubernetes.api.model.APIServiceListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIServiceListNested<A> editOrNewAPIServiceListLike(io.fabric8.kubernetes.api.model.APIServiceList item) {
    return withNewAPIServiceListLike(getAPIServiceList() != null ? getAPIServiceList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBaseKubernetesList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public BaseKubernetesList getBaseKubernetesList() {
    return this.baseKubernetesList!=null ?this.baseKubernetesList.build():null;
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesList buildBaseKubernetesList() {
    return this.baseKubernetesList!=null ?this.baseKubernetesList.build():null;
  }
  public A withBaseKubernetesList(io.fabric8.kubernetes.api.model.BaseKubernetesList baseKubernetesList) {
    _visitables.get("baseKubernetesList").remove(this.baseKubernetesList);
    if (baseKubernetesList!=null){ this.baseKubernetesList= new io.fabric8.kubernetes.api.model.BaseKubernetesListBuilder(baseKubernetesList); _visitables.get("baseKubernetesList").add(this.baseKubernetesList);} return (A) this;
  }
  public java.lang.Boolean hasBaseKubernetesList() {
    return this.baseKubernetesList != null;
  }
  public ValidationSchemaFluent.BaseKubernetesListNested<A> withNewBaseKubernetesList() {
    return new ValidationSchemaFluentImpl.BaseKubernetesListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.BaseKubernetesListNested<A> withNewBaseKubernetesListLike(io.fabric8.kubernetes.api.model.BaseKubernetesList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.BaseKubernetesListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.BaseKubernetesListNested<A> editBaseKubernetesList() {
    return withNewBaseKubernetesListLike(getBaseKubernetesList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.BaseKubernetesListNested<A> editOrNewBaseKubernetesList() {
    return withNewBaseKubernetesListLike(getBaseKubernetesList() != null ? getBaseKubernetesList(): new io.fabric8.kubernetes.api.model.BaseKubernetesListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.BaseKubernetesListNested<A> editOrNewBaseKubernetesListLike(io.fabric8.kubernetes.api.model.BaseKubernetesList item) {
    return withNewBaseKubernetesListLike(getBaseKubernetesList() != null ? getBaseKubernetesList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBinding instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.Binding getBinding() {
    return this.binding!=null ?this.binding.build():null;
  }
  public io.fabric8.kubernetes.api.model.Binding buildBinding() {
    return this.binding!=null ?this.binding.build():null;
  }
  public A withBinding(io.fabric8.kubernetes.api.model.Binding binding) {
    _visitables.get("binding").remove(this.binding);
    if (binding!=null){ this.binding= new BindingBuilder(binding); _visitables.get("binding").add(this.binding);} return (A) this;
  }
  public java.lang.Boolean hasBinding() {
    return this.binding != null;
  }
  public ValidationSchemaFluent.BindingNested<A> withNewBinding() {
    return new ValidationSchemaFluentImpl.BindingNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.BindingNested<A> withNewBindingLike(io.fabric8.kubernetes.api.model.Binding item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.BindingNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.BindingNested<A> editBinding() {
    return withNewBindingLike(getBinding());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.BindingNested<A> editOrNewBinding() {
    return withNewBindingLike(getBinding() != null ? getBinding(): new io.fabric8.kubernetes.api.model.BindingBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.BindingNested<A> editOrNewBindingLike(io.fabric8.kubernetes.api.model.Binding item) {
    return withNewBindingLike(getBinding() != null ? getBinding(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildComponentStatus instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ComponentStatus getComponentStatus() {
    return this.componentStatus!=null ?this.componentStatus.build():null;
  }
  public io.fabric8.kubernetes.api.model.ComponentStatus buildComponentStatus() {
    return this.componentStatus!=null ?this.componentStatus.build():null;
  }
  public A withComponentStatus(io.fabric8.kubernetes.api.model.ComponentStatus componentStatus) {
    _visitables.get("componentStatus").remove(this.componentStatus);
    if (componentStatus!=null){ this.componentStatus= new ComponentStatusBuilder(componentStatus); _visitables.get("componentStatus").add(this.componentStatus);} return (A) this;
  }
  public java.lang.Boolean hasComponentStatus() {
    return this.componentStatus != null;
  }
  public ValidationSchemaFluent.ComponentStatusNested<A> withNewComponentStatus() {
    return new ValidationSchemaFluentImpl.ComponentStatusNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ComponentStatusNested<A> withNewComponentStatusLike(io.fabric8.kubernetes.api.model.ComponentStatus item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.ComponentStatusNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ComponentStatusNested<A> editComponentStatus() {
    return withNewComponentStatusLike(getComponentStatus());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ComponentStatusNested<A> editOrNewComponentStatus() {
    return withNewComponentStatusLike(getComponentStatus() != null ? getComponentStatus(): new io.fabric8.kubernetes.api.model.ComponentStatusBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ComponentStatusNested<A> editOrNewComponentStatusLike(io.fabric8.kubernetes.api.model.ComponentStatus item) {
    return withNewComponentStatusLike(getComponentStatus() != null ? getComponentStatus(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildComponentStatusList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public ComponentStatusList getComponentStatusList() {
    return this.componentStatusList!=null ?this.componentStatusList.build():null;
  }
  public io.fabric8.kubernetes.api.model.ComponentStatusList buildComponentStatusList() {
    return this.componentStatusList!=null ?this.componentStatusList.build():null;
  }
  public A withComponentStatusList(io.fabric8.kubernetes.api.model.ComponentStatusList componentStatusList) {
    _visitables.get("componentStatusList").remove(this.componentStatusList);
    if (componentStatusList!=null){ this.componentStatusList= new io.fabric8.kubernetes.api.model.ComponentStatusListBuilder(componentStatusList); _visitables.get("componentStatusList").add(this.componentStatusList);} return (A) this;
  }
  public java.lang.Boolean hasComponentStatusList() {
    return this.componentStatusList != null;
  }
  public ValidationSchemaFluent.ComponentStatusListNested<A> withNewComponentStatusList() {
    return new ValidationSchemaFluentImpl.ComponentStatusListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ComponentStatusListNested<A> withNewComponentStatusListLike(io.fabric8.kubernetes.api.model.ComponentStatusList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.ComponentStatusListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ComponentStatusListNested<A> editComponentStatusList() {
    return withNewComponentStatusListLike(getComponentStatusList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ComponentStatusListNested<A> editOrNewComponentStatusList() {
    return withNewComponentStatusListLike(getComponentStatusList() != null ? getComponentStatusList(): new io.fabric8.kubernetes.api.model.ComponentStatusListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ComponentStatusListNested<A> editOrNewComponentStatusListLike(io.fabric8.kubernetes.api.model.ComponentStatusList item) {
    return withNewComponentStatusListLike(getComponentStatusList() != null ? getComponentStatusList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCondition instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.Condition getCondition() {
    return this.condition!=null ?this.condition.build():null;
  }
  public io.fabric8.kubernetes.api.model.Condition buildCondition() {
    return this.condition!=null ?this.condition.build():null;
  }
  public A withCondition(io.fabric8.kubernetes.api.model.Condition condition) {
    _visitables.get("condition").remove(this.condition);
    if (condition!=null){ this.condition= new ConditionBuilder(condition); _visitables.get("condition").add(this.condition);} return (A) this;
  }
  public java.lang.Boolean hasCondition() {
    return this.condition != null;
  }
  public ValidationSchemaFluent.ConditionNested<A> withNewCondition() {
    return new ValidationSchemaFluentImpl.ConditionNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConditionNested<A> withNewConditionLike(io.fabric8.kubernetes.api.model.Condition item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.ConditionNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConditionNested<A> editCondition() {
    return withNewConditionLike(getCondition());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConditionNested<A> editOrNewCondition() {
    return withNewConditionLike(getCondition() != null ? getCondition(): new io.fabric8.kubernetes.api.model.ConditionBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConditionNested<A> editOrNewConditionLike(io.fabric8.kubernetes.api.model.Condition item) {
    return withNewConditionLike(getCondition() != null ? getCondition(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public Config getConfig() {
    return this.config!=null ?this.config.build():null;
  }
  public io.fabric8.kubernetes.api.model.Config buildConfig() {
    return this.config!=null ?this.config.build():null;
  }
  public A withConfig(io.fabric8.kubernetes.api.model.Config config) {
    _visitables.get("config").remove(this.config);
    if (config!=null){ this.config= new io.fabric8.kubernetes.api.model.ConfigBuilder(config); _visitables.get("config").add(this.config);} return (A) this;
  }
  public java.lang.Boolean hasConfig() {
    return this.config != null;
  }
  public ValidationSchemaFluent.ConfigNested<A> withNewConfig() {
    return new ValidationSchemaFluentImpl.ConfigNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConfigNested<A> withNewConfigLike(io.fabric8.kubernetes.api.model.Config item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.ConfigNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConfigNested<A> editConfig() {
    return withNewConfigLike(getConfig());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConfigNested<A> editOrNewConfig() {
    return withNewConfigLike(getConfig() != null ? getConfig(): new io.fabric8.kubernetes.api.model.ConfigBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConfigNested<A> editOrNewConfigLike(io.fabric8.kubernetes.api.model.Config item) {
    return withNewConfigLike(getConfig() != null ? getConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildConfigMap instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public ConfigMap getConfigMap() {
    return this.configMap!=null ?this.configMap.build():null;
  }
  public io.fabric8.kubernetes.api.model.ConfigMap buildConfigMap() {
    return this.configMap!=null ?this.configMap.build():null;
  }
  public A withConfigMap(io.fabric8.kubernetes.api.model.ConfigMap configMap) {
    _visitables.get("configMap").remove(this.configMap);
    if (configMap!=null){ this.configMap= new io.fabric8.kubernetes.api.model.ConfigMapBuilder(configMap); _visitables.get("configMap").add(this.configMap);} return (A) this;
  }
  public java.lang.Boolean hasConfigMap() {
    return this.configMap != null;
  }
  public ValidationSchemaFluent.ConfigMapNested<A> withNewConfigMap() {
    return new ValidationSchemaFluentImpl.ConfigMapNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConfigMapNested<A> withNewConfigMapLike(io.fabric8.kubernetes.api.model.ConfigMap item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.ConfigMapNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConfigMapNested<A> editConfigMap() {
    return withNewConfigMapLike(getConfigMap());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConfigMapNested<A> editOrNewConfigMap() {
    return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): new io.fabric8.kubernetes.api.model.ConfigMapBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConfigMapNested<A> editOrNewConfigMapLike(io.fabric8.kubernetes.api.model.ConfigMap item) {
    return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildConfigMapList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ConfigMapList getConfigMapList() {
    return this.configMapList!=null ?this.configMapList.build():null;
  }
  public io.fabric8.kubernetes.api.model.ConfigMapList buildConfigMapList() {
    return this.configMapList!=null ?this.configMapList.build():null;
  }
  public A withConfigMapList(io.fabric8.kubernetes.api.model.ConfigMapList configMapList) {
    _visitables.get("configMapList").remove(this.configMapList);
    if (configMapList!=null){ this.configMapList= new ConfigMapListBuilder(configMapList); _visitables.get("configMapList").add(this.configMapList);} return (A) this;
  }
  public java.lang.Boolean hasConfigMapList() {
    return this.configMapList != null;
  }
  public ValidationSchemaFluent.ConfigMapListNested<A> withNewConfigMapList() {
    return new ValidationSchemaFluentImpl.ConfigMapListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConfigMapListNested<A> withNewConfigMapListLike(io.fabric8.kubernetes.api.model.ConfigMapList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.ConfigMapListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConfigMapListNested<A> editConfigMapList() {
    return withNewConfigMapListLike(getConfigMapList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConfigMapListNested<A> editOrNewConfigMapList() {
    return withNewConfigMapListLike(getConfigMapList() != null ? getConfigMapList(): new io.fabric8.kubernetes.api.model.ConfigMapListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConfigMapListNested<A> editOrNewConfigMapListLike(io.fabric8.kubernetes.api.model.ConfigMapList item) {
    return withNewConfigMapListLike(getConfigMapList() != null ? getConfigMapList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildContainerStatus instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ContainerStatus getContainerStatus() {
    return this.containerStatus!=null ?this.containerStatus.build():null;
  }
  public io.fabric8.kubernetes.api.model.ContainerStatus buildContainerStatus() {
    return this.containerStatus!=null ?this.containerStatus.build():null;
  }
  public A withContainerStatus(io.fabric8.kubernetes.api.model.ContainerStatus containerStatus) {
    _visitables.get("containerStatus").remove(this.containerStatus);
    if (containerStatus!=null){ this.containerStatus= new ContainerStatusBuilder(containerStatus); _visitables.get("containerStatus").add(this.containerStatus);} return (A) this;
  }
  public java.lang.Boolean hasContainerStatus() {
    return this.containerStatus != null;
  }
  public ValidationSchemaFluent.ContainerStatusNested<A> withNewContainerStatus() {
    return new ValidationSchemaFluentImpl.ContainerStatusNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ContainerStatusNested<A> withNewContainerStatusLike(io.fabric8.kubernetes.api.model.ContainerStatus item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.ContainerStatusNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ContainerStatusNested<A> editContainerStatus() {
    return withNewContainerStatusLike(getContainerStatus());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ContainerStatusNested<A> editOrNewContainerStatus() {
    return withNewContainerStatusLike(getContainerStatus() != null ? getContainerStatus(): new io.fabric8.kubernetes.api.model.ContainerStatusBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ContainerStatusNested<A> editOrNewContainerStatusLike(io.fabric8.kubernetes.api.model.ContainerStatus item) {
    return withNewContainerStatusLike(getContainerStatus() != null ? getContainerStatus(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCreateOptions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.CreateOptions getCreateOptions() {
    return this.createOptions!=null ?this.createOptions.build():null;
  }
  public io.fabric8.kubernetes.api.model.CreateOptions buildCreateOptions() {
    return this.createOptions!=null ?this.createOptions.build():null;
  }
  public A withCreateOptions(io.fabric8.kubernetes.api.model.CreateOptions createOptions) {
    _visitables.get("createOptions").remove(this.createOptions);
    if (createOptions!=null){ this.createOptions= new CreateOptionsBuilder(createOptions); _visitables.get("createOptions").add(this.createOptions);} return (A) this;
  }
  public java.lang.Boolean hasCreateOptions() {
    return this.createOptions != null;
  }
  public ValidationSchemaFluent.CreateOptionsNested<A> withNewCreateOptions() {
    return new ValidationSchemaFluentImpl.CreateOptionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.CreateOptionsNested<A> withNewCreateOptionsLike(io.fabric8.kubernetes.api.model.CreateOptions item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.CreateOptionsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.CreateOptionsNested<A> editCreateOptions() {
    return withNewCreateOptionsLike(getCreateOptions());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.CreateOptionsNested<A> editOrNewCreateOptions() {
    return withNewCreateOptionsLike(getCreateOptions() != null ? getCreateOptions(): new io.fabric8.kubernetes.api.model.CreateOptionsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.CreateOptionsNested<A> editOrNewCreateOptionsLike(io.fabric8.kubernetes.api.model.CreateOptions item) {
    return withNewCreateOptionsLike(getCreateOptions() != null ? getCreateOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDeleteOptions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.DeleteOptions getDeleteOptions() {
    return this.deleteOptions!=null ?this.deleteOptions.build():null;
  }
  public io.fabric8.kubernetes.api.model.DeleteOptions buildDeleteOptions() {
    return this.deleteOptions!=null ?this.deleteOptions.build():null;
  }
  public A withDeleteOptions(io.fabric8.kubernetes.api.model.DeleteOptions deleteOptions) {
    _visitables.get("deleteOptions").remove(this.deleteOptions);
    if (deleteOptions!=null){ this.deleteOptions= new DeleteOptionsBuilder(deleteOptions); _visitables.get("deleteOptions").add(this.deleteOptions);} return (A) this;
  }
  public java.lang.Boolean hasDeleteOptions() {
    return this.deleteOptions != null;
  }
  public ValidationSchemaFluent.DeleteOptionsNested<A> withNewDeleteOptions() {
    return new ValidationSchemaFluentImpl.DeleteOptionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.DeleteOptionsNested<A> withNewDeleteOptionsLike(io.fabric8.kubernetes.api.model.DeleteOptions item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.DeleteOptionsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.DeleteOptionsNested<A> editDeleteOptions() {
    return withNewDeleteOptionsLike(getDeleteOptions());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.DeleteOptionsNested<A> editOrNewDeleteOptions() {
    return withNewDeleteOptionsLike(getDeleteOptions() != null ? getDeleteOptions(): new io.fabric8.kubernetes.api.model.DeleteOptionsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.DeleteOptionsNested<A> editOrNewDeleteOptionsLike(io.fabric8.kubernetes.api.model.DeleteOptions item) {
    return withNewDeleteOptionsLike(getDeleteOptions() != null ? getDeleteOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEndpointPort instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.EndpointPort getEndpointPort() {
    return this.endpointPort!=null ?this.endpointPort.build():null;
  }
  public io.fabric8.kubernetes.api.model.EndpointPort buildEndpointPort() {
    return this.endpointPort!=null ?this.endpointPort.build():null;
  }
  public A withEndpointPort(io.fabric8.kubernetes.api.model.EndpointPort endpointPort) {
    _visitables.get("endpointPort").remove(this.endpointPort);
    if (endpointPort!=null){ this.endpointPort= new EndpointPortBuilder(endpointPort); _visitables.get("endpointPort").add(this.endpointPort);} return (A) this;
  }
  public java.lang.Boolean hasEndpointPort() {
    return this.endpointPort != null;
  }
  public A withNewEndpointPort(java.lang.String appProtocol,java.lang.String name,Integer port,java.lang.String protocol) {
    return (A)withEndpointPort(new EndpointPort(appProtocol, name, port, protocol));
  }
  public ValidationSchemaFluent.EndpointPortNested<A> withNewEndpointPort() {
    return new ValidationSchemaFluentImpl.EndpointPortNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EndpointPortNested<A> withNewEndpointPortLike(io.fabric8.kubernetes.api.model.EndpointPort item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.EndpointPortNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EndpointPortNested<A> editEndpointPort() {
    return withNewEndpointPortLike(getEndpointPort());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EndpointPortNested<A> editOrNewEndpointPort() {
    return withNewEndpointPortLike(getEndpointPort() != null ? getEndpointPort(): new io.fabric8.kubernetes.api.model.EndpointPortBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EndpointPortNested<A> editOrNewEndpointPortLike(io.fabric8.kubernetes.api.model.EndpointPort item) {
    return withNewEndpointPortLike(getEndpointPort() != null ? getEndpointPort(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEndpoints instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public Endpoints getEndpoints() {
    return this.endpoints!=null ?this.endpoints.build():null;
  }
  public io.fabric8.kubernetes.api.model.Endpoints buildEndpoints() {
    return this.endpoints!=null ?this.endpoints.build():null;
  }
  public A withEndpoints(io.fabric8.kubernetes.api.model.Endpoints endpoints) {
    _visitables.get("endpoints").remove(this.endpoints);
    if (endpoints!=null){ this.endpoints= new io.fabric8.kubernetes.api.model.EndpointsBuilder(endpoints); _visitables.get("endpoints").add(this.endpoints);} return (A) this;
  }
  public java.lang.Boolean hasEndpoints() {
    return this.endpoints != null;
  }
  public ValidationSchemaFluent.EndpointsNested<A> withNewEndpoints() {
    return new ValidationSchemaFluentImpl.EndpointsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EndpointsNested<A> withNewEndpointsLike(io.fabric8.kubernetes.api.model.Endpoints item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.EndpointsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EndpointsNested<A> editEndpoints() {
    return withNewEndpointsLike(getEndpoints());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EndpointsNested<A> editOrNewEndpoints() {
    return withNewEndpointsLike(getEndpoints() != null ? getEndpoints(): new io.fabric8.kubernetes.api.model.EndpointsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EndpointsNested<A> editOrNewEndpointsLike(io.fabric8.kubernetes.api.model.Endpoints item) {
    return withNewEndpointsLike(getEndpoints() != null ? getEndpoints(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEndpointsList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.EndpointsList getEndpointsList() {
    return this.endpointsList!=null ?this.endpointsList.build():null;
  }
  public io.fabric8.kubernetes.api.model.EndpointsList buildEndpointsList() {
    return this.endpointsList!=null ?this.endpointsList.build():null;
  }
  public A withEndpointsList(io.fabric8.kubernetes.api.model.EndpointsList endpointsList) {
    _visitables.get("endpointsList").remove(this.endpointsList);
    if (endpointsList!=null){ this.endpointsList= new EndpointsListBuilder(endpointsList); _visitables.get("endpointsList").add(this.endpointsList);} return (A) this;
  }
  public java.lang.Boolean hasEndpointsList() {
    return this.endpointsList != null;
  }
  public ValidationSchemaFluent.EndpointsListNested<A> withNewEndpointsList() {
    return new ValidationSchemaFluentImpl.EndpointsListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EndpointsListNested<A> withNewEndpointsListLike(io.fabric8.kubernetes.api.model.EndpointsList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.EndpointsListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EndpointsListNested<A> editEndpointsList() {
    return withNewEndpointsListLike(getEndpointsList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EndpointsListNested<A> editOrNewEndpointsList() {
    return withNewEndpointsListLike(getEndpointsList() != null ? getEndpointsList(): new io.fabric8.kubernetes.api.model.EndpointsListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EndpointsListNested<A> editOrNewEndpointsListLike(io.fabric8.kubernetes.api.model.EndpointsList item) {
    return withNewEndpointsListLike(getEndpointsList() != null ? getEndpointsList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEnvVar instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.EnvVar getEnvVar() {
    return this.envVar!=null ?this.envVar.build():null;
  }
  public io.fabric8.kubernetes.api.model.EnvVar buildEnvVar() {
    return this.envVar!=null ?this.envVar.build():null;
  }
  public A withEnvVar(io.fabric8.kubernetes.api.model.EnvVar envVar) {
    _visitables.get("envVar").remove(this.envVar);
    if (envVar!=null){ this.envVar= new EnvVarBuilder(envVar); _visitables.get("envVar").add(this.envVar);} return (A) this;
  }
  public java.lang.Boolean hasEnvVar() {
    return this.envVar != null;
  }
  public ValidationSchemaFluent.EnvVarNested<A> withNewEnvVar() {
    return new ValidationSchemaFluentImpl.EnvVarNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EnvVarNested<A> withNewEnvVarLike(io.fabric8.kubernetes.api.model.EnvVar item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.EnvVarNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EnvVarNested<A> editEnvVar() {
    return withNewEnvVarLike(getEnvVar());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EnvVarNested<A> editOrNewEnvVar() {
    return withNewEnvVarLike(getEnvVar() != null ? getEnvVar(): new io.fabric8.kubernetes.api.model.EnvVarBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EnvVarNested<A> editOrNewEnvVarLike(io.fabric8.kubernetes.api.model.EnvVar item) {
    return withNewEnvVarLike(getEnvVar() != null ? getEnvVar(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEvent instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.Event getEvent() {
    return this.event!=null ?this.event.build():null;
  }
  public io.fabric8.kubernetes.api.model.Event buildEvent() {
    return this.event!=null ?this.event.build():null;
  }
  public A withEvent(io.fabric8.kubernetes.api.model.Event event) {
    _visitables.get("event").remove(this.event);
    if (event!=null){ this.event= new io.fabric8.kubernetes.api.model.EventBuilder(event); _visitables.get("event").add(this.event);} return (A) this;
  }
  public java.lang.Boolean hasEvent() {
    return this.event != null;
  }
  public ValidationSchemaFluent.EventNested<A> withNewEvent() {
    return new ValidationSchemaFluentImpl.EventNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventNested<A> withNewEventLike(io.fabric8.kubernetes.api.model.Event item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.EventNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventNested<A> editEvent() {
    return withNewEventLike(getEvent());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventNested<A> editOrNewEvent() {
    return withNewEventLike(getEvent() != null ? getEvent(): new io.fabric8.kubernetes.api.model.EventBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventNested<A> editOrNewEventLike(io.fabric8.kubernetes.api.model.Event item) {
    return withNewEventLike(getEvent() != null ? getEvent(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEventList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public EventList getEventList() {
    return this.eventList!=null ?this.eventList.build():null;
  }
  public io.fabric8.kubernetes.api.model.EventList buildEventList() {
    return this.eventList!=null ?this.eventList.build():null;
  }
  public A withEventList(io.fabric8.kubernetes.api.model.EventList eventList) {
    _visitables.get("eventList").remove(this.eventList);
    if (eventList!=null){ this.eventList= new EventListBuilder(eventList); _visitables.get("eventList").add(this.eventList);} return (A) this;
  }
  public java.lang.Boolean hasEventList() {
    return this.eventList != null;
  }
  public ValidationSchemaFluent.EventListNested<A> withNewEventList() {
    return new ValidationSchemaFluentImpl.EventListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventListNested<A> withNewEventListLike(io.fabric8.kubernetes.api.model.EventList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.EventListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventListNested<A> editEventList() {
    return withNewEventListLike(getEventList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventListNested<A> editOrNewEventList() {
    return withNewEventListLike(getEventList() != null ? getEventList(): new io.fabric8.kubernetes.api.model.EventListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventListNested<A> editOrNewEventListLike(io.fabric8.kubernetes.api.model.EventList item) {
    return withNewEventListLike(getEventList() != null ? getEventList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEventSeries instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public EventSeries getEventSeries() {
    return this.eventSeries!=null ?this.eventSeries.build():null;
  }
  public io.fabric8.kubernetes.api.model.EventSeries buildEventSeries() {
    return this.eventSeries!=null ?this.eventSeries.build():null;
  }
  public A withEventSeries(io.fabric8.kubernetes.api.model.EventSeries eventSeries) {
    _visitables.get("eventSeries").remove(this.eventSeries);
    if (eventSeries!=null){ this.eventSeries= new io.fabric8.kubernetes.api.model.EventSeriesBuilder(eventSeries); _visitables.get("eventSeries").add(this.eventSeries);} return (A) this;
  }
  public java.lang.Boolean hasEventSeries() {
    return this.eventSeries != null;
  }
  public ValidationSchemaFluent.EventSeriesNested<A> withNewEventSeries() {
    return new ValidationSchemaFluentImpl.EventSeriesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventSeriesNested<A> withNewEventSeriesLike(io.fabric8.kubernetes.api.model.EventSeries item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.EventSeriesNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventSeriesNested<A> editEventSeries() {
    return withNewEventSeriesLike(getEventSeries());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventSeriesNested<A> editOrNewEventSeries() {
    return withNewEventSeriesLike(getEventSeries() != null ? getEventSeries(): new io.fabric8.kubernetes.api.model.EventSeriesBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventSeriesNested<A> editOrNewEventSeriesLike(io.fabric8.kubernetes.api.model.EventSeries item) {
    return withNewEventSeriesLike(getEventSeries() != null ? getEventSeries(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEventSource instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.EventSource getEventSource() {
    return this.eventSource!=null ?this.eventSource.build():null;
  }
  public io.fabric8.kubernetes.api.model.EventSource buildEventSource() {
    return this.eventSource!=null ?this.eventSource.build():null;
  }
  public A withEventSource(io.fabric8.kubernetes.api.model.EventSource eventSource) {
    _visitables.get("eventSource").remove(this.eventSource);
    if (eventSource!=null){ this.eventSource= new EventSourceBuilder(eventSource); _visitables.get("eventSource").add(this.eventSource);} return (A) this;
  }
  public java.lang.Boolean hasEventSource() {
    return this.eventSource != null;
  }
  public A withNewEventSource(java.lang.String component,java.lang.String host) {
    return (A)withEventSource(new EventSource(component, host));
  }
  public ValidationSchemaFluent.EventSourceNested<A> withNewEventSource() {
    return new ValidationSchemaFluentImpl.EventSourceNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventSourceNested<A> withNewEventSourceLike(io.fabric8.kubernetes.api.model.EventSource item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.EventSourceNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventSourceNested<A> editEventSource() {
    return withNewEventSourceLike(getEventSource());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventSourceNested<A> editOrNewEventSource() {
    return withNewEventSourceLike(getEventSource() != null ? getEventSource(): new io.fabric8.kubernetes.api.model.EventSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventSourceNested<A> editOrNewEventSourceLike(io.fabric8.kubernetes.api.model.EventSource item) {
    return withNewEventSourceLike(getEventSource() != null ? getEventSource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGetOptions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.GetOptions getGetOptions() {
    return this.getOptions!=null ?this.getOptions.build():null;
  }
  public io.fabric8.kubernetes.api.model.GetOptions buildGetOptions() {
    return this.getOptions!=null ?this.getOptions.build():null;
  }
  public A withGetOptions(io.fabric8.kubernetes.api.model.GetOptions getOptions) {
    _visitables.get("getOptions").remove(this.getOptions);
    if (getOptions!=null){ this.getOptions= new GetOptionsBuilder(getOptions); _visitables.get("getOptions").add(this.getOptions);} return (A) this;
  }
  public java.lang.Boolean hasGetOptions() {
    return this.getOptions != null;
  }
  public A withNewGetOptions(java.lang.String apiVersion,java.lang.String kind,java.lang.String resourceVersion) {
    return (A)withGetOptions(new GetOptions(apiVersion, kind, resourceVersion));
  }
  public ValidationSchemaFluent.GetOptionsNested<A> withNewGetOptions() {
    return new ValidationSchemaFluentImpl.GetOptionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GetOptionsNested<A> withNewGetOptionsLike(io.fabric8.kubernetes.api.model.GetOptions item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.GetOptionsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GetOptionsNested<A> editGetOptions() {
    return withNewGetOptionsLike(getGetOptions());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GetOptionsNested<A> editOrNewGetOptions() {
    return withNewGetOptionsLike(getGetOptions() != null ? getGetOptions(): new io.fabric8.kubernetes.api.model.GetOptionsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GetOptionsNested<A> editOrNewGetOptionsLike(io.fabric8.kubernetes.api.model.GetOptions item) {
    return withNewGetOptionsLike(getGetOptions() != null ? getGetOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGroupKind instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public GroupKind getGroupKind() {
    return this.groupKind!=null ?this.groupKind.build():null;
  }
  public io.fabric8.kubernetes.api.model.GroupKind buildGroupKind() {
    return this.groupKind!=null ?this.groupKind.build():null;
  }
  public A withGroupKind(io.fabric8.kubernetes.api.model.GroupKind groupKind) {
    _visitables.get("groupKind").remove(this.groupKind);
    if (groupKind!=null){ this.groupKind= new io.fabric8.kubernetes.api.model.GroupKindBuilder(groupKind); _visitables.get("groupKind").add(this.groupKind);} return (A) this;
  }
  public java.lang.Boolean hasGroupKind() {
    return this.groupKind != null;
  }
  public A withNewGroupKind(java.lang.String group,java.lang.String kind) {
    return (A)withGroupKind(new GroupKind(group, kind));
  }
  public ValidationSchemaFluent.GroupKindNested<A> withNewGroupKind() {
    return new ValidationSchemaFluentImpl.GroupKindNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GroupKindNested<A> withNewGroupKindLike(io.fabric8.kubernetes.api.model.GroupKind item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.GroupKindNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GroupKindNested<A> editGroupKind() {
    return withNewGroupKindLike(getGroupKind());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GroupKindNested<A> editOrNewGroupKind() {
    return withNewGroupKindLike(getGroupKind() != null ? getGroupKind(): new io.fabric8.kubernetes.api.model.GroupKindBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GroupKindNested<A> editOrNewGroupKindLike(io.fabric8.kubernetes.api.model.GroupKind item) {
    return withNewGroupKindLike(getGroupKind() != null ? getGroupKind(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGroupVersionKind instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public GroupVersionKind getGroupVersionKind() {
    return this.groupVersionKind!=null ?this.groupVersionKind.build():null;
  }
  public io.fabric8.kubernetes.api.model.GroupVersionKind buildGroupVersionKind() {
    return this.groupVersionKind!=null ?this.groupVersionKind.build():null;
  }
  public A withGroupVersionKind(io.fabric8.kubernetes.api.model.GroupVersionKind groupVersionKind) {
    _visitables.get("groupVersionKind").remove(this.groupVersionKind);
    if (groupVersionKind!=null){ this.groupVersionKind= new io.fabric8.kubernetes.api.model.GroupVersionKindBuilder(groupVersionKind); _visitables.get("groupVersionKind").add(this.groupVersionKind);} return (A) this;
  }
  public java.lang.Boolean hasGroupVersionKind() {
    return this.groupVersionKind != null;
  }
  public A withNewGroupVersionKind(java.lang.String group,java.lang.String kind,java.lang.String version) {
    return (A)withGroupVersionKind(new GroupVersionKind(group, kind, version));
  }
  public ValidationSchemaFluent.GroupVersionKindNested<A> withNewGroupVersionKind() {
    return new ValidationSchemaFluentImpl.GroupVersionKindNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GroupVersionKindNested<A> withNewGroupVersionKindLike(io.fabric8.kubernetes.api.model.GroupVersionKind item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.GroupVersionKindNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GroupVersionKindNested<A> editGroupVersionKind() {
    return withNewGroupVersionKindLike(getGroupVersionKind());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GroupVersionKindNested<A> editOrNewGroupVersionKind() {
    return withNewGroupVersionKindLike(getGroupVersionKind() != null ? getGroupVersionKind(): new io.fabric8.kubernetes.api.model.GroupVersionKindBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GroupVersionKindNested<A> editOrNewGroupVersionKindLike(io.fabric8.kubernetes.api.model.GroupVersionKind item) {
    return withNewGroupVersionKindLike(getGroupVersionKind() != null ? getGroupVersionKind(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGroupVersionResource instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public GroupVersionResource getGroupVersionResource() {
    return this.groupVersionResource!=null ?this.groupVersionResource.build():null;
  }
  public io.fabric8.kubernetes.api.model.GroupVersionResource buildGroupVersionResource() {
    return this.groupVersionResource!=null ?this.groupVersionResource.build():null;
  }
  public A withGroupVersionResource(io.fabric8.kubernetes.api.model.GroupVersionResource groupVersionResource) {
    _visitables.get("groupVersionResource").remove(this.groupVersionResource);
    if (groupVersionResource!=null){ this.groupVersionResource= new io.fabric8.kubernetes.api.model.GroupVersionResourceBuilder(groupVersionResource); _visitables.get("groupVersionResource").add(this.groupVersionResource);} return (A) this;
  }
  public java.lang.Boolean hasGroupVersionResource() {
    return this.groupVersionResource != null;
  }
  public A withNewGroupVersionResource(java.lang.String group,java.lang.String resource,java.lang.String version) {
    return (A)withGroupVersionResource(new GroupVersionResource(group, resource, version));
  }
  public ValidationSchemaFluent.GroupVersionResourceNested<A> withNewGroupVersionResource() {
    return new ValidationSchemaFluentImpl.GroupVersionResourceNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GroupVersionResourceNested<A> withNewGroupVersionResourceLike(io.fabric8.kubernetes.api.model.GroupVersionResource item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.GroupVersionResourceNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GroupVersionResourceNested<A> editGroupVersionResource() {
    return withNewGroupVersionResourceLike(getGroupVersionResource());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GroupVersionResourceNested<A> editOrNewGroupVersionResource() {
    return withNewGroupVersionResourceLike(getGroupVersionResource() != null ? getGroupVersionResource(): new io.fabric8.kubernetes.api.model.GroupVersionResourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GroupVersionResourceNested<A> editOrNewGroupVersionResourceLike(io.fabric8.kubernetes.api.model.GroupVersionResource item) {
    return withNewGroupVersionResourceLike(getGroupVersionResource() != null ? getGroupVersionResource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildInfo instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.version.Info getInfo() {
    return this.info!=null ?this.info.build():null;
  }
  public io.fabric8.kubernetes.api.model.version.Info buildInfo() {
    return this.info!=null ?this.info.build():null;
  }
  public A withInfo(io.fabric8.kubernetes.api.model.version.Info info) {
    _visitables.get("info").remove(this.info);
    if (info!=null){ this.info= new InfoBuilder(info); _visitables.get("info").add(this.info);} return (A) this;
  }
  public java.lang.Boolean hasInfo() {
    return this.info != null;
  }
  public ValidationSchemaFluent.InfoNested<A> withNewInfo() {
    return new ValidationSchemaFluentImpl.InfoNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.InfoNested<A> withNewInfoLike(io.fabric8.kubernetes.api.model.version.Info item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.InfoNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.InfoNested<A> editInfo() {
    return withNewInfoLike(getInfo());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.InfoNested<A> editOrNewInfo() {
    return withNewInfoLike(getInfo() != null ? getInfo(): new io.fabric8.kubernetes.api.model.version.InfoBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.InfoNested<A> editOrNewInfoLike(io.fabric8.kubernetes.api.model.version.Info item) {
    return withNewInfoLike(getInfo() != null ? getInfo(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLimitRangeList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public LimitRangeList getLimitRangeList() {
    return this.limitRangeList!=null ?this.limitRangeList.build():null;
  }
  public io.fabric8.kubernetes.api.model.LimitRangeList buildLimitRangeList() {
    return this.limitRangeList!=null ?this.limitRangeList.build():null;
  }
  public A withLimitRangeList(io.fabric8.kubernetes.api.model.LimitRangeList limitRangeList) {
    _visitables.get("limitRangeList").remove(this.limitRangeList);
    if (limitRangeList!=null){ this.limitRangeList= new io.fabric8.kubernetes.api.model.LimitRangeListBuilder(limitRangeList); _visitables.get("limitRangeList").add(this.limitRangeList);} return (A) this;
  }
  public java.lang.Boolean hasLimitRangeList() {
    return this.limitRangeList != null;
  }
  public ValidationSchemaFluent.LimitRangeListNested<A> withNewLimitRangeList() {
    return new ValidationSchemaFluentImpl.LimitRangeListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.LimitRangeListNested<A> withNewLimitRangeListLike(io.fabric8.kubernetes.api.model.LimitRangeList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.LimitRangeListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.LimitRangeListNested<A> editLimitRangeList() {
    return withNewLimitRangeListLike(getLimitRangeList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.LimitRangeListNested<A> editOrNewLimitRangeList() {
    return withNewLimitRangeListLike(getLimitRangeList() != null ? getLimitRangeList(): new io.fabric8.kubernetes.api.model.LimitRangeListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.LimitRangeListNested<A> editOrNewLimitRangeListLike(io.fabric8.kubernetes.api.model.LimitRangeList item) {
    return withNewLimitRangeListLike(getLimitRangeList() != null ? getLimitRangeList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildListOptions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public ListOptions getListOptions() {
    return this.listOptions!=null ?this.listOptions.build():null;
  }
  public io.fabric8.kubernetes.api.model.ListOptions buildListOptions() {
    return this.listOptions!=null ?this.listOptions.build():null;
  }
  public A withListOptions(io.fabric8.kubernetes.api.model.ListOptions listOptions) {
    _visitables.get("listOptions").remove(this.listOptions);
    if (listOptions!=null){ this.listOptions= new io.fabric8.kubernetes.api.model.ListOptionsBuilder(listOptions); _visitables.get("listOptions").add(this.listOptions);} return (A) this;
  }
  public java.lang.Boolean hasListOptions() {
    return this.listOptions != null;
  }
  public ValidationSchemaFluent.ListOptionsNested<A> withNewListOptions() {
    return new ValidationSchemaFluentImpl.ListOptionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ListOptionsNested<A> withNewListOptionsLike(io.fabric8.kubernetes.api.model.ListOptions item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.ListOptionsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ListOptionsNested<A> editListOptions() {
    return withNewListOptionsLike(getListOptions());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ListOptionsNested<A> editOrNewListOptions() {
    return withNewListOptionsLike(getListOptions() != null ? getListOptions(): new io.fabric8.kubernetes.api.model.ListOptionsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ListOptionsNested<A> editOrNewListOptionsLike(io.fabric8.kubernetes.api.model.ListOptions item) {
    return withNewListOptionsLike(getListOptions() != null ? getListOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildMicroTime instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.MicroTime getMicroTime() {
    return this.microTime!=null ?this.microTime.build():null;
  }
  public io.fabric8.kubernetes.api.model.MicroTime buildMicroTime() {
    return this.microTime!=null ?this.microTime.build():null;
  }
  public A withMicroTime(io.fabric8.kubernetes.api.model.MicroTime microTime) {
    _visitables.get("microTime").remove(this.microTime);
    if (microTime!=null){ this.microTime= new MicroTimeBuilder(microTime); _visitables.get("microTime").add(this.microTime);} return (A) this;
  }
  public java.lang.Boolean hasMicroTime() {
    return this.microTime != null;
  }
  public A withNewMicroTime(java.lang.String time) {
    return (A)withMicroTime(new MicroTime(time));
  }
  public ValidationSchemaFluent.MicroTimeNested<A> withNewMicroTime() {
    return new ValidationSchemaFluentImpl.MicroTimeNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.MicroTimeNested<A> withNewMicroTimeLike(io.fabric8.kubernetes.api.model.MicroTime item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.MicroTimeNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.MicroTimeNested<A> editMicroTime() {
    return withNewMicroTimeLike(getMicroTime());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.MicroTimeNested<A> editOrNewMicroTime() {
    return withNewMicroTimeLike(getMicroTime() != null ? getMicroTime(): new io.fabric8.kubernetes.api.model.MicroTimeBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.MicroTimeNested<A> editOrNewMicroTimeLike(io.fabric8.kubernetes.api.model.MicroTime item) {
    return withNewMicroTimeLike(getMicroTime() != null ? getMicroTime(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNamespace instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.Namespace getNamespace() {
    return this.namespace!=null ?this.namespace.build():null;
  }
  public io.fabric8.kubernetes.api.model.Namespace buildNamespace() {
    return this.namespace!=null ?this.namespace.build():null;
  }
  public A withNamespace(io.fabric8.kubernetes.api.model.Namespace namespace) {
    _visitables.get("namespace").remove(this.namespace);
    if (namespace!=null){ this.namespace= new io.fabric8.kubernetes.api.model.NamespaceBuilder(namespace); _visitables.get("namespace").add(this.namespace);} return (A) this;
  }
  public java.lang.Boolean hasNamespace() {
    return this.namespace != null;
  }
  public ValidationSchemaFluent.NamespaceNested<A> withNewNamespace() {
    return new ValidationSchemaFluentImpl.NamespaceNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NamespaceNested<A> withNewNamespaceLike(io.fabric8.kubernetes.api.model.Namespace item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.NamespaceNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NamespaceNested<A> editNamespace() {
    return withNewNamespaceLike(getNamespace());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NamespaceNested<A> editOrNewNamespace() {
    return withNewNamespaceLike(getNamespace() != null ? getNamespace(): new io.fabric8.kubernetes.api.model.NamespaceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NamespaceNested<A> editOrNewNamespaceLike(io.fabric8.kubernetes.api.model.Namespace item) {
    return withNewNamespaceLike(getNamespace() != null ? getNamespace(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public NamespaceList getNamespaceList() {
    return this.namespaceList!=null ?this.namespaceList.build():null;
  }
  public io.fabric8.kubernetes.api.model.NamespaceList buildNamespaceList() {
    return this.namespaceList!=null ?this.namespaceList.build():null;
  }
  public A withNamespaceList(io.fabric8.kubernetes.api.model.NamespaceList namespaceList) {
    _visitables.get("namespaceList").remove(this.namespaceList);
    if (namespaceList!=null){ this.namespaceList= new NamespaceListBuilder(namespaceList); _visitables.get("namespaceList").add(this.namespaceList);} return (A) this;
  }
  public java.lang.Boolean hasNamespaceList() {
    return this.namespaceList != null;
  }
  public ValidationSchemaFluent.NamespaceListNested<A> withNewNamespaceList() {
    return new ValidationSchemaFluentImpl.NamespaceListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NamespaceListNested<A> withNewNamespaceListLike(io.fabric8.kubernetes.api.model.NamespaceList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.NamespaceListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NamespaceListNested<A> editNamespaceList() {
    return withNewNamespaceListLike(getNamespaceList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NamespaceListNested<A> editOrNewNamespaceList() {
    return withNewNamespaceListLike(getNamespaceList() != null ? getNamespaceList(): new io.fabric8.kubernetes.api.model.NamespaceListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NamespaceListNested<A> editOrNewNamespaceListLike(io.fabric8.kubernetes.api.model.NamespaceList item) {
    return withNewNamespaceListLike(getNamespaceList() != null ? getNamespaceList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNode instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.Node getNode() {
    return this.node!=null ?this.node.build():null;
  }
  public io.fabric8.kubernetes.api.model.Node buildNode() {
    return this.node!=null ?this.node.build():null;
  }
  public A withNode(io.fabric8.kubernetes.api.model.Node node) {
    _visitables.get("node").remove(this.node);
    if (node!=null){ this.node= new NodeBuilder(node); _visitables.get("node").add(this.node);} return (A) this;
  }
  public java.lang.Boolean hasNode() {
    return this.node != null;
  }
  public ValidationSchemaFluent.NodeNested<A> withNewNode() {
    return new ValidationSchemaFluentImpl.NodeNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NodeNested<A> withNewNodeLike(io.fabric8.kubernetes.api.model.Node item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.NodeNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NodeNested<A> editNode() {
    return withNewNodeLike(getNode());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NodeNested<A> editOrNewNode() {
    return withNewNodeLike(getNode() != null ? getNode(): new io.fabric8.kubernetes.api.model.NodeBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NodeNested<A> editOrNewNodeLike(io.fabric8.kubernetes.api.model.Node item) {
    return withNewNodeLike(getNode() != null ? getNode(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNodeList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.NodeList getNodeList() {
    return this.nodeList!=null ?this.nodeList.build():null;
  }
  public io.fabric8.kubernetes.api.model.NodeList buildNodeList() {
    return this.nodeList!=null ?this.nodeList.build():null;
  }
  public A withNodeList(io.fabric8.kubernetes.api.model.NodeList nodeList) {
    _visitables.get("nodeList").remove(this.nodeList);
    if (nodeList!=null){ this.nodeList= new NodeListBuilder(nodeList); _visitables.get("nodeList").add(this.nodeList);} return (A) this;
  }
  public java.lang.Boolean hasNodeList() {
    return this.nodeList != null;
  }
  public ValidationSchemaFluent.NodeListNested<A> withNewNodeList() {
    return new ValidationSchemaFluentImpl.NodeListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NodeListNested<A> withNewNodeListLike(io.fabric8.kubernetes.api.model.NodeList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.NodeListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NodeListNested<A> editNodeList() {
    return withNewNodeListLike(getNodeList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NodeListNested<A> editOrNewNodeList() {
    return withNewNodeListLike(getNodeList() != null ? getNodeList(): new io.fabric8.kubernetes.api.model.NodeListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NodeListNested<A> editOrNewNodeListLike(io.fabric8.kubernetes.api.model.NodeList item) {
    return withNewNodeListLike(getNodeList() != null ? getNodeList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildObjectMeta instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public ObjectMeta getObjectMeta() {
    return this.objectMeta!=null ?this.objectMeta.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildObjectMeta() {
    return this.objectMeta!=null ?this.objectMeta.build():null;
  }
  public A withObjectMeta(io.fabric8.kubernetes.api.model.ObjectMeta objectMeta) {
    _visitables.get("objectMeta").remove(this.objectMeta);
    if (objectMeta!=null){ this.objectMeta= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(objectMeta); _visitables.get("objectMeta").add(this.objectMeta);} return (A) this;
  }
  public java.lang.Boolean hasObjectMeta() {
    return this.objectMeta != null;
  }
  public ValidationSchemaFluent.ObjectMetaNested<A> withNewObjectMeta() {
    return new ValidationSchemaFluentImpl.ObjectMetaNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ObjectMetaNested<A> withNewObjectMetaLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.ObjectMetaNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ObjectMetaNested<A> editObjectMeta() {
    return withNewObjectMetaLike(getObjectMeta());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ObjectMetaNested<A> editOrNewObjectMeta() {
    return withNewObjectMetaLike(getObjectMeta() != null ? getObjectMeta(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ObjectMetaNested<A> editOrNewObjectMetaLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewObjectMetaLike(getObjectMeta() != null ? getObjectMeta(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPatch instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public Patch getPatch() {
    return this.patch!=null ?this.patch.build():null;
  }
  public io.fabric8.kubernetes.api.model.Patch buildPatch() {
    return this.patch!=null ?this.patch.build():null;
  }
  public A withPatch(io.fabric8.kubernetes.api.model.Patch patch) {
    _visitables.get("patch").remove(this.patch);
    if (patch!=null){ this.patch= new io.fabric8.kubernetes.api.model.PatchBuilder(patch); _visitables.get("patch").add(this.patch);} return (A) this;
  }
  public java.lang.Boolean hasPatch() {
    return this.patch != null;
  }
  public ValidationSchemaFluent.PatchNested<A> withNewPatch() {
    return new ValidationSchemaFluentImpl.PatchNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PatchNested<A> withNewPatchLike(io.fabric8.kubernetes.api.model.Patch item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.PatchNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PatchNested<A> editPatch() {
    return withNewPatchLike(getPatch());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PatchNested<A> editOrNewPatch() {
    return withNewPatchLike(getPatch() != null ? getPatch(): new io.fabric8.kubernetes.api.model.PatchBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PatchNested<A> editOrNewPatchLike(io.fabric8.kubernetes.api.model.Patch item) {
    return withNewPatchLike(getPatch() != null ? getPatch(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPatchOptions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public PatchOptions getPatchOptions() {
    return this.patchOptions!=null ?this.patchOptions.build():null;
  }
  public io.fabric8.kubernetes.api.model.PatchOptions buildPatchOptions() {
    return this.patchOptions!=null ?this.patchOptions.build():null;
  }
  public A withPatchOptions(io.fabric8.kubernetes.api.model.PatchOptions patchOptions) {
    _visitables.get("patchOptions").remove(this.patchOptions);
    if (patchOptions!=null){ this.patchOptions= new io.fabric8.kubernetes.api.model.PatchOptionsBuilder(patchOptions); _visitables.get("patchOptions").add(this.patchOptions);} return (A) this;
  }
  public java.lang.Boolean hasPatchOptions() {
    return this.patchOptions != null;
  }
  public ValidationSchemaFluent.PatchOptionsNested<A> withNewPatchOptions() {
    return new ValidationSchemaFluentImpl.PatchOptionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PatchOptionsNested<A> withNewPatchOptionsLike(io.fabric8.kubernetes.api.model.PatchOptions item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.PatchOptionsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PatchOptionsNested<A> editPatchOptions() {
    return withNewPatchOptionsLike(getPatchOptions());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PatchOptionsNested<A> editOrNewPatchOptions() {
    return withNewPatchOptionsLike(getPatchOptions() != null ? getPatchOptions(): new io.fabric8.kubernetes.api.model.PatchOptionsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PatchOptionsNested<A> editOrNewPatchOptionsLike(io.fabric8.kubernetes.api.model.PatchOptions item) {
    return withNewPatchOptionsLike(getPatchOptions() != null ? getPatchOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPersistentVolume instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.PersistentVolume getPersistentVolume() {
    return this.persistentVolume!=null ?this.persistentVolume.build():null;
  }
  public io.fabric8.kubernetes.api.model.PersistentVolume buildPersistentVolume() {
    return this.persistentVolume!=null ?this.persistentVolume.build():null;
  }
  public A withPersistentVolume(io.fabric8.kubernetes.api.model.PersistentVolume persistentVolume) {
    _visitables.get("persistentVolume").remove(this.persistentVolume);
    if (persistentVolume!=null){ this.persistentVolume= new PersistentVolumeBuilder(persistentVolume); _visitables.get("persistentVolume").add(this.persistentVolume);} return (A) this;
  }
  public java.lang.Boolean hasPersistentVolume() {
    return this.persistentVolume != null;
  }
  public ValidationSchemaFluent.PersistentVolumeNested<A> withNewPersistentVolume() {
    return new ValidationSchemaFluentImpl.PersistentVolumeNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeNested<A> withNewPersistentVolumeLike(io.fabric8.kubernetes.api.model.PersistentVolume item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.PersistentVolumeNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeNested<A> editPersistentVolume() {
    return withNewPersistentVolumeLike(getPersistentVolume());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeNested<A> editOrNewPersistentVolume() {
    return withNewPersistentVolumeLike(getPersistentVolume() != null ? getPersistentVolume(): new io.fabric8.kubernetes.api.model.PersistentVolumeBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeNested<A> editOrNewPersistentVolumeLike(io.fabric8.kubernetes.api.model.PersistentVolume item) {
    return withNewPersistentVolumeLike(getPersistentVolume() != null ? getPersistentVolume(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPersistentVolumeClaim instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaim getPersistentVolumeClaim() {
    return this.persistentVolumeClaim!=null ?this.persistentVolumeClaim.build():null;
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaim buildPersistentVolumeClaim() {
    return this.persistentVolumeClaim!=null ?this.persistentVolumeClaim.build():null;
  }
  public A withPersistentVolumeClaim(io.fabric8.kubernetes.api.model.PersistentVolumeClaim persistentVolumeClaim) {
    _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim);
    if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(persistentVolumeClaim); _visitables.get("persistentVolumeClaim").add(this.persistentVolumeClaim);} return (A) this;
  }
  public java.lang.Boolean hasPersistentVolumeClaim() {
    return this.persistentVolumeClaim != null;
  }
  public ValidationSchemaFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
    return new ValidationSchemaFluentImpl.PersistentVolumeClaimNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.PersistentVolumeClaimNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPersistentVolumeClaimList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public PersistentVolumeClaimList getPersistentVolumeClaimList() {
    return this.persistentVolumeClaimList!=null ?this.persistentVolumeClaimList.build():null;
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimList buildPersistentVolumeClaimList() {
    return this.persistentVolumeClaimList!=null ?this.persistentVolumeClaimList.build():null;
  }
  public A withPersistentVolumeClaimList(io.fabric8.kubernetes.api.model.PersistentVolumeClaimList persistentVolumeClaimList) {
    _visitables.get("persistentVolumeClaimList").remove(this.persistentVolumeClaimList);
    if (persistentVolumeClaimList!=null){ this.persistentVolumeClaimList= new PersistentVolumeClaimListBuilder(persistentVolumeClaimList); _visitables.get("persistentVolumeClaimList").add(this.persistentVolumeClaimList);} return (A) this;
  }
  public java.lang.Boolean hasPersistentVolumeClaimList() {
    return this.persistentVolumeClaimList != null;
  }
  public ValidationSchemaFluent.PersistentVolumeClaimListNested<A> withNewPersistentVolumeClaimList() {
    return new ValidationSchemaFluentImpl.PersistentVolumeClaimListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeClaimListNested<A> withNewPersistentVolumeClaimListLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaimList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.PersistentVolumeClaimListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeClaimListNested<A> editPersistentVolumeClaimList() {
    return withNewPersistentVolumeClaimListLike(getPersistentVolumeClaimList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeClaimListNested<A> editOrNewPersistentVolumeClaimList() {
    return withNewPersistentVolumeClaimListLike(getPersistentVolumeClaimList() != null ? getPersistentVolumeClaimList(): new io.fabric8.kubernetes.api.model.PersistentVolumeClaimListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeClaimListNested<A> editOrNewPersistentVolumeClaimListLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaimList item) {
    return withNewPersistentVolumeClaimListLike(getPersistentVolumeClaimList() != null ? getPersistentVolumeClaimList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPersistentVolumeList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.PersistentVolumeList getPersistentVolumeList() {
    return this.persistentVolumeList!=null ?this.persistentVolumeList.build():null;
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeList buildPersistentVolumeList() {
    return this.persistentVolumeList!=null ?this.persistentVolumeList.build():null;
  }
  public A withPersistentVolumeList(io.fabric8.kubernetes.api.model.PersistentVolumeList persistentVolumeList) {
    _visitables.get("persistentVolumeList").remove(this.persistentVolumeList);
    if (persistentVolumeList!=null){ this.persistentVolumeList= new PersistentVolumeListBuilder(persistentVolumeList); _visitables.get("persistentVolumeList").add(this.persistentVolumeList);} return (A) this;
  }
  public java.lang.Boolean hasPersistentVolumeList() {
    return this.persistentVolumeList != null;
  }
  public ValidationSchemaFluent.PersistentVolumeListNested<A> withNewPersistentVolumeList() {
    return new ValidationSchemaFluentImpl.PersistentVolumeListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeListNested<A> withNewPersistentVolumeListLike(io.fabric8.kubernetes.api.model.PersistentVolumeList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.PersistentVolumeListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeListNested<A> editPersistentVolumeList() {
    return withNewPersistentVolumeListLike(getPersistentVolumeList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeListNested<A> editOrNewPersistentVolumeList() {
    return withNewPersistentVolumeListLike(getPersistentVolumeList() != null ? getPersistentVolumeList(): new io.fabric8.kubernetes.api.model.PersistentVolumeListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeListNested<A> editOrNewPersistentVolumeListLike(io.fabric8.kubernetes.api.model.PersistentVolumeList item) {
    return withNewPersistentVolumeListLike(getPersistentVolumeList() != null ? getPersistentVolumeList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPodExecOptions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.PodExecOptions getPodExecOptions() {
    return this.podExecOptions!=null ?this.podExecOptions.build():null;
  }
  public io.fabric8.kubernetes.api.model.PodExecOptions buildPodExecOptions() {
    return this.podExecOptions!=null ?this.podExecOptions.build():null;
  }
  public A withPodExecOptions(io.fabric8.kubernetes.api.model.PodExecOptions podExecOptions) {
    _visitables.get("podExecOptions").remove(this.podExecOptions);
    if (podExecOptions!=null){ this.podExecOptions= new PodExecOptionsBuilder(podExecOptions); _visitables.get("podExecOptions").add(this.podExecOptions);} return (A) this;
  }
  public java.lang.Boolean hasPodExecOptions() {
    return this.podExecOptions != null;
  }
  public ValidationSchemaFluent.PodExecOptionsNested<A> withNewPodExecOptions() {
    return new ValidationSchemaFluentImpl.PodExecOptionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PodExecOptionsNested<A> withNewPodExecOptionsLike(io.fabric8.kubernetes.api.model.PodExecOptions item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.PodExecOptionsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PodExecOptionsNested<A> editPodExecOptions() {
    return withNewPodExecOptionsLike(getPodExecOptions());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PodExecOptionsNested<A> editOrNewPodExecOptions() {
    return withNewPodExecOptionsLike(getPodExecOptions() != null ? getPodExecOptions(): new io.fabric8.kubernetes.api.model.PodExecOptionsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PodExecOptionsNested<A> editOrNewPodExecOptionsLike(io.fabric8.kubernetes.api.model.PodExecOptions item) {
    return withNewPodExecOptionsLike(getPodExecOptions() != null ? getPodExecOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPodList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public PodList getPodList() {
    return this.podList!=null ?this.podList.build():null;
  }
  public io.fabric8.kubernetes.api.model.PodList buildPodList() {
    return this.podList!=null ?this.podList.build():null;
  }
  public A withPodList(io.fabric8.kubernetes.api.model.PodList podList) {
    _visitables.get("podList").remove(this.podList);
    if (podList!=null){ this.podList= new io.fabric8.kubernetes.api.model.PodListBuilder(podList); _visitables.get("podList").add(this.podList);} return (A) this;
  }
  public java.lang.Boolean hasPodList() {
    return this.podList != null;
  }
  public ValidationSchemaFluent.PodListNested<A> withNewPodList() {
    return new ValidationSchemaFluentImpl.PodListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PodListNested<A> withNewPodListLike(io.fabric8.kubernetes.api.model.PodList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.PodListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PodListNested<A> editPodList() {
    return withNewPodListLike(getPodList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PodListNested<A> editOrNewPodList() {
    return withNewPodListLike(getPodList() != null ? getPodList(): new io.fabric8.kubernetes.api.model.PodListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PodListNested<A> editOrNewPodListLike(io.fabric8.kubernetes.api.model.PodList item) {
    return withNewPodListLike(getPodList() != null ? getPodList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPodTemplateList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.PodTemplateList getPodTemplateList() {
    return this.podTemplateList!=null ?this.podTemplateList.build():null;
  }
  public io.fabric8.kubernetes.api.model.PodTemplateList buildPodTemplateList() {
    return this.podTemplateList!=null ?this.podTemplateList.build():null;
  }
  public A withPodTemplateList(io.fabric8.kubernetes.api.model.PodTemplateList podTemplateList) {
    _visitables.get("podTemplateList").remove(this.podTemplateList);
    if (podTemplateList!=null){ this.podTemplateList= new PodTemplateListBuilder(podTemplateList); _visitables.get("podTemplateList").add(this.podTemplateList);} return (A) this;
  }
  public java.lang.Boolean hasPodTemplateList() {
    return this.podTemplateList != null;
  }
  public ValidationSchemaFluent.PodTemplateListNested<A> withNewPodTemplateList() {
    return new ValidationSchemaFluentImpl.PodTemplateListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PodTemplateListNested<A> withNewPodTemplateListLike(io.fabric8.kubernetes.api.model.PodTemplateList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.PodTemplateListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PodTemplateListNested<A> editPodTemplateList() {
    return withNewPodTemplateListLike(getPodTemplateList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PodTemplateListNested<A> editOrNewPodTemplateList() {
    return withNewPodTemplateListLike(getPodTemplateList() != null ? getPodTemplateList(): new io.fabric8.kubernetes.api.model.PodTemplateListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PodTemplateListNested<A> editOrNewPodTemplateListLike(io.fabric8.kubernetes.api.model.PodTemplateList item) {
    return withNewPodTemplateListLike(getPodTemplateList() != null ? getPodTemplateList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildQuantity instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public Quantity getQuantity() {
    return this.quantity!=null ?this.quantity.build():null;
  }
  public io.fabric8.kubernetes.api.model.Quantity buildQuantity() {
    return this.quantity!=null ?this.quantity.build():null;
  }
  public A withQuantity(io.fabric8.kubernetes.api.model.Quantity quantity) {
    _visitables.get("quantity").remove(this.quantity);
    if (quantity!=null){ this.quantity= new io.fabric8.kubernetes.api.model.QuantityBuilder(quantity); _visitables.get("quantity").add(this.quantity);} return (A) this;
  }
  public java.lang.Boolean hasQuantity() {
    return this.quantity != null;
  }
  public A withNewQuantity(java.lang.String amount,java.lang.String format) {
    return (A)withQuantity(new Quantity(amount, format));
  }
  public A withNewQuantity(java.lang.String amount) {
    return (A)withQuantity(new Quantity(amount));
  }
  public ValidationSchemaFluent.QuantityNested<A> withNewQuantity() {
    return new ValidationSchemaFluentImpl.QuantityNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.QuantityNested<A> withNewQuantityLike(io.fabric8.kubernetes.api.model.Quantity item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.QuantityNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.QuantityNested<A> editQuantity() {
    return withNewQuantityLike(getQuantity());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.QuantityNested<A> editOrNewQuantity() {
    return withNewQuantityLike(getQuantity() != null ? getQuantity(): new io.fabric8.kubernetes.api.model.QuantityBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.QuantityNested<A> editOrNewQuantityLike(io.fabric8.kubernetes.api.model.Quantity item) {
    return withNewQuantityLike(getQuantity() != null ? getQuantity(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildReplicationControllerList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ReplicationControllerList getReplicationControllerList() {
    return this.replicationControllerList!=null ?this.replicationControllerList.build():null;
  }
  public io.fabric8.kubernetes.api.model.ReplicationControllerList buildReplicationControllerList() {
    return this.replicationControllerList!=null ?this.replicationControllerList.build():null;
  }
  public A withReplicationControllerList(io.fabric8.kubernetes.api.model.ReplicationControllerList replicationControllerList) {
    _visitables.get("replicationControllerList").remove(this.replicationControllerList);
    if (replicationControllerList!=null){ this.replicationControllerList= new ReplicationControllerListBuilder(replicationControllerList); _visitables.get("replicationControllerList").add(this.replicationControllerList);} return (A) this;
  }
  public java.lang.Boolean hasReplicationControllerList() {
    return this.replicationControllerList != null;
  }
  public ValidationSchemaFluent.ReplicationControllerListNested<A> withNewReplicationControllerList() {
    return new ValidationSchemaFluentImpl.ReplicationControllerListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ReplicationControllerListNested<A> withNewReplicationControllerListLike(io.fabric8.kubernetes.api.model.ReplicationControllerList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.ReplicationControllerListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ReplicationControllerListNested<A> editReplicationControllerList() {
    return withNewReplicationControllerListLike(getReplicationControllerList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ReplicationControllerListNested<A> editOrNewReplicationControllerList() {
    return withNewReplicationControllerListLike(getReplicationControllerList() != null ? getReplicationControllerList(): new io.fabric8.kubernetes.api.model.ReplicationControllerListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ReplicationControllerListNested<A> editOrNewReplicationControllerListLike(io.fabric8.kubernetes.api.model.ReplicationControllerList item) {
    return withNewReplicationControllerListLike(getReplicationControllerList() != null ? getReplicationControllerList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResourceQuota instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public ResourceQuota getResourceQuota() {
    return this.resourceQuota!=null ?this.resourceQuota.build():null;
  }
  public io.fabric8.kubernetes.api.model.ResourceQuota buildResourceQuota() {
    return this.resourceQuota!=null ?this.resourceQuota.build():null;
  }
  public A withResourceQuota(io.fabric8.kubernetes.api.model.ResourceQuota resourceQuota) {
    _visitables.get("resourceQuota").remove(this.resourceQuota);
    if (resourceQuota!=null){ this.resourceQuota= new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(resourceQuota); _visitables.get("resourceQuota").add(this.resourceQuota);} return (A) this;
  }
  public java.lang.Boolean hasResourceQuota() {
    return this.resourceQuota != null;
  }
  public ValidationSchemaFluent.ResourceQuotaNested<A> withNewResourceQuota() {
    return new ValidationSchemaFluentImpl.ResourceQuotaNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ResourceQuotaNested<A> withNewResourceQuotaLike(io.fabric8.kubernetes.api.model.ResourceQuota item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.ResourceQuotaNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ResourceQuotaNested<A> editResourceQuota() {
    return withNewResourceQuotaLike(getResourceQuota());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ResourceQuotaNested<A> editOrNewResourceQuota() {
    return withNewResourceQuotaLike(getResourceQuota() != null ? getResourceQuota(): new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ResourceQuotaNested<A> editOrNewResourceQuotaLike(io.fabric8.kubernetes.api.model.ResourceQuota item) {
    return withNewResourceQuotaLike(getResourceQuota() != null ? getResourceQuota(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResourceQuotaList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public ResourceQuotaList getResourceQuotaList() {
    return this.resourceQuotaList!=null ?this.resourceQuotaList.build():null;
  }
  public io.fabric8.kubernetes.api.model.ResourceQuotaList buildResourceQuotaList() {
    return this.resourceQuotaList!=null ?this.resourceQuotaList.build():null;
  }
  public A withResourceQuotaList(io.fabric8.kubernetes.api.model.ResourceQuotaList resourceQuotaList) {
    _visitables.get("resourceQuotaList").remove(this.resourceQuotaList);
    if (resourceQuotaList!=null){ this.resourceQuotaList= new io.fabric8.kubernetes.api.model.ResourceQuotaListBuilder(resourceQuotaList); _visitables.get("resourceQuotaList").add(this.resourceQuotaList);} return (A) this;
  }
  public java.lang.Boolean hasResourceQuotaList() {
    return this.resourceQuotaList != null;
  }
  public ValidationSchemaFluent.ResourceQuotaListNested<A> withNewResourceQuotaList() {
    return new ValidationSchemaFluentImpl.ResourceQuotaListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ResourceQuotaListNested<A> withNewResourceQuotaListLike(io.fabric8.kubernetes.api.model.ResourceQuotaList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.ResourceQuotaListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ResourceQuotaListNested<A> editResourceQuotaList() {
    return withNewResourceQuotaListLike(getResourceQuotaList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ResourceQuotaListNested<A> editOrNewResourceQuotaList() {
    return withNewResourceQuotaListLike(getResourceQuotaList() != null ? getResourceQuotaList(): new io.fabric8.kubernetes.api.model.ResourceQuotaListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ResourceQuotaListNested<A> editOrNewResourceQuotaListLike(io.fabric8.kubernetes.api.model.ResourceQuotaList item) {
    return withNewResourceQuotaListLike(getResourceQuotaList() != null ? getResourceQuotaList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRootPaths instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public RootPaths getRootPaths() {
    return this.rootPaths!=null ?this.rootPaths.build():null;
  }
  public io.fabric8.kubernetes.api.model.RootPaths buildRootPaths() {
    return this.rootPaths!=null ?this.rootPaths.build():null;
  }
  public A withRootPaths(io.fabric8.kubernetes.api.model.RootPaths rootPaths) {
    _visitables.get("rootPaths").remove(this.rootPaths);
    if (rootPaths!=null){ this.rootPaths= new io.fabric8.kubernetes.api.model.RootPathsBuilder(rootPaths); _visitables.get("rootPaths").add(this.rootPaths);} return (A) this;
  }
  public java.lang.Boolean hasRootPaths() {
    return this.rootPaths != null;
  }
  public ValidationSchemaFluent.RootPathsNested<A> withNewRootPaths() {
    return new ValidationSchemaFluentImpl.RootPathsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.RootPathsNested<A> withNewRootPathsLike(io.fabric8.kubernetes.api.model.RootPaths item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.RootPathsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.RootPathsNested<A> editRootPaths() {
    return withNewRootPathsLike(getRootPaths());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.RootPathsNested<A> editOrNewRootPaths() {
    return withNewRootPathsLike(getRootPaths() != null ? getRootPaths(): new io.fabric8.kubernetes.api.model.RootPathsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.RootPathsNested<A> editOrNewRootPathsLike(io.fabric8.kubernetes.api.model.RootPaths item) {
    return withNewRootPathsLike(getRootPaths() != null ? getRootPaths(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSecret instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public Secret getSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public io.fabric8.kubernetes.api.model.Secret buildSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public A withSecret(io.fabric8.kubernetes.api.model.Secret secret) {
    _visitables.get("secret").remove(this.secret);
    if (secret!=null){ this.secret= new io.fabric8.kubernetes.api.model.SecretBuilder(secret); _visitables.get("secret").add(this.secret);} return (A) this;
  }
  public java.lang.Boolean hasSecret() {
    return this.secret != null;
  }
  public ValidationSchemaFluent.SecretNested<A> withNewSecret() {
    return new ValidationSchemaFluentImpl.SecretNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.SecretNested<A> withNewSecretLike(io.fabric8.kubernetes.api.model.Secret item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.SecretNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.SecretNested<A> editSecret() {
    return withNewSecretLike(getSecret());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(getSecret() != null ? getSecret(): new io.fabric8.kubernetes.api.model.SecretBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.SecretNested<A> editOrNewSecretLike(io.fabric8.kubernetes.api.model.Secret item) {
    return withNewSecretLike(getSecret() != null ? getSecret(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSecretList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public SecretList getSecretList() {
    return this.secretList!=null ?this.secretList.build():null;
  }
  public io.fabric8.kubernetes.api.model.SecretList buildSecretList() {
    return this.secretList!=null ?this.secretList.build():null;
  }
  public A withSecretList(io.fabric8.kubernetes.api.model.SecretList secretList) {
    _visitables.get("secretList").remove(this.secretList);
    if (secretList!=null){ this.secretList= new io.fabric8.kubernetes.api.model.SecretListBuilder(secretList); _visitables.get("secretList").add(this.secretList);} return (A) this;
  }
  public java.lang.Boolean hasSecretList() {
    return this.secretList != null;
  }
  public ValidationSchemaFluent.SecretListNested<A> withNewSecretList() {
    return new ValidationSchemaFluentImpl.SecretListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.SecretListNested<A> withNewSecretListLike(io.fabric8.kubernetes.api.model.SecretList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.SecretListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.SecretListNested<A> editSecretList() {
    return withNewSecretListLike(getSecretList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.SecretListNested<A> editOrNewSecretList() {
    return withNewSecretListLike(getSecretList() != null ? getSecretList(): new io.fabric8.kubernetes.api.model.SecretListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.SecretListNested<A> editOrNewSecretListLike(io.fabric8.kubernetes.api.model.SecretList item) {
    return withNewSecretListLike(getSecretList() != null ? getSecretList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildServiceAccount instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ServiceAccount getServiceAccount() {
    return this.serviceAccount!=null ?this.serviceAccount.build():null;
  }
  public io.fabric8.kubernetes.api.model.ServiceAccount buildServiceAccount() {
    return this.serviceAccount!=null ?this.serviceAccount.build():null;
  }
  public A withServiceAccount(io.fabric8.kubernetes.api.model.ServiceAccount serviceAccount) {
    _visitables.get("serviceAccount").remove(this.serviceAccount);
    if (serviceAccount!=null){ this.serviceAccount= new ServiceAccountBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} return (A) this;
  }
  public java.lang.Boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  public ValidationSchemaFluent.ServiceAccountNested<A> withNewServiceAccount() {
    return new ValidationSchemaFluentImpl.ServiceAccountNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ServiceAccountNested<A> withNewServiceAccountLike(io.fabric8.kubernetes.api.model.ServiceAccount item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.ServiceAccountNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ServiceAccountNested<A> editServiceAccount() {
    return withNewServiceAccountLike(getServiceAccount());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ServiceAccountNested<A> editOrNewServiceAccount() {
    return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): new io.fabric8.kubernetes.api.model.ServiceAccountBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ServiceAccountNested<A> editOrNewServiceAccountLike(io.fabric8.kubernetes.api.model.ServiceAccount item) {
    return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildServiceAccountList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ServiceAccountList getServiceAccountList() {
    return this.serviceAccountList!=null ?this.serviceAccountList.build():null;
  }
  public io.fabric8.kubernetes.api.model.ServiceAccountList buildServiceAccountList() {
    return this.serviceAccountList!=null ?this.serviceAccountList.build():null;
  }
  public A withServiceAccountList(io.fabric8.kubernetes.api.model.ServiceAccountList serviceAccountList) {
    _visitables.get("serviceAccountList").remove(this.serviceAccountList);
    if (serviceAccountList!=null){ this.serviceAccountList= new ServiceAccountListBuilder(serviceAccountList); _visitables.get("serviceAccountList").add(this.serviceAccountList);} return (A) this;
  }
  public java.lang.Boolean hasServiceAccountList() {
    return this.serviceAccountList != null;
  }
  public ValidationSchemaFluent.ServiceAccountListNested<A> withNewServiceAccountList() {
    return new ValidationSchemaFluentImpl.ServiceAccountListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ServiceAccountListNested<A> withNewServiceAccountListLike(io.fabric8.kubernetes.api.model.ServiceAccountList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.ServiceAccountListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ServiceAccountListNested<A> editServiceAccountList() {
    return withNewServiceAccountListLike(getServiceAccountList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ServiceAccountListNested<A> editOrNewServiceAccountList() {
    return withNewServiceAccountListLike(getServiceAccountList() != null ? getServiceAccountList(): new io.fabric8.kubernetes.api.model.ServiceAccountListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ServiceAccountListNested<A> editOrNewServiceAccountListLike(io.fabric8.kubernetes.api.model.ServiceAccountList item) {
    return withNewServiceAccountListLike(getServiceAccountList() != null ? getServiceAccountList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildServiceList instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public ServiceList getServiceList() {
    return this.serviceList!=null ?this.serviceList.build():null;
  }
  public io.fabric8.kubernetes.api.model.ServiceList buildServiceList() {
    return this.serviceList!=null ?this.serviceList.build():null;
  }
  public A withServiceList(io.fabric8.kubernetes.api.model.ServiceList serviceList) {
    _visitables.get("serviceList").remove(this.serviceList);
    if (serviceList!=null){ this.serviceList= new io.fabric8.kubernetes.api.model.ServiceListBuilder(serviceList); _visitables.get("serviceList").add(this.serviceList);} return (A) this;
  }
  public java.lang.Boolean hasServiceList() {
    return this.serviceList != null;
  }
  public ValidationSchemaFluent.ServiceListNested<A> withNewServiceList() {
    return new ValidationSchemaFluentImpl.ServiceListNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ServiceListNested<A> withNewServiceListLike(io.fabric8.kubernetes.api.model.ServiceList item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.ServiceListNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ServiceListNested<A> editServiceList() {
    return withNewServiceListLike(getServiceList());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ServiceListNested<A> editOrNewServiceList() {
    return withNewServiceListLike(getServiceList() != null ? getServiceList(): new io.fabric8.kubernetes.api.model.ServiceListBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ServiceListNested<A> editOrNewServiceListLike(io.fabric8.kubernetes.api.model.ServiceList item) {
    return withNewServiceListLike(getServiceList() != null ? getServiceList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.Status getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public io.fabric8.kubernetes.api.model.Status buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(io.fabric8.kubernetes.api.model.Status status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new StatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
  }
  public java.lang.Boolean hasStatus() {
    return this.status != null;
  }
  public ValidationSchemaFluent.StatusNested<A> withNewStatus() {
    return new ValidationSchemaFluentImpl.StatusNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.StatusNested<A> withNewStatusLike(io.fabric8.kubernetes.api.model.Status item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.StatusNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new io.fabric8.kubernetes.api.model.StatusBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.StatusNested<A> editOrNewStatusLike(io.fabric8.kubernetes.api.model.Status item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public java.lang.String getTime() {
    return this.time;
  }
  public A withTime(java.lang.String time) {
    this.time=time; return (A) this;
  }
  public java.lang.Boolean hasTime() {
    return this.time != null;
  }
  
  /**
   * This method has been deprecated, please use method buildToleration instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public Toleration getToleration() {
    return this.toleration!=null ?this.toleration.build():null;
  }
  public io.fabric8.kubernetes.api.model.Toleration buildToleration() {
    return this.toleration!=null ?this.toleration.build():null;
  }
  public A withToleration(io.fabric8.kubernetes.api.model.Toleration toleration) {
    _visitables.get("toleration").remove(this.toleration);
    if (toleration!=null){ this.toleration= new io.fabric8.kubernetes.api.model.TolerationBuilder(toleration); _visitables.get("toleration").add(this.toleration);} return (A) this;
  }
  public java.lang.Boolean hasToleration() {
    return this.toleration != null;
  }
  public A withNewToleration(java.lang.String effect,java.lang.String key,java.lang.String operator,Long tolerationSeconds,java.lang.String value) {
    return (A)withToleration(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public ValidationSchemaFluent.TolerationNested<A> withNewToleration() {
    return new ValidationSchemaFluentImpl.TolerationNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.TolerationNested<A> withNewTolerationLike(io.fabric8.kubernetes.api.model.Toleration item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.TolerationNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.TolerationNested<A> editToleration() {
    return withNewTolerationLike(getToleration());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.TolerationNested<A> editOrNewToleration() {
    return withNewTolerationLike(getToleration() != null ? getToleration(): new io.fabric8.kubernetes.api.model.TolerationBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.TolerationNested<A> editOrNewTolerationLike(io.fabric8.kubernetes.api.model.Toleration item) {
    return withNewTolerationLike(getToleration() != null ? getToleration(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTopologySelectorTerm instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public TopologySelectorTerm getTopologySelectorTerm() {
    return this.topologySelectorTerm!=null ?this.topologySelectorTerm.build():null;
  }
  public io.fabric8.kubernetes.api.model.TopologySelectorTerm buildTopologySelectorTerm() {
    return this.topologySelectorTerm!=null ?this.topologySelectorTerm.build():null;
  }
  public A withTopologySelectorTerm(io.fabric8.kubernetes.api.model.TopologySelectorTerm topologySelectorTerm) {
    _visitables.get("topologySelectorTerm").remove(this.topologySelectorTerm);
    if (topologySelectorTerm!=null){ this.topologySelectorTerm= new io.fabric8.kubernetes.api.model.TopologySelectorTermBuilder(topologySelectorTerm); _visitables.get("topologySelectorTerm").add(this.topologySelectorTerm);} return (A) this;
  }
  public java.lang.Boolean hasTopologySelectorTerm() {
    return this.topologySelectorTerm != null;
  }
  public ValidationSchemaFluent.TopologySelectorTermNested<A> withNewTopologySelectorTerm() {
    return new ValidationSchemaFluentImpl.TopologySelectorTermNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.TopologySelectorTermNested<A> withNewTopologySelectorTermLike(io.fabric8.kubernetes.api.model.TopologySelectorTerm item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.TopologySelectorTermNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.TopologySelectorTermNested<A> editTopologySelectorTerm() {
    return withNewTopologySelectorTermLike(getTopologySelectorTerm());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.TopologySelectorTermNested<A> editOrNewTopologySelectorTerm() {
    return withNewTopologySelectorTermLike(getTopologySelectorTerm() != null ? getTopologySelectorTerm(): new io.fabric8.kubernetes.api.model.TopologySelectorTermBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.TopologySelectorTermNested<A> editOrNewTopologySelectorTermLike(io.fabric8.kubernetes.api.model.TopologySelectorTerm item) {
    return withNewTopologySelectorTermLike(getTopologySelectorTerm() != null ? getTopologySelectorTerm(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTypeMeta instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public TypeMeta getTypeMeta() {
    return this.typeMeta!=null ?this.typeMeta.build():null;
  }
  public io.fabric8.kubernetes.api.model.TypeMeta buildTypeMeta() {
    return this.typeMeta!=null ?this.typeMeta.build():null;
  }
  public A withTypeMeta(io.fabric8.kubernetes.api.model.TypeMeta typeMeta) {
    _visitables.get("typeMeta").remove(this.typeMeta);
    if (typeMeta!=null){ this.typeMeta= new io.fabric8.kubernetes.api.model.TypeMetaBuilder(typeMeta); _visitables.get("typeMeta").add(this.typeMeta);} return (A) this;
  }
  public java.lang.Boolean hasTypeMeta() {
    return this.typeMeta != null;
  }
  public A withNewTypeMeta(java.lang.String apiVersion,java.lang.String kind) {
    return (A)withTypeMeta(new TypeMeta(apiVersion, kind));
  }
  public ValidationSchemaFluent.TypeMetaNested<A> withNewTypeMeta() {
    return new ValidationSchemaFluentImpl.TypeMetaNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.TypeMetaNested<A> withNewTypeMetaLike(io.fabric8.kubernetes.api.model.TypeMeta item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.TypeMetaNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.TypeMetaNested<A> editTypeMeta() {
    return withNewTypeMetaLike(getTypeMeta());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.TypeMetaNested<A> editOrNewTypeMeta() {
    return withNewTypeMetaLike(getTypeMeta() != null ? getTypeMeta(): new io.fabric8.kubernetes.api.model.TypeMetaBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.TypeMetaNested<A> editOrNewTypeMetaLike(io.fabric8.kubernetes.api.model.TypeMeta item) {
    return withNewTypeMetaLike(getTypeMeta() != null ? getTypeMeta(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildUpdateOptions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.UpdateOptions getUpdateOptions() {
    return this.updateOptions!=null ?this.updateOptions.build():null;
  }
  public io.fabric8.kubernetes.api.model.UpdateOptions buildUpdateOptions() {
    return this.updateOptions!=null ?this.updateOptions.build():null;
  }
  public A withUpdateOptions(io.fabric8.kubernetes.api.model.UpdateOptions updateOptions) {
    _visitables.get("updateOptions").remove(this.updateOptions);
    if (updateOptions!=null){ this.updateOptions= new UpdateOptionsBuilder(updateOptions); _visitables.get("updateOptions").add(this.updateOptions);} return (A) this;
  }
  public java.lang.Boolean hasUpdateOptions() {
    return this.updateOptions != null;
  }
  public ValidationSchemaFluent.UpdateOptionsNested<A> withNewUpdateOptions() {
    return new ValidationSchemaFluentImpl.UpdateOptionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.UpdateOptionsNested<A> withNewUpdateOptionsLike(io.fabric8.kubernetes.api.model.UpdateOptions item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.UpdateOptionsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.UpdateOptionsNested<A> editUpdateOptions() {
    return withNewUpdateOptionsLike(getUpdateOptions());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.UpdateOptionsNested<A> editOrNewUpdateOptions() {
    return withNewUpdateOptionsLike(getUpdateOptions() != null ? getUpdateOptions(): new io.fabric8.kubernetes.api.model.UpdateOptionsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.UpdateOptionsNested<A> editOrNewUpdateOptionsLike(io.fabric8.kubernetes.api.model.UpdateOptions item) {
    return withNewUpdateOptionsLike(getUpdateOptions() != null ? getUpdateOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildWatchEvent instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.WatchEvent getWatchEvent() {
    return this.watchEvent!=null ?this.watchEvent.build():null;
  }
  public io.fabric8.kubernetes.api.model.WatchEvent buildWatchEvent() {
    return this.watchEvent!=null ?this.watchEvent.build():null;
  }
  public A withWatchEvent(io.fabric8.kubernetes.api.model.WatchEvent watchEvent) {
    _visitables.get("watchEvent").remove(this.watchEvent);
    if (watchEvent!=null){ this.watchEvent= new WatchEventBuilder(watchEvent); _visitables.get("watchEvent").add(this.watchEvent);} return (A) this;
  }
  public java.lang.Boolean hasWatchEvent() {
    return this.watchEvent != null;
  }
  public ValidationSchemaFluent.WatchEventNested<A> withNewWatchEvent() {
    return new ValidationSchemaFluentImpl.WatchEventNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.WatchEventNested<A> withNewWatchEventLike(io.fabric8.kubernetes.api.model.WatchEvent item) {
    return new io.fabric8.kubernetes.api.model.ValidationSchemaFluentImpl.WatchEventNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.WatchEventNested<A> editWatchEvent() {
    return withNewWatchEventLike(getWatchEvent());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.WatchEventNested<A> editOrNewWatchEvent() {
    return withNewWatchEventLike(getWatchEvent() != null ? getWatchEvent(): new io.fabric8.kubernetes.api.model.WatchEventBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ValidationSchemaFluent.WatchEventNested<A> editOrNewWatchEventLike(io.fabric8.kubernetes.api.model.WatchEvent item) {
    return withNewWatchEventLike(getWatchEvent() != null ? getWatchEvent(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ValidationSchemaFluentImpl that = (ValidationSchemaFluentImpl) o;
    if (aPIGroup != null ? !aPIGroup.equals(that.aPIGroup) :that.aPIGroup != null) return false;
    if (aPIGroupList != null ? !aPIGroupList.equals(that.aPIGroupList) :that.aPIGroupList != null) return false;
    if (aPIResource != null ? !aPIResource.equals(that.aPIResource) :that.aPIResource != null) return false;
    if (aPIResourceList != null ? !aPIResourceList.equals(that.aPIResourceList) :that.aPIResourceList != null) return false;
    if (aPIService != null ? !aPIService.equals(that.aPIService) :that.aPIService != null) return false;
    if (aPIServiceList != null ? !aPIServiceList.equals(that.aPIServiceList) :that.aPIServiceList != null) return false;
    if (baseKubernetesList != null ? !baseKubernetesList.equals(that.baseKubernetesList) :that.baseKubernetesList != null) return false;
    if (binding != null ? !binding.equals(that.binding) :that.binding != null) return false;
    if (componentStatus != null ? !componentStatus.equals(that.componentStatus) :that.componentStatus != null) return false;
    if (componentStatusList != null ? !componentStatusList.equals(that.componentStatusList) :that.componentStatusList != null) return false;
    if (condition != null ? !condition.equals(that.condition) :that.condition != null) return false;
    if (config != null ? !config.equals(that.config) :that.config != null) return false;
    if (configMap != null ? !configMap.equals(that.configMap) :that.configMap != null) return false;
    if (configMapList != null ? !configMapList.equals(that.configMapList) :that.configMapList != null) return false;
    if (containerStatus != null ? !containerStatus.equals(that.containerStatus) :that.containerStatus != null) return false;
    if (createOptions != null ? !createOptions.equals(that.createOptions) :that.createOptions != null) return false;
    if (deleteOptions != null ? !deleteOptions.equals(that.deleteOptions) :that.deleteOptions != null) return false;
    if (endpointPort != null ? !endpointPort.equals(that.endpointPort) :that.endpointPort != null) return false;
    if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
    if (endpointsList != null ? !endpointsList.equals(that.endpointsList) :that.endpointsList != null) return false;
    if (envVar != null ? !envVar.equals(that.envVar) :that.envVar != null) return false;
    if (event != null ? !event.equals(that.event) :that.event != null) return false;
    if (eventList != null ? !eventList.equals(that.eventList) :that.eventList != null) return false;
    if (eventSeries != null ? !eventSeries.equals(that.eventSeries) :that.eventSeries != null) return false;
    if (eventSource != null ? !eventSource.equals(that.eventSource) :that.eventSource != null) return false;
    if (getOptions != null ? !getOptions.equals(that.getOptions) :that.getOptions != null) return false;
    if (groupKind != null ? !groupKind.equals(that.groupKind) :that.groupKind != null) return false;
    if (groupVersionKind != null ? !groupVersionKind.equals(that.groupVersionKind) :that.groupVersionKind != null) return false;
    if (groupVersionResource != null ? !groupVersionResource.equals(that.groupVersionResource) :that.groupVersionResource != null) return false;
    if (info != null ? !info.equals(that.info) :that.info != null) return false;
    if (limitRangeList != null ? !limitRangeList.equals(that.limitRangeList) :that.limitRangeList != null) return false;
    if (listOptions != null ? !listOptions.equals(that.listOptions) :that.listOptions != null) return false;
    if (microTime != null ? !microTime.equals(that.microTime) :that.microTime != null) return false;
    if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
    if (namespaceList != null ? !namespaceList.equals(that.namespaceList) :that.namespaceList != null) return false;
    if (node != null ? !node.equals(that.node) :that.node != null) return false;
    if (nodeList != null ? !nodeList.equals(that.nodeList) :that.nodeList != null) return false;
    if (objectMeta != null ? !objectMeta.equals(that.objectMeta) :that.objectMeta != null) return false;
    if (patch != null ? !patch.equals(that.patch) :that.patch != null) return false;
    if (patchOptions != null ? !patchOptions.equals(that.patchOptions) :that.patchOptions != null) return false;
    if (persistentVolume != null ? !persistentVolume.equals(that.persistentVolume) :that.persistentVolume != null) return false;
    if (persistentVolumeClaim != null ? !persistentVolumeClaim.equals(that.persistentVolumeClaim) :that.persistentVolumeClaim != null) return false;
    if (persistentVolumeClaimList != null ? !persistentVolumeClaimList.equals(that.persistentVolumeClaimList) :that.persistentVolumeClaimList != null) return false;
    if (persistentVolumeList != null ? !persistentVolumeList.equals(that.persistentVolumeList) :that.persistentVolumeList != null) return false;
    if (podExecOptions != null ? !podExecOptions.equals(that.podExecOptions) :that.podExecOptions != null) return false;
    if (podList != null ? !podList.equals(that.podList) :that.podList != null) return false;
    if (podTemplateList != null ? !podTemplateList.equals(that.podTemplateList) :that.podTemplateList != null) return false;
    if (quantity != null ? !quantity.equals(that.quantity) :that.quantity != null) return false;
    if (replicationControllerList != null ? !replicationControllerList.equals(that.replicationControllerList) :that.replicationControllerList != null) return false;
    if (resourceQuota != null ? !resourceQuota.equals(that.resourceQuota) :that.resourceQuota != null) return false;
    if (resourceQuotaList != null ? !resourceQuotaList.equals(that.resourceQuotaList) :that.resourceQuotaList != null) return false;
    if (rootPaths != null ? !rootPaths.equals(that.rootPaths) :that.rootPaths != null) return false;
    if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
    if (secretList != null ? !secretList.equals(that.secretList) :that.secretList != null) return false;
    if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
    if (serviceAccountList != null ? !serviceAccountList.equals(that.serviceAccountList) :that.serviceAccountList != null) return false;
    if (serviceList != null ? !serviceList.equals(that.serviceList) :that.serviceList != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    if (time != null ? !time.equals(that.time) :that.time != null) return false;
    if (toleration != null ? !toleration.equals(that.toleration) :that.toleration != null) return false;
    if (topologySelectorTerm != null ? !topologySelectorTerm.equals(that.topologySelectorTerm) :that.topologySelectorTerm != null) return false;
    if (typeMeta != null ? !typeMeta.equals(that.typeMeta) :that.typeMeta != null) return false;
    if (updateOptions != null ? !updateOptions.equals(that.updateOptions) :that.updateOptions != null) return false;
    if (watchEvent != null ? !watchEvent.equals(that.watchEvent) :that.watchEvent != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(aPIGroup,  aPIGroupList,  aPIResource,  aPIResourceList,  aPIService,  aPIServiceList,  baseKubernetesList,  binding,  componentStatus,  componentStatusList,  condition,  config,  configMap,  configMapList,  containerStatus,  createOptions,  deleteOptions,  endpointPort,  endpoints,  endpointsList,  envVar,  event,  eventList,  eventSeries,  eventSource,  getOptions,  groupKind,  groupVersionKind,  groupVersionResource,  info,  limitRangeList,  listOptions,  microTime,  namespace,  namespaceList,  node,  nodeList,  objectMeta,  patch,  patchOptions,  persistentVolume,  persistentVolumeClaim,  persistentVolumeClaimList,  persistentVolumeList,  podExecOptions,  podList,  podTemplateList,  quantity,  replicationControllerList,  resourceQuota,  resourceQuotaList,  rootPaths,  secret,  secretList,  serviceAccount,  serviceAccountList,  serviceList,  status,  time,  toleration,  topologySelectorTerm,  typeMeta,  updateOptions,  watchEvent,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aPIGroup != null) { sb.append("aPIGroup:"); sb.append(aPIGroup + ","); }
    if (aPIGroupList != null) { sb.append("aPIGroupList:"); sb.append(aPIGroupList + ","); }
    if (aPIResource != null) { sb.append("aPIResource:"); sb.append(aPIResource + ","); }
    if (aPIResourceList != null) { sb.append("aPIResourceList:"); sb.append(aPIResourceList + ","); }
    if (aPIService != null) { sb.append("aPIService:"); sb.append(aPIService + ","); }
    if (aPIServiceList != null) { sb.append("aPIServiceList:"); sb.append(aPIServiceList + ","); }
    if (baseKubernetesList != null) { sb.append("baseKubernetesList:"); sb.append(baseKubernetesList + ","); }
    if (binding != null) { sb.append("binding:"); sb.append(binding + ","); }
    if (componentStatus != null) { sb.append("componentStatus:"); sb.append(componentStatus + ","); }
    if (componentStatusList != null) { sb.append("componentStatusList:"); sb.append(componentStatusList + ","); }
    if (condition != null) { sb.append("condition:"); sb.append(condition + ","); }
    if (config != null) { sb.append("config:"); sb.append(config + ","); }
    if (configMap != null) { sb.append("configMap:"); sb.append(configMap + ","); }
    if (configMapList != null) { sb.append("configMapList:"); sb.append(configMapList + ","); }
    if (containerStatus != null) { sb.append("containerStatus:"); sb.append(containerStatus + ","); }
    if (createOptions != null) { sb.append("createOptions:"); sb.append(createOptions + ","); }
    if (deleteOptions != null) { sb.append("deleteOptions:"); sb.append(deleteOptions + ","); }
    if (endpointPort != null) { sb.append("endpointPort:"); sb.append(endpointPort + ","); }
    if (endpoints != null) { sb.append("endpoints:"); sb.append(endpoints + ","); }
    if (endpointsList != null) { sb.append("endpointsList:"); sb.append(endpointsList + ","); }
    if (envVar != null) { sb.append("envVar:"); sb.append(envVar + ","); }
    if (event != null) { sb.append("event:"); sb.append(event + ","); }
    if (eventList != null) { sb.append("eventList:"); sb.append(eventList + ","); }
    if (eventSeries != null) { sb.append("eventSeries:"); sb.append(eventSeries + ","); }
    if (eventSource != null) { sb.append("eventSource:"); sb.append(eventSource + ","); }
    if (getOptions != null) { sb.append("getOptions:"); sb.append(getOptions + ","); }
    if (groupKind != null) { sb.append("groupKind:"); sb.append(groupKind + ","); }
    if (groupVersionKind != null) { sb.append("groupVersionKind:"); sb.append(groupVersionKind + ","); }
    if (groupVersionResource != null) { sb.append("groupVersionResource:"); sb.append(groupVersionResource + ","); }
    if (info != null) { sb.append("info:"); sb.append(info + ","); }
    if (limitRangeList != null) { sb.append("limitRangeList:"); sb.append(limitRangeList + ","); }
    if (listOptions != null) { sb.append("listOptions:"); sb.append(listOptions + ","); }
    if (microTime != null) { sb.append("microTime:"); sb.append(microTime + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (namespaceList != null) { sb.append("namespaceList:"); sb.append(namespaceList + ","); }
    if (node != null) { sb.append("node:"); sb.append(node + ","); }
    if (nodeList != null) { sb.append("nodeList:"); sb.append(nodeList + ","); }
    if (objectMeta != null) { sb.append("objectMeta:"); sb.append(objectMeta + ","); }
    if (patch != null) { sb.append("patch:"); sb.append(patch + ","); }
    if (patchOptions != null) { sb.append("patchOptions:"); sb.append(patchOptions + ","); }
    if (persistentVolume != null) { sb.append("persistentVolume:"); sb.append(persistentVolume + ","); }
    if (persistentVolumeClaim != null) { sb.append("persistentVolumeClaim:"); sb.append(persistentVolumeClaim + ","); }
    if (persistentVolumeClaimList != null) { sb.append("persistentVolumeClaimList:"); sb.append(persistentVolumeClaimList + ","); }
    if (persistentVolumeList != null) { sb.append("persistentVolumeList:"); sb.append(persistentVolumeList + ","); }
    if (podExecOptions != null) { sb.append("podExecOptions:"); sb.append(podExecOptions + ","); }
    if (podList != null) { sb.append("podList:"); sb.append(podList + ","); }
    if (podTemplateList != null) { sb.append("podTemplateList:"); sb.append(podTemplateList + ","); }
    if (quantity != null) { sb.append("quantity:"); sb.append(quantity + ","); }
    if (replicationControllerList != null) { sb.append("replicationControllerList:"); sb.append(replicationControllerList + ","); }
    if (resourceQuota != null) { sb.append("resourceQuota:"); sb.append(resourceQuota + ","); }
    if (resourceQuotaList != null) { sb.append("resourceQuotaList:"); sb.append(resourceQuotaList + ","); }
    if (rootPaths != null) { sb.append("rootPaths:"); sb.append(rootPaths + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (secretList != null) { sb.append("secretList:"); sb.append(secretList + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (serviceAccountList != null) { sb.append("serviceAccountList:"); sb.append(serviceAccountList + ","); }
    if (serviceList != null) { sb.append("serviceList:"); sb.append(serviceList + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (time != null) { sb.append("time:"); sb.append(time + ","); }
    if (toleration != null) { sb.append("toleration:"); sb.append(toleration + ","); }
    if (topologySelectorTerm != null) { sb.append("topologySelectorTerm:"); sb.append(topologySelectorTerm + ","); }
    if (typeMeta != null) { sb.append("typeMeta:"); sb.append(typeMeta + ","); }
    if (updateOptions != null) { sb.append("updateOptions:"); sb.append(updateOptions + ","); }
    if (watchEvent != null) { sb.append("watchEvent:"); sb.append(watchEvent + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class APIGroupNestedImpl<N> extends APIGroupFluentImpl<ValidationSchemaFluent.APIGroupNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIGroupNested<N>,Nested<N>{
    APIGroupNestedImpl(APIGroup item) {
      this.builder = new APIGroupBuilder(this, item);
    }
    APIGroupNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.APIGroupBuilder(this);
    }
    io.fabric8.kubernetes.api.model.APIGroupBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withAPIGroup(builder.build());
    }
    public N endAPIGroup() {
      return and();
    }
    
  }
  class APIGroupListNestedImpl<N> extends APIGroupListFluentImpl<ValidationSchemaFluent.APIGroupListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIGroupListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    APIGroupListNestedImpl(io.fabric8.kubernetes.api.model.APIGroupList item) {
      this.builder = new APIGroupListBuilder(this, item);
    }
    APIGroupListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.APIGroupListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.APIGroupListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withAPIGroupList(builder.build());
    }
    public N endAPIGroupList() {
      return and();
    }
    
  }
  class APIResourceNestedImpl<N> extends APIResourceFluentImpl<ValidationSchemaFluent.APIResourceNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIResourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    APIResourceNestedImpl(io.fabric8.kubernetes.api.model.APIResource item) {
      this.builder = new APIResourceBuilder(this, item);
    }
    APIResourceNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.APIResourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.APIResourceBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withAPIResource(builder.build());
    }
    public N endAPIResource() {
      return and();
    }
    
  }
  class APIResourceListNestedImpl<N> extends APIResourceListFluentImpl<ValidationSchemaFluent.APIResourceListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIResourceListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    APIResourceListNestedImpl(APIResourceList item) {
      this.builder = new APIResourceListBuilder(this, item);
    }
    APIResourceListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.APIResourceListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.APIResourceListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withAPIResourceList(builder.build());
    }
    public N endAPIResourceList() {
      return and();
    }
    
  }
  class APIServiceNestedImpl<N> extends APIServiceFluentImpl<ValidationSchemaFluent.APIServiceNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    APIServiceNestedImpl(APIService item) {
      this.builder = new APIServiceBuilder(this, item);
    }
    APIServiceNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.APIServiceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.APIServiceBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withAPIService(builder.build());
    }
    public N endAPIService() {
      return and();
    }
    
  }
  class APIServiceListNestedImpl<N> extends APIServiceListFluentImpl<ValidationSchemaFluent.APIServiceListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.APIServiceListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    APIServiceListNestedImpl(io.fabric8.kubernetes.api.model.APIServiceList item) {
      this.builder = new APIServiceListBuilder(this, item);
    }
    APIServiceListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.APIServiceListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.APIServiceListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withAPIServiceList(builder.build());
    }
    public N endAPIServiceList() {
      return and();
    }
    
  }
  class BaseKubernetesListNestedImpl<N> extends BaseKubernetesListFluentImpl<ValidationSchemaFluent.BaseKubernetesListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.BaseKubernetesListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BaseKubernetesListNestedImpl(BaseKubernetesList item) {
      this.builder = new BaseKubernetesListBuilder(this, item);
    }
    BaseKubernetesListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.BaseKubernetesListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.BaseKubernetesListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withBaseKubernetesList(builder.build());
    }
    public N endBaseKubernetesList() {
      return and();
    }
    
  }
  class BindingNestedImpl<N> extends BindingFluentImpl<ValidationSchemaFluent.BindingNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.BindingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BindingNestedImpl(io.fabric8.kubernetes.api.model.Binding item) {
      this.builder = new BindingBuilder(this, item);
    }
    BindingNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.BindingBuilder(this);
    }
    io.fabric8.kubernetes.api.model.BindingBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withBinding(builder.build());
    }
    public N endBinding() {
      return and();
    }
    
  }
  class ComponentStatusNestedImpl<N> extends ComponentStatusFluentImpl<ValidationSchemaFluent.ComponentStatusNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ComponentStatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ComponentStatusNestedImpl(io.fabric8.kubernetes.api.model.ComponentStatus item) {
      this.builder = new ComponentStatusBuilder(this, item);
    }
    ComponentStatusNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ComponentStatusBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ComponentStatusBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withComponentStatus(builder.build());
    }
    public N endComponentStatus() {
      return and();
    }
    
  }
  class ComponentStatusListNestedImpl<N> extends ComponentStatusListFluentImpl<ValidationSchemaFluent.ComponentStatusListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ComponentStatusListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ComponentStatusListNestedImpl(io.fabric8.kubernetes.api.model.ComponentStatusList item) {
      this.builder = new ComponentStatusListBuilder(this, item);
    }
    ComponentStatusListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ComponentStatusListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ComponentStatusListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withComponentStatusList(builder.build());
    }
    public N endComponentStatusList() {
      return and();
    }
    
  }
  class ConditionNestedImpl<N> extends ConditionFluentImpl<ValidationSchemaFluent.ConditionNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConditionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConditionNestedImpl(io.fabric8.kubernetes.api.model.Condition item) {
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ConditionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ConditionBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withCondition(builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ConfigNestedImpl<N> extends ConfigFluentImpl<ValidationSchemaFluent.ConfigNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConfigNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ConfigBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ConfigBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withConfig(builder.build());
    }
    public N endConfig() {
      return and();
    }
    
  }
  class ConfigMapNestedImpl<N> extends ConfigMapFluentImpl<ValidationSchemaFluent.ConfigMapNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConfigMapNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConfigMapNestedImpl(io.fabric8.kubernetes.api.model.ConfigMap item) {
      this.builder = new ConfigMapBuilder(this, item);
    }
    ConfigMapNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ConfigMapBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ConfigMapBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withConfigMap(builder.build());
    }
    public N endConfigMap() {
      return and();
    }
    
  }
  class ConfigMapListNestedImpl<N> extends ConfigMapListFluentImpl<ValidationSchemaFluent.ConfigMapListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ConfigMapListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConfigMapListNestedImpl(io.fabric8.kubernetes.api.model.ConfigMapList item) {
      this.builder = new ConfigMapListBuilder(this, item);
    }
    ConfigMapListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ConfigMapListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ConfigMapListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withConfigMapList(builder.build());
    }
    public N endConfigMapList() {
      return and();
    }
    
  }
  class ContainerStatusNestedImpl<N> extends ContainerStatusFluentImpl<ValidationSchemaFluent.ContainerStatusNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ContainerStatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ContainerStatusNestedImpl(io.fabric8.kubernetes.api.model.ContainerStatus item) {
      this.builder = new ContainerStatusBuilder(this, item);
    }
    ContainerStatusNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ContainerStatusBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ContainerStatusBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withContainerStatus(builder.build());
    }
    public N endContainerStatus() {
      return and();
    }
    
  }
  class CreateOptionsNestedImpl<N> extends CreateOptionsFluentImpl<ValidationSchemaFluent.CreateOptionsNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.CreateOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    CreateOptionsNestedImpl(CreateOptions item) {
      this.builder = new CreateOptionsBuilder(this, item);
    }
    CreateOptionsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.CreateOptionsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.CreateOptionsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withCreateOptions(builder.build());
    }
    public N endCreateOptions() {
      return and();
    }
    
  }
  class DeleteOptionsNestedImpl<N> extends DeleteOptionsFluentImpl<ValidationSchemaFluent.DeleteOptionsNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.DeleteOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DeleteOptionsNestedImpl(io.fabric8.kubernetes.api.model.DeleteOptions item) {
      this.builder = new DeleteOptionsBuilder(this, item);
    }
    DeleteOptionsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.DeleteOptionsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.DeleteOptionsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withDeleteOptions(builder.build());
    }
    public N endDeleteOptions() {
      return and();
    }
    
  }
  class EndpointPortNestedImpl<N> extends EndpointPortFluentImpl<ValidationSchemaFluent.EndpointPortNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EndpointPortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EndpointPortNestedImpl(io.fabric8.kubernetes.api.model.EndpointPort item) {
      this.builder = new EndpointPortBuilder(this, item);
    }
    EndpointPortNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.EndpointPortBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EndpointPortBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEndpointPort(builder.build());
    }
    public N endEndpointPort() {
      return and();
    }
    
  }
  class EndpointsNestedImpl<N> extends EndpointsFluentImpl<ValidationSchemaFluent.EndpointsNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EndpointsNestedImpl(io.fabric8.kubernetes.api.model.Endpoints item) {
      this.builder = new EndpointsBuilder(this, item);
    }
    EndpointsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EndpointsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEndpoints(builder.build());
    }
    public N endEndpoints() {
      return and();
    }
    
  }
  class EndpointsListNestedImpl<N> extends EndpointsListFluentImpl<ValidationSchemaFluent.EndpointsListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EndpointsListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EndpointsListNestedImpl(io.fabric8.kubernetes.api.model.EndpointsList item) {
      this.builder = new EndpointsListBuilder(this, item);
    }
    EndpointsListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.EndpointsListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EndpointsListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEndpointsList(builder.build());
    }
    public N endEndpointsList() {
      return and();
    }
    
  }
  class EnvVarNestedImpl<N> extends EnvVarFluentImpl<ValidationSchemaFluent.EnvVarNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EnvVarNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EnvVarNestedImpl(io.fabric8.kubernetes.api.model.EnvVar item) {
      this.builder = new EnvVarBuilder(this, item);
    }
    EnvVarNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.EnvVarBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EnvVarBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEnvVar(builder.build());
    }
    public N endEnvVar() {
      return and();
    }
    
  }
  class EventNestedImpl<N> extends EventFluentImpl<ValidationSchemaFluent.EventNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EventNestedImpl(Event item) {
      this.builder = new EventBuilder(this, item);
    }
    EventNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.EventBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EventBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEvent(builder.build());
    }
    public N endEvent() {
      return and();
    }
    
  }
  class EventListNestedImpl<N> extends EventListFluentImpl<ValidationSchemaFluent.EventListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EventListNestedImpl(io.fabric8.kubernetes.api.model.EventList item) {
      this.builder = new EventListBuilder(this, item);
    }
    EventListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.EventListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EventListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEventList(builder.build());
    }
    public N endEventList() {
      return and();
    }
    
  }
  class EventSeriesNestedImpl<N> extends EventSeriesFluentImpl<ValidationSchemaFluent.EventSeriesNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventSeriesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EventSeriesNestedImpl(io.fabric8.kubernetes.api.model.EventSeries item) {
      this.builder = new EventSeriesBuilder(this, item);
    }
    EventSeriesNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.EventSeriesBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EventSeriesBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEventSeries(builder.build());
    }
    public N endEventSeries() {
      return and();
    }
    
  }
  class EventSourceNestedImpl<N> extends EventSourceFluentImpl<ValidationSchemaFluent.EventSourceNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.EventSourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EventSourceNestedImpl(io.fabric8.kubernetes.api.model.EventSource item) {
      this.builder = new EventSourceBuilder(this, item);
    }
    EventSourceNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.EventSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EventSourceBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEventSource(builder.build());
    }
    public N endEventSource() {
      return and();
    }
    
  }
  class GetOptionsNestedImpl<N> extends GetOptionsFluentImpl<ValidationSchemaFluent.GetOptionsNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GetOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GetOptionsNestedImpl(GetOptions item) {
      this.builder = new GetOptionsBuilder(this, item);
    }
    GetOptionsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.GetOptionsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.GetOptionsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withGetOptions(builder.build());
    }
    public N endGetOptions() {
      return and();
    }
    
  }
  class GroupKindNestedImpl<N> extends GroupKindFluentImpl<ValidationSchemaFluent.GroupKindNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GroupKindNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GroupKindNestedImpl(GroupKind item) {
      this.builder = new GroupKindBuilder(this, item);
    }
    GroupKindNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.GroupKindBuilder(this);
    }
    io.fabric8.kubernetes.api.model.GroupKindBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withGroupKind(builder.build());
    }
    public N endGroupKind() {
      return and();
    }
    
  }
  class GroupVersionKindNestedImpl<N> extends GroupVersionKindFluentImpl<ValidationSchemaFluent.GroupVersionKindNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GroupVersionKindNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GroupVersionKindNestedImpl(GroupVersionKind item) {
      this.builder = new GroupVersionKindBuilder(this, item);
    }
    GroupVersionKindNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.GroupVersionKindBuilder(this);
    }
    io.fabric8.kubernetes.api.model.GroupVersionKindBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withGroupVersionKind(builder.build());
    }
    public N endGroupVersionKind() {
      return and();
    }
    
  }
  class GroupVersionResourceNestedImpl<N> extends GroupVersionResourceFluentImpl<ValidationSchemaFluent.GroupVersionResourceNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.GroupVersionResourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GroupVersionResourceNestedImpl(GroupVersionResource item) {
      this.builder = new GroupVersionResourceBuilder(this, item);
    }
    GroupVersionResourceNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.GroupVersionResourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.GroupVersionResourceBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withGroupVersionResource(builder.build());
    }
    public N endGroupVersionResource() {
      return and();
    }
    
  }
  class InfoNestedImpl<N> extends InfoFluentImpl<ValidationSchemaFluent.InfoNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.InfoNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    InfoNestedImpl(io.fabric8.kubernetes.api.model.version.Info item) {
      this.builder = new io.fabric8.kubernetes.api.model.version.InfoBuilder(this, item);
    }
    InfoNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.version.InfoBuilder(this);
    }
    io.fabric8.kubernetes.api.model.version.InfoBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withInfo(builder.build());
    }
    public N endInfo() {
      return and();
    }
    
  }
  class LimitRangeListNestedImpl<N> extends LimitRangeListFluentImpl<ValidationSchemaFluent.LimitRangeListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.LimitRangeListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    LimitRangeListNestedImpl(LimitRangeList item) {
      this.builder = new LimitRangeListBuilder(this, item);
    }
    LimitRangeListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LimitRangeListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LimitRangeListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withLimitRangeList(builder.build());
    }
    public N endLimitRangeList() {
      return and();
    }
    
  }
  class ListOptionsNestedImpl<N> extends ListOptionsFluentImpl<ValidationSchemaFluent.ListOptionsNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ListOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ListOptionsNestedImpl(ListOptions item) {
      this.builder = new ListOptionsBuilder(this, item);
    }
    ListOptionsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ListOptionsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ListOptionsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withListOptions(builder.build());
    }
    public N endListOptions() {
      return and();
    }
    
  }
  class MicroTimeNestedImpl<N> extends MicroTimeFluentImpl<ValidationSchemaFluent.MicroTimeNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.MicroTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MicroTimeNestedImpl(MicroTime item) {
      this.builder = new MicroTimeBuilder(this, item);
    }
    MicroTimeNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.MicroTimeBuilder(this);
    }
    io.fabric8.kubernetes.api.model.MicroTimeBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withMicroTime(builder.build());
    }
    public N endMicroTime() {
      return and();
    }
    
  }
  class NamespaceNestedImpl<N> extends NamespaceFluentImpl<ValidationSchemaFluent.NamespaceNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NamespaceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NamespaceNestedImpl(io.fabric8.kubernetes.api.model.Namespace item) {
      this.builder = new NamespaceBuilder(this, item);
    }
    NamespaceNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.NamespaceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NamespaceBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withNamespace(builder.build());
    }
    public N endNamespace() {
      return and();
    }
    
  }
  class NamespaceListNestedImpl<N> extends NamespaceListFluentImpl<ValidationSchemaFluent.NamespaceListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NamespaceListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NamespaceListNestedImpl(NamespaceList item) {
      this.builder = new NamespaceListBuilder(this, item);
    }
    NamespaceListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.NamespaceListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NamespaceListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withNamespaceList(builder.build());
    }
    public N endNamespaceList() {
      return and();
    }
    
  }
  class NodeNestedImpl<N> extends NodeFluentImpl<ValidationSchemaFluent.NodeNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NodeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NodeNestedImpl(Node item) {
      this.builder = new NodeBuilder(this, item);
    }
    NodeNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.NodeBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NodeBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withNode(builder.build());
    }
    public N endNode() {
      return and();
    }
    
  }
  class NodeListNestedImpl<N> extends NodeListFluentImpl<ValidationSchemaFluent.NodeListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.NodeListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NodeListNestedImpl(io.fabric8.kubernetes.api.model.NodeList item) {
      this.builder = new NodeListBuilder(this, item);
    }
    NodeListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.NodeListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NodeListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withNodeList(builder.build());
    }
    public N endNodeList() {
      return and();
    }
    
  }
  class ObjectMetaNestedImpl<N> extends ObjectMetaFluentImpl<ValidationSchemaFluent.ObjectMetaNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ObjectMetaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ObjectMetaNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withObjectMeta(builder.build());
    }
    public N endObjectMeta() {
      return and();
    }
    
  }
  class PatchNestedImpl<N> extends PatchFluentImpl<ValidationSchemaFluent.PatchNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PatchNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PatchNestedImpl(Patch item) {
      this.builder = new PatchBuilder(this, item);
    }
    PatchNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PatchBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PatchBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPatch(builder.build());
    }
    public N endPatch() {
      return and();
    }
    
  }
  class PatchOptionsNestedImpl<N> extends PatchOptionsFluentImpl<ValidationSchemaFluent.PatchOptionsNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PatchOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PatchOptionsNestedImpl(io.fabric8.kubernetes.api.model.PatchOptions item) {
      this.builder = new PatchOptionsBuilder(this, item);
    }
    PatchOptionsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PatchOptionsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PatchOptionsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPatchOptions(builder.build());
    }
    public N endPatchOptions() {
      return and();
    }
    
  }
  class PersistentVolumeNestedImpl<N> extends PersistentVolumeFluentImpl<ValidationSchemaFluent.PersistentVolumeNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PersistentVolumeNestedImpl(PersistentVolume item) {
      this.builder = new PersistentVolumeBuilder(this, item);
    }
    PersistentVolumeNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPersistentVolume(builder.build());
    }
    public N endPersistentVolume() {
      return and();
    }
    
  }
  class PersistentVolumeClaimNestedImpl<N> extends PersistentVolumeClaimFluentImpl<ValidationSchemaFluent.PersistentVolumeClaimNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeClaimNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PersistentVolumeClaimNestedImpl(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPersistentVolumeClaim(builder.build());
    }
    public N endPersistentVolumeClaim() {
      return and();
    }
    
  }
  class PersistentVolumeClaimListNestedImpl<N> extends PersistentVolumeClaimListFluentImpl<ValidationSchemaFluent.PersistentVolumeClaimListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeClaimListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PersistentVolumeClaimListNestedImpl(PersistentVolumeClaimList item) {
      this.builder = new PersistentVolumeClaimListBuilder(this, item);
    }
    PersistentVolumeClaimListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPersistentVolumeClaimList(builder.build());
    }
    public N endPersistentVolumeClaimList() {
      return and();
    }
    
  }
  class PersistentVolumeListNestedImpl<N> extends PersistentVolumeListFluentImpl<ValidationSchemaFluent.PersistentVolumeListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PersistentVolumeListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PersistentVolumeListNestedImpl(PersistentVolumeList item) {
      this.builder = new PersistentVolumeListBuilder(this, item);
    }
    PersistentVolumeListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPersistentVolumeList(builder.build());
    }
    public N endPersistentVolumeList() {
      return and();
    }
    
  }
  class PodExecOptionsNestedImpl<N> extends PodExecOptionsFluentImpl<ValidationSchemaFluent.PodExecOptionsNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PodExecOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PodExecOptionsNestedImpl(PodExecOptions item) {
      this.builder = new PodExecOptionsBuilder(this, item);
    }
    PodExecOptionsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PodExecOptionsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PodExecOptionsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPodExecOptions(builder.build());
    }
    public N endPodExecOptions() {
      return and();
    }
    
  }
  class PodListNestedImpl<N> extends PodListFluentImpl<ValidationSchemaFluent.PodListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PodListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PodListNestedImpl(io.fabric8.kubernetes.api.model.PodList item) {
      this.builder = new PodListBuilder(this, item);
    }
    PodListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PodListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PodListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPodList(builder.build());
    }
    public N endPodList() {
      return and();
    }
    
  }
  class PodTemplateListNestedImpl<N> extends PodTemplateListFluentImpl<ValidationSchemaFluent.PodTemplateListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.PodTemplateListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PodTemplateListNestedImpl(io.fabric8.kubernetes.api.model.PodTemplateList item) {
      this.builder = new PodTemplateListBuilder(this, item);
    }
    PodTemplateListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PodTemplateListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PodTemplateListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPodTemplateList(builder.build());
    }
    public N endPodTemplateList() {
      return and();
    }
    
  }
  class QuantityNestedImpl<N> extends QuantityFluentImpl<ValidationSchemaFluent.QuantityNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.QuantityNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    QuantityNestedImpl(io.fabric8.kubernetes.api.model.Quantity item) {
      this.builder = new QuantityBuilder(this, item);
    }
    QuantityNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.QuantityBuilder(this);
    }
    io.fabric8.kubernetes.api.model.QuantityBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withQuantity(builder.build());
    }
    public N endQuantity() {
      return and();
    }
    
  }
  class ReplicationControllerListNestedImpl<N> extends ReplicationControllerListFluentImpl<ValidationSchemaFluent.ReplicationControllerListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ReplicationControllerListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ReplicationControllerListNestedImpl(ReplicationControllerList item) {
      this.builder = new ReplicationControllerListBuilder(this, item);
    }
    ReplicationControllerListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ReplicationControllerListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ReplicationControllerListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withReplicationControllerList(builder.build());
    }
    public N endReplicationControllerList() {
      return and();
    }
    
  }
  class ResourceQuotaNestedImpl<N> extends ResourceQuotaFluentImpl<ValidationSchemaFluent.ResourceQuotaNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ResourceQuotaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ResourceQuotaNestedImpl(io.fabric8.kubernetes.api.model.ResourceQuota item) {
      this.builder = new ResourceQuotaBuilder(this, item);
    }
    ResourceQuotaNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ResourceQuotaBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withResourceQuota(builder.build());
    }
    public N endResourceQuota() {
      return and();
    }
    
  }
  class ResourceQuotaListNestedImpl<N> extends ResourceQuotaListFluentImpl<ValidationSchemaFluent.ResourceQuotaListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ResourceQuotaListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ResourceQuotaListNestedImpl(io.fabric8.kubernetes.api.model.ResourceQuotaList item) {
      this.builder = new ResourceQuotaListBuilder(this, item);
    }
    ResourceQuotaListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ResourceQuotaListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ResourceQuotaListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withResourceQuotaList(builder.build());
    }
    public N endResourceQuotaList() {
      return and();
    }
    
  }
  class RootPathsNestedImpl<N> extends RootPathsFluentImpl<ValidationSchemaFluent.RootPathsNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.RootPathsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RootPathsNestedImpl(io.fabric8.kubernetes.api.model.RootPaths item) {
      this.builder = new RootPathsBuilder(this, item);
    }
    RootPathsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.RootPathsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.RootPathsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withRootPaths(builder.build());
    }
    public N endRootPaths() {
      return and();
    }
    
  }
  class SecretNestedImpl<N> extends SecretFluentImpl<ValidationSchemaFluent.SecretNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.SecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SecretNestedImpl(io.fabric8.kubernetes.api.model.Secret item) {
      this.builder = new SecretBuilder(this, item);
    }
    SecretNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.SecretBuilder(this);
    }
    io.fabric8.kubernetes.api.model.SecretBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret() {
      return and();
    }
    
  }
  class SecretListNestedImpl<N> extends SecretListFluentImpl<ValidationSchemaFluent.SecretListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.SecretListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SecretListNestedImpl(SecretList item) {
      this.builder = new SecretListBuilder(this, item);
    }
    SecretListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.SecretListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.SecretListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withSecretList(builder.build());
    }
    public N endSecretList() {
      return and();
    }
    
  }
  class ServiceAccountNestedImpl<N> extends ServiceAccountFluentImpl<ValidationSchemaFluent.ServiceAccountNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ServiceAccountNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServiceAccountNestedImpl(io.fabric8.kubernetes.api.model.ServiceAccount item) {
      this.builder = new ServiceAccountBuilder(this, item);
    }
    ServiceAccountNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ServiceAccountBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ServiceAccountBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withServiceAccount(builder.build());
    }
    public N endServiceAccount() {
      return and();
    }
    
  }
  class ServiceAccountListNestedImpl<N> extends ServiceAccountListFluentImpl<ValidationSchemaFluent.ServiceAccountListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ServiceAccountListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServiceAccountListNestedImpl(ServiceAccountList item) {
      this.builder = new ServiceAccountListBuilder(this, item);
    }
    ServiceAccountListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ServiceAccountListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ServiceAccountListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withServiceAccountList(builder.build());
    }
    public N endServiceAccountList() {
      return and();
    }
    
  }
  class ServiceListNestedImpl<N> extends ServiceListFluentImpl<ValidationSchemaFluent.ServiceListNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.ServiceListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServiceListNestedImpl(io.fabric8.kubernetes.api.model.ServiceList item) {
      this.builder = new ServiceListBuilder(this, item);
    }
    ServiceListNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ServiceListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ServiceListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withServiceList(builder.build());
    }
    public N endServiceList() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends StatusFluentImpl<ValidationSchemaFluent.StatusNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    StatusNestedImpl(io.fabric8.kubernetes.api.model.Status item) {
      this.builder = new StatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.StatusBuilder(this);
    }
    io.fabric8.kubernetes.api.model.StatusBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  class TolerationNestedImpl<N> extends TolerationFluentImpl<ValidationSchemaFluent.TolerationNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.TolerationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TolerationNestedImpl(io.fabric8.kubernetes.api.model.Toleration item) {
      this.builder = new TolerationBuilder(this, item);
    }
    TolerationNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.TolerationBuilder(this);
    }
    io.fabric8.kubernetes.api.model.TolerationBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withToleration(builder.build());
    }
    public N endToleration() {
      return and();
    }
    
  }
  class TopologySelectorTermNestedImpl<N> extends TopologySelectorTermFluentImpl<ValidationSchemaFluent.TopologySelectorTermNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.TopologySelectorTermNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TopologySelectorTermNestedImpl(io.fabric8.kubernetes.api.model.TopologySelectorTerm item) {
      this.builder = new TopologySelectorTermBuilder(this, item);
    }
    TopologySelectorTermNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.TopologySelectorTermBuilder(this);
    }
    io.fabric8.kubernetes.api.model.TopologySelectorTermBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withTopologySelectorTerm(builder.build());
    }
    public N endTopologySelectorTerm() {
      return and();
    }
    
  }
  class TypeMetaNestedImpl<N> extends TypeMetaFluentImpl<ValidationSchemaFluent.TypeMetaNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.TypeMetaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TypeMetaNestedImpl(io.fabric8.kubernetes.api.model.TypeMeta item) {
      this.builder = new TypeMetaBuilder(this, item);
    }
    TypeMetaNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.TypeMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.TypeMetaBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withTypeMeta(builder.build());
    }
    public N endTypeMeta() {
      return and();
    }
    
  }
  class UpdateOptionsNestedImpl<N> extends UpdateOptionsFluentImpl<ValidationSchemaFluent.UpdateOptionsNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.UpdateOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UpdateOptionsNestedImpl(UpdateOptions item) {
      this.builder = new UpdateOptionsBuilder(this, item);
    }
    UpdateOptionsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.UpdateOptionsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.UpdateOptionsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withUpdateOptions(builder.build());
    }
    public N endUpdateOptions() {
      return and();
    }
    
  }
  class WatchEventNestedImpl<N> extends WatchEventFluentImpl<ValidationSchemaFluent.WatchEventNested<N>> implements io.fabric8.kubernetes.api.model.ValidationSchemaFluent.WatchEventNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    WatchEventNestedImpl(WatchEvent item) {
      this.builder = new WatchEventBuilder(this, item);
    }
    WatchEventNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.WatchEventBuilder(this);
    }
    io.fabric8.kubernetes.api.model.WatchEventBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withWatchEvent(builder.build());
    }
    public N endWatchEvent() {
      return and();
    }
    
  }
  
}