package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumeDeviceBuilder extends VolumeDeviceFluentImpl<VolumeDeviceBuilder> implements VisitableBuilder<VolumeDevice,io.fabric8.kubernetes.api.model.VolumeDeviceBuilder>{
  public VolumeDeviceBuilder() {
    this(false);
  }
  public VolumeDeviceBuilder(Boolean validationEnabled) {
    this(new VolumeDevice(), validationEnabled);
  }
  public VolumeDeviceBuilder(VolumeDeviceFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeDeviceBuilder(io.fabric8.kubernetes.api.model.VolumeDeviceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new VolumeDevice(), validationEnabled);
  }
  public VolumeDeviceBuilder(io.fabric8.kubernetes.api.model.VolumeDeviceFluent<?> fluent,io.fabric8.kubernetes.api.model.VolumeDevice instance) {
    this(fluent, instance, false);
  }
  public VolumeDeviceBuilder(io.fabric8.kubernetes.api.model.VolumeDeviceFluent<?> fluent,io.fabric8.kubernetes.api.model.VolumeDevice instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDevicePath(instance.getDevicePath()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public VolumeDeviceBuilder(io.fabric8.kubernetes.api.model.VolumeDevice instance) {
    this(instance,false);
  }
  public VolumeDeviceBuilder(io.fabric8.kubernetes.api.model.VolumeDevice instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDevicePath(instance.getDevicePath()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.VolumeDeviceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.VolumeDevice build() {
    VolumeDevice buildable = new VolumeDevice(fluent.getDevicePath(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}