package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VsphereVirtualDiskVolumeSourceBuilder extends VsphereVirtualDiskVolumeSourceFluentImpl<VsphereVirtualDiskVolumeSourceBuilder> implements VisitableBuilder<VsphereVirtualDiskVolumeSource,io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceBuilder>{
  public VsphereVirtualDiskVolumeSourceBuilder() {
    this(false);
  }
  public VsphereVirtualDiskVolumeSourceBuilder(Boolean validationEnabled) {
    this(new VsphereVirtualDiskVolumeSource(), validationEnabled);
  }
  public VsphereVirtualDiskVolumeSourceBuilder(VsphereVirtualDiskVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public VsphereVirtualDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new VsphereVirtualDiskVolumeSource(), validationEnabled);
  }
  public VsphereVirtualDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource instance) {
    this(fluent, instance, false);
  }
  public VsphereVirtualDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFsType(instance.getFsType()); 
    fluent.withStoragePolicyID(instance.getStoragePolicyID()); 
    fluent.withStoragePolicyName(instance.getStoragePolicyName()); 
    fluent.withVolumePath(instance.getVolumePath()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public VsphereVirtualDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource instance) {
    this(instance,false);
  }
  public VsphereVirtualDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withFsType(instance.getFsType()); 
    this.withStoragePolicyID(instance.getStoragePolicyID()); 
    this.withStoragePolicyName(instance.getStoragePolicyName()); 
    this.withVolumePath(instance.getVolumePath()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource build() {
    VsphereVirtualDiskVolumeSource buildable = new VsphereVirtualDiskVolumeSource(fluent.getFsType(),fluent.getStoragePolicyID(),fluent.getStoragePolicyName(),fluent.getVolumePath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}