package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WatchEventBuilder extends WatchEventFluentImpl<WatchEventBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.WatchEvent,WatchEventBuilder>{
  public WatchEventBuilder() {
    this(false);
  }
  public WatchEventBuilder(Boolean validationEnabled) {
    this(new WatchEvent(), validationEnabled);
  }
  public WatchEventBuilder(WatchEventFluent<?> fluent) {
    this(fluent, false);
  }
  public WatchEventBuilder(io.fabric8.kubernetes.api.model.WatchEventFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new WatchEvent(), validationEnabled);
  }
  public WatchEventBuilder(io.fabric8.kubernetes.api.model.WatchEventFluent<?> fluent,io.fabric8.kubernetes.api.model.WatchEvent instance) {
    this(fluent, instance, false);
  }
  public WatchEventBuilder(io.fabric8.kubernetes.api.model.WatchEventFluent<?> fluent,io.fabric8.kubernetes.api.model.WatchEvent instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withObject(instance.getObject()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public WatchEventBuilder(io.fabric8.kubernetes.api.model.WatchEvent instance) {
    this(instance,false);
  }
  public WatchEventBuilder(io.fabric8.kubernetes.api.model.WatchEvent instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withObject(instance.getObject()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.WatchEventFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.WatchEvent build() {
    WatchEvent buildable = new WatchEvent(fluent.getObject(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}