package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WeightedPodAffinityTermBuilder extends WeightedPodAffinityTermFluentImpl<WeightedPodAffinityTermBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.WeightedPodAffinityTerm,WeightedPodAffinityTermBuilder>{
  public WeightedPodAffinityTermBuilder() {
    this(false);
  }
  public WeightedPodAffinityTermBuilder(Boolean validationEnabled) {
    this(new WeightedPodAffinityTerm(), validationEnabled);
  }
  public WeightedPodAffinityTermBuilder(WeightedPodAffinityTermFluent<?> fluent) {
    this(fluent, false);
  }
  public WeightedPodAffinityTermBuilder(io.fabric8.kubernetes.api.model.WeightedPodAffinityTermFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new WeightedPodAffinityTerm(), validationEnabled);
  }
  public WeightedPodAffinityTermBuilder(io.fabric8.kubernetes.api.model.WeightedPodAffinityTermFluent<?> fluent,io.fabric8.kubernetes.api.model.WeightedPodAffinityTerm instance) {
    this(fluent, instance, false);
  }
  public WeightedPodAffinityTermBuilder(io.fabric8.kubernetes.api.model.WeightedPodAffinityTermFluent<?> fluent,io.fabric8.kubernetes.api.model.WeightedPodAffinityTerm instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPodAffinityTerm(instance.getPodAffinityTerm()); 
    fluent.withWeight(instance.getWeight()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public WeightedPodAffinityTermBuilder(io.fabric8.kubernetes.api.model.WeightedPodAffinityTerm instance) {
    this(instance,false);
  }
  public WeightedPodAffinityTermBuilder(io.fabric8.kubernetes.api.model.WeightedPodAffinityTerm instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPodAffinityTerm(instance.getPodAffinityTerm()); 
    this.withWeight(instance.getWeight()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.WeightedPodAffinityTermFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.WeightedPodAffinityTerm build() {
    WeightedPodAffinityTerm buildable = new WeightedPodAffinityTerm(fluent.getPodAffinityTerm(),fluent.getWeight());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}