package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WindowsSecurityContextOptionsBuilder extends WindowsSecurityContextOptionsFluentImpl<WindowsSecurityContextOptionsBuilder> implements VisitableBuilder<WindowsSecurityContextOptions,io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsBuilder>{
  public WindowsSecurityContextOptionsBuilder() {
    this(false);
  }
  public WindowsSecurityContextOptionsBuilder(Boolean validationEnabled) {
    this(new WindowsSecurityContextOptions(), validationEnabled);
  }
  public WindowsSecurityContextOptionsBuilder(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public WindowsSecurityContextOptionsBuilder(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new WindowsSecurityContextOptions(), validationEnabled);
  }
  public WindowsSecurityContextOptionsBuilder(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions instance) {
    this(fluent, instance, false);
  }
  public WindowsSecurityContextOptionsBuilder(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGmsaCredentialSpec(instance.getGmsaCredentialSpec()); 
    fluent.withGmsaCredentialSpecName(instance.getGmsaCredentialSpecName()); 
    fluent.withHostProcess(instance.getHostProcess()); 
    fluent.withRunAsUserName(instance.getRunAsUserName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public WindowsSecurityContextOptionsBuilder(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions instance) {
    this(instance,false);
  }
  public WindowsSecurityContextOptionsBuilder(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withGmsaCredentialSpec(instance.getGmsaCredentialSpec()); 
    this.withGmsaCredentialSpecName(instance.getGmsaCredentialSpecName()); 
    this.withHostProcess(instance.getHostProcess()); 
    this.withRunAsUserName(instance.getRunAsUserName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions build() {
    WindowsSecurityContextOptions buildable = new WindowsSecurityContextOptions(fluent.getGmsaCredentialSpec(),fluent.getGmsaCredentialSpecName(),fluent.getHostProcess(),fluent.getRunAsUserName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}