package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CSIPersistentVolumeSourceFluentImpl<A extends CSIPersistentVolumeSourceFluent<A>> extends BaseFluent<A> implements CSIPersistentVolumeSourceFluent<A>{
  public CSIPersistentVolumeSourceFluentImpl() {
  }
  public CSIPersistentVolumeSourceFluentImpl(CSIPersistentVolumeSource instance) {
    this.withControllerExpandSecretRef(instance.getControllerExpandSecretRef()); 
    this.withControllerPublishSecretRef(instance.getControllerPublishSecretRef()); 
    this.withDriver(instance.getDriver()); 
    this.withFsType(instance.getFsType()); 
    this.withNodePublishSecretRef(instance.getNodePublishSecretRef()); 
    this.withNodeStageSecretRef(instance.getNodeStageSecretRef()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withVolumeAttributes(instance.getVolumeAttributes()); 
    this.withVolumeHandle(instance.getVolumeHandle()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private SecretReferenceBuilder controllerExpandSecretRef;
  private SecretReferenceBuilder controllerPublishSecretRef;
  private String driver;
  private String fsType;
  private SecretReferenceBuilder nodePublishSecretRef;
  private SecretReferenceBuilder nodeStageSecretRef;
  private Boolean readOnly;
  private Map<String,String> volumeAttributes;
  private String volumeHandle;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildControllerExpandSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretReference getControllerExpandSecretRef() {
    return this.controllerExpandSecretRef!=null ?this.controllerExpandSecretRef.build():null;
  }
  public SecretReference buildControllerExpandSecretRef() {
    return this.controllerExpandSecretRef!=null ?this.controllerExpandSecretRef.build():null;
  }
  public A withControllerExpandSecretRef(SecretReference controllerExpandSecretRef) {
    _visitables.get("controllerExpandSecretRef").remove(this.controllerExpandSecretRef);
    if (controllerExpandSecretRef!=null){ this.controllerExpandSecretRef= new SecretReferenceBuilder(controllerExpandSecretRef); _visitables.get("controllerExpandSecretRef").add(this.controllerExpandSecretRef);} else { this.controllerExpandSecretRef = null; _visitables.get("controllerExpandSecretRef").remove(this.controllerExpandSecretRef); } return (A) this;
  }
  public Boolean hasControllerExpandSecretRef() {
    return this.controllerExpandSecretRef != null;
  }
  public A withNewControllerExpandSecretRef(String name,String namespace) {
    return (A)withControllerExpandSecretRef(new SecretReference(name, namespace));
  }
  public CSIPersistentVolumeSourceFluent.ControllerExpandSecretRefNested<A> withNewControllerExpandSecretRef() {
    return new CSIPersistentVolumeSourceFluentImpl.ControllerExpandSecretRefNestedImpl();
  }
  public CSIPersistentVolumeSourceFluent.ControllerExpandSecretRefNested<A> withNewControllerExpandSecretRefLike(SecretReference item) {
    return new CSIPersistentVolumeSourceFluentImpl.ControllerExpandSecretRefNestedImpl(item);
  }
  public CSIPersistentVolumeSourceFluent.ControllerExpandSecretRefNested<A> editControllerExpandSecretRef() {
    return withNewControllerExpandSecretRefLike(getControllerExpandSecretRef());
  }
  public CSIPersistentVolumeSourceFluent.ControllerExpandSecretRefNested<A> editOrNewControllerExpandSecretRef() {
    return withNewControllerExpandSecretRefLike(getControllerExpandSecretRef() != null ? getControllerExpandSecretRef(): new SecretReferenceBuilder().build());
  }
  public CSIPersistentVolumeSourceFluent.ControllerExpandSecretRefNested<A> editOrNewControllerExpandSecretRefLike(SecretReference item) {
    return withNewControllerExpandSecretRefLike(getControllerExpandSecretRef() != null ? getControllerExpandSecretRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildControllerPublishSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretReference getControllerPublishSecretRef() {
    return this.controllerPublishSecretRef!=null ?this.controllerPublishSecretRef.build():null;
  }
  public SecretReference buildControllerPublishSecretRef() {
    return this.controllerPublishSecretRef!=null ?this.controllerPublishSecretRef.build():null;
  }
  public A withControllerPublishSecretRef(SecretReference controllerPublishSecretRef) {
    _visitables.get("controllerPublishSecretRef").remove(this.controllerPublishSecretRef);
    if (controllerPublishSecretRef!=null){ this.controllerPublishSecretRef= new SecretReferenceBuilder(controllerPublishSecretRef); _visitables.get("controllerPublishSecretRef").add(this.controllerPublishSecretRef);} else { this.controllerPublishSecretRef = null; _visitables.get("controllerPublishSecretRef").remove(this.controllerPublishSecretRef); } return (A) this;
  }
  public Boolean hasControllerPublishSecretRef() {
    return this.controllerPublishSecretRef != null;
  }
  public A withNewControllerPublishSecretRef(String name,String namespace) {
    return (A)withControllerPublishSecretRef(new SecretReference(name, namespace));
  }
  public CSIPersistentVolumeSourceFluent.ControllerPublishSecretRefNested<A> withNewControllerPublishSecretRef() {
    return new CSIPersistentVolumeSourceFluentImpl.ControllerPublishSecretRefNestedImpl();
  }
  public CSIPersistentVolumeSourceFluent.ControllerPublishSecretRefNested<A> withNewControllerPublishSecretRefLike(SecretReference item) {
    return new CSIPersistentVolumeSourceFluentImpl.ControllerPublishSecretRefNestedImpl(item);
  }
  public CSIPersistentVolumeSourceFluent.ControllerPublishSecretRefNested<A> editControllerPublishSecretRef() {
    return withNewControllerPublishSecretRefLike(getControllerPublishSecretRef());
  }
  public CSIPersistentVolumeSourceFluent.ControllerPublishSecretRefNested<A> editOrNewControllerPublishSecretRef() {
    return withNewControllerPublishSecretRefLike(getControllerPublishSecretRef() != null ? getControllerPublishSecretRef(): new SecretReferenceBuilder().build());
  }
  public CSIPersistentVolumeSourceFluent.ControllerPublishSecretRefNested<A> editOrNewControllerPublishSecretRefLike(SecretReference item) {
    return withNewControllerPublishSecretRefLike(getControllerPublishSecretRef() != null ? getControllerPublishSecretRef(): item);
  }
  public String getDriver() {
    return this.driver;
  }
  public A withDriver(String driver) {
    this.driver=driver; return (A) this;
  }
  public Boolean hasDriver() {
    return this.driver != null;
  }
  public String getFsType() {
    return this.fsType;
  }
  public A withFsType(String fsType) {
    this.fsType=fsType; return (A) this;
  }
  public Boolean hasFsType() {
    return this.fsType != null;
  }
  
  /**
   * This method has been deprecated, please use method buildNodePublishSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretReference getNodePublishSecretRef() {
    return this.nodePublishSecretRef!=null ?this.nodePublishSecretRef.build():null;
  }
  public SecretReference buildNodePublishSecretRef() {
    return this.nodePublishSecretRef!=null ?this.nodePublishSecretRef.build():null;
  }
  public A withNodePublishSecretRef(SecretReference nodePublishSecretRef) {
    _visitables.get("nodePublishSecretRef").remove(this.nodePublishSecretRef);
    if (nodePublishSecretRef!=null){ this.nodePublishSecretRef= new SecretReferenceBuilder(nodePublishSecretRef); _visitables.get("nodePublishSecretRef").add(this.nodePublishSecretRef);} else { this.nodePublishSecretRef = null; _visitables.get("nodePublishSecretRef").remove(this.nodePublishSecretRef); } return (A) this;
  }
  public Boolean hasNodePublishSecretRef() {
    return this.nodePublishSecretRef != null;
  }
  public A withNewNodePublishSecretRef(String name,String namespace) {
    return (A)withNodePublishSecretRef(new SecretReference(name, namespace));
  }
  public CSIPersistentVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRef() {
    return new CSIPersistentVolumeSourceFluentImpl.NodePublishSecretRefNestedImpl();
  }
  public CSIPersistentVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRefLike(SecretReference item) {
    return new CSIPersistentVolumeSourceFluentImpl.NodePublishSecretRefNestedImpl(item);
  }
  public CSIPersistentVolumeSourceFluent.NodePublishSecretRefNested<A> editNodePublishSecretRef() {
    return withNewNodePublishSecretRefLike(getNodePublishSecretRef());
  }
  public CSIPersistentVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRef() {
    return withNewNodePublishSecretRefLike(getNodePublishSecretRef() != null ? getNodePublishSecretRef(): new SecretReferenceBuilder().build());
  }
  public CSIPersistentVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRefLike(SecretReference item) {
    return withNewNodePublishSecretRefLike(getNodePublishSecretRef() != null ? getNodePublishSecretRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNodeStageSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretReference getNodeStageSecretRef() {
    return this.nodeStageSecretRef!=null ?this.nodeStageSecretRef.build():null;
  }
  public SecretReference buildNodeStageSecretRef() {
    return this.nodeStageSecretRef!=null ?this.nodeStageSecretRef.build():null;
  }
  public A withNodeStageSecretRef(SecretReference nodeStageSecretRef) {
    _visitables.get("nodeStageSecretRef").remove(this.nodeStageSecretRef);
    if (nodeStageSecretRef!=null){ this.nodeStageSecretRef= new SecretReferenceBuilder(nodeStageSecretRef); _visitables.get("nodeStageSecretRef").add(this.nodeStageSecretRef);} else { this.nodeStageSecretRef = null; _visitables.get("nodeStageSecretRef").remove(this.nodeStageSecretRef); } return (A) this;
  }
  public Boolean hasNodeStageSecretRef() {
    return this.nodeStageSecretRef != null;
  }
  public A withNewNodeStageSecretRef(String name,String namespace) {
    return (A)withNodeStageSecretRef(new SecretReference(name, namespace));
  }
  public CSIPersistentVolumeSourceFluent.NodeStageSecretRefNested<A> withNewNodeStageSecretRef() {
    return new CSIPersistentVolumeSourceFluentImpl.NodeStageSecretRefNestedImpl();
  }
  public CSIPersistentVolumeSourceFluent.NodeStageSecretRefNested<A> withNewNodeStageSecretRefLike(SecretReference item) {
    return new CSIPersistentVolumeSourceFluentImpl.NodeStageSecretRefNestedImpl(item);
  }
  public CSIPersistentVolumeSourceFluent.NodeStageSecretRefNested<A> editNodeStageSecretRef() {
    return withNewNodeStageSecretRefLike(getNodeStageSecretRef());
  }
  public CSIPersistentVolumeSourceFluent.NodeStageSecretRefNested<A> editOrNewNodeStageSecretRef() {
    return withNewNodeStageSecretRefLike(getNodeStageSecretRef() != null ? getNodeStageSecretRef(): new SecretReferenceBuilder().build());
  }
  public CSIPersistentVolumeSourceFluent.NodeStageSecretRefNested<A> editOrNewNodeStageSecretRefLike(SecretReference item) {
    return withNewNodeStageSecretRefLike(getNodeStageSecretRef() != null ? getNodeStageSecretRef(): item);
  }
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  public A withReadOnly(Boolean readOnly) {
    this.readOnly=readOnly; return (A) this;
  }
  public Boolean hasReadOnly() {
    return this.readOnly != null;
  }
  public A addToVolumeAttributes(String key,String value) {
    if(this.volumeAttributes == null && key != null && value != null) { this.volumeAttributes = new LinkedHashMap(); }
    if(key != null && value != null) {this.volumeAttributes.put(key, value);} return (A)this;
  }
  public A addToVolumeAttributes(Map<String,String> map) {
    if(this.volumeAttributes == null && map != null) { this.volumeAttributes = new LinkedHashMap(); }
    if(map != null) { this.volumeAttributes.putAll(map);} return (A)this;
  }
  public A removeFromVolumeAttributes(String key) {
    if(this.volumeAttributes == null) { return (A) this; }
    if(key != null && this.volumeAttributes != null) {this.volumeAttributes.remove(key);} return (A)this;
  }
  public A removeFromVolumeAttributes(Map<String,String> map) {
    if(this.volumeAttributes == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.volumeAttributes != null){this.volumeAttributes.remove(key);}}} return (A)this;
  }
  public Map<String,String> getVolumeAttributes() {
    return this.volumeAttributes;
  }
  public <K,V>A withVolumeAttributes(Map<String,String> volumeAttributes) {
    if (volumeAttributes == null) { this.volumeAttributes =  null;} else {this.volumeAttributes = new LinkedHashMap(volumeAttributes);} return (A) this;
  }
  public Boolean hasVolumeAttributes() {
    return this.volumeAttributes != null;
  }
  public String getVolumeHandle() {
    return this.volumeHandle;
  }
  public A withVolumeHandle(String volumeHandle) {
    this.volumeHandle=volumeHandle; return (A) this;
  }
  public Boolean hasVolumeHandle() {
    return this.volumeHandle != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CSIPersistentVolumeSourceFluentImpl that = (CSIPersistentVolumeSourceFluentImpl) o;
    if (controllerExpandSecretRef != null ? !controllerExpandSecretRef.equals(that.controllerExpandSecretRef) :that.controllerExpandSecretRef != null) return false;
    if (controllerPublishSecretRef != null ? !controllerPublishSecretRef.equals(that.controllerPublishSecretRef) :that.controllerPublishSecretRef != null) return false;
    if (driver != null ? !driver.equals(that.driver) :that.driver != null) return false;
    if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
    if (nodePublishSecretRef != null ? !nodePublishSecretRef.equals(that.nodePublishSecretRef) :that.nodePublishSecretRef != null) return false;
    if (nodeStageSecretRef != null ? !nodeStageSecretRef.equals(that.nodeStageSecretRef) :that.nodeStageSecretRef != null) return false;
    if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
    if (volumeAttributes != null ? !volumeAttributes.equals(that.volumeAttributes) :that.volumeAttributes != null) return false;
    if (volumeHandle != null ? !volumeHandle.equals(that.volumeHandle) :that.volumeHandle != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(controllerExpandSecretRef,  controllerPublishSecretRef,  driver,  fsType,  nodePublishSecretRef,  nodeStageSecretRef,  readOnly,  volumeAttributes,  volumeHandle,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (controllerExpandSecretRef != null) { sb.append("controllerExpandSecretRef:"); sb.append(controllerExpandSecretRef + ","); }
    if (controllerPublishSecretRef != null) { sb.append("controllerPublishSecretRef:"); sb.append(controllerPublishSecretRef + ","); }
    if (driver != null) { sb.append("driver:"); sb.append(driver + ","); }
    if (fsType != null) { sb.append("fsType:"); sb.append(fsType + ","); }
    if (nodePublishSecretRef != null) { sb.append("nodePublishSecretRef:"); sb.append(nodePublishSecretRef + ","); }
    if (nodeStageSecretRef != null) { sb.append("nodeStageSecretRef:"); sb.append(nodeStageSecretRef + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly + ","); }
    if (volumeAttributes != null && !volumeAttributes.isEmpty()) { sb.append("volumeAttributes:"); sb.append(volumeAttributes + ","); }
    if (volumeHandle != null) { sb.append("volumeHandle:"); sb.append(volumeHandle + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withReadOnly() {
    return withReadOnly(true);
  }
  class ControllerExpandSecretRefNestedImpl<N> extends SecretReferenceFluentImpl<CSIPersistentVolumeSourceFluent.ControllerExpandSecretRefNested<N>> implements CSIPersistentVolumeSourceFluent.ControllerExpandSecretRefNested<N>,Nested<N>{
    ControllerExpandSecretRefNestedImpl(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    ControllerExpandSecretRefNestedImpl() {
      this.builder = new SecretReferenceBuilder(this);
    }
    SecretReferenceBuilder builder;
    public N and() {
      return (N) CSIPersistentVolumeSourceFluentImpl.this.withControllerExpandSecretRef(builder.build());
    }
    public N endControllerExpandSecretRef() {
      return and();
    }
    
  }
  class ControllerPublishSecretRefNestedImpl<N> extends SecretReferenceFluentImpl<CSIPersistentVolumeSourceFluent.ControllerPublishSecretRefNested<N>> implements CSIPersistentVolumeSourceFluent.ControllerPublishSecretRefNested<N>,Nested<N>{
    ControllerPublishSecretRefNestedImpl(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    ControllerPublishSecretRefNestedImpl() {
      this.builder = new SecretReferenceBuilder(this);
    }
    SecretReferenceBuilder builder;
    public N and() {
      return (N) CSIPersistentVolumeSourceFluentImpl.this.withControllerPublishSecretRef(builder.build());
    }
    public N endControllerPublishSecretRef() {
      return and();
    }
    
  }
  class NodePublishSecretRefNestedImpl<N> extends SecretReferenceFluentImpl<CSIPersistentVolumeSourceFluent.NodePublishSecretRefNested<N>> implements CSIPersistentVolumeSourceFluent.NodePublishSecretRefNested<N>,Nested<N>{
    NodePublishSecretRefNestedImpl(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    NodePublishSecretRefNestedImpl() {
      this.builder = new SecretReferenceBuilder(this);
    }
    SecretReferenceBuilder builder;
    public N and() {
      return (N) CSIPersistentVolumeSourceFluentImpl.this.withNodePublishSecretRef(builder.build());
    }
    public N endNodePublishSecretRef() {
      return and();
    }
    
  }
  class NodeStageSecretRefNestedImpl<N> extends SecretReferenceFluentImpl<CSIPersistentVolumeSourceFluent.NodeStageSecretRefNested<N>> implements CSIPersistentVolumeSourceFluent.NodeStageSecretRefNested<N>,Nested<N>{
    NodeStageSecretRefNestedImpl(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    NodeStageSecretRefNestedImpl() {
      this.builder = new SecretReferenceBuilder(this);
    }
    SecretReferenceBuilder builder;
    public N and() {
      return (N) CSIPersistentVolumeSourceFluentImpl.this.withNodeStageSecretRef(builder.build());
    }
    public N endNodeStageSecretRef() {
      return and();
    }
    
  }
  
}