package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GitRepoVolumeSourceFluentImpl<A extends GitRepoVolumeSourceFluent<A>> extends BaseFluent<A> implements GitRepoVolumeSourceFluent<A>{
  public GitRepoVolumeSourceFluentImpl() {
  }
  public GitRepoVolumeSourceFluentImpl(GitRepoVolumeSource instance) {
    this.withDirectory(instance.getDirectory()); 
    this.withRepository(instance.getRepository()); 
    this.withRevision(instance.getRevision()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String directory;
  private String repository;
  private String revision;
  private Map<String,Object> additionalProperties;
  public String getDirectory() {
    return this.directory;
  }
  public A withDirectory(String directory) {
    this.directory=directory; return (A) this;
  }
  public Boolean hasDirectory() {
    return this.directory != null;
  }
  public String getRepository() {
    return this.repository;
  }
  public A withRepository(String repository) {
    this.repository=repository; return (A) this;
  }
  public Boolean hasRepository() {
    return this.repository != null;
  }
  public String getRevision() {
    return this.revision;
  }
  public A withRevision(String revision) {
    this.revision=revision; return (A) this;
  }
  public Boolean hasRevision() {
    return this.revision != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GitRepoVolumeSourceFluentImpl that = (GitRepoVolumeSourceFluentImpl) o;
    if (directory != null ? !directory.equals(that.directory) :that.directory != null) return false;
    if (repository != null ? !repository.equals(that.repository) :that.repository != null) return false;
    if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(directory,  repository,  revision,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (directory != null) { sb.append("directory:"); sb.append(directory + ","); }
    if (repository != null) { sb.append("repository:"); sb.append(repository + ","); }
    if (revision != null) { sb.append("revision:"); sb.append(revision + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}