package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class LimitRangeSpecFluentImpl<A extends LimitRangeSpecFluent<A>> extends BaseFluent<A> implements LimitRangeSpecFluent<A>{
  public LimitRangeSpecFluentImpl() {
  }
  public LimitRangeSpecFluentImpl(LimitRangeSpec instance) {
    this.withLimits(instance.getLimits()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<LimitRangeItemBuilder> limits = new ArrayList<LimitRangeItemBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToLimits(Integer index,LimitRangeItem item) {
    if (this.limits == null) {this.limits = new ArrayList<LimitRangeItemBuilder>();}
    LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);_visitables.get("limits").add(index >= 0 ? index : _visitables.get("limits").size(), builder);this.limits.add(index >= 0 ? index : limits.size(), builder); return (A)this;
  }
  public A setToLimits(Integer index,LimitRangeItem item) {
    if (this.limits == null) {this.limits = new ArrayList<LimitRangeItemBuilder>();}
    LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
    if (index < 0 || index >= _visitables.get("limits").size()) { _visitables.get("limits").add(builder); } else { _visitables.get("limits").set(index, builder);}
    if (index < 0 || index >= limits.size()) { limits.add(builder); } else { limits.set(index, builder);}
     return (A)this;
  }
  public A addToLimits(io.fabric8.kubernetes.api.model.LimitRangeItem... items) {
    if (this.limits == null) {this.limits = new ArrayList<LimitRangeItemBuilder>();}
    for (LimitRangeItem item : items) {LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);_visitables.get("limits").add(builder);this.limits.add(builder);} return (A)this;
  }
  public A addAllToLimits(Collection<LimitRangeItem> items) {
    if (this.limits == null) {this.limits = new ArrayList<LimitRangeItemBuilder>();}
    for (LimitRangeItem item : items) {LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);_visitables.get("limits").add(builder);this.limits.add(builder);} return (A)this;
  }
  public A removeFromLimits(io.fabric8.kubernetes.api.model.LimitRangeItem... items) {
    for (LimitRangeItem item : items) {LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);_visitables.get("limits").remove(builder);if (this.limits != null) {this.limits.remove(builder);}} return (A)this;
  }
  public A removeAllFromLimits(Collection<LimitRangeItem> items) {
    for (LimitRangeItem item : items) {LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);_visitables.get("limits").remove(builder);if (this.limits != null) {this.limits.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromLimits(Predicate<LimitRangeItemBuilder> predicate) {
    if (limits == null) return (A) this;
    final Iterator<LimitRangeItemBuilder> each = limits.iterator();
    final List visitables = _visitables.get("limits");
    while (each.hasNext()) {
      LimitRangeItemBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildLimits instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LimitRangeItem> getLimits() {
    return limits != null ? build(limits) : null;
  }
  public List<LimitRangeItem> buildLimits() {
    return limits != null ? build(limits) : null;
  }
  public LimitRangeItem buildLimit(Integer index) {
    return this.limits.get(index).build();
  }
  public LimitRangeItem buildFirstLimit() {
    return this.limits.get(0).build();
  }
  public LimitRangeItem buildLastLimit() {
    return this.limits.get(limits.size() - 1).build();
  }
  public LimitRangeItem buildMatchingLimit(Predicate<LimitRangeItemBuilder> predicate) {
    for (LimitRangeItemBuilder item: limits) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingLimit(Predicate<LimitRangeItemBuilder> predicate) {
    for (LimitRangeItemBuilder item: limits) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLimits(List<LimitRangeItem> limits) {
    if (this.limits != null) { _visitables.get("limits").removeAll(this.limits);}
    if (limits != null) {this.limits = new ArrayList(); for (LimitRangeItem item : limits){this.addToLimits(item);}} else { this.limits = null;} return (A) this;
  }
  public A withLimits(io.fabric8.kubernetes.api.model.LimitRangeItem... limits) {
    if (this.limits != null) {this.limits.clear();}
    if (limits != null) {for (LimitRangeItem item :limits){ this.addToLimits(item);}} return (A) this;
  }
  public Boolean hasLimits() {
    return limits != null && !limits.isEmpty();
  }
  public LimitRangeSpecFluent.LimitsNested<A> addNewLimit() {
    return new LimitRangeSpecFluentImpl.LimitsNestedImpl();
  }
  public LimitRangeSpecFluent.LimitsNested<A> addNewLimitLike(LimitRangeItem item) {
    return new LimitRangeSpecFluentImpl.LimitsNestedImpl(-1, item);
  }
  public LimitRangeSpecFluent.LimitsNested<A> setNewLimitLike(Integer index,LimitRangeItem item) {
    return new LimitRangeSpecFluentImpl.LimitsNestedImpl(index, item);
  }
  public LimitRangeSpecFluent.LimitsNested<A> editLimit(Integer index) {
    if (limits.size() <= index) throw new RuntimeException("Can't edit limits. Index exceeds size.");
    return setNewLimitLike(index, buildLimit(index));
  }
  public LimitRangeSpecFluent.LimitsNested<A> editFirstLimit() {
    if (limits.size() == 0) throw new RuntimeException("Can't edit first limits. The list is empty.");
    return setNewLimitLike(0, buildLimit(0));
  }
  public LimitRangeSpecFluent.LimitsNested<A> editLastLimit() {
    int index = limits.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last limits. The list is empty.");
    return setNewLimitLike(index, buildLimit(index));
  }
  public LimitRangeSpecFluent.LimitsNested<A> editMatchingLimit(Predicate<LimitRangeItemBuilder> predicate) {
    int index = -1;
    for (int i=0;i<limits.size();i++) { 
    if (predicate.test(limits.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching limits. No match found.");
    return setNewLimitLike(index, buildLimit(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LimitRangeSpecFluentImpl that = (LimitRangeSpecFluentImpl) o;
    if (limits != null ? !limits.equals(that.limits) :that.limits != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(limits,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (limits != null && !limits.isEmpty()) { sb.append("limits:"); sb.append(limits + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class LimitsNestedImpl<N> extends LimitRangeItemFluentImpl<LimitRangeSpecFluent.LimitsNested<N>> implements LimitRangeSpecFluent.LimitsNested<N>,Nested<N>{
    LimitsNestedImpl(Integer index,LimitRangeItem item) {
      this.index = index;
      this.builder = new LimitRangeItemBuilder(this, item);
    }
    LimitsNestedImpl() {
      this.index = -1;
      this.builder = new LimitRangeItemBuilder(this);
    }
    LimitRangeItemBuilder builder;
    Integer index;
    public N and() {
      return (N) LimitRangeSpecFluentImpl.this.setToLimits(index,builder.build());
    }
    public N endLimit() {
      return and();
    }
    
  }
  
}