package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ObjectMetaBuilder extends ObjectMetaFluentImpl<ObjectMetaBuilder> implements VisitableBuilder<ObjectMeta,ObjectMetaBuilder>{
  public ObjectMetaBuilder() {
    this(false);
  }
  public ObjectMetaBuilder(Boolean validationEnabled) {
    this(new ObjectMeta(), validationEnabled);
  }
  public ObjectMetaBuilder(ObjectMetaFluent<?> fluent) {
    this(fluent, false);
  }
  public ObjectMetaBuilder(ObjectMetaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ObjectMeta(), validationEnabled);
  }
  public ObjectMetaBuilder(ObjectMetaFluent<?> fluent,ObjectMeta instance) {
    this(fluent, instance, false);
  }
  public ObjectMetaBuilder(ObjectMetaFluent<?> fluent,ObjectMeta instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withClusterName(instance.getClusterName()); 
    fluent.withCreationTimestamp(instance.getCreationTimestamp()); 
    fluent.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds()); 
    fluent.withDeletionTimestamp(instance.getDeletionTimestamp()); 
    fluent.withFinalizers(instance.getFinalizers()); 
    fluent.withGenerateName(instance.getGenerateName()); 
    fluent.withGeneration(instance.getGeneration()); 
    fluent.withLabels(instance.getLabels()); 
    fluent.withManagedFields(instance.getManagedFields()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withOwnerReferences(instance.getOwnerReferences()); 
    fluent.withResourceVersion(instance.getResourceVersion()); 
    fluent.withSelfLink(instance.getSelfLink()); 
    fluent.withUid(instance.getUid()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ObjectMetaBuilder(ObjectMeta instance) {
    this(instance,false);
  }
  public ObjectMetaBuilder(ObjectMeta instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAnnotations(instance.getAnnotations()); 
    this.withClusterName(instance.getClusterName()); 
    this.withCreationTimestamp(instance.getCreationTimestamp()); 
    this.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds()); 
    this.withDeletionTimestamp(instance.getDeletionTimestamp()); 
    this.withFinalizers(instance.getFinalizers()); 
    this.withGenerateName(instance.getGenerateName()); 
    this.withGeneration(instance.getGeneration()); 
    this.withLabels(instance.getLabels()); 
    this.withManagedFields(instance.getManagedFields()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withOwnerReferences(instance.getOwnerReferences()); 
    this.withResourceVersion(instance.getResourceVersion()); 
    this.withSelfLink(instance.getSelfLink()); 
    this.withUid(instance.getUid()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ObjectMetaFluent<?> fluent;
  Boolean validationEnabled;
  public ObjectMeta build() {
    ObjectMeta buildable = new ObjectMeta(fluent.getAnnotations(),fluent.getClusterName(),fluent.getCreationTimestamp(),fluent.getDeletionGracePeriodSeconds(),fluent.getDeletionTimestamp(),fluent.getFinalizers(),fluent.getGenerateName(),fluent.getGeneration(),fluent.getLabels(),fluent.getManagedFields(),fluent.getName(),fluent.getNamespace(),fluent.getOwnerReferences(),fluent.getResourceVersion(),fluent.getSelfLink(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}