package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodStatusFluentImpl<A extends PodStatusFluent<A>> extends BaseFluent<A> implements PodStatusFluent<A>{
  public PodStatusFluentImpl() {
  }
  public PodStatusFluentImpl(PodStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withContainerStatuses(instance.getContainerStatuses()); 
    this.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses()); 
    this.withHostIP(instance.getHostIP()); 
    this.withInitContainerStatuses(instance.getInitContainerStatuses()); 
    this.withMessage(instance.getMessage()); 
    this.withNominatedNodeName(instance.getNominatedNodeName()); 
    this.withPhase(instance.getPhase()); 
    this.withPodIP(instance.getPodIP()); 
    this.withPodIPs(instance.getPodIPs()); 
    this.withQosClass(instance.getQosClass()); 
    this.withReason(instance.getReason()); 
    this.withStartTime(instance.getStartTime()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<PodConditionBuilder> conditions = new ArrayList<PodConditionBuilder>();
  private ArrayList<ContainerStatusBuilder> containerStatuses = new ArrayList<ContainerStatusBuilder>();
  private ArrayList<ContainerStatusBuilder> ephemeralContainerStatuses = new ArrayList<ContainerStatusBuilder>();
  private String hostIP;
  private ArrayList<ContainerStatusBuilder> initContainerStatuses = new ArrayList<ContainerStatusBuilder>();
  private String message;
  private String nominatedNodeName;
  private String phase;
  private String podIP;
  private ArrayList<PodIPBuilder> podIPs = new ArrayList<PodIPBuilder>();
  private String qosClass;
  private String reason;
  private String startTime;
  private Map<String,Object> additionalProperties;
  public A addToConditions(Integer index,PodCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<PodConditionBuilder>();}
    PodConditionBuilder builder = new PodConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,PodCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<PodConditionBuilder>();}
    PodConditionBuilder builder = new PodConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.PodCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<PodConditionBuilder>();}
    for (PodCondition item : items) {PodConditionBuilder builder = new PodConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<PodCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<PodConditionBuilder>();}
    for (PodCondition item : items) {PodConditionBuilder builder = new PodConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.PodCondition... items) {
    for (PodCondition item : items) {PodConditionBuilder builder = new PodConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<PodCondition> items) {
    for (PodCondition item : items) {PodConditionBuilder builder = new PodConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<PodConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<PodConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      PodConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PodCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<PodCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public PodCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public PodCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public PodCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public PodCondition buildMatchingCondition(Predicate<PodConditionBuilder> predicate) {
    for (PodConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<PodConditionBuilder> predicate) {
    for (PodConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<PodCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (PodCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.PodCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (PodCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public PodStatusFluent.ConditionsNested<A> addNewCondition() {
    return new PodStatusFluentImpl.ConditionsNestedImpl();
  }
  public PodStatusFluent.ConditionsNested<A> addNewConditionLike(PodCondition item) {
    return new PodStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public PodStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,PodCondition item) {
    return new PodStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public PodStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public PodStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public PodStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public PodStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<PodConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public A addToContainerStatuses(Integer index,ContainerStatus item) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").add(index >= 0 ? index : _visitables.get("containerStatuses").size(), builder);this.containerStatuses.add(index >= 0 ? index : containerStatuses.size(), builder); return (A)this;
  }
  public A setToContainerStatuses(Integer index,ContainerStatus item) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("containerStatuses").size()) { _visitables.get("containerStatuses").add(builder); } else { _visitables.get("containerStatuses").set(index, builder);}
    if (index < 0 || index >= containerStatuses.size()) { containerStatuses.add(builder); } else { containerStatuses.set(index, builder);}
     return (A)this;
  }
  public A addToContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").add(builder);this.containerStatuses.add(builder);} return (A)this;
  }
  public A addAllToContainerStatuses(Collection<ContainerStatus> items) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").add(builder);this.containerStatuses.add(builder);} return (A)this;
  }
  public A removeFromContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items) {
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").remove(builder);if (this.containerStatuses != null) {this.containerStatuses.remove(builder);}} return (A)this;
  }
  public A removeAllFromContainerStatuses(Collection<ContainerStatus> items) {
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").remove(builder);if (this.containerStatuses != null) {this.containerStatuses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
    if (containerStatuses == null) return (A) this;
    final Iterator<ContainerStatusBuilder> each = containerStatuses.iterator();
    final List visitables = _visitables.get("containerStatuses");
    while (each.hasNext()) {
      ContainerStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContainerStatuses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContainerStatus> getContainerStatuses() {
    return containerStatuses != null ? build(containerStatuses) : null;
  }
  public List<ContainerStatus> buildContainerStatuses() {
    return containerStatuses != null ? build(containerStatuses) : null;
  }
  public ContainerStatus buildContainerStatus(Integer index) {
    return this.containerStatuses.get(index).build();
  }
  public ContainerStatus buildFirstContainerStatus() {
    return this.containerStatuses.get(0).build();
  }
  public ContainerStatus buildLastContainerStatus() {
    return this.containerStatuses.get(containerStatuses.size() - 1).build();
  }
  public ContainerStatus buildMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: containerStatuses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: containerStatuses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainerStatuses(List<ContainerStatus> containerStatuses) {
    if (this.containerStatuses != null) { _visitables.get("containerStatuses").removeAll(this.containerStatuses);}
    if (containerStatuses != null) {this.containerStatuses = new ArrayList(); for (ContainerStatus item : containerStatuses){this.addToContainerStatuses(item);}} else { this.containerStatuses = null;} return (A) this;
  }
  public A withContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... containerStatuses) {
    if (this.containerStatuses != null) {this.containerStatuses.clear();}
    if (containerStatuses != null) {for (ContainerStatus item :containerStatuses){ this.addToContainerStatuses(item);}} return (A) this;
  }
  public Boolean hasContainerStatuses() {
    return containerStatuses != null && !containerStatuses.isEmpty();
  }
  public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatus() {
    return new PodStatusFluentImpl.ContainerStatusesNestedImpl();
  }
  public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item) {
    return new PodStatusFluentImpl.ContainerStatusesNestedImpl(-1, item);
  }
  public PodStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(Integer index,ContainerStatus item) {
    return new PodStatusFluentImpl.ContainerStatusesNestedImpl(index, item);
  }
  public PodStatusFluent.ContainerStatusesNested<A> editContainerStatus(Integer index) {
    if (containerStatuses.size() <= index) throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
    return setNewContainerStatusLike(index, buildContainerStatus(index));
  }
  public PodStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus() {
    if (containerStatuses.size() == 0) throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
    return setNewContainerStatusLike(0, buildContainerStatus(0));
  }
  public PodStatusFluent.ContainerStatusesNested<A> editLastContainerStatus() {
    int index = containerStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
    return setNewContainerStatusLike(index, buildContainerStatus(index));
  }
  public PodStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containerStatuses.size();i++) { 
    if (predicate.test(containerStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
    return setNewContainerStatusLike(index, buildContainerStatus(index));
  }
  public A addToEphemeralContainerStatuses(Integer index,ContainerStatus item) {
    if (this.ephemeralContainerStatuses == null) {this.ephemeralContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("ephemeralContainerStatuses").add(index >= 0 ? index : _visitables.get("ephemeralContainerStatuses").size(), builder);this.ephemeralContainerStatuses.add(index >= 0 ? index : ephemeralContainerStatuses.size(), builder); return (A)this;
  }
  public A setToEphemeralContainerStatuses(Integer index,ContainerStatus item) {
    if (this.ephemeralContainerStatuses == null) {this.ephemeralContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("ephemeralContainerStatuses").size()) { _visitables.get("ephemeralContainerStatuses").add(builder); } else { _visitables.get("ephemeralContainerStatuses").set(index, builder);}
    if (index < 0 || index >= ephemeralContainerStatuses.size()) { ephemeralContainerStatuses.add(builder); } else { ephemeralContainerStatuses.set(index, builder);}
     return (A)this;
  }
  public A addToEphemeralContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items) {
    if (this.ephemeralContainerStatuses == null) {this.ephemeralContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("ephemeralContainerStatuses").add(builder);this.ephemeralContainerStatuses.add(builder);} return (A)this;
  }
  public A addAllToEphemeralContainerStatuses(Collection<ContainerStatus> items) {
    if (this.ephemeralContainerStatuses == null) {this.ephemeralContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("ephemeralContainerStatuses").add(builder);this.ephemeralContainerStatuses.add(builder);} return (A)this;
  }
  public A removeFromEphemeralContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items) {
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("ephemeralContainerStatuses").remove(builder);if (this.ephemeralContainerStatuses != null) {this.ephemeralContainerStatuses.remove(builder);}} return (A)this;
  }
  public A removeAllFromEphemeralContainerStatuses(Collection<ContainerStatus> items) {
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("ephemeralContainerStatuses").remove(builder);if (this.ephemeralContainerStatuses != null) {this.ephemeralContainerStatuses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEphemeralContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
    if (ephemeralContainerStatuses == null) return (A) this;
    final Iterator<ContainerStatusBuilder> each = ephemeralContainerStatuses.iterator();
    final List visitables = _visitables.get("ephemeralContainerStatuses");
    while (each.hasNext()) {
      ContainerStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEphemeralContainerStatuses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContainerStatus> getEphemeralContainerStatuses() {
    return ephemeralContainerStatuses != null ? build(ephemeralContainerStatuses) : null;
  }
  public List<ContainerStatus> buildEphemeralContainerStatuses() {
    return ephemeralContainerStatuses != null ? build(ephemeralContainerStatuses) : null;
  }
  public ContainerStatus buildEphemeralContainerStatus(Integer index) {
    return this.ephemeralContainerStatuses.get(index).build();
  }
  public ContainerStatus buildFirstEphemeralContainerStatus() {
    return this.ephemeralContainerStatuses.get(0).build();
  }
  public ContainerStatus buildLastEphemeralContainerStatus() {
    return this.ephemeralContainerStatuses.get(ephemeralContainerStatuses.size() - 1).build();
  }
  public ContainerStatus buildMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: ephemeralContainerStatuses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: ephemeralContainerStatuses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEphemeralContainerStatuses(List<ContainerStatus> ephemeralContainerStatuses) {
    if (this.ephemeralContainerStatuses != null) { _visitables.get("ephemeralContainerStatuses").removeAll(this.ephemeralContainerStatuses);}
    if (ephemeralContainerStatuses != null) {this.ephemeralContainerStatuses = new ArrayList(); for (ContainerStatus item : ephemeralContainerStatuses){this.addToEphemeralContainerStatuses(item);}} else { this.ephemeralContainerStatuses = null;} return (A) this;
  }
  public A withEphemeralContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... ephemeralContainerStatuses) {
    if (this.ephemeralContainerStatuses != null) {this.ephemeralContainerStatuses.clear();}
    if (ephemeralContainerStatuses != null) {for (ContainerStatus item :ephemeralContainerStatuses){ this.addToEphemeralContainerStatuses(item);}} return (A) this;
  }
  public Boolean hasEphemeralContainerStatuses() {
    return ephemeralContainerStatuses != null && !ephemeralContainerStatuses.isEmpty();
  }
  public PodStatusFluent.EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatus() {
    return new PodStatusFluentImpl.EphemeralContainerStatusesNestedImpl();
  }
  public PodStatusFluent.EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatusLike(ContainerStatus item) {
    return new PodStatusFluentImpl.EphemeralContainerStatusesNestedImpl(-1, item);
  }
  public PodStatusFluent.EphemeralContainerStatusesNested<A> setNewEphemeralContainerStatusLike(Integer index,ContainerStatus item) {
    return new PodStatusFluentImpl.EphemeralContainerStatusesNestedImpl(index, item);
  }
  public PodStatusFluent.EphemeralContainerStatusesNested<A> editEphemeralContainerStatus(Integer index) {
    if (ephemeralContainerStatuses.size() <= index) throw new RuntimeException("Can't edit ephemeralContainerStatuses. Index exceeds size.");
    return setNewEphemeralContainerStatusLike(index, buildEphemeralContainerStatus(index));
  }
  public PodStatusFluent.EphemeralContainerStatusesNested<A> editFirstEphemeralContainerStatus() {
    if (ephemeralContainerStatuses.size() == 0) throw new RuntimeException("Can't edit first ephemeralContainerStatuses. The list is empty.");
    return setNewEphemeralContainerStatusLike(0, buildEphemeralContainerStatus(0));
  }
  public PodStatusFluent.EphemeralContainerStatusesNested<A> editLastEphemeralContainerStatus() {
    int index = ephemeralContainerStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ephemeralContainerStatuses. The list is empty.");
    return setNewEphemeralContainerStatusLike(index, buildEphemeralContainerStatus(index));
  }
  public PodStatusFluent.EphemeralContainerStatusesNested<A> editMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ephemeralContainerStatuses.size();i++) { 
    if (predicate.test(ephemeralContainerStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ephemeralContainerStatuses. No match found.");
    return setNewEphemeralContainerStatusLike(index, buildEphemeralContainerStatus(index));
  }
  public String getHostIP() {
    return this.hostIP;
  }
  public A withHostIP(String hostIP) {
    this.hostIP=hostIP; return (A) this;
  }
  public Boolean hasHostIP() {
    return this.hostIP != null;
  }
  public A addToInitContainerStatuses(Integer index,ContainerStatus item) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").add(index >= 0 ? index : _visitables.get("initContainerStatuses").size(), builder);this.initContainerStatuses.add(index >= 0 ? index : initContainerStatuses.size(), builder); return (A)this;
  }
  public A setToInitContainerStatuses(Integer index,ContainerStatus item) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("initContainerStatuses").size()) { _visitables.get("initContainerStatuses").add(builder); } else { _visitables.get("initContainerStatuses").set(index, builder);}
    if (index < 0 || index >= initContainerStatuses.size()) { initContainerStatuses.add(builder); } else { initContainerStatuses.set(index, builder);}
     return (A)this;
  }
  public A addToInitContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").add(builder);this.initContainerStatuses.add(builder);} return (A)this;
  }
  public A addAllToInitContainerStatuses(Collection<ContainerStatus> items) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").add(builder);this.initContainerStatuses.add(builder);} return (A)this;
  }
  public A removeFromInitContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items) {
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").remove(builder);if (this.initContainerStatuses != null) {this.initContainerStatuses.remove(builder);}} return (A)this;
  }
  public A removeAllFromInitContainerStatuses(Collection<ContainerStatus> items) {
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").remove(builder);if (this.initContainerStatuses != null) {this.initContainerStatuses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInitContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
    if (initContainerStatuses == null) return (A) this;
    final Iterator<ContainerStatusBuilder> each = initContainerStatuses.iterator();
    final List visitables = _visitables.get("initContainerStatuses");
    while (each.hasNext()) {
      ContainerStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildInitContainerStatuses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContainerStatus> getInitContainerStatuses() {
    return initContainerStatuses != null ? build(initContainerStatuses) : null;
  }
  public List<ContainerStatus> buildInitContainerStatuses() {
    return initContainerStatuses != null ? build(initContainerStatuses) : null;
  }
  public ContainerStatus buildInitContainerStatus(Integer index) {
    return this.initContainerStatuses.get(index).build();
  }
  public ContainerStatus buildFirstInitContainerStatus() {
    return this.initContainerStatuses.get(0).build();
  }
  public ContainerStatus buildLastInitContainerStatus() {
    return this.initContainerStatuses.get(initContainerStatuses.size() - 1).build();
  }
  public ContainerStatus buildMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: initContainerStatuses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: initContainerStatuses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInitContainerStatuses(List<ContainerStatus> initContainerStatuses) {
    if (this.initContainerStatuses != null) { _visitables.get("initContainerStatuses").removeAll(this.initContainerStatuses);}
    if (initContainerStatuses != null) {this.initContainerStatuses = new ArrayList(); for (ContainerStatus item : initContainerStatuses){this.addToInitContainerStatuses(item);}} else { this.initContainerStatuses = null;} return (A) this;
  }
  public A withInitContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... initContainerStatuses) {
    if (this.initContainerStatuses != null) {this.initContainerStatuses.clear();}
    if (initContainerStatuses != null) {for (ContainerStatus item :initContainerStatuses){ this.addToInitContainerStatuses(item);}} return (A) this;
  }
  public Boolean hasInitContainerStatuses() {
    return initContainerStatuses != null && !initContainerStatuses.isEmpty();
  }
  public PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatus() {
    return new PodStatusFluentImpl.InitContainerStatusesNestedImpl();
  }
  public PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatusLike(ContainerStatus item) {
    return new PodStatusFluentImpl.InitContainerStatusesNestedImpl(-1, item);
  }
  public PodStatusFluent.InitContainerStatusesNested<A> setNewInitContainerStatusLike(Integer index,ContainerStatus item) {
    return new PodStatusFluentImpl.InitContainerStatusesNestedImpl(index, item);
  }
  public PodStatusFluent.InitContainerStatusesNested<A> editInitContainerStatus(Integer index) {
    if (initContainerStatuses.size() <= index) throw new RuntimeException("Can't edit initContainerStatuses. Index exceeds size.");
    return setNewInitContainerStatusLike(index, buildInitContainerStatus(index));
  }
  public PodStatusFluent.InitContainerStatusesNested<A> editFirstInitContainerStatus() {
    if (initContainerStatuses.size() == 0) throw new RuntimeException("Can't edit first initContainerStatuses. The list is empty.");
    return setNewInitContainerStatusLike(0, buildInitContainerStatus(0));
  }
  public PodStatusFluent.InitContainerStatusesNested<A> editLastInitContainerStatus() {
    int index = initContainerStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainerStatuses. The list is empty.");
    return setNewInitContainerStatusLike(index, buildInitContainerStatus(index));
  }
  public PodStatusFluent.InitContainerStatusesNested<A> editMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainerStatuses.size();i++) { 
    if (predicate.test(initContainerStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainerStatuses. No match found.");
    return setNewInitContainerStatusLike(index, buildInitContainerStatus(index));
  }
  public String getMessage() {
    return this.message;
  }
  public A withMessage(String message) {
    this.message=message; return (A) this;
  }
  public Boolean hasMessage() {
    return this.message != null;
  }
  public String getNominatedNodeName() {
    return this.nominatedNodeName;
  }
  public A withNominatedNodeName(String nominatedNodeName) {
    this.nominatedNodeName=nominatedNodeName; return (A) this;
  }
  public Boolean hasNominatedNodeName() {
    return this.nominatedNodeName != null;
  }
  public String getPhase() {
    return this.phase;
  }
  public A withPhase(String phase) {
    this.phase=phase; return (A) this;
  }
  public Boolean hasPhase() {
    return this.phase != null;
  }
  public String getPodIP() {
    return this.podIP;
  }
  public A withPodIP(String podIP) {
    this.podIP=podIP; return (A) this;
  }
  public Boolean hasPodIP() {
    return this.podIP != null;
  }
  public A addToPodIPs(Integer index,PodIP item) {
    if (this.podIPs == null) {this.podIPs = new ArrayList<PodIPBuilder>();}
    PodIPBuilder builder = new PodIPBuilder(item);_visitables.get("podIPs").add(index >= 0 ? index : _visitables.get("podIPs").size(), builder);this.podIPs.add(index >= 0 ? index : podIPs.size(), builder); return (A)this;
  }
  public A setToPodIPs(Integer index,PodIP item) {
    if (this.podIPs == null) {this.podIPs = new ArrayList<PodIPBuilder>();}
    PodIPBuilder builder = new PodIPBuilder(item);
    if (index < 0 || index >= _visitables.get("podIPs").size()) { _visitables.get("podIPs").add(builder); } else { _visitables.get("podIPs").set(index, builder);}
    if (index < 0 || index >= podIPs.size()) { podIPs.add(builder); } else { podIPs.set(index, builder);}
     return (A)this;
  }
  public A addToPodIPs(io.fabric8.kubernetes.api.model.PodIP... items) {
    if (this.podIPs == null) {this.podIPs = new ArrayList<PodIPBuilder>();}
    for (PodIP item : items) {PodIPBuilder builder = new PodIPBuilder(item);_visitables.get("podIPs").add(builder);this.podIPs.add(builder);} return (A)this;
  }
  public A addAllToPodIPs(Collection<PodIP> items) {
    if (this.podIPs == null) {this.podIPs = new ArrayList<PodIPBuilder>();}
    for (PodIP item : items) {PodIPBuilder builder = new PodIPBuilder(item);_visitables.get("podIPs").add(builder);this.podIPs.add(builder);} return (A)this;
  }
  public A removeFromPodIPs(io.fabric8.kubernetes.api.model.PodIP... items) {
    for (PodIP item : items) {PodIPBuilder builder = new PodIPBuilder(item);_visitables.get("podIPs").remove(builder);if (this.podIPs != null) {this.podIPs.remove(builder);}} return (A)this;
  }
  public A removeAllFromPodIPs(Collection<PodIP> items) {
    for (PodIP item : items) {PodIPBuilder builder = new PodIPBuilder(item);_visitables.get("podIPs").remove(builder);if (this.podIPs != null) {this.podIPs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPodIPs(Predicate<PodIPBuilder> predicate) {
    if (podIPs == null) return (A) this;
    final Iterator<PodIPBuilder> each = podIPs.iterator();
    final List visitables = _visitables.get("podIPs");
    while (each.hasNext()) {
      PodIPBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPodIPs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PodIP> getPodIPs() {
    return podIPs != null ? build(podIPs) : null;
  }
  public List<PodIP> buildPodIPs() {
    return podIPs != null ? build(podIPs) : null;
  }
  public PodIP buildPodIP(Integer index) {
    return this.podIPs.get(index).build();
  }
  public PodIP buildFirstPodIP() {
    return this.podIPs.get(0).build();
  }
  public PodIP buildLastPodIP() {
    return this.podIPs.get(podIPs.size() - 1).build();
  }
  public PodIP buildMatchingPodIP(Predicate<PodIPBuilder> predicate) {
    for (PodIPBuilder item: podIPs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPodIP(Predicate<PodIPBuilder> predicate) {
    for (PodIPBuilder item: podIPs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPodIPs(List<PodIP> podIPs) {
    if (this.podIPs != null) { _visitables.get("podIPs").removeAll(this.podIPs);}
    if (podIPs != null) {this.podIPs = new ArrayList(); for (PodIP item : podIPs){this.addToPodIPs(item);}} else { this.podIPs = null;} return (A) this;
  }
  public A withPodIPs(io.fabric8.kubernetes.api.model.PodIP... podIPs) {
    if (this.podIPs != null) {this.podIPs.clear();}
    if (podIPs != null) {for (PodIP item :podIPs){ this.addToPodIPs(item);}} return (A) this;
  }
  public Boolean hasPodIPs() {
    return podIPs != null && !podIPs.isEmpty();
  }
  public A addNewPodIP(String ip) {
    return (A)addToPodIPs(new PodIP(ip));
  }
  public PodStatusFluent.PodIPsNested<A> addNewPodIP() {
    return new PodStatusFluentImpl.PodIPsNestedImpl();
  }
  public PodStatusFluent.PodIPsNested<A> addNewPodIPLike(PodIP item) {
    return new PodStatusFluentImpl.PodIPsNestedImpl(-1, item);
  }
  public PodStatusFluent.PodIPsNested<A> setNewPodIPLike(Integer index,PodIP item) {
    return new PodStatusFluentImpl.PodIPsNestedImpl(index, item);
  }
  public PodStatusFluent.PodIPsNested<A> editPodIP(Integer index) {
    if (podIPs.size() <= index) throw new RuntimeException("Can't edit podIPs. Index exceeds size.");
    return setNewPodIPLike(index, buildPodIP(index));
  }
  public PodStatusFluent.PodIPsNested<A> editFirstPodIP() {
    if (podIPs.size() == 0) throw new RuntimeException("Can't edit first podIPs. The list is empty.");
    return setNewPodIPLike(0, buildPodIP(0));
  }
  public PodStatusFluent.PodIPsNested<A> editLastPodIP() {
    int index = podIPs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last podIPs. The list is empty.");
    return setNewPodIPLike(index, buildPodIP(index));
  }
  public PodStatusFluent.PodIPsNested<A> editMatchingPodIP(Predicate<PodIPBuilder> predicate) {
    int index = -1;
    for (int i=0;i<podIPs.size();i++) { 
    if (predicate.test(podIPs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching podIPs. No match found.");
    return setNewPodIPLike(index, buildPodIP(index));
  }
  public String getQosClass() {
    return this.qosClass;
  }
  public A withQosClass(String qosClass) {
    this.qosClass=qosClass; return (A) this;
  }
  public Boolean hasQosClass() {
    return this.qosClass != null;
  }
  public String getReason() {
    return this.reason;
  }
  public A withReason(String reason) {
    this.reason=reason; return (A) this;
  }
  public Boolean hasReason() {
    return this.reason != null;
  }
  public String getStartTime() {
    return this.startTime;
  }
  public A withStartTime(String startTime) {
    this.startTime=startTime; return (A) this;
  }
  public Boolean hasStartTime() {
    return this.startTime != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodStatusFluentImpl that = (PodStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (containerStatuses != null ? !containerStatuses.equals(that.containerStatuses) :that.containerStatuses != null) return false;
    if (ephemeralContainerStatuses != null ? !ephemeralContainerStatuses.equals(that.ephemeralContainerStatuses) :that.ephemeralContainerStatuses != null) return false;
    if (hostIP != null ? !hostIP.equals(that.hostIP) :that.hostIP != null) return false;
    if (initContainerStatuses != null ? !initContainerStatuses.equals(that.initContainerStatuses) :that.initContainerStatuses != null) return false;
    if (message != null ? !message.equals(that.message) :that.message != null) return false;
    if (nominatedNodeName != null ? !nominatedNodeName.equals(that.nominatedNodeName) :that.nominatedNodeName != null) return false;
    if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
    if (podIP != null ? !podIP.equals(that.podIP) :that.podIP != null) return false;
    if (podIPs != null ? !podIPs.equals(that.podIPs) :that.podIPs != null) return false;
    if (qosClass != null ? !qosClass.equals(that.qosClass) :that.qosClass != null) return false;
    if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
    if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  containerStatuses,  ephemeralContainerStatuses,  hostIP,  initContainerStatuses,  message,  nominatedNodeName,  phase,  podIP,  podIPs,  qosClass,  reason,  startTime,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (containerStatuses != null && !containerStatuses.isEmpty()) { sb.append("containerStatuses:"); sb.append(containerStatuses + ","); }
    if (ephemeralContainerStatuses != null && !ephemeralContainerStatuses.isEmpty()) { sb.append("ephemeralContainerStatuses:"); sb.append(ephemeralContainerStatuses + ","); }
    if (hostIP != null) { sb.append("hostIP:"); sb.append(hostIP + ","); }
    if (initContainerStatuses != null && !initContainerStatuses.isEmpty()) { sb.append("initContainerStatuses:"); sb.append(initContainerStatuses + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (nominatedNodeName != null) { sb.append("nominatedNodeName:"); sb.append(nominatedNodeName + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (podIP != null) { sb.append("podIP:"); sb.append(podIP + ","); }
    if (podIPs != null && !podIPs.isEmpty()) { sb.append("podIPs:"); sb.append(podIPs + ","); }
    if (qosClass != null) { sb.append("qosClass:"); sb.append(qosClass + ","); }
    if (reason != null) { sb.append("reason:"); sb.append(reason + ","); }
    if (startTime != null) { sb.append("startTime:"); sb.append(startTime + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends PodConditionFluentImpl<PodStatusFluent.ConditionsNested<N>> implements PodStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,PodCondition item) {
      this.index = index;
      this.builder = new PodConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new PodConditionBuilder(this);
    }
    PodConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) PodStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ContainerStatusesNestedImpl<N> extends ContainerStatusFluentImpl<PodStatusFluent.ContainerStatusesNested<N>> implements PodStatusFluent.ContainerStatusesNested<N>,Nested<N>{
    ContainerStatusesNestedImpl(Integer index,ContainerStatus item) {
      this.index = index;
      this.builder = new ContainerStatusBuilder(this, item);
    }
    ContainerStatusesNestedImpl() {
      this.index = -1;
      this.builder = new ContainerStatusBuilder(this);
    }
    ContainerStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) PodStatusFluentImpl.this.setToContainerStatuses(index,builder.build());
    }
    public N endContainerStatus() {
      return and();
    }
    
  }
  class EphemeralContainerStatusesNestedImpl<N> extends ContainerStatusFluentImpl<PodStatusFluent.EphemeralContainerStatusesNested<N>> implements PodStatusFluent.EphemeralContainerStatusesNested<N>,Nested<N>{
    EphemeralContainerStatusesNestedImpl(Integer index,ContainerStatus item) {
      this.index = index;
      this.builder = new ContainerStatusBuilder(this, item);
    }
    EphemeralContainerStatusesNestedImpl() {
      this.index = -1;
      this.builder = new ContainerStatusBuilder(this);
    }
    ContainerStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) PodStatusFluentImpl.this.setToEphemeralContainerStatuses(index,builder.build());
    }
    public N endEphemeralContainerStatus() {
      return and();
    }
    
  }
  class InitContainerStatusesNestedImpl<N> extends ContainerStatusFluentImpl<PodStatusFluent.InitContainerStatusesNested<N>> implements PodStatusFluent.InitContainerStatusesNested<N>,Nested<N>{
    InitContainerStatusesNestedImpl(Integer index,ContainerStatus item) {
      this.index = index;
      this.builder = new ContainerStatusBuilder(this, item);
    }
    InitContainerStatusesNestedImpl() {
      this.index = -1;
      this.builder = new ContainerStatusBuilder(this);
    }
    ContainerStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) PodStatusFluentImpl.this.setToInitContainerStatuses(index,builder.build());
    }
    public N endInitContainerStatus() {
      return and();
    }
    
  }
  class PodIPsNestedImpl<N> extends PodIPFluentImpl<PodStatusFluent.PodIPsNested<N>> implements PodStatusFluent.PodIPsNested<N>,Nested<N>{
    PodIPsNestedImpl(Integer index,PodIP item) {
      this.index = index;
      this.builder = new PodIPBuilder(this, item);
    }
    PodIPsNestedImpl() {
      this.index = -1;
      this.builder = new PodIPBuilder(this);
    }
    PodIPBuilder builder;
    Integer index;
    public N and() {
      return (N) PodStatusFluentImpl.this.setToPodIPs(index,builder.build());
    }
    public N endPodIP() {
      return and();
    }
    
  }
  
}