package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ReplicationControllerStatusFluent<A extends ReplicationControllerStatusFluent<A>> extends Fluent<A>{
  public Integer getAvailableReplicas();
  public A withAvailableReplicas(Integer availableReplicas);
  public Boolean hasAvailableReplicas();
  public A addToConditions(Integer index,ReplicationControllerCondition item);
  public A setToConditions(Integer index,ReplicationControllerCondition item);
  public A addToConditions(io.fabric8.kubernetes.api.model.ReplicationControllerCondition... items);
  public A addAllToConditions(Collection<ReplicationControllerCondition> items);
  public A removeFromConditions(io.fabric8.kubernetes.api.model.ReplicationControllerCondition... items);
  public A removeAllFromConditions(Collection<ReplicationControllerCondition> items);
  public A removeMatchingFromConditions(Predicate<ReplicationControllerConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ReplicationControllerCondition> getConditions();
  public List<ReplicationControllerCondition> buildConditions();
  public ReplicationControllerCondition buildCondition(Integer index);
  public ReplicationControllerCondition buildFirstCondition();
  public ReplicationControllerCondition buildLastCondition();
  public ReplicationControllerCondition buildMatchingCondition(Predicate<ReplicationControllerConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<ReplicationControllerConditionBuilder> predicate);
  public A withConditions(List<ReplicationControllerCondition> conditions);
  public A withConditions(io.fabric8.kubernetes.api.model.ReplicationControllerCondition... conditions);
  public Boolean hasConditions();
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
  public ReplicationControllerStatusFluent.ConditionsNested<A> addNewCondition();
  public ReplicationControllerStatusFluent.ConditionsNested<A> addNewConditionLike(ReplicationControllerCondition item);
  public ReplicationControllerStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,ReplicationControllerCondition item);
  public ReplicationControllerStatusFluent.ConditionsNested<A> editCondition(Integer index);
  public ReplicationControllerStatusFluent.ConditionsNested<A> editFirstCondition();
  public ReplicationControllerStatusFluent.ConditionsNested<A> editLastCondition();
  public ReplicationControllerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ReplicationControllerConditionBuilder> predicate);
  public Integer getFullyLabeledReplicas();
  public A withFullyLabeledReplicas(Integer fullyLabeledReplicas);
  public Boolean hasFullyLabeledReplicas();
  public Long getObservedGeneration();
  public A withObservedGeneration(Long observedGeneration);
  public Boolean hasObservedGeneration();
  public Integer getReadyReplicas();
  public A withReadyReplicas(Integer readyReplicas);
  public Boolean hasReadyReplicas();
  public Integer getReplicas();
  public A withReplicas(Integer replicas);
  public Boolean hasReplicas();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ConditionsNested<N> extends Nested<N>,ReplicationControllerConditionFluent<ReplicationControllerStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  
}