package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ScopeSelectorFluentImpl<A extends ScopeSelectorFluent<A>> extends BaseFluent<A> implements ScopeSelectorFluent<A>{
  public ScopeSelectorFluentImpl() {
  }
  public ScopeSelectorFluentImpl(ScopeSelector instance) {
    this.withMatchExpressions(instance.getMatchExpressions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<ScopedResourceSelectorRequirementBuilder> matchExpressions = new ArrayList<ScopedResourceSelectorRequirementBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToMatchExpressions(Integer index,ScopedResourceSelectorRequirement item) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<ScopedResourceSelectorRequirementBuilder>();}
    ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(index >= 0 ? index : _visitables.get("matchExpressions").size(), builder);this.matchExpressions.add(index >= 0 ? index : matchExpressions.size(), builder); return (A)this;
  }
  public A setToMatchExpressions(Integer index,ScopedResourceSelectorRequirement item) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<ScopedResourceSelectorRequirementBuilder>();}
    ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);
    if (index < 0 || index >= _visitables.get("matchExpressions").size()) { _visitables.get("matchExpressions").add(builder); } else { _visitables.get("matchExpressions").set(index, builder);}
    if (index < 0 || index >= matchExpressions.size()) { matchExpressions.add(builder); } else { matchExpressions.set(index, builder);}
     return (A)this;
  }
  public A addToMatchExpressions(io.fabric8.kubernetes.api.model.ScopedResourceSelectorRequirement... items) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<ScopedResourceSelectorRequirementBuilder>();}
    for (ScopedResourceSelectorRequirement item : items) {ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(builder);this.matchExpressions.add(builder);} return (A)this;
  }
  public A addAllToMatchExpressions(Collection<ScopedResourceSelectorRequirement> items) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<ScopedResourceSelectorRequirementBuilder>();}
    for (ScopedResourceSelectorRequirement item : items) {ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(builder);this.matchExpressions.add(builder);} return (A)this;
  }
  public A removeFromMatchExpressions(io.fabric8.kubernetes.api.model.ScopedResourceSelectorRequirement... items) {
    for (ScopedResourceSelectorRequirement item : items) {ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);_visitables.get("matchExpressions").remove(builder);if (this.matchExpressions != null) {this.matchExpressions.remove(builder);}} return (A)this;
  }
  public A removeAllFromMatchExpressions(Collection<ScopedResourceSelectorRequirement> items) {
    for (ScopedResourceSelectorRequirement item : items) {ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);_visitables.get("matchExpressions").remove(builder);if (this.matchExpressions != null) {this.matchExpressions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMatchExpressions(Predicate<ScopedResourceSelectorRequirementBuilder> predicate) {
    if (matchExpressions == null) return (A) this;
    final Iterator<ScopedResourceSelectorRequirementBuilder> each = matchExpressions.iterator();
    final List visitables = _visitables.get("matchExpressions");
    while (each.hasNext()) {
      ScopedResourceSelectorRequirementBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMatchExpressions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ScopedResourceSelectorRequirement> getMatchExpressions() {
    return matchExpressions != null ? build(matchExpressions) : null;
  }
  public List<ScopedResourceSelectorRequirement> buildMatchExpressions() {
    return matchExpressions != null ? build(matchExpressions) : null;
  }
  public ScopedResourceSelectorRequirement buildMatchExpression(Integer index) {
    return this.matchExpressions.get(index).build();
  }
  public ScopedResourceSelectorRequirement buildFirstMatchExpression() {
    return this.matchExpressions.get(0).build();
  }
  public ScopedResourceSelectorRequirement buildLastMatchExpression() {
    return this.matchExpressions.get(matchExpressions.size() - 1).build();
  }
  public ScopedResourceSelectorRequirement buildMatchingMatchExpression(Predicate<ScopedResourceSelectorRequirementBuilder> predicate) {
    for (ScopedResourceSelectorRequirementBuilder item: matchExpressions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMatchExpression(Predicate<ScopedResourceSelectorRequirementBuilder> predicate) {
    for (ScopedResourceSelectorRequirementBuilder item: matchExpressions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMatchExpressions(List<ScopedResourceSelectorRequirement> matchExpressions) {
    if (this.matchExpressions != null) { _visitables.get("matchExpressions").removeAll(this.matchExpressions);}
    if (matchExpressions != null) {this.matchExpressions = new ArrayList(); for (ScopedResourceSelectorRequirement item : matchExpressions){this.addToMatchExpressions(item);}} else { this.matchExpressions = null;} return (A) this;
  }
  public A withMatchExpressions(io.fabric8.kubernetes.api.model.ScopedResourceSelectorRequirement... matchExpressions) {
    if (this.matchExpressions != null) {this.matchExpressions.clear();}
    if (matchExpressions != null) {for (ScopedResourceSelectorRequirement item :matchExpressions){ this.addToMatchExpressions(item);}} return (A) this;
  }
  public Boolean hasMatchExpressions() {
    return matchExpressions != null && !matchExpressions.isEmpty();
  }
  public ScopeSelectorFluent.MatchExpressionsNested<A> addNewMatchExpression() {
    return new ScopeSelectorFluentImpl.MatchExpressionsNestedImpl();
  }
  public ScopeSelectorFluent.MatchExpressionsNested<A> addNewMatchExpressionLike(ScopedResourceSelectorRequirement item) {
    return new ScopeSelectorFluentImpl.MatchExpressionsNestedImpl(-1, item);
  }
  public ScopeSelectorFluent.MatchExpressionsNested<A> setNewMatchExpressionLike(Integer index,ScopedResourceSelectorRequirement item) {
    return new ScopeSelectorFluentImpl.MatchExpressionsNestedImpl(index, item);
  }
  public ScopeSelectorFluent.MatchExpressionsNested<A> editMatchExpression(Integer index) {
    if (matchExpressions.size() <= index) throw new RuntimeException("Can't edit matchExpressions. Index exceeds size.");
    return setNewMatchExpressionLike(index, buildMatchExpression(index));
  }
  public ScopeSelectorFluent.MatchExpressionsNested<A> editFirstMatchExpression() {
    if (matchExpressions.size() == 0) throw new RuntimeException("Can't edit first matchExpressions. The list is empty.");
    return setNewMatchExpressionLike(0, buildMatchExpression(0));
  }
  public ScopeSelectorFluent.MatchExpressionsNested<A> editLastMatchExpression() {
    int index = matchExpressions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matchExpressions. The list is empty.");
    return setNewMatchExpressionLike(index, buildMatchExpression(index));
  }
  public ScopeSelectorFluent.MatchExpressionsNested<A> editMatchingMatchExpression(Predicate<ScopedResourceSelectorRequirementBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matchExpressions.size();i++) { 
    if (predicate.test(matchExpressions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matchExpressions. No match found.");
    return setNewMatchExpressionLike(index, buildMatchExpression(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ScopeSelectorFluentImpl that = (ScopeSelectorFluentImpl) o;
    if (matchExpressions != null ? !matchExpressions.equals(that.matchExpressions) :that.matchExpressions != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(matchExpressions,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (matchExpressions != null && !matchExpressions.isEmpty()) { sb.append("matchExpressions:"); sb.append(matchExpressions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MatchExpressionsNestedImpl<N> extends ScopedResourceSelectorRequirementFluentImpl<ScopeSelectorFluent.MatchExpressionsNested<N>> implements ScopeSelectorFluent.MatchExpressionsNested<N>,Nested<N>{
    MatchExpressionsNestedImpl(Integer index,ScopedResourceSelectorRequirement item) {
      this.index = index;
      this.builder = new ScopedResourceSelectorRequirementBuilder(this, item);
    }
    MatchExpressionsNestedImpl() {
      this.index = -1;
      this.builder = new ScopedResourceSelectorRequirementBuilder(this);
    }
    ScopedResourceSelectorRequirementBuilder builder;
    Integer index;
    public N and() {
      return (N) ScopeSelectorFluentImpl.this.setToMatchExpressions(index,builder.build());
    }
    public N endMatchExpression() {
      return and();
    }
    
  }
  
}