package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceAccountTokenProjectionBuilder extends ServiceAccountTokenProjectionFluentImpl<ServiceAccountTokenProjectionBuilder> implements VisitableBuilder<ServiceAccountTokenProjection,ServiceAccountTokenProjectionBuilder>{
  public ServiceAccountTokenProjectionBuilder() {
    this(false);
  }
  public ServiceAccountTokenProjectionBuilder(Boolean validationEnabled) {
    this(new ServiceAccountTokenProjection(), validationEnabled);
  }
  public ServiceAccountTokenProjectionBuilder(ServiceAccountTokenProjectionFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceAccountTokenProjectionBuilder(ServiceAccountTokenProjectionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceAccountTokenProjection(), validationEnabled);
  }
  public ServiceAccountTokenProjectionBuilder(ServiceAccountTokenProjectionFluent<?> fluent,ServiceAccountTokenProjection instance) {
    this(fluent, instance, false);
  }
  public ServiceAccountTokenProjectionBuilder(ServiceAccountTokenProjectionFluent<?> fluent,ServiceAccountTokenProjection instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAudience(instance.getAudience()); 
    fluent.withExpirationSeconds(instance.getExpirationSeconds()); 
    fluent.withPath(instance.getPath()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceAccountTokenProjectionBuilder(ServiceAccountTokenProjection instance) {
    this(instance,false);
  }
  public ServiceAccountTokenProjectionBuilder(ServiceAccountTokenProjection instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAudience(instance.getAudience()); 
    this.withExpirationSeconds(instance.getExpirationSeconds()); 
    this.withPath(instance.getPath()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ServiceAccountTokenProjectionFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceAccountTokenProjection build() {
    ServiceAccountTokenProjection buildable = new ServiceAccountTokenProjection(fluent.getAudience(),fluent.getExpirationSeconds(),fluent.getPath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}