package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceSpecBuilder extends ServiceSpecFluentImpl<ServiceSpecBuilder> implements VisitableBuilder<ServiceSpec,ServiceSpecBuilder>{
  public ServiceSpecBuilder() {
    this(false);
  }
  public ServiceSpecBuilder(Boolean validationEnabled) {
    this(new ServiceSpec(), validationEnabled);
  }
  public ServiceSpecBuilder(ServiceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceSpecBuilder(ServiceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceSpec(), validationEnabled);
  }
  public ServiceSpecBuilder(ServiceSpecFluent<?> fluent,ServiceSpec instance) {
    this(fluent, instance, false);
  }
  public ServiceSpecBuilder(ServiceSpecFluent<?> fluent,ServiceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllocateLoadBalancerNodePorts(instance.getAllocateLoadBalancerNodePorts()); 
    fluent.withClusterIP(instance.getClusterIP()); 
    fluent.withClusterIPs(instance.getClusterIPs()); 
    fluent.withExternalIPs(instance.getExternalIPs()); 
    fluent.withExternalName(instance.getExternalName()); 
    fluent.withExternalTrafficPolicy(instance.getExternalTrafficPolicy()); 
    fluent.withHealthCheckNodePort(instance.getHealthCheckNodePort()); 
    fluent.withInternalTrafficPolicy(instance.getInternalTrafficPolicy()); 
    fluent.withIpFamilies(instance.getIpFamilies()); 
    fluent.withIpFamilyPolicy(instance.getIpFamilyPolicy()); 
    fluent.withLoadBalancerClass(instance.getLoadBalancerClass()); 
    fluent.withLoadBalancerIP(instance.getLoadBalancerIP()); 
    fluent.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges()); 
    fluent.withPorts(instance.getPorts()); 
    fluent.withPublishNotReadyAddresses(instance.getPublishNotReadyAddresses()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withSessionAffinity(instance.getSessionAffinity()); 
    fluent.withSessionAffinityConfig(instance.getSessionAffinityConfig()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceSpecBuilder(ServiceSpec instance) {
    this(instance,false);
  }
  public ServiceSpecBuilder(ServiceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllocateLoadBalancerNodePorts(instance.getAllocateLoadBalancerNodePorts()); 
    this.withClusterIP(instance.getClusterIP()); 
    this.withClusterIPs(instance.getClusterIPs()); 
    this.withExternalIPs(instance.getExternalIPs()); 
    this.withExternalName(instance.getExternalName()); 
    this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy()); 
    this.withHealthCheckNodePort(instance.getHealthCheckNodePort()); 
    this.withInternalTrafficPolicy(instance.getInternalTrafficPolicy()); 
    this.withIpFamilies(instance.getIpFamilies()); 
    this.withIpFamilyPolicy(instance.getIpFamilyPolicy()); 
    this.withLoadBalancerClass(instance.getLoadBalancerClass()); 
    this.withLoadBalancerIP(instance.getLoadBalancerIP()); 
    this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges()); 
    this.withPorts(instance.getPorts()); 
    this.withPublishNotReadyAddresses(instance.getPublishNotReadyAddresses()); 
    this.withSelector(instance.getSelector()); 
    this.withSessionAffinity(instance.getSessionAffinity()); 
    this.withSessionAffinityConfig(instance.getSessionAffinityConfig()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ServiceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceSpec build() {
    ServiceSpec buildable = new ServiceSpec(fluent.getAllocateLoadBalancerNodePorts(),fluent.getClusterIP(),fluent.getClusterIPs(),fluent.getExternalIPs(),fluent.getExternalName(),fluent.getExternalTrafficPolicy(),fluent.getHealthCheckNodePort(),fluent.getInternalTrafficPolicy(),fluent.getIpFamilies(),fluent.getIpFamilyPolicy(),fluent.getLoadBalancerClass(),fluent.getLoadBalancerIP(),fluent.getLoadBalancerSourceRanges(),fluent.getPorts(),fluent.getPublishNotReadyAddresses(),fluent.getSelector(),fluent.getSessionAffinity(),fluent.getSessionAffinityConfig(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}