package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TopologySelectorLabelRequirementFluentImpl<A extends TopologySelectorLabelRequirementFluent<A>> extends BaseFluent<A> implements TopologySelectorLabelRequirementFluent<A>{
  public TopologySelectorLabelRequirementFluentImpl() {
  }
  public TopologySelectorLabelRequirementFluentImpl(TopologySelectorLabelRequirement instance) {
    this.withKey(instance.getKey()); 
    this.withValues(instance.getValues()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String key;
  private List<String> values = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public String getKey() {
    return this.key;
  }
  public A withKey(String key) {
    this.key=key; return (A) this;
  }
  public Boolean hasKey() {
    return this.key != null;
  }
  public A addToValues(Integer index,String item) {
    if (this.values == null) {this.values = new ArrayList<String>();}
    this.values.add(index, item);
    return (A)this;
  }
  public A setToValues(Integer index,String item) {
    if (this.values == null) {this.values = new ArrayList<String>();}
    this.values.set(index, item); return (A)this;
  }
  public A addToValues(java.lang.String... items) {
    if (this.values == null) {this.values = new ArrayList<String>();}
    for (String item : items) {this.values.add(item);} return (A)this;
  }
  public A addAllToValues(Collection<String> items) {
    if (this.values == null) {this.values = new ArrayList<String>();}
    for (String item : items) {this.values.add(item);} return (A)this;
  }
  public A removeFromValues(java.lang.String... items) {
    for (String item : items) {if (this.values!= null){ this.values.remove(item);}} return (A)this;
  }
  public A removeAllFromValues(Collection<String> items) {
    for (String item : items) {if (this.values!= null){ this.values.remove(item);}} return (A)this;
  }
  public List<String> getValues() {
    return this.values;
  }
  public String getValue(Integer index) {
    return this.values.get(index);
  }
  public String getFirstValue() {
    return this.values.get(0);
  }
  public String getLastValue() {
    return this.values.get(values.size() - 1);
  }
  public String getMatchingValue(Predicate<String> predicate) {
    for (String item: values) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingValue(Predicate<String> predicate) {
    for (String item: values) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withValues(List<String> values) {
    if (values != null) {this.values = new ArrayList(); for (String item : values){this.addToValues(item);}} else { this.values = null;} return (A) this;
  }
  public A withValues(java.lang.String... values) {
    if (this.values != null) {this.values.clear();}
    if (values != null) {for (String item :values){ this.addToValues(item);}} return (A) this;
  }
  public Boolean hasValues() {
    return values != null && !values.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TopologySelectorLabelRequirementFluentImpl that = (TopologySelectorLabelRequirementFluentImpl) o;
    if (key != null ? !key.equals(that.key) :that.key != null) return false;
    if (values != null ? !values.equals(that.values) :that.values != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(key,  values,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (key != null) { sb.append("key:"); sb.append(key + ","); }
    if (values != null && !values.isEmpty()) { sb.append("values:"); sb.append(values + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}