package io.fabric8.kubernetes.api.model.version;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InfoBuilder extends InfoFluentImpl<InfoBuilder> implements VisitableBuilder<Info,InfoBuilder>{
  public InfoBuilder() {
    this(false);
  }
  public InfoBuilder(Boolean validationEnabled) {
    this(new Info(), validationEnabled);
  }
  public InfoBuilder(InfoFluent<?> fluent) {
    this(fluent, false);
  }
  public InfoBuilder(InfoFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Info(), validationEnabled);
  }
  public InfoBuilder(InfoFluent<?> fluent,Info instance) {
    this(fluent, instance, false);
  }
  public InfoBuilder(InfoFluent<?> fluent,Info instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBuildDate(instance.getBuildDate()); 
    fluent.withCompiler(instance.getCompiler()); 
    fluent.withGitCommit(instance.getGitCommit()); 
    fluent.withGitTreeState(instance.getGitTreeState()); 
    fluent.withGitVersion(instance.getGitVersion()); 
    fluent.withGoVersion(instance.getGoVersion()); 
    fluent.withMajor(instance.getMajor()); 
    fluent.withMinor(instance.getMinor()); 
    fluent.withPlatform(instance.getPlatform()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public InfoBuilder(Info instance) {
    this(instance,false);
  }
  public InfoBuilder(Info instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBuildDate(instance.getBuildDate()); 
    this.withCompiler(instance.getCompiler()); 
    this.withGitCommit(instance.getGitCommit()); 
    this.withGitTreeState(instance.getGitTreeState()); 
    this.withGitVersion(instance.getGitVersion()); 
    this.withGoVersion(instance.getGoVersion()); 
    this.withMajor(instance.getMajor()); 
    this.withMinor(instance.getMinor()); 
    this.withPlatform(instance.getPlatform()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  InfoFluent<?> fluent;
  Boolean validationEnabled;
  public Info build() {
    Info buildable = new Info(fluent.getBuildDate(),fluent.getCompiler(),fluent.getGitCommit(),fluent.getGitTreeState(),fluent.getGitVersion(),fluent.getGoVersion(),fluent.getMajor(),fluent.getMinor(),fluent.getPlatform());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}