package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EnvFromSourceFluent<A extends EnvFromSourceFluent<A>> extends BaseFluent<A>{
  public EnvFromSourceFluent() {
  }
  
  public EnvFromSourceFluent(EnvFromSource instance) {
    this.copyInstance(instance);
  }
  private ConfigMapEnvSourceBuilder configMapRef;
  private String prefix;
  private SecretEnvSourceBuilder secretRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(EnvFromSource instance) {
    instance = (instance != null ? instance : new EnvFromSource());
    if (instance != null) {
          this.withConfigMapRef(instance.getConfigMapRef());
          this.withPrefix(instance.getPrefix());
          this.withSecretRef(instance.getSecretRef());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ConfigMapEnvSource buildConfigMapRef() {
    return this.configMapRef != null ? this.configMapRef.build() : null;
  }
  
  public A withConfigMapRef(ConfigMapEnvSource configMapRef) {
    this._visitables.remove("configMapRef");
    if (configMapRef != null) {
        this.configMapRef = new ConfigMapEnvSourceBuilder(configMapRef);
        this._visitables.get("configMapRef").add(this.configMapRef);
    } else {
        this.configMapRef = null;
        this._visitables.get("configMapRef").remove(this.configMapRef);
    }
    return (A) this;
  }
  
  public boolean hasConfigMapRef() {
    return this.configMapRef != null;
  }
  
  public A withNewConfigMapRef(String name,Boolean optional) {
    return (A)withConfigMapRef(new ConfigMapEnvSource(name, optional));
  }
  
  public ConfigMapRefNested<A> withNewConfigMapRef() {
    return new ConfigMapRefNested(null);
  }
  
  public ConfigMapRefNested<A> withNewConfigMapRefLike(ConfigMapEnvSource item) {
    return new ConfigMapRefNested(item);
  }
  
  public ConfigMapRefNested<A> editConfigMapRef() {
    return withNewConfigMapRefLike(java.util.Optional.ofNullable(buildConfigMapRef()).orElse(null));
  }
  
  public ConfigMapRefNested<A> editOrNewConfigMapRef() {
    return withNewConfigMapRefLike(java.util.Optional.ofNullable(buildConfigMapRef()).orElse(new ConfigMapEnvSourceBuilder().build()));
  }
  
  public ConfigMapRefNested<A> editOrNewConfigMapRefLike(ConfigMapEnvSource item) {
    return withNewConfigMapRefLike(java.util.Optional.ofNullable(buildConfigMapRef()).orElse(item));
  }
  
  public String getPrefix() {
    return this.prefix;
  }
  
  public A withPrefix(String prefix) {
    this.prefix = prefix;
    return (A) this;
  }
  
  public boolean hasPrefix() {
    return this.prefix != null;
  }
  
  public SecretEnvSource buildSecretRef() {
    return this.secretRef != null ? this.secretRef.build() : null;
  }
  
  public A withSecretRef(SecretEnvSource secretRef) {
    this._visitables.remove("secretRef");
    if (secretRef != null) {
        this.secretRef = new SecretEnvSourceBuilder(secretRef);
        this._visitables.get("secretRef").add(this.secretRef);
    } else {
        this.secretRef = null;
        this._visitables.get("secretRef").remove(this.secretRef);
    }
    return (A) this;
  }
  
  public boolean hasSecretRef() {
    return this.secretRef != null;
  }
  
  public A withNewSecretRef(String name,Boolean optional) {
    return (A)withSecretRef(new SecretEnvSource(name, optional));
  }
  
  public SecretRefNested<A> withNewSecretRef() {
    return new SecretRefNested(null);
  }
  
  public SecretRefNested<A> withNewSecretRefLike(SecretEnvSource item) {
    return new SecretRefNested(item);
  }
  
  public SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(null));
  }
  
  public SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(new SecretEnvSourceBuilder().build()));
  }
  
  public SecretRefNested<A> editOrNewSecretRefLike(SecretEnvSource item) {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EnvFromSourceFluent that = (EnvFromSourceFluent) o;
    if (!java.util.Objects.equals(configMapRef, that.configMapRef)) return false;
    if (!java.util.Objects.equals(prefix, that.prefix)) return false;
    if (!java.util.Objects.equals(secretRef, that.secretRef)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(configMapRef,  prefix,  secretRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configMapRef != null) { sb.append("configMapRef:"); sb.append(configMapRef + ","); }
    if (prefix != null) { sb.append("prefix:"); sb.append(prefix + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConfigMapRefNested<N> extends ConfigMapEnvSourceFluent<ConfigMapRefNested<N>> implements Nested<N>{
    ConfigMapRefNested(ConfigMapEnvSource item) {
      this.builder = new ConfigMapEnvSourceBuilder(this, item);
    }
    ConfigMapEnvSourceBuilder builder;
    
    public N and() {
      return (N) EnvFromSourceFluent.this.withConfigMapRef(builder.build());
    }
    
    public N endConfigMapRef() {
      return and();
    }
    
  
  }
  public class SecretRefNested<N> extends SecretEnvSourceFluent<SecretRefNested<N>> implements Nested<N>{
    SecretRefNested(SecretEnvSource item) {
      this.builder = new SecretEnvSourceBuilder(this, item);
    }
    SecretEnvSourceBuilder builder;
    
    public N and() {
      return (N) EnvFromSourceFluent.this.withSecretRef(builder.build());
    }
    
    public N endSecretRef() {
      return and();
    }
    
  
  }

}