package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NodeDaemonEndpointsBuilder extends NodeDaemonEndpointsFluent<NodeDaemonEndpointsBuilder> implements VisitableBuilder<NodeDaemonEndpoints,NodeDaemonEndpointsBuilder>{
  public NodeDaemonEndpointsBuilder() {
    this(new NodeDaemonEndpoints());
  }
  
  public NodeDaemonEndpointsBuilder(NodeDaemonEndpointsFluent<?> fluent) {
    this(fluent, new NodeDaemonEndpoints());
  }
  
  public NodeDaemonEndpointsBuilder(NodeDaemonEndpointsFluent<?> fluent,NodeDaemonEndpoints instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NodeDaemonEndpointsBuilder(NodeDaemonEndpoints instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NodeDaemonEndpointsFluent<?> fluent;
  
  public NodeDaemonEndpoints build() {
    NodeDaemonEndpoints buildable = new NodeDaemonEndpoints(fluent.buildKubeletEndpoint());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}