package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzureFileVolumeSourceBuilder extends AzureFileVolumeSourceFluent<AzureFileVolumeSourceBuilder> implements VisitableBuilder<AzureFileVolumeSource,AzureFileVolumeSourceBuilder>{
  public AzureFileVolumeSourceBuilder() {
    this(new AzureFileVolumeSource());
  }
  
  public AzureFileVolumeSourceBuilder(AzureFileVolumeSourceFluent<?> fluent) {
    this(fluent, new AzureFileVolumeSource());
  }
  
  public AzureFileVolumeSourceBuilder(AzureFileVolumeSourceFluent<?> fluent,AzureFileVolumeSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzureFileVolumeSourceBuilder(AzureFileVolumeSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzureFileVolumeSourceFluent<?> fluent;
  
  public AzureFileVolumeSource build() {
    AzureFileVolumeSource buildable = new AzureFileVolumeSource(fluent.getReadOnly(),fluent.getSecretName(),fluent.getShareName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}