package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PersistentVolumeClaimBuilder extends PersistentVolumeClaimFluent<PersistentVolumeClaimBuilder> implements VisitableBuilder<PersistentVolumeClaim,PersistentVolumeClaimBuilder>{
  public PersistentVolumeClaimBuilder() {
    this(new PersistentVolumeClaim());
  }
  
  public PersistentVolumeClaimBuilder(PersistentVolumeClaimFluent<?> fluent) {
    this(fluent, new PersistentVolumeClaim());
  }
  
  public PersistentVolumeClaimBuilder(PersistentVolumeClaimFluent<?> fluent,PersistentVolumeClaim instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PersistentVolumeClaimBuilder(PersistentVolumeClaim instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PersistentVolumeClaimFluent<?> fluent;
  
  public PersistentVolumeClaim build() {
    PersistentVolumeClaim buildable = new PersistentVolumeClaim(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}