package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServiceConditionBuilder extends APIServiceConditionFluentImpl<APIServiceConditionBuilder> implements VisitableBuilder<APIServiceCondition,APIServiceConditionBuilder>{
  public APIServiceConditionBuilder() {
    this(false);
  }
  public APIServiceConditionBuilder(Boolean validationEnabled) {
    this(new APIServiceCondition(), validationEnabled);
  }
  public APIServiceConditionBuilder(APIServiceConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServiceConditionBuilder(APIServiceConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIServiceCondition(), validationEnabled);
  }
  public APIServiceConditionBuilder(APIServiceConditionFluent<?> fluent,APIServiceCondition instance) {
    this(fluent, instance, false);
  }
  public APIServiceConditionBuilder(APIServiceConditionFluent<?> fluent,APIServiceCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIServiceConditionBuilder(APIServiceCondition instance) {
    this(instance,false);
  }
  public APIServiceConditionBuilder(APIServiceCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  APIServiceConditionFluent<?> fluent;
  Boolean validationEnabled;
  public APIServiceCondition build() {
    APIServiceCondition buildable = new APIServiceCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}