package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigBuilder extends ConfigFluentImpl<ConfigBuilder> implements VisitableBuilder<Config,ConfigBuilder>{
  public ConfigBuilder() {
    this(false);
  }
  public ConfigBuilder(Boolean validationEnabled) {
    this(new Config(), validationEnabled);
  }
  public ConfigBuilder(ConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigBuilder(ConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Config(), validationEnabled);
  }
  public ConfigBuilder(ConfigFluent<?> fluent,Config instance) {
    this(fluent, instance, false);
  }
  public ConfigBuilder(ConfigFluent<?> fluent,Config instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withClusters(instance.getClusters()); 
    fluent.withContexts(instance.getContexts()); 
    fluent.withCurrentContext(instance.getCurrentContext()); 
    fluent.withExtensions(instance.getExtensions()); 
    fluent.withKind(instance.getKind()); 
    fluent.withPreferences(instance.getPreferences()); 
    fluent.withUsers(instance.getUsers()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConfigBuilder(Config instance) {
    this(instance,false);
  }
  public ConfigBuilder(Config instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withClusters(instance.getClusters()); 
    this.withContexts(instance.getContexts()); 
    this.withCurrentContext(instance.getCurrentContext()); 
    this.withExtensions(instance.getExtensions()); 
    this.withKind(instance.getKind()); 
    this.withPreferences(instance.getPreferences()); 
    this.withUsers(instance.getUsers()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConfigFluent<?> fluent;
  Boolean validationEnabled;
  public Config build() {
    Config buildable = new Config(fluent.getApiVersion(),fluent.getClusters(),fluent.getContexts(),fluent.getCurrentContext(),fluent.getExtensions(),fluent.getKind(),fluent.getPreferences(),fluent.getUsers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}