package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface EndpointsListFluent<A extends EndpointsListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,Endpoints item);
  public A setToItems(Integer index,Endpoints item);
  public A addToItems(io.fabric8.kubernetes.api.model.Endpoints... items);
  public A addAllToItems(Collection<Endpoints> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.Endpoints... items);
  public A removeAllFromItems(Collection<Endpoints> items);
  public A removeMatchingFromItems(Predicate<EndpointsBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Endpoints> getItems();
  public List<Endpoints> buildItems();
  public Endpoints buildItem(Integer index);
  public Endpoints buildFirstItem();
  public Endpoints buildLastItem();
  public Endpoints buildMatchingItem(Predicate<EndpointsBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<EndpointsBuilder> predicate);
  public A withItems(List<Endpoints> items);
  public A withItems(io.fabric8.kubernetes.api.model.Endpoints... items);
  public Boolean hasItems();
  public EndpointsListFluent.ItemsNested<A> addNewItem();
  public EndpointsListFluent.ItemsNested<A> addNewItemLike(Endpoints item);
  public EndpointsListFluent.ItemsNested<A> setNewItemLike(Integer index,Endpoints item);
  public EndpointsListFluent.ItemsNested<A> editItem(Integer index);
  public EndpointsListFluent.ItemsNested<A> editFirstItem();
  public EndpointsListFluent.ItemsNested<A> editLastItem();
  public EndpointsListFluent.ItemsNested<A> editMatchingItem(Predicate<EndpointsBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata();
  public ListMeta buildMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public EndpointsListFluent.MetadataNested<A> withNewMetadata();
  public EndpointsListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
  public EndpointsListFluent.MetadataNested<A> editMetadata();
  public EndpointsListFluent.MetadataNested<A> editOrNewMetadata();
  public EndpointsListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,EndpointsFluent<EndpointsListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<EndpointsListFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}