package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamespaceStatusBuilder extends NamespaceStatusFluentImpl<NamespaceStatusBuilder> implements VisitableBuilder<NamespaceStatus,NamespaceStatusBuilder>{
  public NamespaceStatusBuilder() {
    this(false);
  }
  public NamespaceStatusBuilder(Boolean validationEnabled) {
    this(new NamespaceStatus(), validationEnabled);
  }
  public NamespaceStatusBuilder(NamespaceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NamespaceStatusBuilder(NamespaceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NamespaceStatus(), validationEnabled);
  }
  public NamespaceStatusBuilder(NamespaceStatusFluent<?> fluent,NamespaceStatus instance) {
    this(fluent, instance, false);
  }
  public NamespaceStatusBuilder(NamespaceStatusFluent<?> fluent,NamespaceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withPhase(instance.getPhase()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NamespaceStatusBuilder(NamespaceStatus instance) {
    this(instance,false);
  }
  public NamespaceStatusBuilder(NamespaceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withPhase(instance.getPhase()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  NamespaceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public NamespaceStatus build() {
    NamespaceStatus buildable = new NamespaceStatus(fluent.getConditions(),fluent.getPhase());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}