package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ResourceFieldSelectorFluentImpl<A extends ResourceFieldSelectorFluent<A>> extends BaseFluent<A> implements ResourceFieldSelectorFluent<A>{
  public ResourceFieldSelectorFluentImpl() {
  }
  public ResourceFieldSelectorFluentImpl(ResourceFieldSelector instance) {
    this.withContainerName(instance.getContainerName()); 
    this.withDivisor(instance.getDivisor()); 
    this.withResource(instance.getResource()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String containerName;
  private QuantityBuilder divisor;
  private String resource;
  private Map<String,Object> additionalProperties;
  public String getContainerName() {
    return this.containerName;
  }
  public A withContainerName(String containerName) {
    this.containerName=containerName; return (A) this;
  }
  public Boolean hasContainerName() {
    return this.containerName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDivisor instead.
   * @return The buildable object.
   */
  @Deprecated
  public Quantity getDivisor() {
    return this.divisor!=null ?this.divisor.build():null;
  }
  public Quantity buildDivisor() {
    return this.divisor!=null ?this.divisor.build():null;
  }
  public A withDivisor(Quantity divisor) {
    _visitables.get("divisor").remove(this.divisor);
    if (divisor!=null){ this.divisor= new QuantityBuilder(divisor); _visitables.get("divisor").add(this.divisor);} else { this.divisor = null; _visitables.get("divisor").remove(this.divisor); } return (A) this;
  }
  public Boolean hasDivisor() {
    return this.divisor != null;
  }
  public A withNewDivisor(String amount,String format) {
    return (A)withDivisor(new Quantity(amount, format));
  }
  public A withNewDivisor(String amount) {
    return (A)withDivisor(new Quantity(amount));
  }
  public ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisor() {
    return new ResourceFieldSelectorFluentImpl.DivisorNestedImpl();
  }
  public ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisorLike(Quantity item) {
    return new ResourceFieldSelectorFluentImpl.DivisorNestedImpl(item);
  }
  public ResourceFieldSelectorFluent.DivisorNested<A> editDivisor() {
    return withNewDivisorLike(getDivisor());
  }
  public ResourceFieldSelectorFluent.DivisorNested<A> editOrNewDivisor() {
    return withNewDivisorLike(getDivisor() != null ? getDivisor(): new QuantityBuilder().build());
  }
  public ResourceFieldSelectorFluent.DivisorNested<A> editOrNewDivisorLike(Quantity item) {
    return withNewDivisorLike(getDivisor() != null ? getDivisor(): item);
  }
  public String getResource() {
    return this.resource;
  }
  public A withResource(String resource) {
    this.resource=resource; return (A) this;
  }
  public Boolean hasResource() {
    return this.resource != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResourceFieldSelectorFluentImpl that = (ResourceFieldSelectorFluentImpl) o;
    if (containerName != null ? !containerName.equals(that.containerName) :that.containerName != null) return false;
    if (divisor != null ? !divisor.equals(that.divisor) :that.divisor != null) return false;
    if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(containerName,  divisor,  resource,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerName != null) { sb.append("containerName:"); sb.append(containerName + ","); }
    if (divisor != null) { sb.append("divisor:"); sb.append(divisor + ","); }
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DivisorNestedImpl<N> extends QuantityFluentImpl<ResourceFieldSelectorFluent.DivisorNested<N>> implements ResourceFieldSelectorFluent.DivisorNested<N>,Nested<N>{
    DivisorNestedImpl(Quantity item) {
      this.builder = new QuantityBuilder(this, item);
    }
    DivisorNestedImpl() {
      this.builder = new QuantityBuilder(this);
    }
    QuantityBuilder builder;
    public N and() {
      return (N) ResourceFieldSelectorFluentImpl.this.withDivisor(builder.build());
    }
    public N endDivisor() {
      return and();
    }
    
  }
  
}