package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ResourceQuotaFluentImpl<A extends ResourceQuotaFluent<A>> extends BaseFluent<A> implements ResourceQuotaFluent<A>{
  public ResourceQuotaFluentImpl() {
  }
  public ResourceQuotaFluentImpl(ResourceQuota instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ResourceQuotaSpecBuilder spec;
  private ResourceQuotaStatusBuilder status;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ResourceQuotaFluent.MetadataNested<A> withNewMetadata() {
    return new ResourceQuotaFluentImpl.MetadataNestedImpl();
  }
  public ResourceQuotaFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ResourceQuotaFluentImpl.MetadataNestedImpl(item);
  }
  public ResourceQuotaFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ResourceQuotaFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ResourceQuotaFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceQuotaSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ResourceQuotaSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ResourceQuotaSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ResourceQuotaSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ResourceQuotaFluent.SpecNested<A> withNewSpec() {
    return new ResourceQuotaFluentImpl.SpecNestedImpl();
  }
  public ResourceQuotaFluent.SpecNested<A> withNewSpecLike(ResourceQuotaSpec item) {
    return new ResourceQuotaFluentImpl.SpecNestedImpl(item);
  }
  public ResourceQuotaFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ResourceQuotaFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ResourceQuotaSpecBuilder().build());
  }
  public ResourceQuotaFluent.SpecNested<A> editOrNewSpecLike(ResourceQuotaSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceQuotaStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public ResourceQuotaStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(ResourceQuotaStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new ResourceQuotaStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public ResourceQuotaFluent.StatusNested<A> withNewStatus() {
    return new ResourceQuotaFluentImpl.StatusNestedImpl();
  }
  public ResourceQuotaFluent.StatusNested<A> withNewStatusLike(ResourceQuotaStatus item) {
    return new ResourceQuotaFluentImpl.StatusNestedImpl(item);
  }
  public ResourceQuotaFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ResourceQuotaFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new ResourceQuotaStatusBuilder().build());
  }
  public ResourceQuotaFluent.StatusNested<A> editOrNewStatusLike(ResourceQuotaStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResourceQuotaFluentImpl that = (ResourceQuotaFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ResourceQuotaFluent.MetadataNested<N>> implements ResourceQuotaFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ResourceQuotaFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ResourceQuotaSpecFluentImpl<ResourceQuotaFluent.SpecNested<N>> implements ResourceQuotaFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ResourceQuotaSpec item) {
      this.builder = new ResourceQuotaSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ResourceQuotaSpecBuilder(this);
    }
    ResourceQuotaSpecBuilder builder;
    public N and() {
      return (N) ResourceQuotaFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends ResourceQuotaStatusFluentImpl<ResourceQuotaFluent.StatusNested<N>> implements ResourceQuotaFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(ResourceQuotaStatus item) {
      this.builder = new ResourceQuotaStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new ResourceQuotaStatusBuilder(this);
    }
    ResourceQuotaStatusBuilder builder;
    public N and() {
      return (N) ResourceQuotaFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}