package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ScopedResourceSelectorRequirementBuilder extends ScopedResourceSelectorRequirementFluentImpl<ScopedResourceSelectorRequirementBuilder> implements VisitableBuilder<ScopedResourceSelectorRequirement,ScopedResourceSelectorRequirementBuilder>{
  public ScopedResourceSelectorRequirementBuilder() {
    this(false);
  }
  public ScopedResourceSelectorRequirementBuilder(Boolean validationEnabled) {
    this(new ScopedResourceSelectorRequirement(), validationEnabled);
  }
  public ScopedResourceSelectorRequirementBuilder(ScopedResourceSelectorRequirementFluent<?> fluent) {
    this(fluent, false);
  }
  public ScopedResourceSelectorRequirementBuilder(ScopedResourceSelectorRequirementFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ScopedResourceSelectorRequirement(), validationEnabled);
  }
  public ScopedResourceSelectorRequirementBuilder(ScopedResourceSelectorRequirementFluent<?> fluent,ScopedResourceSelectorRequirement instance) {
    this(fluent, instance, false);
  }
  public ScopedResourceSelectorRequirementBuilder(ScopedResourceSelectorRequirementFluent<?> fluent,ScopedResourceSelectorRequirement instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withOperator(instance.getOperator()); 
    fluent.withScopeName(instance.getScopeName()); 
    fluent.withValues(instance.getValues()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ScopedResourceSelectorRequirementBuilder(ScopedResourceSelectorRequirement instance) {
    this(instance,false);
  }
  public ScopedResourceSelectorRequirementBuilder(ScopedResourceSelectorRequirement instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withOperator(instance.getOperator()); 
    this.withScopeName(instance.getScopeName()); 
    this.withValues(instance.getValues()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ScopedResourceSelectorRequirementFluent<?> fluent;
  Boolean validationEnabled;
  public ScopedResourceSelectorRequirement build() {
    ScopedResourceSelectorRequirement buildable = new ScopedResourceSelectorRequirement(fluent.getOperator(),fluent.getScopeName(),fluent.getValues());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}