package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitRepoVolumeSourceBuilder extends GitRepoVolumeSourceFluentImpl<GitRepoVolumeSourceBuilder> implements VisitableBuilder<GitRepoVolumeSource,GitRepoVolumeSourceBuilder>{
  public GitRepoVolumeSourceBuilder() {
    this(false);
  }
  public GitRepoVolumeSourceBuilder(Boolean validationEnabled) {
    this(new GitRepoVolumeSource(), validationEnabled);
  }
  public GitRepoVolumeSourceBuilder(GitRepoVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GitRepoVolumeSourceBuilder(GitRepoVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitRepoVolumeSource(), validationEnabled);
  }
  public GitRepoVolumeSourceBuilder(GitRepoVolumeSourceFluent<?> fluent,GitRepoVolumeSource instance) {
    this(fluent, instance, false);
  }
  public GitRepoVolumeSourceBuilder(GitRepoVolumeSourceFluent<?> fluent,GitRepoVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDirectory(instance.getDirectory()); 
    fluent.withRepository(instance.getRepository()); 
    fluent.withRevision(instance.getRevision()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GitRepoVolumeSourceBuilder(GitRepoVolumeSource instance) {
    this(instance,false);
  }
  public GitRepoVolumeSourceBuilder(GitRepoVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDirectory(instance.getDirectory()); 
    this.withRepository(instance.getRepository()); 
    this.withRevision(instance.getRevision()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GitRepoVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public GitRepoVolumeSource build() {
    GitRepoVolumeSource buildable = new GitRepoVolumeSource(fluent.getDirectory(),fluent.getRepository(),fluent.getRevision());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}