package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface PersistentVolumeListFluent<A extends PersistentVolumeListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,PersistentVolume item);
  public A setToItems(Integer index,PersistentVolume item);
  public A addToItems(io.fabric8.kubernetes.api.model.PersistentVolume... items);
  public A addAllToItems(Collection<PersistentVolume> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.PersistentVolume... items);
  public A removeAllFromItems(Collection<PersistentVolume> items);
  public A removeMatchingFromItems(Predicate<PersistentVolumeBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PersistentVolume> getItems();
  public List<PersistentVolume> buildItems();
  public PersistentVolume buildItem(Integer index);
  public PersistentVolume buildFirstItem();
  public PersistentVolume buildLastItem();
  public PersistentVolume buildMatchingItem(Predicate<PersistentVolumeBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<PersistentVolumeBuilder> predicate);
  public A withItems(List<PersistentVolume> items);
  public A withItems(io.fabric8.kubernetes.api.model.PersistentVolume... items);
  public Boolean hasItems();
  public PersistentVolumeListFluent.ItemsNested<A> addNewItem();
  public PersistentVolumeListFluent.ItemsNested<A> addNewItemLike(PersistentVolume item);
  public PersistentVolumeListFluent.ItemsNested<A> setNewItemLike(Integer index,PersistentVolume item);
  public PersistentVolumeListFluent.ItemsNested<A> editItem(Integer index);
  public PersistentVolumeListFluent.ItemsNested<A> editFirstItem();
  public PersistentVolumeListFluent.ItemsNested<A> editLastItem();
  public PersistentVolumeListFluent.ItemsNested<A> editMatchingItem(Predicate<PersistentVolumeBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata();
  public ListMeta buildMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public PersistentVolumeListFluent.MetadataNested<A> withNewMetadata();
  public PersistentVolumeListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
  public PersistentVolumeListFluent.MetadataNested<A> editMetadata();
  public PersistentVolumeListFluent.MetadataNested<A> editOrNewMetadata();
  public PersistentVolumeListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,PersistentVolumeFluent<PersistentVolumeListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<PersistentVolumeListFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}