package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodOSBuilder extends PodOSFluentImpl<PodOSBuilder> implements VisitableBuilder<PodOS,PodOSBuilder>{
  public PodOSBuilder() {
    this(false);
  }
  public PodOSBuilder(Boolean validationEnabled) {
    this(new PodOS(), validationEnabled);
  }
  public PodOSBuilder(PodOSFluent<?> fluent) {
    this(fluent, false);
  }
  public PodOSBuilder(PodOSFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodOS(), validationEnabled);
  }
  public PodOSBuilder(PodOSFluent<?> fluent,PodOS instance) {
    this(fluent, instance, false);
  }
  public PodOSBuilder(PodOSFluent<?> fluent,PodOS instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodOSBuilder(PodOS instance) {
    this(instance,false);
  }
  public PodOSBuilder(PodOS instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PodOSFluent<?> fluent;
  Boolean validationEnabled;
  public PodOS build() {
    PodOS buildable = new PodOS(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}