package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceQuotaSpecBuilder extends ResourceQuotaSpecFluentImpl<ResourceQuotaSpecBuilder> implements VisitableBuilder<ResourceQuotaSpec,ResourceQuotaSpecBuilder>{
  public ResourceQuotaSpecBuilder() {
    this(false);
  }
  public ResourceQuotaSpecBuilder(Boolean validationEnabled) {
    this(new ResourceQuotaSpec(), validationEnabled);
  }
  public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceQuotaSpec(), validationEnabled);
  }
  public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent,ResourceQuotaSpec instance) {
    this(fluent, instance, false);
  }
  public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent,ResourceQuotaSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHard(instance.getHard()); 
    fluent.withScopeSelector(instance.getScopeSelector()); 
    fluent.withScopes(instance.getScopes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceQuotaSpecBuilder(ResourceQuotaSpec instance) {
    this(instance,false);
  }
  public ResourceQuotaSpecBuilder(ResourceQuotaSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withHard(instance.getHard()); 
    this.withScopeSelector(instance.getScopeSelector()); 
    this.withScopes(instance.getScopes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ResourceQuotaSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceQuotaSpec build() {
    ResourceQuotaSpec buildable = new ResourceQuotaSpec(fluent.getHard(),fluent.getScopeSelector(),fluent.getScopes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}