package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ContainerStatusFluentImpl<A extends ContainerStatusFluent<A>> extends BaseFluent<A> implements ContainerStatusFluent<A>{
  public ContainerStatusFluentImpl() {
  }
  public ContainerStatusFluentImpl(ContainerStatus instance) {
    this.withContainerID(instance.getContainerID()); 
    this.withImage(instance.getImage()); 
    this.withImageID(instance.getImageID()); 
    this.withLastState(instance.getLastState()); 
    this.withName(instance.getName()); 
    this.withReady(instance.getReady()); 
    this.withRestartCount(instance.getRestartCount()); 
    this.withStarted(instance.getStarted()); 
    this.withState(instance.getState()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String containerID;
  private String image;
  private String imageID;
  private ContainerStateBuilder lastState;
  private String name;
  private Boolean ready;
  private Integer restartCount;
  private Boolean started;
  private ContainerStateBuilder state;
  private Map<String,Object> additionalProperties;
  public String getContainerID() {
    return this.containerID;
  }
  public A withContainerID(String containerID) {
    this.containerID=containerID; return (A) this;
  }
  public Boolean hasContainerID() {
    return this.containerID != null;
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public String getImageID() {
    return this.imageID;
  }
  public A withImageID(String imageID) {
    this.imageID=imageID; return (A) this;
  }
  public Boolean hasImageID() {
    return this.imageID != null;
  }
  
  /**
   * This method has been deprecated, please use method buildLastState instead.
   * @return The buildable object.
   */
  @Deprecated
  public ContainerState getLastState() {
    return this.lastState!=null ?this.lastState.build():null;
  }
  public ContainerState buildLastState() {
    return this.lastState!=null ?this.lastState.build():null;
  }
  public A withLastState(ContainerState lastState) {
    _visitables.get("lastState").remove(this.lastState);
    if (lastState!=null){ this.lastState= new ContainerStateBuilder(lastState); _visitables.get("lastState").add(this.lastState);} else { this.lastState = null; _visitables.get("lastState").remove(this.lastState); } return (A) this;
  }
  public Boolean hasLastState() {
    return this.lastState != null;
  }
  public ContainerStatusFluent.LastStateNested<A> withNewLastState() {
    return new ContainerStatusFluentImpl.LastStateNestedImpl();
  }
  public ContainerStatusFluent.LastStateNested<A> withNewLastStateLike(ContainerState item) {
    return new ContainerStatusFluentImpl.LastStateNestedImpl(item);
  }
  public ContainerStatusFluent.LastStateNested<A> editLastState() {
    return withNewLastStateLike(getLastState());
  }
  public ContainerStatusFluent.LastStateNested<A> editOrNewLastState() {
    return withNewLastStateLike(getLastState() != null ? getLastState(): new ContainerStateBuilder().build());
  }
  public ContainerStatusFluent.LastStateNested<A> editOrNewLastStateLike(ContainerState item) {
    return withNewLastStateLike(getLastState() != null ? getLastState(): item);
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public Boolean getReady() {
    return this.ready;
  }
  public A withReady(Boolean ready) {
    this.ready=ready; return (A) this;
  }
  public Boolean hasReady() {
    return this.ready != null;
  }
  public Integer getRestartCount() {
    return this.restartCount;
  }
  public A withRestartCount(Integer restartCount) {
    this.restartCount=restartCount; return (A) this;
  }
  public Boolean hasRestartCount() {
    return this.restartCount != null;
  }
  public Boolean getStarted() {
    return this.started;
  }
  public A withStarted(Boolean started) {
    this.started=started; return (A) this;
  }
  public Boolean hasStarted() {
    return this.started != null;
  }
  
  /**
   * This method has been deprecated, please use method buildState instead.
   * @return The buildable object.
   */
  @Deprecated
  public ContainerState getState() {
    return this.state!=null ?this.state.build():null;
  }
  public ContainerState buildState() {
    return this.state!=null ?this.state.build():null;
  }
  public A withState(ContainerState state) {
    _visitables.get("state").remove(this.state);
    if (state!=null){ this.state= new ContainerStateBuilder(state); _visitables.get("state").add(this.state);} else { this.state = null; _visitables.get("state").remove(this.state); } return (A) this;
  }
  public Boolean hasState() {
    return this.state != null;
  }
  public ContainerStatusFluent.StateNested<A> withNewState() {
    return new ContainerStatusFluentImpl.StateNestedImpl();
  }
  public ContainerStatusFluent.StateNested<A> withNewStateLike(ContainerState item) {
    return new ContainerStatusFluentImpl.StateNestedImpl(item);
  }
  public ContainerStatusFluent.StateNested<A> editState() {
    return withNewStateLike(getState());
  }
  public ContainerStatusFluent.StateNested<A> editOrNewState() {
    return withNewStateLike(getState() != null ? getState(): new ContainerStateBuilder().build());
  }
  public ContainerStatusFluent.StateNested<A> editOrNewStateLike(ContainerState item) {
    return withNewStateLike(getState() != null ? getState(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ContainerStatusFluentImpl that = (ContainerStatusFluentImpl) o;
    if (containerID != null ? !containerID.equals(that.containerID) :that.containerID != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (imageID != null ? !imageID.equals(that.imageID) :that.imageID != null) return false;
    if (lastState != null ? !lastState.equals(that.lastState) :that.lastState != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (ready != null ? !ready.equals(that.ready) :that.ready != null) return false;
    if (restartCount != null ? !restartCount.equals(that.restartCount) :that.restartCount != null) return false;
    if (started != null ? !started.equals(that.started) :that.started != null) return false;
    if (state != null ? !state.equals(that.state) :that.state != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(containerID,  image,  imageID,  lastState,  name,  ready,  restartCount,  started,  state,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerID != null) { sb.append("containerID:"); sb.append(containerID + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (imageID != null) { sb.append("imageID:"); sb.append(imageID + ","); }
    if (lastState != null) { sb.append("lastState:"); sb.append(lastState + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (ready != null) { sb.append("ready:"); sb.append(ready + ","); }
    if (restartCount != null) { sb.append("restartCount:"); sb.append(restartCount + ","); }
    if (started != null) { sb.append("started:"); sb.append(started + ","); }
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withReady() {
    return withReady(true);
  }
  public A withStarted() {
    return withStarted(true);
  }
  class LastStateNestedImpl<N> extends ContainerStateFluentImpl<ContainerStatusFluent.LastStateNested<N>> implements ContainerStatusFluent.LastStateNested<N>,Nested<N>{
    LastStateNestedImpl(ContainerState item) {
      this.builder = new ContainerStateBuilder(this, item);
    }
    LastStateNestedImpl() {
      this.builder = new ContainerStateBuilder(this);
    }
    ContainerStateBuilder builder;
    public N and() {
      return (N) ContainerStatusFluentImpl.this.withLastState(builder.build());
    }
    public N endLastState() {
      return and();
    }
    
  }
  class StateNestedImpl<N> extends ContainerStateFluentImpl<ContainerStatusFluent.StateNested<N>> implements ContainerStatusFluent.StateNested<N>,Nested<N>{
    StateNestedImpl(ContainerState item) {
      this.builder = new ContainerStateBuilder(this, item);
    }
    StateNestedImpl() {
      this.builder = new ContainerStateBuilder(this);
    }
    ContainerStateBuilder builder;
    public N and() {
      return (N) ContainerStatusFluentImpl.this.withState(builder.build());
    }
    public N endState() {
      return and();
    }
    
  }
  
}