package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LifecycleHandlerBuilder extends LifecycleHandlerFluentImpl<LifecycleHandlerBuilder> implements VisitableBuilder<LifecycleHandler,LifecycleHandlerBuilder>{
  public LifecycleHandlerBuilder() {
    this(false);
  }
  public LifecycleHandlerBuilder(Boolean validationEnabled) {
    this(new LifecycleHandler(), validationEnabled);
  }
  public LifecycleHandlerBuilder(LifecycleHandlerFluent<?> fluent) {
    this(fluent, false);
  }
  public LifecycleHandlerBuilder(LifecycleHandlerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LifecycleHandler(), validationEnabled);
  }
  public LifecycleHandlerBuilder(LifecycleHandlerFluent<?> fluent,LifecycleHandler instance) {
    this(fluent, instance, false);
  }
  public LifecycleHandlerBuilder(LifecycleHandlerFluent<?> fluent,LifecycleHandler instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExec(instance.getExec()); 
    fluent.withHttpGet(instance.getHttpGet()); 
    fluent.withTcpSocket(instance.getTcpSocket()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LifecycleHandlerBuilder(LifecycleHandler instance) {
    this(instance,false);
  }
  public LifecycleHandlerBuilder(LifecycleHandler instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExec(instance.getExec()); 
    this.withHttpGet(instance.getHttpGet()); 
    this.withTcpSocket(instance.getTcpSocket()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  LifecycleHandlerFluent<?> fluent;
  Boolean validationEnabled;
  public LifecycleHandler build() {
    LifecycleHandler buildable = new LifecycleHandler(fluent.getExec(),fluent.getHttpGet(),fluent.getTcpSocket());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}