package io.fabric8.kubernetes.api.model;

import java.lang.String;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluentImpl;
import io.fabric8.kubernetes.api.model.version.Info;
import io.fabric8.kubernetes.api.model.version.InfoBuilder;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder;
import java.lang.Long;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Deprecated;
import java.lang.SuppressWarnings;
import java.util.Map;
import io.fabric8.kubernetes.api.model.version.InfoFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NamedExtensionFluentImpl<A extends NamedExtensionFluent<A>> extends BaseFluent<A> implements NamedExtensionFluent<A>{
  public NamedExtensionFluentImpl() {
  }
  public NamedExtensionFluentImpl(NamedExtension instance) {
    this.withExtension(instance.getExtension()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private VisitableBuilder<? extends KubernetesResource,?> extension;
  private String name;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildExtension instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubernetesResource getExtension() {
    return this.extension!=null?this.extension.build():null;
  }
  public KubernetesResource buildExtension() {
    return this.extension!=null?this.extension.build():null;
  }
  public A withExtension(KubernetesResource extension) {
    if (extension instanceof Patch){ this.extension= new PatchBuilder((Patch)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof LimitRange){ this.extension= new LimitRangeBuilder((LimitRange)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof APIGroupList){ this.extension= new APIGroupListBuilder((APIGroupList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PortStatus){ this.extension= new PortStatusBuilder((PortStatus)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodTemplateSpec){ this.extension= new PodTemplateSpecBuilder((PodTemplateSpec)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof CSIPersistentVolumeSource){ this.extension= new CSIPersistentVolumeSourceBuilder((CSIPersistentVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof AuthInfo){ this.extension= new AuthInfoBuilder((AuthInfo)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof APIService){ this.extension= new APIServiceBuilder((APIService)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ResourceRequirements){ this.extension= new ResourceRequirementsBuilder((ResourceRequirements)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ConfigMapKeySelector){ this.extension= new ConfigMapKeySelectorBuilder((ConfigMapKeySelector)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof HostPathVolumeSource){ this.extension= new HostPathVolumeSourceBuilder((HostPathVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PersistentVolumeClaimList){ this.extension= new PersistentVolumeClaimListBuilder((PersistentVolumeClaimList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NamedContext){ this.extension= new NamedContextBuilder((NamedContext)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Config){ this.extension= new ConfigBuilder((Config)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Affinity){ this.extension= new AffinityBuilder((Affinity)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodResourceClaim){ this.extension= new PodResourceClaimBuilder((PodResourceClaim)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ReplicationControllerStatus){ this.extension= new ReplicationControllerStatusBuilder((ReplicationControllerStatus)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof APIServiceStatus){ this.extension= new APIServiceStatusBuilder((APIServiceStatus)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof MicroTime){ this.extension= new MicroTimeBuilder((MicroTime)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Lifecycle){ this.extension= new LifecycleBuilder((Lifecycle)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PortworxVolumeSource){ this.extension= new PortworxVolumeSourceBuilder((PortworxVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof EventSource){ this.extension= new EventSourceBuilder((EventSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof GRPCAction){ this.extension= new GRPCActionBuilder((GRPCAction)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof AzureFileVolumeSource){ this.extension= new AzureFileVolumeSourceBuilder((AzureFileVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ResourceClaim){ this.extension= new ResourceClaimBuilder((ResourceClaim)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ComponentCondition){ this.extension= new ComponentConditionBuilder((ComponentCondition)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof EnvVar){ this.extension= new EnvVarBuilder((EnvVar)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ReplicationControllerSpec){ this.extension= new ReplicationControllerSpecBuilder((ReplicationControllerSpec)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof LoadBalancerIngress){ this.extension= new LoadBalancerIngressBuilder((LoadBalancerIngress)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof AttachedVolume){ this.extension= new AttachedVolumeBuilder((AttachedVolume)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof LocalObjectReference){ this.extension= new LocalObjectReferenceBuilder((LocalObjectReference)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NamedAuthInfo){ this.extension= new NamedAuthInfoBuilder((NamedAuthInfo)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof EmptyDirVolumeSource){ this.extension= new EmptyDirVolumeSourceBuilder((EmptyDirVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodSpec){ this.extension= new PodSpecBuilder((PodSpec)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ServerAddressByClientCIDR){ this.extension= new ServerAddressByClientCIDRBuilder((ServerAddressByClientCIDR)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof AzureDiskVolumeSource){ this.extension= new AzureDiskVolumeSourceBuilder((AzureDiskVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Preconditions){ this.extension= new PreconditionsBuilder((Preconditions)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Info){ this.extension= new InfoBuilder((Info)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof CephFSVolumeSource){ this.extension= new CephFSVolumeSourceBuilder((CephFSVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof EphemeralContainer){ this.extension= new EphemeralContainerBuilder((EphemeralContainer)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NodeCondition){ this.extension= new NodeConditionBuilder((NodeCondition)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof EndpointSubset){ this.extension= new EndpointSubsetBuilder((EndpointSubset)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof LocalVolumeSource){ this.extension= new LocalVolumeSourceBuilder((LocalVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ServiceReference){ this.extension= new ServiceReferenceBuilder((ServiceReference)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ServiceStatus){ this.extension= new ServiceStatusBuilder((ServiceStatus)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Taint){ this.extension= new TaintBuilder((Taint)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PatchOptions){ this.extension= new PatchOptionsBuilder((PatchOptions)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ConfigMapNodeConfigSource){ this.extension= new ConfigMapNodeConfigSourceBuilder((ConfigMapNodeConfigSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof HTTPGetAction){ this.extension= new HTTPGetActionBuilder((HTTPGetAction)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof GlusterfsPersistentVolumeSource){ this.extension= new GlusterfsPersistentVolumeSourceBuilder((GlusterfsPersistentVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof DownwardAPIVolumeSource){ this.extension= new DownwardAPIVolumeSourceBuilder((DownwardAPIVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ISCSIPersistentVolumeSource){ this.extension= new ISCSIPersistentVolumeSourceBuilder((ISCSIPersistentVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof WindowsSecurityContextOptions){ this.extension= new WindowsSecurityContextOptionsBuilder((WindowsSecurityContextOptions)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof CreateOptions){ this.extension= new CreateOptionsBuilder((CreateOptions)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof EnvFromSource){ this.extension= new EnvFromSourceBuilder((EnvFromSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NamespaceSpec){ this.extension= new NamespaceSpecBuilder((NamespaceSpec)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof TypeMeta){ this.extension= new TypeMetaBuilder((TypeMeta)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof RootPaths){ this.extension= new RootPathsBuilder((RootPaths)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ListMeta){ this.extension= new ListMetaBuilder((ListMeta)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof SecretReference){ this.extension= new SecretReferenceBuilder((SecretReference)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof APIGroup){ this.extension= new APIGroupBuilder((APIGroup)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof FlexVolumeSource){ this.extension= new FlexVolumeSourceBuilder((FlexVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PersistentVolumeClaimTemplate){ this.extension= new PersistentVolumeClaimTemplateBuilder((PersistentVolumeClaimTemplate)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ISCSIVolumeSource){ this.extension= new ISCSIVolumeSourceBuilder((ISCSIVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof SecretKeySelector){ this.extension= new SecretKeySelectorBuilder((SecretKeySelector)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof RBDVolumeSource){ this.extension= new RBDVolumeSourceBuilder((RBDVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NodeConfigStatus){ this.extension= new NodeConfigStatusBuilder((NodeConfigStatus)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ResourceQuotaList){ this.extension= new ResourceQuotaListBuilder((ResourceQuotaList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof QuobyteVolumeSource){ this.extension= new QuobyteVolumeSourceBuilder((QuobyteVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof APIResource){ this.extension= new APIResourceBuilder((APIResource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ResourceQuotaStatus){ this.extension= new ResourceQuotaStatusBuilder((ResourceQuotaStatus)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof RawExtension){ this.extension= new RawExtensionBuilder((RawExtension)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ConfigMapProjection){ this.extension= new ConfigMapProjectionBuilder((ConfigMapProjection)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ScopedResourceSelectorRequirement){ this.extension= new ScopedResourceSelectorRequirementBuilder((ScopedResourceSelectorRequirement)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Namespace){ this.extension= new NamespaceBuilder((Namespace)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof GroupVersionKind){ this.extension= new GroupVersionKindBuilder((GroupVersionKind)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ContainerStateTerminated){ this.extension= new ContainerStateTerminatedBuilder((ContainerStateTerminated)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof LimitRangeSpec){ this.extension= new LimitRangeSpecBuilder((LimitRangeSpec)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ProjectedVolumeSource){ this.extension= new ProjectedVolumeSourceBuilder((ProjectedVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodOS){ this.extension= new PodOSBuilder((PodOS)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PersistentVolumeClaimStatus){ this.extension= new PersistentVolumeClaimStatusBuilder((PersistentVolumeClaimStatus)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ContainerState){ this.extension= new ContainerStateBuilder((ContainerState)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ServiceSpec){ this.extension= new ServiceSpecBuilder((ServiceSpec)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ServiceAccountTokenProjection){ this.extension= new ServiceAccountTokenProjectionBuilder((ServiceAccountTokenProjection)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PhotonPersistentDiskVolumeSource){ this.extension= new PhotonPersistentDiskVolumeSourceBuilder((PhotonPersistentDiskVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Container){ this.extension= new ContainerBuilder((Container)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NodeSpec){ this.extension= new NodeSpecBuilder((NodeSpec)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof TypedLocalObjectReference){ this.extension= new TypedLocalObjectReferenceBuilder((TypedLocalObjectReference)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof FieldsV1){ this.extension= new FieldsV1Builder((FieldsV1)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof SecretList){ this.extension= new SecretListBuilder((SecretList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NodeAddress){ this.extension= new NodeAddressBuilder((NodeAddress)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodAffinity){ this.extension= new PodAffinityBuilder((PodAffinity)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ExecEnvVar){ this.extension= new ExecEnvVarBuilder((ExecEnvVar)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Service){ this.extension= new ServiceBuilder((Service)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof EventSeries){ this.extension= new EventSeriesBuilder((EventSeries)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodCondition){ this.extension= new PodConditionBuilder((PodCondition)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof TopologySpreadConstraint){ this.extension= new TopologySpreadConstraintBuilder((TopologySpreadConstraint)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ExecAction){ this.extension= new ExecActionBuilder((ExecAction)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ContainerImage){ this.extension= new ContainerImageBuilder((ContainerImage)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof GroupKind){ this.extension= new GroupKindBuilder((GroupKind)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ReplicationController){ this.extension= new ReplicationControllerBuilder((ReplicationController)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NodeStatus){ this.extension= new NodeStatusBuilder((NodeStatus)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ConfigMapList){ this.extension= new ConfigMapListBuilder((ConfigMapList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NodeSelector){ this.extension= new NodeSelectorBuilder((NodeSelector)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Toleration){ this.extension= new TolerationBuilder((Toleration)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof CephFSPersistentVolumeSource){ this.extension= new CephFSPersistentVolumeSourceBuilder((CephFSPersistentVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PersistentVolumeClaimCondition){ this.extension= new PersistentVolumeClaimConditionBuilder((PersistentVolumeClaimCondition)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PreferredSchedulingTerm){ this.extension= new PreferredSchedulingTermBuilder((PreferredSchedulingTerm)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PersistentVolumeList){ this.extension= new PersistentVolumeListBuilder((PersistentVolumeList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodSchedulingGate){ this.extension= new PodSchedulingGateBuilder((PodSchedulingGate)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodDNSConfigOption){ this.extension= new PodDNSConfigOptionBuilder((PodDNSConfigOption)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof GCEPersistentDiskVolumeSource){ this.extension= new GCEPersistentDiskVolumeSourceBuilder((GCEPersistentDiskVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof APIServiceCondition){ this.extension= new APIServiceConditionBuilder((APIServiceCondition)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof EventList){ this.extension= new EventListBuilder((EventList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodReadinessGate){ this.extension= new PodReadinessGateBuilder((PodReadinessGate)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ContainerStateWaiting){ this.extension= new ContainerStateWaitingBuilder((ContainerStateWaiting)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof VolumeMount){ this.extension= new VolumeMountBuilder((VolumeMount)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NamespaceCondition){ this.extension= new NamespaceConditionBuilder((NamespaceCondition)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof LabelSelector){ this.extension= new LabelSelectorBuilder((LabelSelector)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof StatusCause){ this.extension= new StatusCauseBuilder((StatusCause)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NamedCluster){ this.extension= new NamedClusterBuilder((NamedCluster)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof StatusDetails){ this.extension= new StatusDetailsBuilder((StatusDetails)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof DownwardAPIVolumeFile){ this.extension= new DownwardAPIVolumeFileBuilder((DownwardAPIVolumeFile)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof SeccompProfile){ this.extension= new SeccompProfileBuilder((SeccompProfile)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Sysctl){ this.extension= new SysctlBuilder((Sysctl)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof DeleteOptions){ this.extension= new DeleteOptionsBuilder((DeleteOptions)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Status){ this.extension= new StatusBuilder((Status)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ContainerStatus){ this.extension= new ContainerStatusBuilder((ContainerStatus)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodTemplate){ this.extension= new PodTemplateBuilder((PodTemplate)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ConfigMapEnvSource){ this.extension= new ConfigMapEnvSourceBuilder((ConfigMapEnvSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NodeSelectorRequirement){ this.extension= new NodeSelectorRequirementBuilder((NodeSelectorRequirement)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof TCPSocketAction){ this.extension= new TCPSocketActionBuilder((TCPSocketAction)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Event){ this.extension= new EventBuilder((Event)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Preferences){ this.extension= new PreferencesBuilder((Preferences)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ObjectFieldSelector){ this.extension= new ObjectFieldSelectorBuilder((ObjectFieldSelector)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodTemplateList){ this.extension= new PodTemplateListBuilder((PodTemplateList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PersistentVolume){ this.extension= new PersistentVolumeBuilder((PersistentVolume)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof CinderVolumeSource){ this.extension= new CinderVolumeSourceBuilder((CinderVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof EndpointAddress){ this.extension= new EndpointAddressBuilder((EndpointAddress)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NodeConfigSource){ this.extension= new NodeConfigSourceBuilder((NodeConfigSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof VsphereVirtualDiskVolumeSource){ this.extension= new VsphereVirtualDiskVolumeSourceBuilder((VsphereVirtualDiskVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ObjectMeta){ this.extension= new ObjectMetaBuilder((ObjectMeta)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PersistentVolumeClaim){ this.extension= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof LabelSelectorRequirement){ this.extension= new LabelSelectorRequirementBuilder((LabelSelectorRequirement)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof GitRepoVolumeSource){ this.extension= new GitRepoVolumeSourceBuilder((GitRepoVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof GenericKubernetesResource){ this.extension= new GenericKubernetesResourceBuilder((GenericKubernetesResource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof EndpointsList){ this.extension= new EndpointsListBuilder((EndpointsList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof GroupVersionResource){ this.extension= new GroupVersionResourceBuilder((GroupVersionResource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof CinderPersistentVolumeSource){ this.extension= new CinderPersistentVolumeSourceBuilder((CinderPersistentVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof TopologySelectorTerm){ this.extension= new TopologySelectorTermBuilder((TopologySelectorTerm)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof OwnerReference){ this.extension= new OwnerReferenceBuilder((OwnerReference)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof StorageOSPersistentVolumeSource){ this.extension= new StorageOSPersistentVolumeSourceBuilder((StorageOSPersistentVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof EphemeralVolumeSource){ this.extension= new EphemeralVolumeSourceBuilder((EphemeralVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ReplicationControllerCondition){ this.extension= new ReplicationControllerConditionBuilder((ReplicationControllerCondition)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodAntiAffinity){ this.extension= new PodAntiAffinityBuilder((PodAntiAffinity)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof SecurityContext){ this.extension= new SecurityContextBuilder((SecurityContext)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ReplicationControllerList){ this.extension= new ReplicationControllerListBuilder((ReplicationControllerList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ConfigMapVolumeSource){ this.extension= new ConfigMapVolumeSourceBuilder((ConfigMapVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ContainerStateRunning){ this.extension= new ContainerStateRunningBuilder((ContainerStateRunning)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ComponentStatusList){ this.extension= new ComponentStatusListBuilder((ComponentStatusList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof FlockerVolumeSource){ this.extension= new FlockerVolumeSourceBuilder((FlockerVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ScaleIOVolumeSource){ this.extension= new ScaleIOVolumeSourceBuilder((ScaleIOVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof LimitRangeList){ this.extension= new LimitRangeListBuilder((LimitRangeList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodExecOptions){ this.extension= new PodExecOptionsBuilder((PodExecOptions)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Probe){ this.extension= new ProbeBuilder((Probe)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof UpdateOptions){ this.extension= new UpdateOptionsBuilder((UpdateOptions)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Endpoints){ this.extension= new EndpointsBuilder((Endpoints)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NamedExtension){ this.extension= new NamedExtensionBuilder((NamedExtension)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof AzureFilePersistentVolumeSource){ this.extension= new AzureFilePersistentVolumeSourceBuilder((AzureFilePersistentVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof APIResourceList){ this.extension= new APIResourceListBuilder((APIResourceList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof APIServiceList){ this.extension= new APIServiceListBuilder((APIServiceList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof SecretVolumeSource){ this.extension= new SecretVolumeSourceBuilder((SecretVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Pod){ this.extension= new PodBuilder((Pod)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ClientIPConfig){ this.extension= new ClientIPConfigBuilder((ClientIPConfig)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Context){ this.extension= new ContextBuilder((Context)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NodeAffinity){ this.extension= new NodeAffinityBuilder((NodeAffinity)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ConfigMap){ this.extension= new ConfigMapBuilder((ConfigMap)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ContainerPort){ this.extension= new ContainerPortBuilder((ContainerPort)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Condition){ this.extension= new ConditionBuilder((Condition)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodList){ this.extension= new PodListBuilder((PodList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof FCVolumeSource){ this.extension= new FCVolumeSourceBuilder((FCVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ResourceFieldSelector){ this.extension= new ResourceFieldSelectorBuilder((ResourceFieldSelector)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PersistentVolumeClaimSpec){ this.extension= new PersistentVolumeClaimSpecBuilder((PersistentVolumeClaimSpec)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof LoadBalancerStatus){ this.extension= new LoadBalancerStatusBuilder((LoadBalancerStatus)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodSecurityContext){ this.extension= new PodSecurityContextBuilder((PodSecurityContext)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ScopeSelector){ this.extension= new ScopeSelectorBuilder((ScopeSelector)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof DownwardAPIProjection){ this.extension= new DownwardAPIProjectionBuilder((DownwardAPIProjection)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodAffinityTerm){ this.extension= new PodAffinityTermBuilder((PodAffinityTerm)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof APIServiceSpec){ this.extension= new APIServiceSpecBuilder((APIServiceSpec)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ServicePort){ this.extension= new ServicePortBuilder((ServicePort)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof GroupVersionForDiscovery){ this.extension= new GroupVersionForDiscoveryBuilder((GroupVersionForDiscovery)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ClaimSource){ this.extension= new ClaimSourceBuilder((ClaimSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PersistentVolumeClaimVolumeSource){ this.extension= new PersistentVolumeClaimVolumeSourceBuilder((PersistentVolumeClaimVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof SessionAffinityConfig){ this.extension= new SessionAffinityConfigBuilder((SessionAffinityConfig)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ServiceAccountList){ this.extension= new ServiceAccountListBuilder((ServiceAccountList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ComponentStatus){ this.extension= new ComponentStatusBuilder((ComponentStatus)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof DaemonEndpoint){ this.extension= new DaemonEndpointBuilder((DaemonEndpoint)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof KeyToPath){ this.extension= new KeyToPathBuilder((KeyToPath)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof FlexPersistentVolumeSource){ this.extension= new FlexPersistentVolumeSourceBuilder((FlexPersistentVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NamespaceList){ this.extension= new NamespaceListBuilder((NamespaceList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodDNSConfig){ this.extension= new PodDNSConfigBuilder((PodDNSConfig)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NodeList){ this.extension= new NodeListBuilder((NodeList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Binding){ this.extension= new BindingBuilder((Binding)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof EnvVarSource){ this.extension= new EnvVarSourceBuilder((EnvVarSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof VolumeProjection){ this.extension= new VolumeProjectionBuilder((VolumeProjection)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ResourceQuota){ this.extension= new ResourceQuotaBuilder((ResourceQuota)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Secret){ this.extension= new SecretBuilder((Secret)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ServiceList){ this.extension= new ServiceListBuilder((ServiceList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof VolumeNodeAffinity){ this.extension= new VolumeNodeAffinityBuilder((VolumeNodeAffinity)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ResourceQuotaSpec){ this.extension= new ResourceQuotaSpecBuilder((ResourceQuotaSpec)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NodeSelectorTerm){ this.extension= new NodeSelectorTermBuilder((NodeSelectorTerm)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ScaleIOPersistentVolumeSource){ this.extension= new ScaleIOPersistentVolumeSourceBuilder((ScaleIOPersistentVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ListOptions){ this.extension= new ListOptionsBuilder((ListOptions)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof WeightedPodAffinityTerm){ this.extension= new WeightedPodAffinityTermBuilder((WeightedPodAffinityTerm)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof TypedObjectReference){ this.extension= new TypedObjectReferenceBuilder((TypedObjectReference)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NodeSystemInfo){ this.extension= new NodeSystemInfoBuilder((NodeSystemInfo)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof TopologySelectorLabelRequirement){ this.extension= new TopologySelectorLabelRequirementBuilder((TopologySelectorLabelRequirement)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof RBDPersistentVolumeSource){ this.extension= new RBDPersistentVolumeSourceBuilder((RBDPersistentVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof AuthProviderConfig){ this.extension= new AuthProviderConfigBuilder((AuthProviderConfig)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof SELinuxOptions){ this.extension= new SELinuxOptionsBuilder((SELinuxOptions)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof HostAlias){ this.extension= new HostAliasBuilder((HostAlias)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NodeDaemonEndpoints){ this.extension= new NodeDaemonEndpointsBuilder((NodeDaemonEndpoints)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof VolumeDevice){ this.extension= new VolumeDeviceBuilder((VolumeDevice)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof CSIVolumeSource){ this.extension= new CSIVolumeSourceBuilder((CSIVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PersistentVolumeSpec){ this.extension= new PersistentVolumeSpecBuilder((PersistentVolumeSpec)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Node){ this.extension= new NodeBuilder((Node)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof LifecycleHandler){ this.extension= new LifecycleHandlerBuilder((LifecycleHandler)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Volume){ this.extension= new VolumeBuilder((Volume)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Cluster){ this.extension= new ClusterBuilder((Cluster)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NFSVolumeSource){ this.extension= new NFSVolumeSourceBuilder((NFSVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof StorageOSVolumeSource){ this.extension= new StorageOSVolumeSourceBuilder((StorageOSVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodStatus){ this.extension= new PodStatusBuilder((PodStatus)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof KubernetesList){ this.extension= new KubernetesListBuilder((KubernetesList)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ExecConfig){ this.extension= new ExecConfigBuilder((ExecConfig)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PersistentVolumeStatus){ this.extension= new PersistentVolumeStatusBuilder((PersistentVolumeStatus)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof EndpointPort){ this.extension= new EndpointPortBuilder((EndpointPort)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof HTTPHeader){ this.extension= new HTTPHeaderBuilder((HTTPHeader)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Capabilities){ this.extension= new CapabilitiesBuilder((Capabilities)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ObjectReference){ this.extension= new ObjectReferenceBuilder((ObjectReference)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof WatchEvent){ this.extension= new WatchEventBuilder((WatchEvent)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof LimitRangeItem){ this.extension= new LimitRangeItemBuilder((LimitRangeItem)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof SecretProjection){ this.extension= new SecretProjectionBuilder((SecretProjection)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof GetOptions){ this.extension= new GetOptionsBuilder((GetOptions)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof GlusterfsVolumeSource){ this.extension= new GlusterfsVolumeSourceBuilder((GlusterfsVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ManagedFieldsEntry){ this.extension= new ManagedFieldsEntryBuilder((ManagedFieldsEntry)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NamespaceStatus){ this.extension= new NamespaceStatusBuilder((NamespaceStatus)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof SecretEnvSource){ this.extension= new SecretEnvSourceBuilder((SecretEnvSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ServiceAccount){ this.extension= new ServiceAccountBuilder((ServiceAccount)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof AWSElasticBlockStoreVolumeSource){ this.extension= new AWSElasticBlockStoreVolumeSourceBuilder((AWSElasticBlockStoreVolumeSource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodIP){ this.extension= new PodIPBuilder((PodIP)extension); _visitables.get("extension").add(this.extension);}
    return (A) this;
  }
  public Boolean hasExtension() {
    return this.extension != null;
  }
  public A withPatchExtension(Patch patchExtension) {
    _visitables.get("extension").remove(this.extension);
    if (patchExtension!=null){ this.extension= new PatchBuilder(patchExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PatchExtensionNested<A> withNewPatchExtension() {
    return new NamedExtensionFluentImpl.PatchExtensionNestedImpl();
  }
  public NamedExtensionFluent.PatchExtensionNested<A> withNewPatchExtensionLike(Patch item) {
    return new NamedExtensionFluentImpl.PatchExtensionNestedImpl(item);
  }
  public A withLimitRangeExtension(LimitRange limitRangeExtension) {
    _visitables.get("extension").remove(this.extension);
    if (limitRangeExtension!=null){ this.extension= new LimitRangeBuilder(limitRangeExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.LimitRangeExtensionNested<A> withNewLimitRangeExtension() {
    return new NamedExtensionFluentImpl.LimitRangeExtensionNestedImpl();
  }
  public NamedExtensionFluent.LimitRangeExtensionNested<A> withNewLimitRangeExtensionLike(LimitRange item) {
    return new NamedExtensionFluentImpl.LimitRangeExtensionNestedImpl(item);
  }
  public A withAPIGroupListExtension(APIGroupList aPIGroupListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (aPIGroupListExtension!=null){ this.extension= new APIGroupListBuilder(aPIGroupListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.APIGroupListExtensionNested<A> withNewAPIGroupListExtension() {
    return new NamedExtensionFluentImpl.APIGroupListExtensionNestedImpl();
  }
  public NamedExtensionFluent.APIGroupListExtensionNested<A> withNewAPIGroupListExtensionLike(APIGroupList item) {
    return new NamedExtensionFluentImpl.APIGroupListExtensionNestedImpl(item);
  }
  public A withPortStatusExtension(PortStatus portStatusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (portStatusExtension!=null){ this.extension= new PortStatusBuilder(portStatusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PortStatusExtensionNested<A> withNewPortStatusExtension() {
    return new NamedExtensionFluentImpl.PortStatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.PortStatusExtensionNested<A> withNewPortStatusExtensionLike(PortStatus item) {
    return new NamedExtensionFluentImpl.PortStatusExtensionNestedImpl(item);
  }
  public A withNewPortStatusExtension(String error,Integer port,String protocol) {
    return (A)withPortStatusExtension(new PortStatus(error, port, protocol));
  }
  public A withPodTemplateSpecExtension(PodTemplateSpec podTemplateSpecExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podTemplateSpecExtension!=null){ this.extension= new PodTemplateSpecBuilder(podTemplateSpecExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodTemplateSpecExtensionNested<A> withNewPodTemplateSpecExtension() {
    return new NamedExtensionFluentImpl.PodTemplateSpecExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodTemplateSpecExtensionNested<A> withNewPodTemplateSpecExtensionLike(PodTemplateSpec item) {
    return new NamedExtensionFluentImpl.PodTemplateSpecExtensionNestedImpl(item);
  }
  public A withCSIPersistentVolumeSourceExtension(CSIPersistentVolumeSource cSIPersistentVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (cSIPersistentVolumeSourceExtension!=null){ this.extension= new CSIPersistentVolumeSourceBuilder(cSIPersistentVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.CSIPersistentVolumeSourceExtensionNested<A> withNewCSIPersistentVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.CSIPersistentVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.CSIPersistentVolumeSourceExtensionNested<A> withNewCSIPersistentVolumeSourceExtensionLike(CSIPersistentVolumeSource item) {
    return new NamedExtensionFluentImpl.CSIPersistentVolumeSourceExtensionNestedImpl(item);
  }
  public A withAuthInfoExtension(AuthInfo authInfoExtension) {
    _visitables.get("extension").remove(this.extension);
    if (authInfoExtension!=null){ this.extension= new AuthInfoBuilder(authInfoExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.AuthInfoExtensionNested<A> withNewAuthInfoExtension() {
    return new NamedExtensionFluentImpl.AuthInfoExtensionNestedImpl();
  }
  public NamedExtensionFluent.AuthInfoExtensionNested<A> withNewAuthInfoExtensionLike(AuthInfo item) {
    return new NamedExtensionFluentImpl.AuthInfoExtensionNestedImpl(item);
  }
  public A withAPIServiceExtension(APIService aPIServiceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (aPIServiceExtension!=null){ this.extension= new APIServiceBuilder(aPIServiceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.APIServiceExtensionNested<A> withNewAPIServiceExtension() {
    return new NamedExtensionFluentImpl.APIServiceExtensionNestedImpl();
  }
  public NamedExtensionFluent.APIServiceExtensionNested<A> withNewAPIServiceExtensionLike(APIService item) {
    return new NamedExtensionFluentImpl.APIServiceExtensionNestedImpl(item);
  }
  public A withResourceRequirementsExtension(ResourceRequirements resourceRequirementsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (resourceRequirementsExtension!=null){ this.extension= new ResourceRequirementsBuilder(resourceRequirementsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ResourceRequirementsExtensionNested<A> withNewResourceRequirementsExtension() {
    return new NamedExtensionFluentImpl.ResourceRequirementsExtensionNestedImpl();
  }
  public NamedExtensionFluent.ResourceRequirementsExtensionNested<A> withNewResourceRequirementsExtensionLike(ResourceRequirements item) {
    return new NamedExtensionFluentImpl.ResourceRequirementsExtensionNestedImpl(item);
  }
  public A withConfigMapKeySelectorExtension(ConfigMapKeySelector configMapKeySelectorExtension) {
    _visitables.get("extension").remove(this.extension);
    if (configMapKeySelectorExtension!=null){ this.extension= new ConfigMapKeySelectorBuilder(configMapKeySelectorExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ConfigMapKeySelectorExtensionNested<A> withNewConfigMapKeySelectorExtension() {
    return new NamedExtensionFluentImpl.ConfigMapKeySelectorExtensionNestedImpl();
  }
  public NamedExtensionFluent.ConfigMapKeySelectorExtensionNested<A> withNewConfigMapKeySelectorExtensionLike(ConfigMapKeySelector item) {
    return new NamedExtensionFluentImpl.ConfigMapKeySelectorExtensionNestedImpl(item);
  }
  public A withNewConfigMapKeySelectorExtension(String key,String name,Boolean optional) {
    return (A)withConfigMapKeySelectorExtension(new ConfigMapKeySelector(key, name, optional));
  }
  public A withHostPathVolumeSourceExtension(HostPathVolumeSource hostPathVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (hostPathVolumeSourceExtension!=null){ this.extension= new HostPathVolumeSourceBuilder(hostPathVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.HostPathVolumeSourceExtensionNested<A> withNewHostPathVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.HostPathVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.HostPathVolumeSourceExtensionNested<A> withNewHostPathVolumeSourceExtensionLike(HostPathVolumeSource item) {
    return new NamedExtensionFluentImpl.HostPathVolumeSourceExtensionNestedImpl(item);
  }
  public A withNewHostPathVolumeSourceExtension(String path,String type) {
    return (A)withHostPathVolumeSourceExtension(new HostPathVolumeSource(path, type));
  }
  public A withPersistentVolumeClaimListExtension(PersistentVolumeClaimList persistentVolumeClaimListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeClaimListExtension!=null){ this.extension= new PersistentVolumeClaimListBuilder(persistentVolumeClaimListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PersistentVolumeClaimListExtensionNested<A> withNewPersistentVolumeClaimListExtension() {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimListExtensionNestedImpl();
  }
  public NamedExtensionFluent.PersistentVolumeClaimListExtensionNested<A> withNewPersistentVolumeClaimListExtensionLike(PersistentVolumeClaimList item) {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimListExtensionNestedImpl(item);
  }
  public A withNamedContextExtension(NamedContext namedContextExtension) {
    _visitables.get("extension").remove(this.extension);
    if (namedContextExtension!=null){ this.extension= new NamedContextBuilder(namedContextExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NamedContextExtensionNested<A> withNewNamedContextExtension() {
    return new NamedExtensionFluentImpl.NamedContextExtensionNestedImpl();
  }
  public NamedExtensionFluent.NamedContextExtensionNested<A> withNewNamedContextExtensionLike(NamedContext item) {
    return new NamedExtensionFluentImpl.NamedContextExtensionNestedImpl(item);
  }
  public A withConfigExtension(Config configExtension) {
    _visitables.get("extension").remove(this.extension);
    if (configExtension!=null){ this.extension= new ConfigBuilder(configExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ConfigExtensionNested<A> withNewConfigExtension() {
    return new NamedExtensionFluentImpl.ConfigExtensionNestedImpl();
  }
  public NamedExtensionFluent.ConfigExtensionNested<A> withNewConfigExtensionLike(Config item) {
    return new NamedExtensionFluentImpl.ConfigExtensionNestedImpl(item);
  }
  public A withAffinityExtension(Affinity affinityExtension) {
    _visitables.get("extension").remove(this.extension);
    if (affinityExtension!=null){ this.extension= new AffinityBuilder(affinityExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.AffinityExtensionNested<A> withNewAffinityExtension() {
    return new NamedExtensionFluentImpl.AffinityExtensionNestedImpl();
  }
  public NamedExtensionFluent.AffinityExtensionNested<A> withNewAffinityExtensionLike(Affinity item) {
    return new NamedExtensionFluentImpl.AffinityExtensionNestedImpl(item);
  }
  public A withPodResourceClaimExtension(PodResourceClaim podResourceClaimExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podResourceClaimExtension!=null){ this.extension= new PodResourceClaimBuilder(podResourceClaimExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodResourceClaimExtensionNested<A> withNewPodResourceClaimExtension() {
    return new NamedExtensionFluentImpl.PodResourceClaimExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodResourceClaimExtensionNested<A> withNewPodResourceClaimExtensionLike(PodResourceClaim item) {
    return new NamedExtensionFluentImpl.PodResourceClaimExtensionNestedImpl(item);
  }
  public A withReplicationControllerStatusExtension(ReplicationControllerStatus replicationControllerStatusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (replicationControllerStatusExtension!=null){ this.extension= new ReplicationControllerStatusBuilder(replicationControllerStatusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ReplicationControllerStatusExtensionNested<A> withNewReplicationControllerStatusExtension() {
    return new NamedExtensionFluentImpl.ReplicationControllerStatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.ReplicationControllerStatusExtensionNested<A> withNewReplicationControllerStatusExtensionLike(ReplicationControllerStatus item) {
    return new NamedExtensionFluentImpl.ReplicationControllerStatusExtensionNestedImpl(item);
  }
  public A withAPIServiceStatusExtension(APIServiceStatus aPIServiceStatusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (aPIServiceStatusExtension!=null){ this.extension= new APIServiceStatusBuilder(aPIServiceStatusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.APIServiceStatusExtensionNested<A> withNewAPIServiceStatusExtension() {
    return new NamedExtensionFluentImpl.APIServiceStatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.APIServiceStatusExtensionNested<A> withNewAPIServiceStatusExtensionLike(APIServiceStatus item) {
    return new NamedExtensionFluentImpl.APIServiceStatusExtensionNestedImpl(item);
  }
  public A withMicroTimeExtension(MicroTime microTimeExtension) {
    _visitables.get("extension").remove(this.extension);
    if (microTimeExtension!=null){ this.extension= new MicroTimeBuilder(microTimeExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.MicroTimeExtensionNested<A> withNewMicroTimeExtension() {
    return new NamedExtensionFluentImpl.MicroTimeExtensionNestedImpl();
  }
  public NamedExtensionFluent.MicroTimeExtensionNested<A> withNewMicroTimeExtensionLike(MicroTime item) {
    return new NamedExtensionFluentImpl.MicroTimeExtensionNestedImpl(item);
  }
  public A withNewMicroTimeExtension(String time) {
    return (A)withMicroTimeExtension(new MicroTime(time));
  }
  public A withLifecycleExtension(Lifecycle lifecycleExtension) {
    _visitables.get("extension").remove(this.extension);
    if (lifecycleExtension!=null){ this.extension= new LifecycleBuilder(lifecycleExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.LifecycleExtensionNested<A> withNewLifecycleExtension() {
    return new NamedExtensionFluentImpl.LifecycleExtensionNestedImpl();
  }
  public NamedExtensionFluent.LifecycleExtensionNested<A> withNewLifecycleExtensionLike(Lifecycle item) {
    return new NamedExtensionFluentImpl.LifecycleExtensionNestedImpl(item);
  }
  public A withPortworxVolumeSourceExtension(PortworxVolumeSource portworxVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (portworxVolumeSourceExtension!=null){ this.extension= new PortworxVolumeSourceBuilder(portworxVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PortworxVolumeSourceExtensionNested<A> withNewPortworxVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.PortworxVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.PortworxVolumeSourceExtensionNested<A> withNewPortworxVolumeSourceExtensionLike(PortworxVolumeSource item) {
    return new NamedExtensionFluentImpl.PortworxVolumeSourceExtensionNestedImpl(item);
  }
  public A withNewPortworxVolumeSourceExtension(String fsType,Boolean readOnly,String volumeID) {
    return (A)withPortworxVolumeSourceExtension(new PortworxVolumeSource(fsType, readOnly, volumeID));
  }
  public A withEventSourceExtension(EventSource eventSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (eventSourceExtension!=null){ this.extension= new EventSourceBuilder(eventSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EventSourceExtensionNested<A> withNewEventSourceExtension() {
    return new NamedExtensionFluentImpl.EventSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.EventSourceExtensionNested<A> withNewEventSourceExtensionLike(EventSource item) {
    return new NamedExtensionFluentImpl.EventSourceExtensionNestedImpl(item);
  }
  public A withNewEventSourceExtension(String component,String host) {
    return (A)withEventSourceExtension(new EventSource(component, host));
  }
  public A withGRPCActionExtension(GRPCAction gRPCActionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (gRPCActionExtension!=null){ this.extension= new GRPCActionBuilder(gRPCActionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.GRPCActionExtensionNested<A> withNewGRPCActionExtension() {
    return new NamedExtensionFluentImpl.GRPCActionExtensionNestedImpl();
  }
  public NamedExtensionFluent.GRPCActionExtensionNested<A> withNewGRPCActionExtensionLike(GRPCAction item) {
    return new NamedExtensionFluentImpl.GRPCActionExtensionNestedImpl(item);
  }
  public A withNewGRPCActionExtension(Integer port,String service) {
    return (A)withGRPCActionExtension(new GRPCAction(port, service));
  }
  public A withAzureFileVolumeSourceExtension(AzureFileVolumeSource azureFileVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (azureFileVolumeSourceExtension!=null){ this.extension= new AzureFileVolumeSourceBuilder(azureFileVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.AzureFileVolumeSourceExtensionNested<A> withNewAzureFileVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.AzureFileVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.AzureFileVolumeSourceExtensionNested<A> withNewAzureFileVolumeSourceExtensionLike(AzureFileVolumeSource item) {
    return new NamedExtensionFluentImpl.AzureFileVolumeSourceExtensionNestedImpl(item);
  }
  public A withNewAzureFileVolumeSourceExtension(Boolean readOnly,String secretName,String shareName) {
    return (A)withAzureFileVolumeSourceExtension(new AzureFileVolumeSource(readOnly, secretName, shareName));
  }
  public A withResourceClaimExtension(ResourceClaim resourceClaimExtension) {
    _visitables.get("extension").remove(this.extension);
    if (resourceClaimExtension!=null){ this.extension= new ResourceClaimBuilder(resourceClaimExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ResourceClaimExtensionNested<A> withNewResourceClaimExtension() {
    return new NamedExtensionFluentImpl.ResourceClaimExtensionNestedImpl();
  }
  public NamedExtensionFluent.ResourceClaimExtensionNested<A> withNewResourceClaimExtensionLike(ResourceClaim item) {
    return new NamedExtensionFluentImpl.ResourceClaimExtensionNestedImpl(item);
  }
  public A withNewResourceClaimExtension(String name) {
    return (A)withResourceClaimExtension(new ResourceClaim(name));
  }
  public A withComponentConditionExtension(ComponentCondition componentConditionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (componentConditionExtension!=null){ this.extension= new ComponentConditionBuilder(componentConditionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ComponentConditionExtensionNested<A> withNewComponentConditionExtension() {
    return new NamedExtensionFluentImpl.ComponentConditionExtensionNestedImpl();
  }
  public NamedExtensionFluent.ComponentConditionExtensionNested<A> withNewComponentConditionExtensionLike(ComponentCondition item) {
    return new NamedExtensionFluentImpl.ComponentConditionExtensionNestedImpl(item);
  }
  public A withNewComponentConditionExtension(String error,String message,String status,String type) {
    return (A)withComponentConditionExtension(new ComponentCondition(error, message, status, type));
  }
  public A withEnvVarExtension(EnvVar envVarExtension) {
    _visitables.get("extension").remove(this.extension);
    if (envVarExtension!=null){ this.extension= new EnvVarBuilder(envVarExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EnvVarExtensionNested<A> withNewEnvVarExtension() {
    return new NamedExtensionFluentImpl.EnvVarExtensionNestedImpl();
  }
  public NamedExtensionFluent.EnvVarExtensionNested<A> withNewEnvVarExtensionLike(EnvVar item) {
    return new NamedExtensionFluentImpl.EnvVarExtensionNestedImpl(item);
  }
  public A withReplicationControllerSpecExtension(ReplicationControllerSpec replicationControllerSpecExtension) {
    _visitables.get("extension").remove(this.extension);
    if (replicationControllerSpecExtension!=null){ this.extension= new ReplicationControllerSpecBuilder(replicationControllerSpecExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ReplicationControllerSpecExtensionNested<A> withNewReplicationControllerSpecExtension() {
    return new NamedExtensionFluentImpl.ReplicationControllerSpecExtensionNestedImpl();
  }
  public NamedExtensionFluent.ReplicationControllerSpecExtensionNested<A> withNewReplicationControllerSpecExtensionLike(ReplicationControllerSpec item) {
    return new NamedExtensionFluentImpl.ReplicationControllerSpecExtensionNestedImpl(item);
  }
  public A withLoadBalancerIngressExtension(LoadBalancerIngress loadBalancerIngressExtension) {
    _visitables.get("extension").remove(this.extension);
    if (loadBalancerIngressExtension!=null){ this.extension= new LoadBalancerIngressBuilder(loadBalancerIngressExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.LoadBalancerIngressExtensionNested<A> withNewLoadBalancerIngressExtension() {
    return new NamedExtensionFluentImpl.LoadBalancerIngressExtensionNestedImpl();
  }
  public NamedExtensionFluent.LoadBalancerIngressExtensionNested<A> withNewLoadBalancerIngressExtensionLike(LoadBalancerIngress item) {
    return new NamedExtensionFluentImpl.LoadBalancerIngressExtensionNestedImpl(item);
  }
  public A withAttachedVolumeExtension(AttachedVolume attachedVolumeExtension) {
    _visitables.get("extension").remove(this.extension);
    if (attachedVolumeExtension!=null){ this.extension= new AttachedVolumeBuilder(attachedVolumeExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.AttachedVolumeExtensionNested<A> withNewAttachedVolumeExtension() {
    return new NamedExtensionFluentImpl.AttachedVolumeExtensionNestedImpl();
  }
  public NamedExtensionFluent.AttachedVolumeExtensionNested<A> withNewAttachedVolumeExtensionLike(AttachedVolume item) {
    return new NamedExtensionFluentImpl.AttachedVolumeExtensionNestedImpl(item);
  }
  public A withNewAttachedVolumeExtension(String devicePath,String name) {
    return (A)withAttachedVolumeExtension(new AttachedVolume(devicePath, name));
  }
  public A withLocalObjectReferenceExtension(LocalObjectReference localObjectReferenceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (localObjectReferenceExtension!=null){ this.extension= new LocalObjectReferenceBuilder(localObjectReferenceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.LocalObjectReferenceExtensionNested<A> withNewLocalObjectReferenceExtension() {
    return new NamedExtensionFluentImpl.LocalObjectReferenceExtensionNestedImpl();
  }
  public NamedExtensionFluent.LocalObjectReferenceExtensionNested<A> withNewLocalObjectReferenceExtensionLike(LocalObjectReference item) {
    return new NamedExtensionFluentImpl.LocalObjectReferenceExtensionNestedImpl(item);
  }
  public A withNewLocalObjectReferenceExtension(String name) {
    return (A)withLocalObjectReferenceExtension(new LocalObjectReference(name));
  }
  public A withNamedAuthInfoExtension(NamedAuthInfo namedAuthInfoExtension) {
    _visitables.get("extension").remove(this.extension);
    if (namedAuthInfoExtension!=null){ this.extension= new NamedAuthInfoBuilder(namedAuthInfoExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NamedAuthInfoExtensionNested<A> withNewNamedAuthInfoExtension() {
    return new NamedExtensionFluentImpl.NamedAuthInfoExtensionNestedImpl();
  }
  public NamedExtensionFluent.NamedAuthInfoExtensionNested<A> withNewNamedAuthInfoExtensionLike(NamedAuthInfo item) {
    return new NamedExtensionFluentImpl.NamedAuthInfoExtensionNestedImpl(item);
  }
  public A withEmptyDirVolumeSourceExtension(EmptyDirVolumeSource emptyDirVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (emptyDirVolumeSourceExtension!=null){ this.extension= new EmptyDirVolumeSourceBuilder(emptyDirVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EmptyDirVolumeSourceExtensionNested<A> withNewEmptyDirVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.EmptyDirVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.EmptyDirVolumeSourceExtensionNested<A> withNewEmptyDirVolumeSourceExtensionLike(EmptyDirVolumeSource item) {
    return new NamedExtensionFluentImpl.EmptyDirVolumeSourceExtensionNestedImpl(item);
  }
  public A withPodSpecExtension(PodSpec podSpecExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podSpecExtension!=null){ this.extension= new PodSpecBuilder(podSpecExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodSpecExtensionNested<A> withNewPodSpecExtension() {
    return new NamedExtensionFluentImpl.PodSpecExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodSpecExtensionNested<A> withNewPodSpecExtensionLike(PodSpec item) {
    return new NamedExtensionFluentImpl.PodSpecExtensionNestedImpl(item);
  }
  public A withServerAddressByClientCIDRExtension(ServerAddressByClientCIDR serverAddressByClientCIDRExtension) {
    _visitables.get("extension").remove(this.extension);
    if (serverAddressByClientCIDRExtension!=null){ this.extension= new ServerAddressByClientCIDRBuilder(serverAddressByClientCIDRExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ServerAddressByClientCIDRExtensionNested<A> withNewServerAddressByClientCIDRExtension() {
    return new NamedExtensionFluentImpl.ServerAddressByClientCIDRExtensionNestedImpl();
  }
  public NamedExtensionFluent.ServerAddressByClientCIDRExtensionNested<A> withNewServerAddressByClientCIDRExtensionLike(ServerAddressByClientCIDR item) {
    return new NamedExtensionFluentImpl.ServerAddressByClientCIDRExtensionNestedImpl(item);
  }
  public A withNewServerAddressByClientCIDRExtension(String clientCIDR,String serverAddress) {
    return (A)withServerAddressByClientCIDRExtension(new ServerAddressByClientCIDR(clientCIDR, serverAddress));
  }
  public A withAzureDiskVolumeSourceExtension(AzureDiskVolumeSource azureDiskVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (azureDiskVolumeSourceExtension!=null){ this.extension= new AzureDiskVolumeSourceBuilder(azureDiskVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.AzureDiskVolumeSourceExtensionNested<A> withNewAzureDiskVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.AzureDiskVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.AzureDiskVolumeSourceExtensionNested<A> withNewAzureDiskVolumeSourceExtensionLike(AzureDiskVolumeSource item) {
    return new NamedExtensionFluentImpl.AzureDiskVolumeSourceExtensionNestedImpl(item);
  }
  public A withPreconditionsExtension(Preconditions preconditionsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (preconditionsExtension!=null){ this.extension= new PreconditionsBuilder(preconditionsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PreconditionsExtensionNested<A> withNewPreconditionsExtension() {
    return new NamedExtensionFluentImpl.PreconditionsExtensionNestedImpl();
  }
  public NamedExtensionFluent.PreconditionsExtensionNested<A> withNewPreconditionsExtensionLike(Preconditions item) {
    return new NamedExtensionFluentImpl.PreconditionsExtensionNestedImpl(item);
  }
  public A withNewPreconditionsExtension(String resourceVersion,String uid) {
    return (A)withPreconditionsExtension(new Preconditions(resourceVersion, uid));
  }
  public A withInfoExtension(Info infoExtension) {
    _visitables.get("extension").remove(this.extension);
    if (infoExtension!=null){ this.extension= new InfoBuilder(infoExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.InfoExtensionNested<A> withNewInfoExtension() {
    return new NamedExtensionFluentImpl.InfoExtensionNestedImpl();
  }
  public NamedExtensionFluent.InfoExtensionNested<A> withNewInfoExtensionLike(Info item) {
    return new NamedExtensionFluentImpl.InfoExtensionNestedImpl(item);
  }
  public A withCephFSVolumeSourceExtension(CephFSVolumeSource cephFSVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (cephFSVolumeSourceExtension!=null){ this.extension= new CephFSVolumeSourceBuilder(cephFSVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.CephFSVolumeSourceExtensionNested<A> withNewCephFSVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.CephFSVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.CephFSVolumeSourceExtensionNested<A> withNewCephFSVolumeSourceExtensionLike(CephFSVolumeSource item) {
    return new NamedExtensionFluentImpl.CephFSVolumeSourceExtensionNestedImpl(item);
  }
  public A withEphemeralContainerExtension(EphemeralContainer ephemeralContainerExtension) {
    _visitables.get("extension").remove(this.extension);
    if (ephemeralContainerExtension!=null){ this.extension= new EphemeralContainerBuilder(ephemeralContainerExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EphemeralContainerExtensionNested<A> withNewEphemeralContainerExtension() {
    return new NamedExtensionFluentImpl.EphemeralContainerExtensionNestedImpl();
  }
  public NamedExtensionFluent.EphemeralContainerExtensionNested<A> withNewEphemeralContainerExtensionLike(EphemeralContainer item) {
    return new NamedExtensionFluentImpl.EphemeralContainerExtensionNestedImpl(item);
  }
  public A withNodeConditionExtension(NodeCondition nodeConditionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nodeConditionExtension!=null){ this.extension= new NodeConditionBuilder(nodeConditionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NodeConditionExtensionNested<A> withNewNodeConditionExtension() {
    return new NamedExtensionFluentImpl.NodeConditionExtensionNestedImpl();
  }
  public NamedExtensionFluent.NodeConditionExtensionNested<A> withNewNodeConditionExtensionLike(NodeCondition item) {
    return new NamedExtensionFluentImpl.NodeConditionExtensionNestedImpl(item);
  }
  public A withEndpointSubsetExtension(EndpointSubset endpointSubsetExtension) {
    _visitables.get("extension").remove(this.extension);
    if (endpointSubsetExtension!=null){ this.extension= new EndpointSubsetBuilder(endpointSubsetExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EndpointSubsetExtensionNested<A> withNewEndpointSubsetExtension() {
    return new NamedExtensionFluentImpl.EndpointSubsetExtensionNestedImpl();
  }
  public NamedExtensionFluent.EndpointSubsetExtensionNested<A> withNewEndpointSubsetExtensionLike(EndpointSubset item) {
    return new NamedExtensionFluentImpl.EndpointSubsetExtensionNestedImpl(item);
  }
  public A withLocalVolumeSourceExtension(LocalVolumeSource localVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (localVolumeSourceExtension!=null){ this.extension= new LocalVolumeSourceBuilder(localVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.LocalVolumeSourceExtensionNested<A> withNewLocalVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.LocalVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.LocalVolumeSourceExtensionNested<A> withNewLocalVolumeSourceExtensionLike(LocalVolumeSource item) {
    return new NamedExtensionFluentImpl.LocalVolumeSourceExtensionNestedImpl(item);
  }
  public A withNewLocalVolumeSourceExtension(String fsType,String path) {
    return (A)withLocalVolumeSourceExtension(new LocalVolumeSource(fsType, path));
  }
  public A withServiceReferenceExtension(ServiceReference serviceReferenceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (serviceReferenceExtension!=null){ this.extension= new ServiceReferenceBuilder(serviceReferenceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ServiceReferenceExtensionNested<A> withNewServiceReferenceExtension() {
    return new NamedExtensionFluentImpl.ServiceReferenceExtensionNestedImpl();
  }
  public NamedExtensionFluent.ServiceReferenceExtensionNested<A> withNewServiceReferenceExtensionLike(ServiceReference item) {
    return new NamedExtensionFluentImpl.ServiceReferenceExtensionNestedImpl(item);
  }
  public A withNewServiceReferenceExtension(String name,String namespace,Integer port) {
    return (A)withServiceReferenceExtension(new ServiceReference(name, namespace, port));
  }
  public A withServiceStatusExtension(ServiceStatus serviceStatusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (serviceStatusExtension!=null){ this.extension= new ServiceStatusBuilder(serviceStatusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ServiceStatusExtensionNested<A> withNewServiceStatusExtension() {
    return new NamedExtensionFluentImpl.ServiceStatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.ServiceStatusExtensionNested<A> withNewServiceStatusExtensionLike(ServiceStatus item) {
    return new NamedExtensionFluentImpl.ServiceStatusExtensionNestedImpl(item);
  }
  public A withTaintExtension(Taint taintExtension) {
    _visitables.get("extension").remove(this.extension);
    if (taintExtension!=null){ this.extension= new TaintBuilder(taintExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.TaintExtensionNested<A> withNewTaintExtension() {
    return new NamedExtensionFluentImpl.TaintExtensionNestedImpl();
  }
  public NamedExtensionFluent.TaintExtensionNested<A> withNewTaintExtensionLike(Taint item) {
    return new NamedExtensionFluentImpl.TaintExtensionNestedImpl(item);
  }
  public A withNewTaintExtension(String effect,String key,String timeAdded,String value) {
    return (A)withTaintExtension(new Taint(effect, key, timeAdded, value));
  }
  public A withPatchOptionsExtension(PatchOptions patchOptionsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (patchOptionsExtension!=null){ this.extension= new PatchOptionsBuilder(patchOptionsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PatchOptionsExtensionNested<A> withNewPatchOptionsExtension() {
    return new NamedExtensionFluentImpl.PatchOptionsExtensionNestedImpl();
  }
  public NamedExtensionFluent.PatchOptionsExtensionNested<A> withNewPatchOptionsExtensionLike(PatchOptions item) {
    return new NamedExtensionFluentImpl.PatchOptionsExtensionNestedImpl(item);
  }
  public A withConfigMapNodeConfigSourceExtension(ConfigMapNodeConfigSource configMapNodeConfigSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (configMapNodeConfigSourceExtension!=null){ this.extension= new ConfigMapNodeConfigSourceBuilder(configMapNodeConfigSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ConfigMapNodeConfigSourceExtensionNested<A> withNewConfigMapNodeConfigSourceExtension() {
    return new NamedExtensionFluentImpl.ConfigMapNodeConfigSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.ConfigMapNodeConfigSourceExtensionNested<A> withNewConfigMapNodeConfigSourceExtensionLike(ConfigMapNodeConfigSource item) {
    return new NamedExtensionFluentImpl.ConfigMapNodeConfigSourceExtensionNestedImpl(item);
  }
  public A withNewConfigMapNodeConfigSourceExtension(String kubeletConfigKey,String name,String namespace,String resourceVersion,String uid) {
    return (A)withConfigMapNodeConfigSourceExtension(new ConfigMapNodeConfigSource(kubeletConfigKey, name, namespace, resourceVersion, uid));
  }
  public A withHTTPGetActionExtension(HTTPGetAction hTTPGetActionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (hTTPGetActionExtension!=null){ this.extension= new HTTPGetActionBuilder(hTTPGetActionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.HTTPGetActionExtensionNested<A> withNewHTTPGetActionExtension() {
    return new NamedExtensionFluentImpl.HTTPGetActionExtensionNestedImpl();
  }
  public NamedExtensionFluent.HTTPGetActionExtensionNested<A> withNewHTTPGetActionExtensionLike(HTTPGetAction item) {
    return new NamedExtensionFluentImpl.HTTPGetActionExtensionNestedImpl(item);
  }
  public A withGlusterfsPersistentVolumeSourceExtension(GlusterfsPersistentVolumeSource glusterfsPersistentVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (glusterfsPersistentVolumeSourceExtension!=null){ this.extension= new GlusterfsPersistentVolumeSourceBuilder(glusterfsPersistentVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.GlusterfsPersistentVolumeSourceExtensionNested<A> withNewGlusterfsPersistentVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.GlusterfsPersistentVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.GlusterfsPersistentVolumeSourceExtensionNested<A> withNewGlusterfsPersistentVolumeSourceExtensionLike(GlusterfsPersistentVolumeSource item) {
    return new NamedExtensionFluentImpl.GlusterfsPersistentVolumeSourceExtensionNestedImpl(item);
  }
  public A withNewGlusterfsPersistentVolumeSourceExtension(String endpoints,String endpointsNamespace,String path,Boolean readOnly) {
    return (A)withGlusterfsPersistentVolumeSourceExtension(new GlusterfsPersistentVolumeSource(endpoints, endpointsNamespace, path, readOnly));
  }
  public A withDownwardAPIVolumeSourceExtension(DownwardAPIVolumeSource downwardAPIVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (downwardAPIVolumeSourceExtension!=null){ this.extension= new DownwardAPIVolumeSourceBuilder(downwardAPIVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.DownwardAPIVolumeSourceExtensionNested<A> withNewDownwardAPIVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.DownwardAPIVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.DownwardAPIVolumeSourceExtensionNested<A> withNewDownwardAPIVolumeSourceExtensionLike(DownwardAPIVolumeSource item) {
    return new NamedExtensionFluentImpl.DownwardAPIVolumeSourceExtensionNestedImpl(item);
  }
  public A withISCSIPersistentVolumeSourceExtension(ISCSIPersistentVolumeSource iSCSIPersistentVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (iSCSIPersistentVolumeSourceExtension!=null){ this.extension= new ISCSIPersistentVolumeSourceBuilder(iSCSIPersistentVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ISCSIPersistentVolumeSourceExtensionNested<A> withNewISCSIPersistentVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.ISCSIPersistentVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.ISCSIPersistentVolumeSourceExtensionNested<A> withNewISCSIPersistentVolumeSourceExtensionLike(ISCSIPersistentVolumeSource item) {
    return new NamedExtensionFluentImpl.ISCSIPersistentVolumeSourceExtensionNestedImpl(item);
  }
  public A withWindowsSecurityContextOptionsExtension(WindowsSecurityContextOptions windowsSecurityContextOptionsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (windowsSecurityContextOptionsExtension!=null){ this.extension= new WindowsSecurityContextOptionsBuilder(windowsSecurityContextOptionsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.WindowsSecurityContextOptionsExtensionNested<A> withNewWindowsSecurityContextOptionsExtension() {
    return new NamedExtensionFluentImpl.WindowsSecurityContextOptionsExtensionNestedImpl();
  }
  public NamedExtensionFluent.WindowsSecurityContextOptionsExtensionNested<A> withNewWindowsSecurityContextOptionsExtensionLike(WindowsSecurityContextOptions item) {
    return new NamedExtensionFluentImpl.WindowsSecurityContextOptionsExtensionNestedImpl(item);
  }
  public A withNewWindowsSecurityContextOptionsExtension(String gmsaCredentialSpec,String gmsaCredentialSpecName,Boolean hostProcess,String runAsUserName) {
    return (A)withWindowsSecurityContextOptionsExtension(new WindowsSecurityContextOptions(gmsaCredentialSpec, gmsaCredentialSpecName, hostProcess, runAsUserName));
  }
  public A withCreateOptionsExtension(CreateOptions createOptionsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (createOptionsExtension!=null){ this.extension= new CreateOptionsBuilder(createOptionsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.CreateOptionsExtensionNested<A> withNewCreateOptionsExtension() {
    return new NamedExtensionFluentImpl.CreateOptionsExtensionNestedImpl();
  }
  public NamedExtensionFluent.CreateOptionsExtensionNested<A> withNewCreateOptionsExtensionLike(CreateOptions item) {
    return new NamedExtensionFluentImpl.CreateOptionsExtensionNestedImpl(item);
  }
  public A withEnvFromSourceExtension(EnvFromSource envFromSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (envFromSourceExtension!=null){ this.extension= new EnvFromSourceBuilder(envFromSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EnvFromSourceExtensionNested<A> withNewEnvFromSourceExtension() {
    return new NamedExtensionFluentImpl.EnvFromSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.EnvFromSourceExtensionNested<A> withNewEnvFromSourceExtensionLike(EnvFromSource item) {
    return new NamedExtensionFluentImpl.EnvFromSourceExtensionNestedImpl(item);
  }
  public A withNamespaceSpecExtension(NamespaceSpec namespaceSpecExtension) {
    _visitables.get("extension").remove(this.extension);
    if (namespaceSpecExtension!=null){ this.extension= new NamespaceSpecBuilder(namespaceSpecExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NamespaceSpecExtensionNested<A> withNewNamespaceSpecExtension() {
    return new NamedExtensionFluentImpl.NamespaceSpecExtensionNestedImpl();
  }
  public NamedExtensionFluent.NamespaceSpecExtensionNested<A> withNewNamespaceSpecExtensionLike(NamespaceSpec item) {
    return new NamedExtensionFluentImpl.NamespaceSpecExtensionNestedImpl(item);
  }
  public A withTypeMetaExtension(TypeMeta typeMetaExtension) {
    _visitables.get("extension").remove(this.extension);
    if (typeMetaExtension!=null){ this.extension= new TypeMetaBuilder(typeMetaExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.TypeMetaExtensionNested<A> withNewTypeMetaExtension() {
    return new NamedExtensionFluentImpl.TypeMetaExtensionNestedImpl();
  }
  public NamedExtensionFluent.TypeMetaExtensionNested<A> withNewTypeMetaExtensionLike(TypeMeta item) {
    return new NamedExtensionFluentImpl.TypeMetaExtensionNestedImpl(item);
  }
  public A withNewTypeMetaExtension(String apiVersion,String kind) {
    return (A)withTypeMetaExtension(new TypeMeta(apiVersion, kind));
  }
  public A withRootPathsExtension(RootPaths rootPathsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (rootPathsExtension!=null){ this.extension= new RootPathsBuilder(rootPathsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.RootPathsExtensionNested<A> withNewRootPathsExtension() {
    return new NamedExtensionFluentImpl.RootPathsExtensionNestedImpl();
  }
  public NamedExtensionFluent.RootPathsExtensionNested<A> withNewRootPathsExtensionLike(RootPaths item) {
    return new NamedExtensionFluentImpl.RootPathsExtensionNestedImpl(item);
  }
  public A withListMetaExtension(ListMeta listMetaExtension) {
    _visitables.get("extension").remove(this.extension);
    if (listMetaExtension!=null){ this.extension= new ListMetaBuilder(listMetaExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ListMetaExtensionNested<A> withNewListMetaExtension() {
    return new NamedExtensionFluentImpl.ListMetaExtensionNestedImpl();
  }
  public NamedExtensionFluent.ListMetaExtensionNested<A> withNewListMetaExtensionLike(ListMeta item) {
    return new NamedExtensionFluentImpl.ListMetaExtensionNestedImpl(item);
  }
  public A withNewListMetaExtension(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withListMetaExtension(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public A withSecretReferenceExtension(SecretReference secretReferenceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (secretReferenceExtension!=null){ this.extension= new SecretReferenceBuilder(secretReferenceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.SecretReferenceExtensionNested<A> withNewSecretReferenceExtension() {
    return new NamedExtensionFluentImpl.SecretReferenceExtensionNestedImpl();
  }
  public NamedExtensionFluent.SecretReferenceExtensionNested<A> withNewSecretReferenceExtensionLike(SecretReference item) {
    return new NamedExtensionFluentImpl.SecretReferenceExtensionNestedImpl(item);
  }
  public A withNewSecretReferenceExtension(String name,String namespace) {
    return (A)withSecretReferenceExtension(new SecretReference(name, namespace));
  }
  public A withAPIGroupExtension(APIGroup aPIGroupExtension) {
    _visitables.get("extension").remove(this.extension);
    if (aPIGroupExtension!=null){ this.extension= new APIGroupBuilder(aPIGroupExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.APIGroupExtensionNested<A> withNewAPIGroupExtension() {
    return new NamedExtensionFluentImpl.APIGroupExtensionNestedImpl();
  }
  public NamedExtensionFluent.APIGroupExtensionNested<A> withNewAPIGroupExtensionLike(APIGroup item) {
    return new NamedExtensionFluentImpl.APIGroupExtensionNestedImpl(item);
  }
  public A withFlexVolumeSourceExtension(FlexVolumeSource flexVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (flexVolumeSourceExtension!=null){ this.extension= new FlexVolumeSourceBuilder(flexVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.FlexVolumeSourceExtensionNested<A> withNewFlexVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.FlexVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.FlexVolumeSourceExtensionNested<A> withNewFlexVolumeSourceExtensionLike(FlexVolumeSource item) {
    return new NamedExtensionFluentImpl.FlexVolumeSourceExtensionNestedImpl(item);
  }
  public A withPersistentVolumeClaimTemplateExtension(PersistentVolumeClaimTemplate persistentVolumeClaimTemplateExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeClaimTemplateExtension!=null){ this.extension= new PersistentVolumeClaimTemplateBuilder(persistentVolumeClaimTemplateExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PersistentVolumeClaimTemplateExtensionNested<A> withNewPersistentVolumeClaimTemplateExtension() {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimTemplateExtensionNestedImpl();
  }
  public NamedExtensionFluent.PersistentVolumeClaimTemplateExtensionNested<A> withNewPersistentVolumeClaimTemplateExtensionLike(PersistentVolumeClaimTemplate item) {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimTemplateExtensionNestedImpl(item);
  }
  public A withISCSIVolumeSourceExtension(ISCSIVolumeSource iSCSIVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (iSCSIVolumeSourceExtension!=null){ this.extension= new ISCSIVolumeSourceBuilder(iSCSIVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ISCSIVolumeSourceExtensionNested<A> withNewISCSIVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.ISCSIVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.ISCSIVolumeSourceExtensionNested<A> withNewISCSIVolumeSourceExtensionLike(ISCSIVolumeSource item) {
    return new NamedExtensionFluentImpl.ISCSIVolumeSourceExtensionNestedImpl(item);
  }
  public A withSecretKeySelectorExtension(SecretKeySelector secretKeySelectorExtension) {
    _visitables.get("extension").remove(this.extension);
    if (secretKeySelectorExtension!=null){ this.extension= new SecretKeySelectorBuilder(secretKeySelectorExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.SecretKeySelectorExtensionNested<A> withNewSecretKeySelectorExtension() {
    return new NamedExtensionFluentImpl.SecretKeySelectorExtensionNestedImpl();
  }
  public NamedExtensionFluent.SecretKeySelectorExtensionNested<A> withNewSecretKeySelectorExtensionLike(SecretKeySelector item) {
    return new NamedExtensionFluentImpl.SecretKeySelectorExtensionNestedImpl(item);
  }
  public A withNewSecretKeySelectorExtension(String key,String name,Boolean optional) {
    return (A)withSecretKeySelectorExtension(new SecretKeySelector(key, name, optional));
  }
  public A withRBDVolumeSourceExtension(RBDVolumeSource rBDVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (rBDVolumeSourceExtension!=null){ this.extension= new RBDVolumeSourceBuilder(rBDVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.RBDVolumeSourceExtensionNested<A> withNewRBDVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.RBDVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.RBDVolumeSourceExtensionNested<A> withNewRBDVolumeSourceExtensionLike(RBDVolumeSource item) {
    return new NamedExtensionFluentImpl.RBDVolumeSourceExtensionNestedImpl(item);
  }
  public A withNodeConfigStatusExtension(NodeConfigStatus nodeConfigStatusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nodeConfigStatusExtension!=null){ this.extension= new NodeConfigStatusBuilder(nodeConfigStatusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NodeConfigStatusExtensionNested<A> withNewNodeConfigStatusExtension() {
    return new NamedExtensionFluentImpl.NodeConfigStatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.NodeConfigStatusExtensionNested<A> withNewNodeConfigStatusExtensionLike(NodeConfigStatus item) {
    return new NamedExtensionFluentImpl.NodeConfigStatusExtensionNestedImpl(item);
  }
  public A withResourceQuotaListExtension(ResourceQuotaList resourceQuotaListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (resourceQuotaListExtension!=null){ this.extension= new ResourceQuotaListBuilder(resourceQuotaListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ResourceQuotaListExtensionNested<A> withNewResourceQuotaListExtension() {
    return new NamedExtensionFluentImpl.ResourceQuotaListExtensionNestedImpl();
  }
  public NamedExtensionFluent.ResourceQuotaListExtensionNested<A> withNewResourceQuotaListExtensionLike(ResourceQuotaList item) {
    return new NamedExtensionFluentImpl.ResourceQuotaListExtensionNestedImpl(item);
  }
  public A withQuobyteVolumeSourceExtension(QuobyteVolumeSource quobyteVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (quobyteVolumeSourceExtension!=null){ this.extension= new QuobyteVolumeSourceBuilder(quobyteVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.QuobyteVolumeSourceExtensionNested<A> withNewQuobyteVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.QuobyteVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.QuobyteVolumeSourceExtensionNested<A> withNewQuobyteVolumeSourceExtensionLike(QuobyteVolumeSource item) {
    return new NamedExtensionFluentImpl.QuobyteVolumeSourceExtensionNestedImpl(item);
  }
  public A withAPIResourceExtension(APIResource aPIResourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (aPIResourceExtension!=null){ this.extension= new APIResourceBuilder(aPIResourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.APIResourceExtensionNested<A> withNewAPIResourceExtension() {
    return new NamedExtensionFluentImpl.APIResourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.APIResourceExtensionNested<A> withNewAPIResourceExtensionLike(APIResource item) {
    return new NamedExtensionFluentImpl.APIResourceExtensionNestedImpl(item);
  }
  public A withResourceQuotaStatusExtension(ResourceQuotaStatus resourceQuotaStatusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (resourceQuotaStatusExtension!=null){ this.extension= new ResourceQuotaStatusBuilder(resourceQuotaStatusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ResourceQuotaStatusExtensionNested<A> withNewResourceQuotaStatusExtension() {
    return new NamedExtensionFluentImpl.ResourceQuotaStatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.ResourceQuotaStatusExtensionNested<A> withNewResourceQuotaStatusExtensionLike(ResourceQuotaStatus item) {
    return new NamedExtensionFluentImpl.ResourceQuotaStatusExtensionNestedImpl(item);
  }
  public A withRawExtension(RawExtension rawExtension) {
    _visitables.get("extension").remove(this.extension);
    if (rawExtension!=null){ this.extension= new RawExtensionBuilder(rawExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.RawExtensionNested<A> withNewRawExtension() {
    return new NamedExtensionFluentImpl.RawExtensionNestedImpl();
  }
  public NamedExtensionFluent.RawExtensionNested<A> withNewRawExtensionLike(RawExtension item) {
    return new NamedExtensionFluentImpl.RawExtensionNestedImpl(item);
  }
  public A withNewRawExtension(Object value) {
    return (A)withRawExtension(new RawExtension(value));
  }
  public A withConfigMapProjectionExtension(ConfigMapProjection configMapProjectionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (configMapProjectionExtension!=null){ this.extension= new ConfigMapProjectionBuilder(configMapProjectionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ConfigMapProjectionExtensionNested<A> withNewConfigMapProjectionExtension() {
    return new NamedExtensionFluentImpl.ConfigMapProjectionExtensionNestedImpl();
  }
  public NamedExtensionFluent.ConfigMapProjectionExtensionNested<A> withNewConfigMapProjectionExtensionLike(ConfigMapProjection item) {
    return new NamedExtensionFluentImpl.ConfigMapProjectionExtensionNestedImpl(item);
  }
  public A withScopedResourceSelectorRequirementExtension(ScopedResourceSelectorRequirement scopedResourceSelectorRequirementExtension) {
    _visitables.get("extension").remove(this.extension);
    if (scopedResourceSelectorRequirementExtension!=null){ this.extension= new ScopedResourceSelectorRequirementBuilder(scopedResourceSelectorRequirementExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ScopedResourceSelectorRequirementExtensionNested<A> withNewScopedResourceSelectorRequirementExtension() {
    return new NamedExtensionFluentImpl.ScopedResourceSelectorRequirementExtensionNestedImpl();
  }
  public NamedExtensionFluent.ScopedResourceSelectorRequirementExtensionNested<A> withNewScopedResourceSelectorRequirementExtensionLike(ScopedResourceSelectorRequirement item) {
    return new NamedExtensionFluentImpl.ScopedResourceSelectorRequirementExtensionNestedImpl(item);
  }
  public A withNamespaceExtension(Namespace namespaceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (namespaceExtension!=null){ this.extension= new NamespaceBuilder(namespaceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NamespaceExtensionNested<A> withNewNamespaceExtension() {
    return new NamedExtensionFluentImpl.NamespaceExtensionNestedImpl();
  }
  public NamedExtensionFluent.NamespaceExtensionNested<A> withNewNamespaceExtensionLike(Namespace item) {
    return new NamedExtensionFluentImpl.NamespaceExtensionNestedImpl(item);
  }
  public A withGroupVersionKindExtension(GroupVersionKind groupVersionKindExtension) {
    _visitables.get("extension").remove(this.extension);
    if (groupVersionKindExtension!=null){ this.extension= new GroupVersionKindBuilder(groupVersionKindExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.GroupVersionKindExtensionNested<A> withNewGroupVersionKindExtension() {
    return new NamedExtensionFluentImpl.GroupVersionKindExtensionNestedImpl();
  }
  public NamedExtensionFluent.GroupVersionKindExtensionNested<A> withNewGroupVersionKindExtensionLike(GroupVersionKind item) {
    return new NamedExtensionFluentImpl.GroupVersionKindExtensionNestedImpl(item);
  }
  public A withNewGroupVersionKindExtension(String group,String kind,String version) {
    return (A)withGroupVersionKindExtension(new GroupVersionKind(group, kind, version));
  }
  public A withContainerStateTerminatedExtension(ContainerStateTerminated containerStateTerminatedExtension) {
    _visitables.get("extension").remove(this.extension);
    if (containerStateTerminatedExtension!=null){ this.extension= new ContainerStateTerminatedBuilder(containerStateTerminatedExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ContainerStateTerminatedExtensionNested<A> withNewContainerStateTerminatedExtension() {
    return new NamedExtensionFluentImpl.ContainerStateTerminatedExtensionNestedImpl();
  }
  public NamedExtensionFluent.ContainerStateTerminatedExtensionNested<A> withNewContainerStateTerminatedExtensionLike(ContainerStateTerminated item) {
    return new NamedExtensionFluentImpl.ContainerStateTerminatedExtensionNestedImpl(item);
  }
  public A withLimitRangeSpecExtension(LimitRangeSpec limitRangeSpecExtension) {
    _visitables.get("extension").remove(this.extension);
    if (limitRangeSpecExtension!=null){ this.extension= new LimitRangeSpecBuilder(limitRangeSpecExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.LimitRangeSpecExtensionNested<A> withNewLimitRangeSpecExtension() {
    return new NamedExtensionFluentImpl.LimitRangeSpecExtensionNestedImpl();
  }
  public NamedExtensionFluent.LimitRangeSpecExtensionNested<A> withNewLimitRangeSpecExtensionLike(LimitRangeSpec item) {
    return new NamedExtensionFluentImpl.LimitRangeSpecExtensionNestedImpl(item);
  }
  public A withProjectedVolumeSourceExtension(ProjectedVolumeSource projectedVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (projectedVolumeSourceExtension!=null){ this.extension= new ProjectedVolumeSourceBuilder(projectedVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ProjectedVolumeSourceExtensionNested<A> withNewProjectedVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.ProjectedVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.ProjectedVolumeSourceExtensionNested<A> withNewProjectedVolumeSourceExtensionLike(ProjectedVolumeSource item) {
    return new NamedExtensionFluentImpl.ProjectedVolumeSourceExtensionNestedImpl(item);
  }
  public A withPodOSExtension(PodOS podOSExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podOSExtension!=null){ this.extension= new PodOSBuilder(podOSExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodOSExtensionNested<A> withNewPodOSExtension() {
    return new NamedExtensionFluentImpl.PodOSExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodOSExtensionNested<A> withNewPodOSExtensionLike(PodOS item) {
    return new NamedExtensionFluentImpl.PodOSExtensionNestedImpl(item);
  }
  public A withNewPodOSExtension(String name) {
    return (A)withPodOSExtension(new PodOS(name));
  }
  public A withPersistentVolumeClaimStatusExtension(PersistentVolumeClaimStatus persistentVolumeClaimStatusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeClaimStatusExtension!=null){ this.extension= new PersistentVolumeClaimStatusBuilder(persistentVolumeClaimStatusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PersistentVolumeClaimStatusExtensionNested<A> withNewPersistentVolumeClaimStatusExtension() {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimStatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.PersistentVolumeClaimStatusExtensionNested<A> withNewPersistentVolumeClaimStatusExtensionLike(PersistentVolumeClaimStatus item) {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimStatusExtensionNestedImpl(item);
  }
  public A withContainerStateExtension(ContainerState containerStateExtension) {
    _visitables.get("extension").remove(this.extension);
    if (containerStateExtension!=null){ this.extension= new ContainerStateBuilder(containerStateExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ContainerStateExtensionNested<A> withNewContainerStateExtension() {
    return new NamedExtensionFluentImpl.ContainerStateExtensionNestedImpl();
  }
  public NamedExtensionFluent.ContainerStateExtensionNested<A> withNewContainerStateExtensionLike(ContainerState item) {
    return new NamedExtensionFluentImpl.ContainerStateExtensionNestedImpl(item);
  }
  public A withServiceSpecExtension(ServiceSpec serviceSpecExtension) {
    _visitables.get("extension").remove(this.extension);
    if (serviceSpecExtension!=null){ this.extension= new ServiceSpecBuilder(serviceSpecExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ServiceSpecExtensionNested<A> withNewServiceSpecExtension() {
    return new NamedExtensionFluentImpl.ServiceSpecExtensionNestedImpl();
  }
  public NamedExtensionFluent.ServiceSpecExtensionNested<A> withNewServiceSpecExtensionLike(ServiceSpec item) {
    return new NamedExtensionFluentImpl.ServiceSpecExtensionNestedImpl(item);
  }
  public A withServiceAccountTokenProjectionExtension(ServiceAccountTokenProjection serviceAccountTokenProjectionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (serviceAccountTokenProjectionExtension!=null){ this.extension= new ServiceAccountTokenProjectionBuilder(serviceAccountTokenProjectionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ServiceAccountTokenProjectionExtensionNested<A> withNewServiceAccountTokenProjectionExtension() {
    return new NamedExtensionFluentImpl.ServiceAccountTokenProjectionExtensionNestedImpl();
  }
  public NamedExtensionFluent.ServiceAccountTokenProjectionExtensionNested<A> withNewServiceAccountTokenProjectionExtensionLike(ServiceAccountTokenProjection item) {
    return new NamedExtensionFluentImpl.ServiceAccountTokenProjectionExtensionNestedImpl(item);
  }
  public A withNewServiceAccountTokenProjectionExtension(String audience,Long expirationSeconds,String path) {
    return (A)withServiceAccountTokenProjectionExtension(new ServiceAccountTokenProjection(audience, expirationSeconds, path));
  }
  public A withPhotonPersistentDiskVolumeSourceExtension(PhotonPersistentDiskVolumeSource photonPersistentDiskVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (photonPersistentDiskVolumeSourceExtension!=null){ this.extension= new PhotonPersistentDiskVolumeSourceBuilder(photonPersistentDiskVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PhotonPersistentDiskVolumeSourceExtensionNested<A> withNewPhotonPersistentDiskVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.PhotonPersistentDiskVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.PhotonPersistentDiskVolumeSourceExtensionNested<A> withNewPhotonPersistentDiskVolumeSourceExtensionLike(PhotonPersistentDiskVolumeSource item) {
    return new NamedExtensionFluentImpl.PhotonPersistentDiskVolumeSourceExtensionNestedImpl(item);
  }
  public A withNewPhotonPersistentDiskVolumeSourceExtension(String fsType,String pdID) {
    return (A)withPhotonPersistentDiskVolumeSourceExtension(new PhotonPersistentDiskVolumeSource(fsType, pdID));
  }
  public A withContainerExtension(Container containerExtension) {
    _visitables.get("extension").remove(this.extension);
    if (containerExtension!=null){ this.extension= new ContainerBuilder(containerExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ContainerExtensionNested<A> withNewContainerExtension() {
    return new NamedExtensionFluentImpl.ContainerExtensionNestedImpl();
  }
  public NamedExtensionFluent.ContainerExtensionNested<A> withNewContainerExtensionLike(Container item) {
    return new NamedExtensionFluentImpl.ContainerExtensionNestedImpl(item);
  }
  public A withNodeSpecExtension(NodeSpec nodeSpecExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nodeSpecExtension!=null){ this.extension= new NodeSpecBuilder(nodeSpecExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NodeSpecExtensionNested<A> withNewNodeSpecExtension() {
    return new NamedExtensionFluentImpl.NodeSpecExtensionNestedImpl();
  }
  public NamedExtensionFluent.NodeSpecExtensionNested<A> withNewNodeSpecExtensionLike(NodeSpec item) {
    return new NamedExtensionFluentImpl.NodeSpecExtensionNestedImpl(item);
  }
  public A withTypedLocalObjectReferenceExtension(TypedLocalObjectReference typedLocalObjectReferenceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (typedLocalObjectReferenceExtension!=null){ this.extension= new TypedLocalObjectReferenceBuilder(typedLocalObjectReferenceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.TypedLocalObjectReferenceExtensionNested<A> withNewTypedLocalObjectReferenceExtension() {
    return new NamedExtensionFluentImpl.TypedLocalObjectReferenceExtensionNestedImpl();
  }
  public NamedExtensionFluent.TypedLocalObjectReferenceExtensionNested<A> withNewTypedLocalObjectReferenceExtensionLike(TypedLocalObjectReference item) {
    return new NamedExtensionFluentImpl.TypedLocalObjectReferenceExtensionNestedImpl(item);
  }
  public A withNewTypedLocalObjectReferenceExtension(String apiGroup,String kind,String name) {
    return (A)withTypedLocalObjectReferenceExtension(new TypedLocalObjectReference(apiGroup, kind, name));
  }
  public A withFieldsV1Extension(FieldsV1 fieldsV1Extension) {
    _visitables.get("extension").remove(this.extension);
    if (fieldsV1Extension!=null){ this.extension= new FieldsV1Builder(fieldsV1Extension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.FieldsV1ExtensionNested<A> withNewFieldsV1Extension() {
    return new NamedExtensionFluentImpl.FieldsV1ExtensionNestedImpl();
  }
  public NamedExtensionFluent.FieldsV1ExtensionNested<A> withNewFieldsV1ExtensionLike(FieldsV1 item) {
    return new NamedExtensionFluentImpl.FieldsV1ExtensionNestedImpl(item);
  }
  public A withSecretListExtension(SecretList secretListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (secretListExtension!=null){ this.extension= new SecretListBuilder(secretListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.SecretListExtensionNested<A> withNewSecretListExtension() {
    return new NamedExtensionFluentImpl.SecretListExtensionNestedImpl();
  }
  public NamedExtensionFluent.SecretListExtensionNested<A> withNewSecretListExtensionLike(SecretList item) {
    return new NamedExtensionFluentImpl.SecretListExtensionNestedImpl(item);
  }
  public A withNodeAddressExtension(NodeAddress nodeAddressExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nodeAddressExtension!=null){ this.extension= new NodeAddressBuilder(nodeAddressExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NodeAddressExtensionNested<A> withNewNodeAddressExtension() {
    return new NamedExtensionFluentImpl.NodeAddressExtensionNestedImpl();
  }
  public NamedExtensionFluent.NodeAddressExtensionNested<A> withNewNodeAddressExtensionLike(NodeAddress item) {
    return new NamedExtensionFluentImpl.NodeAddressExtensionNestedImpl(item);
  }
  public A withNewNodeAddressExtension(String address,String type) {
    return (A)withNodeAddressExtension(new NodeAddress(address, type));
  }
  public A withPodAffinityExtension(PodAffinity podAffinityExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podAffinityExtension!=null){ this.extension= new PodAffinityBuilder(podAffinityExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodAffinityExtensionNested<A> withNewPodAffinityExtension() {
    return new NamedExtensionFluentImpl.PodAffinityExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodAffinityExtensionNested<A> withNewPodAffinityExtensionLike(PodAffinity item) {
    return new NamedExtensionFluentImpl.PodAffinityExtensionNestedImpl(item);
  }
  public A withExecEnvVarExtension(ExecEnvVar execEnvVarExtension) {
    _visitables.get("extension").remove(this.extension);
    if (execEnvVarExtension!=null){ this.extension= new ExecEnvVarBuilder(execEnvVarExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ExecEnvVarExtensionNested<A> withNewExecEnvVarExtension() {
    return new NamedExtensionFluentImpl.ExecEnvVarExtensionNestedImpl();
  }
  public NamedExtensionFluent.ExecEnvVarExtensionNested<A> withNewExecEnvVarExtensionLike(ExecEnvVar item) {
    return new NamedExtensionFluentImpl.ExecEnvVarExtensionNestedImpl(item);
  }
  public A withNewExecEnvVarExtension(String name,String value) {
    return (A)withExecEnvVarExtension(new ExecEnvVar(name, value));
  }
  public A withServiceExtension(Service serviceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (serviceExtension!=null){ this.extension= new ServiceBuilder(serviceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ServiceExtensionNested<A> withNewServiceExtension() {
    return new NamedExtensionFluentImpl.ServiceExtensionNestedImpl();
  }
  public NamedExtensionFluent.ServiceExtensionNested<A> withNewServiceExtensionLike(Service item) {
    return new NamedExtensionFluentImpl.ServiceExtensionNestedImpl(item);
  }
  public A withEventSeriesExtension(EventSeries eventSeriesExtension) {
    _visitables.get("extension").remove(this.extension);
    if (eventSeriesExtension!=null){ this.extension= new EventSeriesBuilder(eventSeriesExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EventSeriesExtensionNested<A> withNewEventSeriesExtension() {
    return new NamedExtensionFluentImpl.EventSeriesExtensionNestedImpl();
  }
  public NamedExtensionFluent.EventSeriesExtensionNested<A> withNewEventSeriesExtensionLike(EventSeries item) {
    return new NamedExtensionFluentImpl.EventSeriesExtensionNestedImpl(item);
  }
  public A withPodConditionExtension(PodCondition podConditionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podConditionExtension!=null){ this.extension= new PodConditionBuilder(podConditionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodConditionExtensionNested<A> withNewPodConditionExtension() {
    return new NamedExtensionFluentImpl.PodConditionExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodConditionExtensionNested<A> withNewPodConditionExtensionLike(PodCondition item) {
    return new NamedExtensionFluentImpl.PodConditionExtensionNestedImpl(item);
  }
  public A withTopologySpreadConstraintExtension(TopologySpreadConstraint topologySpreadConstraintExtension) {
    _visitables.get("extension").remove(this.extension);
    if (topologySpreadConstraintExtension!=null){ this.extension= new TopologySpreadConstraintBuilder(topologySpreadConstraintExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.TopologySpreadConstraintExtensionNested<A> withNewTopologySpreadConstraintExtension() {
    return new NamedExtensionFluentImpl.TopologySpreadConstraintExtensionNestedImpl();
  }
  public NamedExtensionFluent.TopologySpreadConstraintExtensionNested<A> withNewTopologySpreadConstraintExtensionLike(TopologySpreadConstraint item) {
    return new NamedExtensionFluentImpl.TopologySpreadConstraintExtensionNestedImpl(item);
  }
  public A withExecActionExtension(ExecAction execActionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (execActionExtension!=null){ this.extension= new ExecActionBuilder(execActionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ExecActionExtensionNested<A> withNewExecActionExtension() {
    return new NamedExtensionFluentImpl.ExecActionExtensionNestedImpl();
  }
  public NamedExtensionFluent.ExecActionExtensionNested<A> withNewExecActionExtensionLike(ExecAction item) {
    return new NamedExtensionFluentImpl.ExecActionExtensionNestedImpl(item);
  }
  public A withContainerImageExtension(ContainerImage containerImageExtension) {
    _visitables.get("extension").remove(this.extension);
    if (containerImageExtension!=null){ this.extension= new ContainerImageBuilder(containerImageExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ContainerImageExtensionNested<A> withNewContainerImageExtension() {
    return new NamedExtensionFluentImpl.ContainerImageExtensionNestedImpl();
  }
  public NamedExtensionFluent.ContainerImageExtensionNested<A> withNewContainerImageExtensionLike(ContainerImage item) {
    return new NamedExtensionFluentImpl.ContainerImageExtensionNestedImpl(item);
  }
  public A withGroupKindExtension(GroupKind groupKindExtension) {
    _visitables.get("extension").remove(this.extension);
    if (groupKindExtension!=null){ this.extension= new GroupKindBuilder(groupKindExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.GroupKindExtensionNested<A> withNewGroupKindExtension() {
    return new NamedExtensionFluentImpl.GroupKindExtensionNestedImpl();
  }
  public NamedExtensionFluent.GroupKindExtensionNested<A> withNewGroupKindExtensionLike(GroupKind item) {
    return new NamedExtensionFluentImpl.GroupKindExtensionNestedImpl(item);
  }
  public A withNewGroupKindExtension(String group,String kind) {
    return (A)withGroupKindExtension(new GroupKind(group, kind));
  }
  public A withReplicationControllerExtension(ReplicationController replicationControllerExtension) {
    _visitables.get("extension").remove(this.extension);
    if (replicationControllerExtension!=null){ this.extension= new ReplicationControllerBuilder(replicationControllerExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ReplicationControllerExtensionNested<A> withNewReplicationControllerExtension() {
    return new NamedExtensionFluentImpl.ReplicationControllerExtensionNestedImpl();
  }
  public NamedExtensionFluent.ReplicationControllerExtensionNested<A> withNewReplicationControllerExtensionLike(ReplicationController item) {
    return new NamedExtensionFluentImpl.ReplicationControllerExtensionNestedImpl(item);
  }
  public A withNodeStatusExtension(NodeStatus nodeStatusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nodeStatusExtension!=null){ this.extension= new NodeStatusBuilder(nodeStatusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NodeStatusExtensionNested<A> withNewNodeStatusExtension() {
    return new NamedExtensionFluentImpl.NodeStatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.NodeStatusExtensionNested<A> withNewNodeStatusExtensionLike(NodeStatus item) {
    return new NamedExtensionFluentImpl.NodeStatusExtensionNestedImpl(item);
  }
  public A withConfigMapListExtension(ConfigMapList configMapListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (configMapListExtension!=null){ this.extension= new ConfigMapListBuilder(configMapListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ConfigMapListExtensionNested<A> withNewConfigMapListExtension() {
    return new NamedExtensionFluentImpl.ConfigMapListExtensionNestedImpl();
  }
  public NamedExtensionFluent.ConfigMapListExtensionNested<A> withNewConfigMapListExtensionLike(ConfigMapList item) {
    return new NamedExtensionFluentImpl.ConfigMapListExtensionNestedImpl(item);
  }
  public A withNodeSelectorExtension(NodeSelector nodeSelectorExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nodeSelectorExtension!=null){ this.extension= new NodeSelectorBuilder(nodeSelectorExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NodeSelectorExtensionNested<A> withNewNodeSelectorExtension() {
    return new NamedExtensionFluentImpl.NodeSelectorExtensionNestedImpl();
  }
  public NamedExtensionFluent.NodeSelectorExtensionNested<A> withNewNodeSelectorExtensionLike(NodeSelector item) {
    return new NamedExtensionFluentImpl.NodeSelectorExtensionNestedImpl(item);
  }
  public A withTolerationExtension(Toleration tolerationExtension) {
    _visitables.get("extension").remove(this.extension);
    if (tolerationExtension!=null){ this.extension= new TolerationBuilder(tolerationExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.TolerationExtensionNested<A> withNewTolerationExtension() {
    return new NamedExtensionFluentImpl.TolerationExtensionNestedImpl();
  }
  public NamedExtensionFluent.TolerationExtensionNested<A> withNewTolerationExtensionLike(Toleration item) {
    return new NamedExtensionFluentImpl.TolerationExtensionNestedImpl(item);
  }
  public A withNewTolerationExtension(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)withTolerationExtension(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public A withCephFSPersistentVolumeSourceExtension(CephFSPersistentVolumeSource cephFSPersistentVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (cephFSPersistentVolumeSourceExtension!=null){ this.extension= new CephFSPersistentVolumeSourceBuilder(cephFSPersistentVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.CephFSPersistentVolumeSourceExtensionNested<A> withNewCephFSPersistentVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.CephFSPersistentVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.CephFSPersistentVolumeSourceExtensionNested<A> withNewCephFSPersistentVolumeSourceExtensionLike(CephFSPersistentVolumeSource item) {
    return new NamedExtensionFluentImpl.CephFSPersistentVolumeSourceExtensionNestedImpl(item);
  }
  public A withPersistentVolumeClaimConditionExtension(PersistentVolumeClaimCondition persistentVolumeClaimConditionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeClaimConditionExtension!=null){ this.extension= new PersistentVolumeClaimConditionBuilder(persistentVolumeClaimConditionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PersistentVolumeClaimConditionExtensionNested<A> withNewPersistentVolumeClaimConditionExtension() {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimConditionExtensionNestedImpl();
  }
  public NamedExtensionFluent.PersistentVolumeClaimConditionExtensionNested<A> withNewPersistentVolumeClaimConditionExtensionLike(PersistentVolumeClaimCondition item) {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimConditionExtensionNestedImpl(item);
  }
  public A withPreferredSchedulingTermExtension(PreferredSchedulingTerm preferredSchedulingTermExtension) {
    _visitables.get("extension").remove(this.extension);
    if (preferredSchedulingTermExtension!=null){ this.extension= new PreferredSchedulingTermBuilder(preferredSchedulingTermExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PreferredSchedulingTermExtensionNested<A> withNewPreferredSchedulingTermExtension() {
    return new NamedExtensionFluentImpl.PreferredSchedulingTermExtensionNestedImpl();
  }
  public NamedExtensionFluent.PreferredSchedulingTermExtensionNested<A> withNewPreferredSchedulingTermExtensionLike(PreferredSchedulingTerm item) {
    return new NamedExtensionFluentImpl.PreferredSchedulingTermExtensionNestedImpl(item);
  }
  public A withPersistentVolumeListExtension(PersistentVolumeList persistentVolumeListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeListExtension!=null){ this.extension= new PersistentVolumeListBuilder(persistentVolumeListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PersistentVolumeListExtensionNested<A> withNewPersistentVolumeListExtension() {
    return new NamedExtensionFluentImpl.PersistentVolumeListExtensionNestedImpl();
  }
  public NamedExtensionFluent.PersistentVolumeListExtensionNested<A> withNewPersistentVolumeListExtensionLike(PersistentVolumeList item) {
    return new NamedExtensionFluentImpl.PersistentVolumeListExtensionNestedImpl(item);
  }
  public A withPodSchedulingGateExtension(PodSchedulingGate podSchedulingGateExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podSchedulingGateExtension!=null){ this.extension= new PodSchedulingGateBuilder(podSchedulingGateExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodSchedulingGateExtensionNested<A> withNewPodSchedulingGateExtension() {
    return new NamedExtensionFluentImpl.PodSchedulingGateExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodSchedulingGateExtensionNested<A> withNewPodSchedulingGateExtensionLike(PodSchedulingGate item) {
    return new NamedExtensionFluentImpl.PodSchedulingGateExtensionNestedImpl(item);
  }
  public A withNewPodSchedulingGateExtension(String name) {
    return (A)withPodSchedulingGateExtension(new PodSchedulingGate(name));
  }
  public A withPodDNSConfigOptionExtension(PodDNSConfigOption podDNSConfigOptionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podDNSConfigOptionExtension!=null){ this.extension= new PodDNSConfigOptionBuilder(podDNSConfigOptionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodDNSConfigOptionExtensionNested<A> withNewPodDNSConfigOptionExtension() {
    return new NamedExtensionFluentImpl.PodDNSConfigOptionExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodDNSConfigOptionExtensionNested<A> withNewPodDNSConfigOptionExtensionLike(PodDNSConfigOption item) {
    return new NamedExtensionFluentImpl.PodDNSConfigOptionExtensionNestedImpl(item);
  }
  public A withNewPodDNSConfigOptionExtension(String name,String value) {
    return (A)withPodDNSConfigOptionExtension(new PodDNSConfigOption(name, value));
  }
  public A withGCEPersistentDiskVolumeSourceExtension(GCEPersistentDiskVolumeSource gCEPersistentDiskVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (gCEPersistentDiskVolumeSourceExtension!=null){ this.extension= new GCEPersistentDiskVolumeSourceBuilder(gCEPersistentDiskVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.GCEPersistentDiskVolumeSourceExtensionNested<A> withNewGCEPersistentDiskVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.GCEPersistentDiskVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.GCEPersistentDiskVolumeSourceExtensionNested<A> withNewGCEPersistentDiskVolumeSourceExtensionLike(GCEPersistentDiskVolumeSource item) {
    return new NamedExtensionFluentImpl.GCEPersistentDiskVolumeSourceExtensionNestedImpl(item);
  }
  public A withNewGCEPersistentDiskVolumeSourceExtension(String fsType,Integer partition,String pdName,Boolean readOnly) {
    return (A)withGCEPersistentDiskVolumeSourceExtension(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
  }
  public A withAPIServiceConditionExtension(APIServiceCondition aPIServiceConditionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (aPIServiceConditionExtension!=null){ this.extension= new APIServiceConditionBuilder(aPIServiceConditionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.APIServiceConditionExtensionNested<A> withNewAPIServiceConditionExtension() {
    return new NamedExtensionFluentImpl.APIServiceConditionExtensionNestedImpl();
  }
  public NamedExtensionFluent.APIServiceConditionExtensionNested<A> withNewAPIServiceConditionExtensionLike(APIServiceCondition item) {
    return new NamedExtensionFluentImpl.APIServiceConditionExtensionNestedImpl(item);
  }
  public A withNewAPIServiceConditionExtension(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withAPIServiceConditionExtension(new APIServiceCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withEventListExtension(EventList eventListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (eventListExtension!=null){ this.extension= new EventListBuilder(eventListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EventListExtensionNested<A> withNewEventListExtension() {
    return new NamedExtensionFluentImpl.EventListExtensionNestedImpl();
  }
  public NamedExtensionFluent.EventListExtensionNested<A> withNewEventListExtensionLike(EventList item) {
    return new NamedExtensionFluentImpl.EventListExtensionNestedImpl(item);
  }
  public A withPodReadinessGateExtension(PodReadinessGate podReadinessGateExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podReadinessGateExtension!=null){ this.extension= new PodReadinessGateBuilder(podReadinessGateExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodReadinessGateExtensionNested<A> withNewPodReadinessGateExtension() {
    return new NamedExtensionFluentImpl.PodReadinessGateExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodReadinessGateExtensionNested<A> withNewPodReadinessGateExtensionLike(PodReadinessGate item) {
    return new NamedExtensionFluentImpl.PodReadinessGateExtensionNestedImpl(item);
  }
  public A withNewPodReadinessGateExtension(String conditionType) {
    return (A)withPodReadinessGateExtension(new PodReadinessGate(conditionType));
  }
  public A withContainerStateWaitingExtension(ContainerStateWaiting containerStateWaitingExtension) {
    _visitables.get("extension").remove(this.extension);
    if (containerStateWaitingExtension!=null){ this.extension= new ContainerStateWaitingBuilder(containerStateWaitingExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ContainerStateWaitingExtensionNested<A> withNewContainerStateWaitingExtension() {
    return new NamedExtensionFluentImpl.ContainerStateWaitingExtensionNestedImpl();
  }
  public NamedExtensionFluent.ContainerStateWaitingExtensionNested<A> withNewContainerStateWaitingExtensionLike(ContainerStateWaiting item) {
    return new NamedExtensionFluentImpl.ContainerStateWaitingExtensionNestedImpl(item);
  }
  public A withNewContainerStateWaitingExtension(String message,String reason) {
    return (A)withContainerStateWaitingExtension(new ContainerStateWaiting(message, reason));
  }
  public A withVolumeMountExtension(VolumeMount volumeMountExtension) {
    _visitables.get("extension").remove(this.extension);
    if (volumeMountExtension!=null){ this.extension= new VolumeMountBuilder(volumeMountExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.VolumeMountExtensionNested<A> withNewVolumeMountExtension() {
    return new NamedExtensionFluentImpl.VolumeMountExtensionNestedImpl();
  }
  public NamedExtensionFluent.VolumeMountExtensionNested<A> withNewVolumeMountExtensionLike(VolumeMount item) {
    return new NamedExtensionFluentImpl.VolumeMountExtensionNestedImpl(item);
  }
  public A withNamespaceConditionExtension(NamespaceCondition namespaceConditionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (namespaceConditionExtension!=null){ this.extension= new NamespaceConditionBuilder(namespaceConditionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NamespaceConditionExtensionNested<A> withNewNamespaceConditionExtension() {
    return new NamedExtensionFluentImpl.NamespaceConditionExtensionNestedImpl();
  }
  public NamedExtensionFluent.NamespaceConditionExtensionNested<A> withNewNamespaceConditionExtensionLike(NamespaceCondition item) {
    return new NamedExtensionFluentImpl.NamespaceConditionExtensionNestedImpl(item);
  }
  public A withNewNamespaceConditionExtension(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withNamespaceConditionExtension(new NamespaceCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withLabelSelectorExtension(LabelSelector labelSelectorExtension) {
    _visitables.get("extension").remove(this.extension);
    if (labelSelectorExtension!=null){ this.extension= new LabelSelectorBuilder(labelSelectorExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.LabelSelectorExtensionNested<A> withNewLabelSelectorExtension() {
    return new NamedExtensionFluentImpl.LabelSelectorExtensionNestedImpl();
  }
  public NamedExtensionFluent.LabelSelectorExtensionNested<A> withNewLabelSelectorExtensionLike(LabelSelector item) {
    return new NamedExtensionFluentImpl.LabelSelectorExtensionNestedImpl(item);
  }
  public A withStatusCauseExtension(StatusCause statusCauseExtension) {
    _visitables.get("extension").remove(this.extension);
    if (statusCauseExtension!=null){ this.extension= new StatusCauseBuilder(statusCauseExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.StatusCauseExtensionNested<A> withNewStatusCauseExtension() {
    return new NamedExtensionFluentImpl.StatusCauseExtensionNestedImpl();
  }
  public NamedExtensionFluent.StatusCauseExtensionNested<A> withNewStatusCauseExtensionLike(StatusCause item) {
    return new NamedExtensionFluentImpl.StatusCauseExtensionNestedImpl(item);
  }
  public A withNewStatusCauseExtension(String field,String message,String reason) {
    return (A)withStatusCauseExtension(new StatusCause(field, message, reason));
  }
  public A withNamedClusterExtension(NamedCluster namedClusterExtension) {
    _visitables.get("extension").remove(this.extension);
    if (namedClusterExtension!=null){ this.extension= new NamedClusterBuilder(namedClusterExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NamedClusterExtensionNested<A> withNewNamedClusterExtension() {
    return new NamedExtensionFluentImpl.NamedClusterExtensionNestedImpl();
  }
  public NamedExtensionFluent.NamedClusterExtensionNested<A> withNewNamedClusterExtensionLike(NamedCluster item) {
    return new NamedExtensionFluentImpl.NamedClusterExtensionNestedImpl(item);
  }
  public A withStatusDetailsExtension(StatusDetails statusDetailsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (statusDetailsExtension!=null){ this.extension= new StatusDetailsBuilder(statusDetailsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.StatusDetailsExtensionNested<A> withNewStatusDetailsExtension() {
    return new NamedExtensionFluentImpl.StatusDetailsExtensionNestedImpl();
  }
  public NamedExtensionFluent.StatusDetailsExtensionNested<A> withNewStatusDetailsExtensionLike(StatusDetails item) {
    return new NamedExtensionFluentImpl.StatusDetailsExtensionNestedImpl(item);
  }
  public A withDownwardAPIVolumeFileExtension(DownwardAPIVolumeFile downwardAPIVolumeFileExtension) {
    _visitables.get("extension").remove(this.extension);
    if (downwardAPIVolumeFileExtension!=null){ this.extension= new DownwardAPIVolumeFileBuilder(downwardAPIVolumeFileExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.DownwardAPIVolumeFileExtensionNested<A> withNewDownwardAPIVolumeFileExtension() {
    return new NamedExtensionFluentImpl.DownwardAPIVolumeFileExtensionNestedImpl();
  }
  public NamedExtensionFluent.DownwardAPIVolumeFileExtensionNested<A> withNewDownwardAPIVolumeFileExtensionLike(DownwardAPIVolumeFile item) {
    return new NamedExtensionFluentImpl.DownwardAPIVolumeFileExtensionNestedImpl(item);
  }
  public A withSeccompProfileExtension(SeccompProfile seccompProfileExtension) {
    _visitables.get("extension").remove(this.extension);
    if (seccompProfileExtension!=null){ this.extension= new SeccompProfileBuilder(seccompProfileExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.SeccompProfileExtensionNested<A> withNewSeccompProfileExtension() {
    return new NamedExtensionFluentImpl.SeccompProfileExtensionNestedImpl();
  }
  public NamedExtensionFluent.SeccompProfileExtensionNested<A> withNewSeccompProfileExtensionLike(SeccompProfile item) {
    return new NamedExtensionFluentImpl.SeccompProfileExtensionNestedImpl(item);
  }
  public A withNewSeccompProfileExtension(String localhostProfile,String type) {
    return (A)withSeccompProfileExtension(new SeccompProfile(localhostProfile, type));
  }
  public A withSysctlExtension(Sysctl sysctlExtension) {
    _visitables.get("extension").remove(this.extension);
    if (sysctlExtension!=null){ this.extension= new SysctlBuilder(sysctlExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.SysctlExtensionNested<A> withNewSysctlExtension() {
    return new NamedExtensionFluentImpl.SysctlExtensionNestedImpl();
  }
  public NamedExtensionFluent.SysctlExtensionNested<A> withNewSysctlExtensionLike(Sysctl item) {
    return new NamedExtensionFluentImpl.SysctlExtensionNestedImpl(item);
  }
  public A withNewSysctlExtension(String name,String value) {
    return (A)withSysctlExtension(new Sysctl(name, value));
  }
  public A withDeleteOptionsExtension(DeleteOptions deleteOptionsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (deleteOptionsExtension!=null){ this.extension= new DeleteOptionsBuilder(deleteOptionsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.DeleteOptionsExtensionNested<A> withNewDeleteOptionsExtension() {
    return new NamedExtensionFluentImpl.DeleteOptionsExtensionNestedImpl();
  }
  public NamedExtensionFluent.DeleteOptionsExtensionNested<A> withNewDeleteOptionsExtensionLike(DeleteOptions item) {
    return new NamedExtensionFluentImpl.DeleteOptionsExtensionNestedImpl(item);
  }
  public A withStatusExtension(Status statusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (statusExtension!=null){ this.extension= new StatusBuilder(statusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.StatusExtensionNested<A> withNewStatusExtension() {
    return new NamedExtensionFluentImpl.StatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.StatusExtensionNested<A> withNewStatusExtensionLike(Status item) {
    return new NamedExtensionFluentImpl.StatusExtensionNestedImpl(item);
  }
  public A withContainerStatusExtension(ContainerStatus containerStatusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (containerStatusExtension!=null){ this.extension= new ContainerStatusBuilder(containerStatusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ContainerStatusExtensionNested<A> withNewContainerStatusExtension() {
    return new NamedExtensionFluentImpl.ContainerStatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.ContainerStatusExtensionNested<A> withNewContainerStatusExtensionLike(ContainerStatus item) {
    return new NamedExtensionFluentImpl.ContainerStatusExtensionNestedImpl(item);
  }
  public A withPodTemplateExtension(PodTemplate podTemplateExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podTemplateExtension!=null){ this.extension= new PodTemplateBuilder(podTemplateExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodTemplateExtensionNested<A> withNewPodTemplateExtension() {
    return new NamedExtensionFluentImpl.PodTemplateExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodTemplateExtensionNested<A> withNewPodTemplateExtensionLike(PodTemplate item) {
    return new NamedExtensionFluentImpl.PodTemplateExtensionNestedImpl(item);
  }
  public A withConfigMapEnvSourceExtension(ConfigMapEnvSource configMapEnvSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (configMapEnvSourceExtension!=null){ this.extension= new ConfigMapEnvSourceBuilder(configMapEnvSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ConfigMapEnvSourceExtensionNested<A> withNewConfigMapEnvSourceExtension() {
    return new NamedExtensionFluentImpl.ConfigMapEnvSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.ConfigMapEnvSourceExtensionNested<A> withNewConfigMapEnvSourceExtensionLike(ConfigMapEnvSource item) {
    return new NamedExtensionFluentImpl.ConfigMapEnvSourceExtensionNestedImpl(item);
  }
  public A withNewConfigMapEnvSourceExtension(String name,Boolean optional) {
    return (A)withConfigMapEnvSourceExtension(new ConfigMapEnvSource(name, optional));
  }
  public A withNodeSelectorRequirementExtension(NodeSelectorRequirement nodeSelectorRequirementExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nodeSelectorRequirementExtension!=null){ this.extension= new NodeSelectorRequirementBuilder(nodeSelectorRequirementExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NodeSelectorRequirementExtensionNested<A> withNewNodeSelectorRequirementExtension() {
    return new NamedExtensionFluentImpl.NodeSelectorRequirementExtensionNestedImpl();
  }
  public NamedExtensionFluent.NodeSelectorRequirementExtensionNested<A> withNewNodeSelectorRequirementExtensionLike(NodeSelectorRequirement item) {
    return new NamedExtensionFluentImpl.NodeSelectorRequirementExtensionNestedImpl(item);
  }
  public A withTCPSocketActionExtension(TCPSocketAction tCPSocketActionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (tCPSocketActionExtension!=null){ this.extension= new TCPSocketActionBuilder(tCPSocketActionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.TCPSocketActionExtensionNested<A> withNewTCPSocketActionExtension() {
    return new NamedExtensionFluentImpl.TCPSocketActionExtensionNestedImpl();
  }
  public NamedExtensionFluent.TCPSocketActionExtensionNested<A> withNewTCPSocketActionExtensionLike(TCPSocketAction item) {
    return new NamedExtensionFluentImpl.TCPSocketActionExtensionNestedImpl(item);
  }
  public A withEventExtension(Event eventExtension) {
    _visitables.get("extension").remove(this.extension);
    if (eventExtension!=null){ this.extension= new EventBuilder(eventExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EventExtensionNested<A> withNewEventExtension() {
    return new NamedExtensionFluentImpl.EventExtensionNestedImpl();
  }
  public NamedExtensionFluent.EventExtensionNested<A> withNewEventExtensionLike(Event item) {
    return new NamedExtensionFluentImpl.EventExtensionNestedImpl(item);
  }
  public A withPreferencesExtension(Preferences preferencesExtension) {
    _visitables.get("extension").remove(this.extension);
    if (preferencesExtension!=null){ this.extension= new PreferencesBuilder(preferencesExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PreferencesExtensionNested<A> withNewPreferencesExtension() {
    return new NamedExtensionFluentImpl.PreferencesExtensionNestedImpl();
  }
  public NamedExtensionFluent.PreferencesExtensionNested<A> withNewPreferencesExtensionLike(Preferences item) {
    return new NamedExtensionFluentImpl.PreferencesExtensionNestedImpl(item);
  }
  public A withObjectFieldSelectorExtension(ObjectFieldSelector objectFieldSelectorExtension) {
    _visitables.get("extension").remove(this.extension);
    if (objectFieldSelectorExtension!=null){ this.extension= new ObjectFieldSelectorBuilder(objectFieldSelectorExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ObjectFieldSelectorExtensionNested<A> withNewObjectFieldSelectorExtension() {
    return new NamedExtensionFluentImpl.ObjectFieldSelectorExtensionNestedImpl();
  }
  public NamedExtensionFluent.ObjectFieldSelectorExtensionNested<A> withNewObjectFieldSelectorExtensionLike(ObjectFieldSelector item) {
    return new NamedExtensionFluentImpl.ObjectFieldSelectorExtensionNestedImpl(item);
  }
  public A withNewObjectFieldSelectorExtension(String apiVersion,String fieldPath) {
    return (A)withObjectFieldSelectorExtension(new ObjectFieldSelector(apiVersion, fieldPath));
  }
  public A withPodTemplateListExtension(PodTemplateList podTemplateListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podTemplateListExtension!=null){ this.extension= new PodTemplateListBuilder(podTemplateListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodTemplateListExtensionNested<A> withNewPodTemplateListExtension() {
    return new NamedExtensionFluentImpl.PodTemplateListExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodTemplateListExtensionNested<A> withNewPodTemplateListExtensionLike(PodTemplateList item) {
    return new NamedExtensionFluentImpl.PodTemplateListExtensionNestedImpl(item);
  }
  public A withPersistentVolumeExtension(PersistentVolume persistentVolumeExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeExtension!=null){ this.extension= new PersistentVolumeBuilder(persistentVolumeExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PersistentVolumeExtensionNested<A> withNewPersistentVolumeExtension() {
    return new NamedExtensionFluentImpl.PersistentVolumeExtensionNestedImpl();
  }
  public NamedExtensionFluent.PersistentVolumeExtensionNested<A> withNewPersistentVolumeExtensionLike(PersistentVolume item) {
    return new NamedExtensionFluentImpl.PersistentVolumeExtensionNestedImpl(item);
  }
  public A withCinderVolumeSourceExtension(CinderVolumeSource cinderVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (cinderVolumeSourceExtension!=null){ this.extension= new CinderVolumeSourceBuilder(cinderVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.CinderVolumeSourceExtensionNested<A> withNewCinderVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.CinderVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.CinderVolumeSourceExtensionNested<A> withNewCinderVolumeSourceExtensionLike(CinderVolumeSource item) {
    return new NamedExtensionFluentImpl.CinderVolumeSourceExtensionNestedImpl(item);
  }
  public A withEndpointAddressExtension(EndpointAddress endpointAddressExtension) {
    _visitables.get("extension").remove(this.extension);
    if (endpointAddressExtension!=null){ this.extension= new EndpointAddressBuilder(endpointAddressExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EndpointAddressExtensionNested<A> withNewEndpointAddressExtension() {
    return new NamedExtensionFluentImpl.EndpointAddressExtensionNestedImpl();
  }
  public NamedExtensionFluent.EndpointAddressExtensionNested<A> withNewEndpointAddressExtensionLike(EndpointAddress item) {
    return new NamedExtensionFluentImpl.EndpointAddressExtensionNestedImpl(item);
  }
  public A withNodeConfigSourceExtension(NodeConfigSource nodeConfigSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nodeConfigSourceExtension!=null){ this.extension= new NodeConfigSourceBuilder(nodeConfigSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NodeConfigSourceExtensionNested<A> withNewNodeConfigSourceExtension() {
    return new NamedExtensionFluentImpl.NodeConfigSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.NodeConfigSourceExtensionNested<A> withNewNodeConfigSourceExtensionLike(NodeConfigSource item) {
    return new NamedExtensionFluentImpl.NodeConfigSourceExtensionNestedImpl(item);
  }
  public A withVsphereVirtualDiskVolumeSourceExtension(VsphereVirtualDiskVolumeSource vsphereVirtualDiskVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (vsphereVirtualDiskVolumeSourceExtension!=null){ this.extension= new VsphereVirtualDiskVolumeSourceBuilder(vsphereVirtualDiskVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.VsphereVirtualDiskVolumeSourceExtensionNested<A> withNewVsphereVirtualDiskVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.VsphereVirtualDiskVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.VsphereVirtualDiskVolumeSourceExtensionNested<A> withNewVsphereVirtualDiskVolumeSourceExtensionLike(VsphereVirtualDiskVolumeSource item) {
    return new NamedExtensionFluentImpl.VsphereVirtualDiskVolumeSourceExtensionNestedImpl(item);
  }
  public A withNewVsphereVirtualDiskVolumeSourceExtension(String fsType,String storagePolicyID,String storagePolicyName,String volumePath) {
    return (A)withVsphereVirtualDiskVolumeSourceExtension(new VsphereVirtualDiskVolumeSource(fsType, storagePolicyID, storagePolicyName, volumePath));
  }
  public A withObjectMetaExtension(ObjectMeta objectMetaExtension) {
    _visitables.get("extension").remove(this.extension);
    if (objectMetaExtension!=null){ this.extension= new ObjectMetaBuilder(objectMetaExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ObjectMetaExtensionNested<A> withNewObjectMetaExtension() {
    return new NamedExtensionFluentImpl.ObjectMetaExtensionNestedImpl();
  }
  public NamedExtensionFluent.ObjectMetaExtensionNested<A> withNewObjectMetaExtensionLike(ObjectMeta item) {
    return new NamedExtensionFluentImpl.ObjectMetaExtensionNestedImpl(item);
  }
  public A withPersistentVolumeClaimExtension(PersistentVolumeClaim persistentVolumeClaimExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeClaimExtension!=null){ this.extension= new PersistentVolumeClaimBuilder(persistentVolumeClaimExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtension() {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimExtensionNestedImpl();
  }
  public NamedExtensionFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtensionLike(PersistentVolumeClaim item) {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimExtensionNestedImpl(item);
  }
  public A withLabelSelectorRequirementExtension(LabelSelectorRequirement labelSelectorRequirementExtension) {
    _visitables.get("extension").remove(this.extension);
    if (labelSelectorRequirementExtension!=null){ this.extension= new LabelSelectorRequirementBuilder(labelSelectorRequirementExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.LabelSelectorRequirementExtensionNested<A> withNewLabelSelectorRequirementExtension() {
    return new NamedExtensionFluentImpl.LabelSelectorRequirementExtensionNestedImpl();
  }
  public NamedExtensionFluent.LabelSelectorRequirementExtensionNested<A> withNewLabelSelectorRequirementExtensionLike(LabelSelectorRequirement item) {
    return new NamedExtensionFluentImpl.LabelSelectorRequirementExtensionNestedImpl(item);
  }
  public A withGitRepoVolumeSourceExtension(GitRepoVolumeSource gitRepoVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (gitRepoVolumeSourceExtension!=null){ this.extension= new GitRepoVolumeSourceBuilder(gitRepoVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.GitRepoVolumeSourceExtensionNested<A> withNewGitRepoVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.GitRepoVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.GitRepoVolumeSourceExtensionNested<A> withNewGitRepoVolumeSourceExtensionLike(GitRepoVolumeSource item) {
    return new NamedExtensionFluentImpl.GitRepoVolumeSourceExtensionNestedImpl(item);
  }
  public A withNewGitRepoVolumeSourceExtension(String directory,String repository,String revision) {
    return (A)withGitRepoVolumeSourceExtension(new GitRepoVolumeSource(directory, repository, revision));
  }
  public A withGenericKubernetesResourceExtension(GenericKubernetesResource genericKubernetesResourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (genericKubernetesResourceExtension!=null){ this.extension= new GenericKubernetesResourceBuilder(genericKubernetesResourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.GenericKubernetesResourceExtensionNested<A> withNewGenericKubernetesResourceExtension() {
    return new NamedExtensionFluentImpl.GenericKubernetesResourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.GenericKubernetesResourceExtensionNested<A> withNewGenericKubernetesResourceExtensionLike(GenericKubernetesResource item) {
    return new NamedExtensionFluentImpl.GenericKubernetesResourceExtensionNestedImpl(item);
  }
  public A withEndpointsListExtension(EndpointsList endpointsListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (endpointsListExtension!=null){ this.extension= new EndpointsListBuilder(endpointsListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EndpointsListExtensionNested<A> withNewEndpointsListExtension() {
    return new NamedExtensionFluentImpl.EndpointsListExtensionNestedImpl();
  }
  public NamedExtensionFluent.EndpointsListExtensionNested<A> withNewEndpointsListExtensionLike(EndpointsList item) {
    return new NamedExtensionFluentImpl.EndpointsListExtensionNestedImpl(item);
  }
  public A withGroupVersionResourceExtension(GroupVersionResource groupVersionResourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (groupVersionResourceExtension!=null){ this.extension= new GroupVersionResourceBuilder(groupVersionResourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.GroupVersionResourceExtensionNested<A> withNewGroupVersionResourceExtension() {
    return new NamedExtensionFluentImpl.GroupVersionResourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.GroupVersionResourceExtensionNested<A> withNewGroupVersionResourceExtensionLike(GroupVersionResource item) {
    return new NamedExtensionFluentImpl.GroupVersionResourceExtensionNestedImpl(item);
  }
  public A withNewGroupVersionResourceExtension(String group,String resource,String version) {
    return (A)withGroupVersionResourceExtension(new GroupVersionResource(group, resource, version));
  }
  public A withCinderPersistentVolumeSourceExtension(CinderPersistentVolumeSource cinderPersistentVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (cinderPersistentVolumeSourceExtension!=null){ this.extension= new CinderPersistentVolumeSourceBuilder(cinderPersistentVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.CinderPersistentVolumeSourceExtensionNested<A> withNewCinderPersistentVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.CinderPersistentVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.CinderPersistentVolumeSourceExtensionNested<A> withNewCinderPersistentVolumeSourceExtensionLike(CinderPersistentVolumeSource item) {
    return new NamedExtensionFluentImpl.CinderPersistentVolumeSourceExtensionNestedImpl(item);
  }
  public A withTopologySelectorTermExtension(TopologySelectorTerm topologySelectorTermExtension) {
    _visitables.get("extension").remove(this.extension);
    if (topologySelectorTermExtension!=null){ this.extension= new TopologySelectorTermBuilder(topologySelectorTermExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.TopologySelectorTermExtensionNested<A> withNewTopologySelectorTermExtension() {
    return new NamedExtensionFluentImpl.TopologySelectorTermExtensionNestedImpl();
  }
  public NamedExtensionFluent.TopologySelectorTermExtensionNested<A> withNewTopologySelectorTermExtensionLike(TopologySelectorTerm item) {
    return new NamedExtensionFluentImpl.TopologySelectorTermExtensionNestedImpl(item);
  }
  public A withOwnerReferenceExtension(OwnerReference ownerReferenceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (ownerReferenceExtension!=null){ this.extension= new OwnerReferenceBuilder(ownerReferenceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.OwnerReferenceExtensionNested<A> withNewOwnerReferenceExtension() {
    return new NamedExtensionFluentImpl.OwnerReferenceExtensionNestedImpl();
  }
  public NamedExtensionFluent.OwnerReferenceExtensionNested<A> withNewOwnerReferenceExtensionLike(OwnerReference item) {
    return new NamedExtensionFluentImpl.OwnerReferenceExtensionNestedImpl(item);
  }
  public A withStorageOSPersistentVolumeSourceExtension(StorageOSPersistentVolumeSource storageOSPersistentVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (storageOSPersistentVolumeSourceExtension!=null){ this.extension= new StorageOSPersistentVolumeSourceBuilder(storageOSPersistentVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.StorageOSPersistentVolumeSourceExtensionNested<A> withNewStorageOSPersistentVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.StorageOSPersistentVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.StorageOSPersistentVolumeSourceExtensionNested<A> withNewStorageOSPersistentVolumeSourceExtensionLike(StorageOSPersistentVolumeSource item) {
    return new NamedExtensionFluentImpl.StorageOSPersistentVolumeSourceExtensionNestedImpl(item);
  }
  public A withEphemeralVolumeSourceExtension(EphemeralVolumeSource ephemeralVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (ephemeralVolumeSourceExtension!=null){ this.extension= new EphemeralVolumeSourceBuilder(ephemeralVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EphemeralVolumeSourceExtensionNested<A> withNewEphemeralVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.EphemeralVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.EphemeralVolumeSourceExtensionNested<A> withNewEphemeralVolumeSourceExtensionLike(EphemeralVolumeSource item) {
    return new NamedExtensionFluentImpl.EphemeralVolumeSourceExtensionNestedImpl(item);
  }
  public A withReplicationControllerConditionExtension(ReplicationControllerCondition replicationControllerConditionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (replicationControllerConditionExtension!=null){ this.extension= new ReplicationControllerConditionBuilder(replicationControllerConditionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ReplicationControllerConditionExtensionNested<A> withNewReplicationControllerConditionExtension() {
    return new NamedExtensionFluentImpl.ReplicationControllerConditionExtensionNestedImpl();
  }
  public NamedExtensionFluent.ReplicationControllerConditionExtensionNested<A> withNewReplicationControllerConditionExtensionLike(ReplicationControllerCondition item) {
    return new NamedExtensionFluentImpl.ReplicationControllerConditionExtensionNestedImpl(item);
  }
  public A withNewReplicationControllerConditionExtension(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withReplicationControllerConditionExtension(new ReplicationControllerCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withPodAntiAffinityExtension(PodAntiAffinity podAntiAffinityExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podAntiAffinityExtension!=null){ this.extension= new PodAntiAffinityBuilder(podAntiAffinityExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodAntiAffinityExtensionNested<A> withNewPodAntiAffinityExtension() {
    return new NamedExtensionFluentImpl.PodAntiAffinityExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodAntiAffinityExtensionNested<A> withNewPodAntiAffinityExtensionLike(PodAntiAffinity item) {
    return new NamedExtensionFluentImpl.PodAntiAffinityExtensionNestedImpl(item);
  }
  public A withSecurityContextExtension(SecurityContext securityContextExtension) {
    _visitables.get("extension").remove(this.extension);
    if (securityContextExtension!=null){ this.extension= new SecurityContextBuilder(securityContextExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.SecurityContextExtensionNested<A> withNewSecurityContextExtension() {
    return new NamedExtensionFluentImpl.SecurityContextExtensionNestedImpl();
  }
  public NamedExtensionFluent.SecurityContextExtensionNested<A> withNewSecurityContextExtensionLike(SecurityContext item) {
    return new NamedExtensionFluentImpl.SecurityContextExtensionNestedImpl(item);
  }
  public A withReplicationControllerListExtension(ReplicationControllerList replicationControllerListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (replicationControllerListExtension!=null){ this.extension= new ReplicationControllerListBuilder(replicationControllerListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ReplicationControllerListExtensionNested<A> withNewReplicationControllerListExtension() {
    return new NamedExtensionFluentImpl.ReplicationControllerListExtensionNestedImpl();
  }
  public NamedExtensionFluent.ReplicationControllerListExtensionNested<A> withNewReplicationControllerListExtensionLike(ReplicationControllerList item) {
    return new NamedExtensionFluentImpl.ReplicationControllerListExtensionNestedImpl(item);
  }
  public A withConfigMapVolumeSourceExtension(ConfigMapVolumeSource configMapVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (configMapVolumeSourceExtension!=null){ this.extension= new ConfigMapVolumeSourceBuilder(configMapVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ConfigMapVolumeSourceExtensionNested<A> withNewConfigMapVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.ConfigMapVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.ConfigMapVolumeSourceExtensionNested<A> withNewConfigMapVolumeSourceExtensionLike(ConfigMapVolumeSource item) {
    return new NamedExtensionFluentImpl.ConfigMapVolumeSourceExtensionNestedImpl(item);
  }
  public A withContainerStateRunningExtension(ContainerStateRunning containerStateRunningExtension) {
    _visitables.get("extension").remove(this.extension);
    if (containerStateRunningExtension!=null){ this.extension= new ContainerStateRunningBuilder(containerStateRunningExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ContainerStateRunningExtensionNested<A> withNewContainerStateRunningExtension() {
    return new NamedExtensionFluentImpl.ContainerStateRunningExtensionNestedImpl();
  }
  public NamedExtensionFluent.ContainerStateRunningExtensionNested<A> withNewContainerStateRunningExtensionLike(ContainerStateRunning item) {
    return new NamedExtensionFluentImpl.ContainerStateRunningExtensionNestedImpl(item);
  }
  public A withNewContainerStateRunningExtension(String startedAt) {
    return (A)withContainerStateRunningExtension(new ContainerStateRunning(startedAt));
  }
  public A withComponentStatusListExtension(ComponentStatusList componentStatusListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (componentStatusListExtension!=null){ this.extension= new ComponentStatusListBuilder(componentStatusListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ComponentStatusListExtensionNested<A> withNewComponentStatusListExtension() {
    return new NamedExtensionFluentImpl.ComponentStatusListExtensionNestedImpl();
  }
  public NamedExtensionFluent.ComponentStatusListExtensionNested<A> withNewComponentStatusListExtensionLike(ComponentStatusList item) {
    return new NamedExtensionFluentImpl.ComponentStatusListExtensionNestedImpl(item);
  }
  public A withFlockerVolumeSourceExtension(FlockerVolumeSource flockerVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (flockerVolumeSourceExtension!=null){ this.extension= new FlockerVolumeSourceBuilder(flockerVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.FlockerVolumeSourceExtensionNested<A> withNewFlockerVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.FlockerVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.FlockerVolumeSourceExtensionNested<A> withNewFlockerVolumeSourceExtensionLike(FlockerVolumeSource item) {
    return new NamedExtensionFluentImpl.FlockerVolumeSourceExtensionNestedImpl(item);
  }
  public A withNewFlockerVolumeSourceExtension(String datasetName,String datasetUUID) {
    return (A)withFlockerVolumeSourceExtension(new FlockerVolumeSource(datasetName, datasetUUID));
  }
  public A withScaleIOVolumeSourceExtension(ScaleIOVolumeSource scaleIOVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (scaleIOVolumeSourceExtension!=null){ this.extension= new ScaleIOVolumeSourceBuilder(scaleIOVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ScaleIOVolumeSourceExtensionNested<A> withNewScaleIOVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.ScaleIOVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.ScaleIOVolumeSourceExtensionNested<A> withNewScaleIOVolumeSourceExtensionLike(ScaleIOVolumeSource item) {
    return new NamedExtensionFluentImpl.ScaleIOVolumeSourceExtensionNestedImpl(item);
  }
  public A withLimitRangeListExtension(LimitRangeList limitRangeListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (limitRangeListExtension!=null){ this.extension= new LimitRangeListBuilder(limitRangeListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.LimitRangeListExtensionNested<A> withNewLimitRangeListExtension() {
    return new NamedExtensionFluentImpl.LimitRangeListExtensionNestedImpl();
  }
  public NamedExtensionFluent.LimitRangeListExtensionNested<A> withNewLimitRangeListExtensionLike(LimitRangeList item) {
    return new NamedExtensionFluentImpl.LimitRangeListExtensionNestedImpl(item);
  }
  public A withPodExecOptionsExtension(PodExecOptions podExecOptionsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podExecOptionsExtension!=null){ this.extension= new PodExecOptionsBuilder(podExecOptionsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodExecOptionsExtensionNested<A> withNewPodExecOptionsExtension() {
    return new NamedExtensionFluentImpl.PodExecOptionsExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodExecOptionsExtensionNested<A> withNewPodExecOptionsExtensionLike(PodExecOptions item) {
    return new NamedExtensionFluentImpl.PodExecOptionsExtensionNestedImpl(item);
  }
  public A withProbeExtension(Probe probeExtension) {
    _visitables.get("extension").remove(this.extension);
    if (probeExtension!=null){ this.extension= new ProbeBuilder(probeExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ProbeExtensionNested<A> withNewProbeExtension() {
    return new NamedExtensionFluentImpl.ProbeExtensionNestedImpl();
  }
  public NamedExtensionFluent.ProbeExtensionNested<A> withNewProbeExtensionLike(Probe item) {
    return new NamedExtensionFluentImpl.ProbeExtensionNestedImpl(item);
  }
  public A withUpdateOptionsExtension(UpdateOptions updateOptionsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (updateOptionsExtension!=null){ this.extension= new UpdateOptionsBuilder(updateOptionsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.UpdateOptionsExtensionNested<A> withNewUpdateOptionsExtension() {
    return new NamedExtensionFluentImpl.UpdateOptionsExtensionNestedImpl();
  }
  public NamedExtensionFluent.UpdateOptionsExtensionNested<A> withNewUpdateOptionsExtensionLike(UpdateOptions item) {
    return new NamedExtensionFluentImpl.UpdateOptionsExtensionNestedImpl(item);
  }
  public A withEndpointsExtension(Endpoints endpointsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (endpointsExtension!=null){ this.extension= new EndpointsBuilder(endpointsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EndpointsExtensionNested<A> withNewEndpointsExtension() {
    return new NamedExtensionFluentImpl.EndpointsExtensionNestedImpl();
  }
  public NamedExtensionFluent.EndpointsExtensionNested<A> withNewEndpointsExtensionLike(Endpoints item) {
    return new NamedExtensionFluentImpl.EndpointsExtensionNestedImpl(item);
  }
  public A withNamedExtension(NamedExtension namedExtension) {
    _visitables.get("extension").remove(this.extension);
    if (namedExtension!=null){ this.extension= new NamedExtensionBuilder(namedExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NamedExtensionNested<A> withNewNamedExtension() {
    return new NamedExtensionFluentImpl.NamedExtensionNestedImpl();
  }
  public NamedExtensionFluent.NamedExtensionNested<A> withNewNamedExtensionLike(NamedExtension item) {
    return new NamedExtensionFluentImpl.NamedExtensionNestedImpl(item);
  }
  public A withAzureFilePersistentVolumeSourceExtension(AzureFilePersistentVolumeSource azureFilePersistentVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (azureFilePersistentVolumeSourceExtension!=null){ this.extension= new AzureFilePersistentVolumeSourceBuilder(azureFilePersistentVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.AzureFilePersistentVolumeSourceExtensionNested<A> withNewAzureFilePersistentVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.AzureFilePersistentVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.AzureFilePersistentVolumeSourceExtensionNested<A> withNewAzureFilePersistentVolumeSourceExtensionLike(AzureFilePersistentVolumeSource item) {
    return new NamedExtensionFluentImpl.AzureFilePersistentVolumeSourceExtensionNestedImpl(item);
  }
  public A withNewAzureFilePersistentVolumeSourceExtension(Boolean readOnly,String secretName,String secretNamespace,String shareName) {
    return (A)withAzureFilePersistentVolumeSourceExtension(new AzureFilePersistentVolumeSource(readOnly, secretName, secretNamespace, shareName));
  }
  public A withAPIResourceListExtension(APIResourceList aPIResourceListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (aPIResourceListExtension!=null){ this.extension= new APIResourceListBuilder(aPIResourceListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.APIResourceListExtensionNested<A> withNewAPIResourceListExtension() {
    return new NamedExtensionFluentImpl.APIResourceListExtensionNestedImpl();
  }
  public NamedExtensionFluent.APIResourceListExtensionNested<A> withNewAPIResourceListExtensionLike(APIResourceList item) {
    return new NamedExtensionFluentImpl.APIResourceListExtensionNestedImpl(item);
  }
  public A withAPIServiceListExtension(APIServiceList aPIServiceListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (aPIServiceListExtension!=null){ this.extension= new APIServiceListBuilder(aPIServiceListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.APIServiceListExtensionNested<A> withNewAPIServiceListExtension() {
    return new NamedExtensionFluentImpl.APIServiceListExtensionNestedImpl();
  }
  public NamedExtensionFluent.APIServiceListExtensionNested<A> withNewAPIServiceListExtensionLike(APIServiceList item) {
    return new NamedExtensionFluentImpl.APIServiceListExtensionNestedImpl(item);
  }
  public A withSecretVolumeSourceExtension(SecretVolumeSource secretVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (secretVolumeSourceExtension!=null){ this.extension= new SecretVolumeSourceBuilder(secretVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.SecretVolumeSourceExtensionNested<A> withNewSecretVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.SecretVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.SecretVolumeSourceExtensionNested<A> withNewSecretVolumeSourceExtensionLike(SecretVolumeSource item) {
    return new NamedExtensionFluentImpl.SecretVolumeSourceExtensionNestedImpl(item);
  }
  public A withPodExtension(Pod podExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podExtension!=null){ this.extension= new PodBuilder(podExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodExtensionNested<A> withNewPodExtension() {
    return new NamedExtensionFluentImpl.PodExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodExtensionNested<A> withNewPodExtensionLike(Pod item) {
    return new NamedExtensionFluentImpl.PodExtensionNestedImpl(item);
  }
  public A withClientIPConfigExtension(ClientIPConfig clientIPConfigExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clientIPConfigExtension!=null){ this.extension= new ClientIPConfigBuilder(clientIPConfigExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ClientIPConfigExtensionNested<A> withNewClientIPConfigExtension() {
    return new NamedExtensionFluentImpl.ClientIPConfigExtensionNestedImpl();
  }
  public NamedExtensionFluent.ClientIPConfigExtensionNested<A> withNewClientIPConfigExtensionLike(ClientIPConfig item) {
    return new NamedExtensionFluentImpl.ClientIPConfigExtensionNestedImpl(item);
  }
  public A withNewClientIPConfigExtension(Integer timeoutSeconds) {
    return (A)withClientIPConfigExtension(new ClientIPConfig(timeoutSeconds));
  }
  public A withContextExtension(Context contextExtension) {
    _visitables.get("extension").remove(this.extension);
    if (contextExtension!=null){ this.extension= new ContextBuilder(contextExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ContextExtensionNested<A> withNewContextExtension() {
    return new NamedExtensionFluentImpl.ContextExtensionNestedImpl();
  }
  public NamedExtensionFluent.ContextExtensionNested<A> withNewContextExtensionLike(Context item) {
    return new NamedExtensionFluentImpl.ContextExtensionNestedImpl(item);
  }
  public A withNodeAffinityExtension(NodeAffinity nodeAffinityExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nodeAffinityExtension!=null){ this.extension= new NodeAffinityBuilder(nodeAffinityExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NodeAffinityExtensionNested<A> withNewNodeAffinityExtension() {
    return new NamedExtensionFluentImpl.NodeAffinityExtensionNestedImpl();
  }
  public NamedExtensionFluent.NodeAffinityExtensionNested<A> withNewNodeAffinityExtensionLike(NodeAffinity item) {
    return new NamedExtensionFluentImpl.NodeAffinityExtensionNestedImpl(item);
  }
  public A withConfigMapExtension(ConfigMap configMapExtension) {
    _visitables.get("extension").remove(this.extension);
    if (configMapExtension!=null){ this.extension= new ConfigMapBuilder(configMapExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ConfigMapExtensionNested<A> withNewConfigMapExtension() {
    return new NamedExtensionFluentImpl.ConfigMapExtensionNestedImpl();
  }
  public NamedExtensionFluent.ConfigMapExtensionNested<A> withNewConfigMapExtensionLike(ConfigMap item) {
    return new NamedExtensionFluentImpl.ConfigMapExtensionNestedImpl(item);
  }
  public A withContainerPortExtension(ContainerPort containerPortExtension) {
    _visitables.get("extension").remove(this.extension);
    if (containerPortExtension!=null){ this.extension= new ContainerPortBuilder(containerPortExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ContainerPortExtensionNested<A> withNewContainerPortExtension() {
    return new NamedExtensionFluentImpl.ContainerPortExtensionNestedImpl();
  }
  public NamedExtensionFluent.ContainerPortExtensionNested<A> withNewContainerPortExtensionLike(ContainerPort item) {
    return new NamedExtensionFluentImpl.ContainerPortExtensionNestedImpl(item);
  }
  public A withNewContainerPortExtension(Integer containerPort,String hostIP,Integer hostPort,String name,String protocol) {
    return (A)withContainerPortExtension(new ContainerPort(containerPort, hostIP, hostPort, name, protocol));
  }
  public A withConditionExtension(Condition conditionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (conditionExtension!=null){ this.extension= new ConditionBuilder(conditionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ConditionExtensionNested<A> withNewConditionExtension() {
    return new NamedExtensionFluentImpl.ConditionExtensionNestedImpl();
  }
  public NamedExtensionFluent.ConditionExtensionNested<A> withNewConditionExtensionLike(Condition item) {
    return new NamedExtensionFluentImpl.ConditionExtensionNestedImpl(item);
  }
  public A withPodListExtension(PodList podListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podListExtension!=null){ this.extension= new PodListBuilder(podListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodListExtensionNested<A> withNewPodListExtension() {
    return new NamedExtensionFluentImpl.PodListExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodListExtensionNested<A> withNewPodListExtensionLike(PodList item) {
    return new NamedExtensionFluentImpl.PodListExtensionNestedImpl(item);
  }
  public A withFCVolumeSourceExtension(FCVolumeSource fCVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (fCVolumeSourceExtension!=null){ this.extension= new FCVolumeSourceBuilder(fCVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.FCVolumeSourceExtensionNested<A> withNewFCVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.FCVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.FCVolumeSourceExtensionNested<A> withNewFCVolumeSourceExtensionLike(FCVolumeSource item) {
    return new NamedExtensionFluentImpl.FCVolumeSourceExtensionNestedImpl(item);
  }
  public A withResourceFieldSelectorExtension(ResourceFieldSelector resourceFieldSelectorExtension) {
    _visitables.get("extension").remove(this.extension);
    if (resourceFieldSelectorExtension!=null){ this.extension= new ResourceFieldSelectorBuilder(resourceFieldSelectorExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ResourceFieldSelectorExtensionNested<A> withNewResourceFieldSelectorExtension() {
    return new NamedExtensionFluentImpl.ResourceFieldSelectorExtensionNestedImpl();
  }
  public NamedExtensionFluent.ResourceFieldSelectorExtensionNested<A> withNewResourceFieldSelectorExtensionLike(ResourceFieldSelector item) {
    return new NamedExtensionFluentImpl.ResourceFieldSelectorExtensionNestedImpl(item);
  }
  public A withPersistentVolumeClaimSpecExtension(PersistentVolumeClaimSpec persistentVolumeClaimSpecExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeClaimSpecExtension!=null){ this.extension= new PersistentVolumeClaimSpecBuilder(persistentVolumeClaimSpecExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PersistentVolumeClaimSpecExtensionNested<A> withNewPersistentVolumeClaimSpecExtension() {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimSpecExtensionNestedImpl();
  }
  public NamedExtensionFluent.PersistentVolumeClaimSpecExtensionNested<A> withNewPersistentVolumeClaimSpecExtensionLike(PersistentVolumeClaimSpec item) {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimSpecExtensionNestedImpl(item);
  }
  public A withLoadBalancerStatusExtension(LoadBalancerStatus loadBalancerStatusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (loadBalancerStatusExtension!=null){ this.extension= new LoadBalancerStatusBuilder(loadBalancerStatusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.LoadBalancerStatusExtensionNested<A> withNewLoadBalancerStatusExtension() {
    return new NamedExtensionFluentImpl.LoadBalancerStatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.LoadBalancerStatusExtensionNested<A> withNewLoadBalancerStatusExtensionLike(LoadBalancerStatus item) {
    return new NamedExtensionFluentImpl.LoadBalancerStatusExtensionNestedImpl(item);
  }
  public A withPodSecurityContextExtension(PodSecurityContext podSecurityContextExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podSecurityContextExtension!=null){ this.extension= new PodSecurityContextBuilder(podSecurityContextExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodSecurityContextExtensionNested<A> withNewPodSecurityContextExtension() {
    return new NamedExtensionFluentImpl.PodSecurityContextExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodSecurityContextExtensionNested<A> withNewPodSecurityContextExtensionLike(PodSecurityContext item) {
    return new NamedExtensionFluentImpl.PodSecurityContextExtensionNestedImpl(item);
  }
  public A withScopeSelectorExtension(ScopeSelector scopeSelectorExtension) {
    _visitables.get("extension").remove(this.extension);
    if (scopeSelectorExtension!=null){ this.extension= new ScopeSelectorBuilder(scopeSelectorExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ScopeSelectorExtensionNested<A> withNewScopeSelectorExtension() {
    return new NamedExtensionFluentImpl.ScopeSelectorExtensionNestedImpl();
  }
  public NamedExtensionFluent.ScopeSelectorExtensionNested<A> withNewScopeSelectorExtensionLike(ScopeSelector item) {
    return new NamedExtensionFluentImpl.ScopeSelectorExtensionNestedImpl(item);
  }
  public A withDownwardAPIProjectionExtension(DownwardAPIProjection downwardAPIProjectionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (downwardAPIProjectionExtension!=null){ this.extension= new DownwardAPIProjectionBuilder(downwardAPIProjectionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.DownwardAPIProjectionExtensionNested<A> withNewDownwardAPIProjectionExtension() {
    return new NamedExtensionFluentImpl.DownwardAPIProjectionExtensionNestedImpl();
  }
  public NamedExtensionFluent.DownwardAPIProjectionExtensionNested<A> withNewDownwardAPIProjectionExtensionLike(DownwardAPIProjection item) {
    return new NamedExtensionFluentImpl.DownwardAPIProjectionExtensionNestedImpl(item);
  }
  public A withPodAffinityTermExtension(PodAffinityTerm podAffinityTermExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podAffinityTermExtension!=null){ this.extension= new PodAffinityTermBuilder(podAffinityTermExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodAffinityTermExtensionNested<A> withNewPodAffinityTermExtension() {
    return new NamedExtensionFluentImpl.PodAffinityTermExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodAffinityTermExtensionNested<A> withNewPodAffinityTermExtensionLike(PodAffinityTerm item) {
    return new NamedExtensionFluentImpl.PodAffinityTermExtensionNestedImpl(item);
  }
  public A withAPIServiceSpecExtension(APIServiceSpec aPIServiceSpecExtension) {
    _visitables.get("extension").remove(this.extension);
    if (aPIServiceSpecExtension!=null){ this.extension= new APIServiceSpecBuilder(aPIServiceSpecExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.APIServiceSpecExtensionNested<A> withNewAPIServiceSpecExtension() {
    return new NamedExtensionFluentImpl.APIServiceSpecExtensionNestedImpl();
  }
  public NamedExtensionFluent.APIServiceSpecExtensionNested<A> withNewAPIServiceSpecExtensionLike(APIServiceSpec item) {
    return new NamedExtensionFluentImpl.APIServiceSpecExtensionNestedImpl(item);
  }
  public A withServicePortExtension(ServicePort servicePortExtension) {
    _visitables.get("extension").remove(this.extension);
    if (servicePortExtension!=null){ this.extension= new ServicePortBuilder(servicePortExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ServicePortExtensionNested<A> withNewServicePortExtension() {
    return new NamedExtensionFluentImpl.ServicePortExtensionNestedImpl();
  }
  public NamedExtensionFluent.ServicePortExtensionNested<A> withNewServicePortExtensionLike(ServicePort item) {
    return new NamedExtensionFluentImpl.ServicePortExtensionNestedImpl(item);
  }
  public A withGroupVersionForDiscoveryExtension(GroupVersionForDiscovery groupVersionForDiscoveryExtension) {
    _visitables.get("extension").remove(this.extension);
    if (groupVersionForDiscoveryExtension!=null){ this.extension= new GroupVersionForDiscoveryBuilder(groupVersionForDiscoveryExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.GroupVersionForDiscoveryExtensionNested<A> withNewGroupVersionForDiscoveryExtension() {
    return new NamedExtensionFluentImpl.GroupVersionForDiscoveryExtensionNestedImpl();
  }
  public NamedExtensionFluent.GroupVersionForDiscoveryExtensionNested<A> withNewGroupVersionForDiscoveryExtensionLike(GroupVersionForDiscovery item) {
    return new NamedExtensionFluentImpl.GroupVersionForDiscoveryExtensionNestedImpl(item);
  }
  public A withNewGroupVersionForDiscoveryExtension(String groupVersion,String version) {
    return (A)withGroupVersionForDiscoveryExtension(new GroupVersionForDiscovery(groupVersion, version));
  }
  public A withClaimSourceExtension(ClaimSource claimSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (claimSourceExtension!=null){ this.extension= new ClaimSourceBuilder(claimSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ClaimSourceExtensionNested<A> withNewClaimSourceExtension() {
    return new NamedExtensionFluentImpl.ClaimSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.ClaimSourceExtensionNested<A> withNewClaimSourceExtensionLike(ClaimSource item) {
    return new NamedExtensionFluentImpl.ClaimSourceExtensionNestedImpl(item);
  }
  public A withNewClaimSourceExtension(String resourceClaimName,String resourceClaimTemplateName) {
    return (A)withClaimSourceExtension(new ClaimSource(resourceClaimName, resourceClaimTemplateName));
  }
  public A withPersistentVolumeClaimSourceExtension(PersistentVolumeClaimVolumeSource persistentVolumeClaimSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeClaimSourceExtension!=null){ this.extension= new PersistentVolumeClaimVolumeSourceBuilder(persistentVolumeClaimSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PersistentVolumeClaimSourceExtensionNested<A> withNewPersistentVolumeClaimSourceExtension() {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.PersistentVolumeClaimSourceExtensionNested<A> withNewPersistentVolumeClaimSourceExtensionLike(PersistentVolumeClaimVolumeSource item) {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimSourceExtensionNestedImpl(item);
  }
  public A withNewPersistentVolumeClaimSourceExtension(String claimName,Boolean readOnly) {
    return (A)withPersistentVolumeClaimSourceExtension(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
  }
  public A withSessionAffinityConfigExtension(SessionAffinityConfig sessionAffinityConfigExtension) {
    _visitables.get("extension").remove(this.extension);
    if (sessionAffinityConfigExtension!=null){ this.extension= new SessionAffinityConfigBuilder(sessionAffinityConfigExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.SessionAffinityConfigExtensionNested<A> withNewSessionAffinityConfigExtension() {
    return new NamedExtensionFluentImpl.SessionAffinityConfigExtensionNestedImpl();
  }
  public NamedExtensionFluent.SessionAffinityConfigExtensionNested<A> withNewSessionAffinityConfigExtensionLike(SessionAffinityConfig item) {
    return new NamedExtensionFluentImpl.SessionAffinityConfigExtensionNestedImpl(item);
  }
  public A withServiceAccountListExtension(ServiceAccountList serviceAccountListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (serviceAccountListExtension!=null){ this.extension= new ServiceAccountListBuilder(serviceAccountListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ServiceAccountListExtensionNested<A> withNewServiceAccountListExtension() {
    return new NamedExtensionFluentImpl.ServiceAccountListExtensionNestedImpl();
  }
  public NamedExtensionFluent.ServiceAccountListExtensionNested<A> withNewServiceAccountListExtensionLike(ServiceAccountList item) {
    return new NamedExtensionFluentImpl.ServiceAccountListExtensionNestedImpl(item);
  }
  public A withComponentStatusExtension(ComponentStatus componentStatusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (componentStatusExtension!=null){ this.extension= new ComponentStatusBuilder(componentStatusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ComponentStatusExtensionNested<A> withNewComponentStatusExtension() {
    return new NamedExtensionFluentImpl.ComponentStatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.ComponentStatusExtensionNested<A> withNewComponentStatusExtensionLike(ComponentStatus item) {
    return new NamedExtensionFluentImpl.ComponentStatusExtensionNestedImpl(item);
  }
  public A withDaemonEndpointExtension(DaemonEndpoint daemonEndpointExtension) {
    _visitables.get("extension").remove(this.extension);
    if (daemonEndpointExtension!=null){ this.extension= new DaemonEndpointBuilder(daemonEndpointExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.DaemonEndpointExtensionNested<A> withNewDaemonEndpointExtension() {
    return new NamedExtensionFluentImpl.DaemonEndpointExtensionNestedImpl();
  }
  public NamedExtensionFluent.DaemonEndpointExtensionNested<A> withNewDaemonEndpointExtensionLike(DaemonEndpoint item) {
    return new NamedExtensionFluentImpl.DaemonEndpointExtensionNestedImpl(item);
  }
  public A withNewDaemonEndpointExtension(Integer port) {
    return (A)withDaemonEndpointExtension(new DaemonEndpoint(port));
  }
  public A withKeyToPathExtension(KeyToPath keyToPathExtension) {
    _visitables.get("extension").remove(this.extension);
    if (keyToPathExtension!=null){ this.extension= new KeyToPathBuilder(keyToPathExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.KeyToPathExtensionNested<A> withNewKeyToPathExtension() {
    return new NamedExtensionFluentImpl.KeyToPathExtensionNestedImpl();
  }
  public NamedExtensionFluent.KeyToPathExtensionNested<A> withNewKeyToPathExtensionLike(KeyToPath item) {
    return new NamedExtensionFluentImpl.KeyToPathExtensionNestedImpl(item);
  }
  public A withNewKeyToPathExtension(String key,Integer mode,String path) {
    return (A)withKeyToPathExtension(new KeyToPath(key, mode, path));
  }
  public A withFlexPersistentVolumeSourceExtension(FlexPersistentVolumeSource flexPersistentVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (flexPersistentVolumeSourceExtension!=null){ this.extension= new FlexPersistentVolumeSourceBuilder(flexPersistentVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.FlexPersistentVolumeSourceExtensionNested<A> withNewFlexPersistentVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.FlexPersistentVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.FlexPersistentVolumeSourceExtensionNested<A> withNewFlexPersistentVolumeSourceExtensionLike(FlexPersistentVolumeSource item) {
    return new NamedExtensionFluentImpl.FlexPersistentVolumeSourceExtensionNestedImpl(item);
  }
  public A withNamespaceListExtension(NamespaceList namespaceListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (namespaceListExtension!=null){ this.extension= new NamespaceListBuilder(namespaceListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NamespaceListExtensionNested<A> withNewNamespaceListExtension() {
    return new NamedExtensionFluentImpl.NamespaceListExtensionNestedImpl();
  }
  public NamedExtensionFluent.NamespaceListExtensionNested<A> withNewNamespaceListExtensionLike(NamespaceList item) {
    return new NamedExtensionFluentImpl.NamespaceListExtensionNestedImpl(item);
  }
  public A withPodDNSConfigExtension(PodDNSConfig podDNSConfigExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podDNSConfigExtension!=null){ this.extension= new PodDNSConfigBuilder(podDNSConfigExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodDNSConfigExtensionNested<A> withNewPodDNSConfigExtension() {
    return new NamedExtensionFluentImpl.PodDNSConfigExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodDNSConfigExtensionNested<A> withNewPodDNSConfigExtensionLike(PodDNSConfig item) {
    return new NamedExtensionFluentImpl.PodDNSConfigExtensionNestedImpl(item);
  }
  public A withNodeListExtension(NodeList nodeListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nodeListExtension!=null){ this.extension= new NodeListBuilder(nodeListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NodeListExtensionNested<A> withNewNodeListExtension() {
    return new NamedExtensionFluentImpl.NodeListExtensionNestedImpl();
  }
  public NamedExtensionFluent.NodeListExtensionNested<A> withNewNodeListExtensionLike(NodeList item) {
    return new NamedExtensionFluentImpl.NodeListExtensionNestedImpl(item);
  }
  public A withBindingExtension(Binding bindingExtension) {
    _visitables.get("extension").remove(this.extension);
    if (bindingExtension!=null){ this.extension= new BindingBuilder(bindingExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.BindingExtensionNested<A> withNewBindingExtension() {
    return new NamedExtensionFluentImpl.BindingExtensionNestedImpl();
  }
  public NamedExtensionFluent.BindingExtensionNested<A> withNewBindingExtensionLike(Binding item) {
    return new NamedExtensionFluentImpl.BindingExtensionNestedImpl(item);
  }
  public A withEnvVarSourceExtension(EnvVarSource envVarSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (envVarSourceExtension!=null){ this.extension= new EnvVarSourceBuilder(envVarSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EnvVarSourceExtensionNested<A> withNewEnvVarSourceExtension() {
    return new NamedExtensionFluentImpl.EnvVarSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.EnvVarSourceExtensionNested<A> withNewEnvVarSourceExtensionLike(EnvVarSource item) {
    return new NamedExtensionFluentImpl.EnvVarSourceExtensionNestedImpl(item);
  }
  public A withVolumeProjectionExtension(VolumeProjection volumeProjectionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (volumeProjectionExtension!=null){ this.extension= new VolumeProjectionBuilder(volumeProjectionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.VolumeProjectionExtensionNested<A> withNewVolumeProjectionExtension() {
    return new NamedExtensionFluentImpl.VolumeProjectionExtensionNestedImpl();
  }
  public NamedExtensionFluent.VolumeProjectionExtensionNested<A> withNewVolumeProjectionExtensionLike(VolumeProjection item) {
    return new NamedExtensionFluentImpl.VolumeProjectionExtensionNestedImpl(item);
  }
  public A withResourceQuotaExtension(ResourceQuota resourceQuotaExtension) {
    _visitables.get("extension").remove(this.extension);
    if (resourceQuotaExtension!=null){ this.extension= new ResourceQuotaBuilder(resourceQuotaExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ResourceQuotaExtensionNested<A> withNewResourceQuotaExtension() {
    return new NamedExtensionFluentImpl.ResourceQuotaExtensionNestedImpl();
  }
  public NamedExtensionFluent.ResourceQuotaExtensionNested<A> withNewResourceQuotaExtensionLike(ResourceQuota item) {
    return new NamedExtensionFluentImpl.ResourceQuotaExtensionNestedImpl(item);
  }
  public A withSecretExtension(Secret secretExtension) {
    _visitables.get("extension").remove(this.extension);
    if (secretExtension!=null){ this.extension= new SecretBuilder(secretExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.SecretExtensionNested<A> withNewSecretExtension() {
    return new NamedExtensionFluentImpl.SecretExtensionNestedImpl();
  }
  public NamedExtensionFluent.SecretExtensionNested<A> withNewSecretExtensionLike(Secret item) {
    return new NamedExtensionFluentImpl.SecretExtensionNestedImpl(item);
  }
  public A withServiceListExtension(ServiceList serviceListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (serviceListExtension!=null){ this.extension= new ServiceListBuilder(serviceListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ServiceListExtensionNested<A> withNewServiceListExtension() {
    return new NamedExtensionFluentImpl.ServiceListExtensionNestedImpl();
  }
  public NamedExtensionFluent.ServiceListExtensionNested<A> withNewServiceListExtensionLike(ServiceList item) {
    return new NamedExtensionFluentImpl.ServiceListExtensionNestedImpl(item);
  }
  public A withVolumeNodeAffinityExtension(VolumeNodeAffinity volumeNodeAffinityExtension) {
    _visitables.get("extension").remove(this.extension);
    if (volumeNodeAffinityExtension!=null){ this.extension= new VolumeNodeAffinityBuilder(volumeNodeAffinityExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.VolumeNodeAffinityExtensionNested<A> withNewVolumeNodeAffinityExtension() {
    return new NamedExtensionFluentImpl.VolumeNodeAffinityExtensionNestedImpl();
  }
  public NamedExtensionFluent.VolumeNodeAffinityExtensionNested<A> withNewVolumeNodeAffinityExtensionLike(VolumeNodeAffinity item) {
    return new NamedExtensionFluentImpl.VolumeNodeAffinityExtensionNestedImpl(item);
  }
  public A withResourceQuotaSpecExtension(ResourceQuotaSpec resourceQuotaSpecExtension) {
    _visitables.get("extension").remove(this.extension);
    if (resourceQuotaSpecExtension!=null){ this.extension= new ResourceQuotaSpecBuilder(resourceQuotaSpecExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ResourceQuotaSpecExtensionNested<A> withNewResourceQuotaSpecExtension() {
    return new NamedExtensionFluentImpl.ResourceQuotaSpecExtensionNestedImpl();
  }
  public NamedExtensionFluent.ResourceQuotaSpecExtensionNested<A> withNewResourceQuotaSpecExtensionLike(ResourceQuotaSpec item) {
    return new NamedExtensionFluentImpl.ResourceQuotaSpecExtensionNestedImpl(item);
  }
  public A withNodeSelectorTermExtension(NodeSelectorTerm nodeSelectorTermExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nodeSelectorTermExtension!=null){ this.extension= new NodeSelectorTermBuilder(nodeSelectorTermExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NodeSelectorTermExtensionNested<A> withNewNodeSelectorTermExtension() {
    return new NamedExtensionFluentImpl.NodeSelectorTermExtensionNestedImpl();
  }
  public NamedExtensionFluent.NodeSelectorTermExtensionNested<A> withNewNodeSelectorTermExtensionLike(NodeSelectorTerm item) {
    return new NamedExtensionFluentImpl.NodeSelectorTermExtensionNestedImpl(item);
  }
  public A withScaleIOPersistentVolumeSourceExtension(ScaleIOPersistentVolumeSource scaleIOPersistentVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (scaleIOPersistentVolumeSourceExtension!=null){ this.extension= new ScaleIOPersistentVolumeSourceBuilder(scaleIOPersistentVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ScaleIOPersistentVolumeSourceExtensionNested<A> withNewScaleIOPersistentVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.ScaleIOPersistentVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.ScaleIOPersistentVolumeSourceExtensionNested<A> withNewScaleIOPersistentVolumeSourceExtensionLike(ScaleIOPersistentVolumeSource item) {
    return new NamedExtensionFluentImpl.ScaleIOPersistentVolumeSourceExtensionNestedImpl(item);
  }
  public A withListOptionsExtension(ListOptions listOptionsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (listOptionsExtension!=null){ this.extension= new ListOptionsBuilder(listOptionsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ListOptionsExtensionNested<A> withNewListOptionsExtension() {
    return new NamedExtensionFluentImpl.ListOptionsExtensionNestedImpl();
  }
  public NamedExtensionFluent.ListOptionsExtensionNested<A> withNewListOptionsExtensionLike(ListOptions item) {
    return new NamedExtensionFluentImpl.ListOptionsExtensionNestedImpl(item);
  }
  public A withWeightedPodAffinityTermExtension(WeightedPodAffinityTerm weightedPodAffinityTermExtension) {
    _visitables.get("extension").remove(this.extension);
    if (weightedPodAffinityTermExtension!=null){ this.extension= new WeightedPodAffinityTermBuilder(weightedPodAffinityTermExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.WeightedPodAffinityTermExtensionNested<A> withNewWeightedPodAffinityTermExtension() {
    return new NamedExtensionFluentImpl.WeightedPodAffinityTermExtensionNestedImpl();
  }
  public NamedExtensionFluent.WeightedPodAffinityTermExtensionNested<A> withNewWeightedPodAffinityTermExtensionLike(WeightedPodAffinityTerm item) {
    return new NamedExtensionFluentImpl.WeightedPodAffinityTermExtensionNestedImpl(item);
  }
  public A withTypedObjectReferenceExtension(TypedObjectReference typedObjectReferenceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (typedObjectReferenceExtension!=null){ this.extension= new TypedObjectReferenceBuilder(typedObjectReferenceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.TypedObjectReferenceExtensionNested<A> withNewTypedObjectReferenceExtension() {
    return new NamedExtensionFluentImpl.TypedObjectReferenceExtensionNestedImpl();
  }
  public NamedExtensionFluent.TypedObjectReferenceExtensionNested<A> withNewTypedObjectReferenceExtensionLike(TypedObjectReference item) {
    return new NamedExtensionFluentImpl.TypedObjectReferenceExtensionNestedImpl(item);
  }
  public A withNewTypedObjectReferenceExtension(String apiGroup,String kind,String name,String namespace) {
    return (A)withTypedObjectReferenceExtension(new TypedObjectReference(apiGroup, kind, name, namespace));
  }
  public A withNodeSystemInfoExtension(NodeSystemInfo nodeSystemInfoExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nodeSystemInfoExtension!=null){ this.extension= new NodeSystemInfoBuilder(nodeSystemInfoExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NodeSystemInfoExtensionNested<A> withNewNodeSystemInfoExtension() {
    return new NamedExtensionFluentImpl.NodeSystemInfoExtensionNestedImpl();
  }
  public NamedExtensionFluent.NodeSystemInfoExtensionNested<A> withNewNodeSystemInfoExtensionLike(NodeSystemInfo item) {
    return new NamedExtensionFluentImpl.NodeSystemInfoExtensionNestedImpl(item);
  }
  public A withTopologySelectorLabelRequirementExtension(TopologySelectorLabelRequirement topologySelectorLabelRequirementExtension) {
    _visitables.get("extension").remove(this.extension);
    if (topologySelectorLabelRequirementExtension!=null){ this.extension= new TopologySelectorLabelRequirementBuilder(topologySelectorLabelRequirementExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.TopologySelectorLabelRequirementExtensionNested<A> withNewTopologySelectorLabelRequirementExtension() {
    return new NamedExtensionFluentImpl.TopologySelectorLabelRequirementExtensionNestedImpl();
  }
  public NamedExtensionFluent.TopologySelectorLabelRequirementExtensionNested<A> withNewTopologySelectorLabelRequirementExtensionLike(TopologySelectorLabelRequirement item) {
    return new NamedExtensionFluentImpl.TopologySelectorLabelRequirementExtensionNestedImpl(item);
  }
  public A withRBDPersistentVolumeSourceExtension(RBDPersistentVolumeSource rBDPersistentVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (rBDPersistentVolumeSourceExtension!=null){ this.extension= new RBDPersistentVolumeSourceBuilder(rBDPersistentVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.RBDPersistentVolumeSourceExtensionNested<A> withNewRBDPersistentVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.RBDPersistentVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.RBDPersistentVolumeSourceExtensionNested<A> withNewRBDPersistentVolumeSourceExtensionLike(RBDPersistentVolumeSource item) {
    return new NamedExtensionFluentImpl.RBDPersistentVolumeSourceExtensionNestedImpl(item);
  }
  public A withAuthProviderConfigExtension(AuthProviderConfig authProviderConfigExtension) {
    _visitables.get("extension").remove(this.extension);
    if (authProviderConfigExtension!=null){ this.extension= new AuthProviderConfigBuilder(authProviderConfigExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.AuthProviderConfigExtensionNested<A> withNewAuthProviderConfigExtension() {
    return new NamedExtensionFluentImpl.AuthProviderConfigExtensionNestedImpl();
  }
  public NamedExtensionFluent.AuthProviderConfigExtensionNested<A> withNewAuthProviderConfigExtensionLike(AuthProviderConfig item) {
    return new NamedExtensionFluentImpl.AuthProviderConfigExtensionNestedImpl(item);
  }
  public A withSELinuxOptionsExtension(SELinuxOptions sELinuxOptionsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (sELinuxOptionsExtension!=null){ this.extension= new SELinuxOptionsBuilder(sELinuxOptionsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.SELinuxOptionsExtensionNested<A> withNewSELinuxOptionsExtension() {
    return new NamedExtensionFluentImpl.SELinuxOptionsExtensionNestedImpl();
  }
  public NamedExtensionFluent.SELinuxOptionsExtensionNested<A> withNewSELinuxOptionsExtensionLike(SELinuxOptions item) {
    return new NamedExtensionFluentImpl.SELinuxOptionsExtensionNestedImpl(item);
  }
  public A withNewSELinuxOptionsExtension(String level,String role,String type,String user) {
    return (A)withSELinuxOptionsExtension(new SELinuxOptions(level, role, type, user));
  }
  public A withHostAliasExtension(HostAlias hostAliasExtension) {
    _visitables.get("extension").remove(this.extension);
    if (hostAliasExtension!=null){ this.extension= new HostAliasBuilder(hostAliasExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.HostAliasExtensionNested<A> withNewHostAliasExtension() {
    return new NamedExtensionFluentImpl.HostAliasExtensionNestedImpl();
  }
  public NamedExtensionFluent.HostAliasExtensionNested<A> withNewHostAliasExtensionLike(HostAlias item) {
    return new NamedExtensionFluentImpl.HostAliasExtensionNestedImpl(item);
  }
  public A withNodeDaemonEndpointsExtension(NodeDaemonEndpoints nodeDaemonEndpointsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nodeDaemonEndpointsExtension!=null){ this.extension= new NodeDaemonEndpointsBuilder(nodeDaemonEndpointsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NodeDaemonEndpointsExtensionNested<A> withNewNodeDaemonEndpointsExtension() {
    return new NamedExtensionFluentImpl.NodeDaemonEndpointsExtensionNestedImpl();
  }
  public NamedExtensionFluent.NodeDaemonEndpointsExtensionNested<A> withNewNodeDaemonEndpointsExtensionLike(NodeDaemonEndpoints item) {
    return new NamedExtensionFluentImpl.NodeDaemonEndpointsExtensionNestedImpl(item);
  }
  public A withVolumeDeviceExtension(VolumeDevice volumeDeviceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (volumeDeviceExtension!=null){ this.extension= new VolumeDeviceBuilder(volumeDeviceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.VolumeDeviceExtensionNested<A> withNewVolumeDeviceExtension() {
    return new NamedExtensionFluentImpl.VolumeDeviceExtensionNestedImpl();
  }
  public NamedExtensionFluent.VolumeDeviceExtensionNested<A> withNewVolumeDeviceExtensionLike(VolumeDevice item) {
    return new NamedExtensionFluentImpl.VolumeDeviceExtensionNestedImpl(item);
  }
  public A withNewVolumeDeviceExtension(String devicePath,String name) {
    return (A)withVolumeDeviceExtension(new VolumeDevice(devicePath, name));
  }
  public A withCSIVolumeSourceExtension(CSIVolumeSource cSIVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (cSIVolumeSourceExtension!=null){ this.extension= new CSIVolumeSourceBuilder(cSIVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.CSIVolumeSourceExtensionNested<A> withNewCSIVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.CSIVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.CSIVolumeSourceExtensionNested<A> withNewCSIVolumeSourceExtensionLike(CSIVolumeSource item) {
    return new NamedExtensionFluentImpl.CSIVolumeSourceExtensionNestedImpl(item);
  }
  public A withPersistentVolumeSpecExtension(PersistentVolumeSpec persistentVolumeSpecExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeSpecExtension!=null){ this.extension= new PersistentVolumeSpecBuilder(persistentVolumeSpecExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PersistentVolumeSpecExtensionNested<A> withNewPersistentVolumeSpecExtension() {
    return new NamedExtensionFluentImpl.PersistentVolumeSpecExtensionNestedImpl();
  }
  public NamedExtensionFluent.PersistentVolumeSpecExtensionNested<A> withNewPersistentVolumeSpecExtensionLike(PersistentVolumeSpec item) {
    return new NamedExtensionFluentImpl.PersistentVolumeSpecExtensionNestedImpl(item);
  }
  public A withNodeExtension(Node nodeExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nodeExtension!=null){ this.extension= new NodeBuilder(nodeExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NodeExtensionNested<A> withNewNodeExtension() {
    return new NamedExtensionFluentImpl.NodeExtensionNestedImpl();
  }
  public NamedExtensionFluent.NodeExtensionNested<A> withNewNodeExtensionLike(Node item) {
    return new NamedExtensionFluentImpl.NodeExtensionNestedImpl(item);
  }
  public A withLifecycleHandlerExtension(LifecycleHandler lifecycleHandlerExtension) {
    _visitables.get("extension").remove(this.extension);
    if (lifecycleHandlerExtension!=null){ this.extension= new LifecycleHandlerBuilder(lifecycleHandlerExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.LifecycleHandlerExtensionNested<A> withNewLifecycleHandlerExtension() {
    return new NamedExtensionFluentImpl.LifecycleHandlerExtensionNestedImpl();
  }
  public NamedExtensionFluent.LifecycleHandlerExtensionNested<A> withNewLifecycleHandlerExtensionLike(LifecycleHandler item) {
    return new NamedExtensionFluentImpl.LifecycleHandlerExtensionNestedImpl(item);
  }
  public A withVolumeExtension(Volume volumeExtension) {
    _visitables.get("extension").remove(this.extension);
    if (volumeExtension!=null){ this.extension= new VolumeBuilder(volumeExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.VolumeExtensionNested<A> withNewVolumeExtension() {
    return new NamedExtensionFluentImpl.VolumeExtensionNestedImpl();
  }
  public NamedExtensionFluent.VolumeExtensionNested<A> withNewVolumeExtensionLike(Volume item) {
    return new NamedExtensionFluentImpl.VolumeExtensionNestedImpl(item);
  }
  public A withClusterExtension(Cluster clusterExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clusterExtension!=null){ this.extension= new ClusterBuilder(clusterExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ClusterExtensionNested<A> withNewClusterExtension() {
    return new NamedExtensionFluentImpl.ClusterExtensionNestedImpl();
  }
  public NamedExtensionFluent.ClusterExtensionNested<A> withNewClusterExtensionLike(Cluster item) {
    return new NamedExtensionFluentImpl.ClusterExtensionNestedImpl(item);
  }
  public A withNFSVolumeSourceExtension(NFSVolumeSource nFSVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nFSVolumeSourceExtension!=null){ this.extension= new NFSVolumeSourceBuilder(nFSVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NFSVolumeSourceExtensionNested<A> withNewNFSVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.NFSVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.NFSVolumeSourceExtensionNested<A> withNewNFSVolumeSourceExtensionLike(NFSVolumeSource item) {
    return new NamedExtensionFluentImpl.NFSVolumeSourceExtensionNestedImpl(item);
  }
  public A withNewNFSVolumeSourceExtension(String path,Boolean readOnly,String server) {
    return (A)withNFSVolumeSourceExtension(new NFSVolumeSource(path, readOnly, server));
  }
  public A withStorageOSVolumeSourceExtension(StorageOSVolumeSource storageOSVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (storageOSVolumeSourceExtension!=null){ this.extension= new StorageOSVolumeSourceBuilder(storageOSVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.StorageOSVolumeSourceExtensionNested<A> withNewStorageOSVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.StorageOSVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.StorageOSVolumeSourceExtensionNested<A> withNewStorageOSVolumeSourceExtensionLike(StorageOSVolumeSource item) {
    return new NamedExtensionFluentImpl.StorageOSVolumeSourceExtensionNestedImpl(item);
  }
  public A withPodStatusExtension(PodStatus podStatusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podStatusExtension!=null){ this.extension= new PodStatusBuilder(podStatusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodStatusExtensionNested<A> withNewPodStatusExtension() {
    return new NamedExtensionFluentImpl.PodStatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodStatusExtensionNested<A> withNewPodStatusExtensionLike(PodStatus item) {
    return new NamedExtensionFluentImpl.PodStatusExtensionNestedImpl(item);
  }
  public A withKubernetesListExtension(KubernetesList kubernetesListExtension) {
    _visitables.get("extension").remove(this.extension);
    if (kubernetesListExtension!=null){ this.extension= new KubernetesListBuilder(kubernetesListExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.KubernetesListExtensionNested<A> withNewKubernetesListExtension() {
    return new NamedExtensionFluentImpl.KubernetesListExtensionNestedImpl();
  }
  public NamedExtensionFluent.KubernetesListExtensionNested<A> withNewKubernetesListExtensionLike(KubernetesList item) {
    return new NamedExtensionFluentImpl.KubernetesListExtensionNestedImpl(item);
  }
  public A withExecConfigExtension(ExecConfig execConfigExtension) {
    _visitables.get("extension").remove(this.extension);
    if (execConfigExtension!=null){ this.extension= new ExecConfigBuilder(execConfigExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ExecConfigExtensionNested<A> withNewExecConfigExtension() {
    return new NamedExtensionFluentImpl.ExecConfigExtensionNestedImpl();
  }
  public NamedExtensionFluent.ExecConfigExtensionNested<A> withNewExecConfigExtensionLike(ExecConfig item) {
    return new NamedExtensionFluentImpl.ExecConfigExtensionNestedImpl(item);
  }
  public A withPersistentVolumeStatusExtension(PersistentVolumeStatus persistentVolumeStatusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeStatusExtension!=null){ this.extension= new PersistentVolumeStatusBuilder(persistentVolumeStatusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PersistentVolumeStatusExtensionNested<A> withNewPersistentVolumeStatusExtension() {
    return new NamedExtensionFluentImpl.PersistentVolumeStatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.PersistentVolumeStatusExtensionNested<A> withNewPersistentVolumeStatusExtensionLike(PersistentVolumeStatus item) {
    return new NamedExtensionFluentImpl.PersistentVolumeStatusExtensionNestedImpl(item);
  }
  public A withNewPersistentVolumeStatusExtension(String message,String phase,String reason) {
    return (A)withPersistentVolumeStatusExtension(new PersistentVolumeStatus(message, phase, reason));
  }
  public A withEndpointPortExtension(EndpointPort endpointPortExtension) {
    _visitables.get("extension").remove(this.extension);
    if (endpointPortExtension!=null){ this.extension= new EndpointPortBuilder(endpointPortExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EndpointPortExtensionNested<A> withNewEndpointPortExtension() {
    return new NamedExtensionFluentImpl.EndpointPortExtensionNestedImpl();
  }
  public NamedExtensionFluent.EndpointPortExtensionNested<A> withNewEndpointPortExtensionLike(EndpointPort item) {
    return new NamedExtensionFluentImpl.EndpointPortExtensionNestedImpl(item);
  }
  public A withNewEndpointPortExtension(String appProtocol,String name,Integer port,String protocol) {
    return (A)withEndpointPortExtension(new EndpointPort(appProtocol, name, port, protocol));
  }
  public A withHTTPHeaderExtension(HTTPHeader hTTPHeaderExtension) {
    _visitables.get("extension").remove(this.extension);
    if (hTTPHeaderExtension!=null){ this.extension= new HTTPHeaderBuilder(hTTPHeaderExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.HTTPHeaderExtensionNested<A> withNewHTTPHeaderExtension() {
    return new NamedExtensionFluentImpl.HTTPHeaderExtensionNestedImpl();
  }
  public NamedExtensionFluent.HTTPHeaderExtensionNested<A> withNewHTTPHeaderExtensionLike(HTTPHeader item) {
    return new NamedExtensionFluentImpl.HTTPHeaderExtensionNestedImpl(item);
  }
  public A withNewHTTPHeaderExtension(String name,String value) {
    return (A)withHTTPHeaderExtension(new HTTPHeader(name, value));
  }
  public A withCapabilitiesExtension(Capabilities capabilitiesExtension) {
    _visitables.get("extension").remove(this.extension);
    if (capabilitiesExtension!=null){ this.extension= new CapabilitiesBuilder(capabilitiesExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.CapabilitiesExtensionNested<A> withNewCapabilitiesExtension() {
    return new NamedExtensionFluentImpl.CapabilitiesExtensionNestedImpl();
  }
  public NamedExtensionFluent.CapabilitiesExtensionNested<A> withNewCapabilitiesExtensionLike(Capabilities item) {
    return new NamedExtensionFluentImpl.CapabilitiesExtensionNestedImpl(item);
  }
  public A withObjectReferenceExtension(ObjectReference objectReferenceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (objectReferenceExtension!=null){ this.extension= new ObjectReferenceBuilder(objectReferenceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ObjectReferenceExtensionNested<A> withNewObjectReferenceExtension() {
    return new NamedExtensionFluentImpl.ObjectReferenceExtensionNestedImpl();
  }
  public NamedExtensionFluent.ObjectReferenceExtensionNested<A> withNewObjectReferenceExtensionLike(ObjectReference item) {
    return new NamedExtensionFluentImpl.ObjectReferenceExtensionNestedImpl(item);
  }
  public A withWatchEventExtension(WatchEvent watchEventExtension) {
    _visitables.get("extension").remove(this.extension);
    if (watchEventExtension!=null){ this.extension= new WatchEventBuilder(watchEventExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.WatchEventExtensionNested<A> withNewWatchEventExtension() {
    return new NamedExtensionFluentImpl.WatchEventExtensionNestedImpl();
  }
  public NamedExtensionFluent.WatchEventExtensionNested<A> withNewWatchEventExtensionLike(WatchEvent item) {
    return new NamedExtensionFluentImpl.WatchEventExtensionNestedImpl(item);
  }
  public A withLimitRangeItemExtension(LimitRangeItem limitRangeItemExtension) {
    _visitables.get("extension").remove(this.extension);
    if (limitRangeItemExtension!=null){ this.extension= new LimitRangeItemBuilder(limitRangeItemExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.LimitRangeItemExtensionNested<A> withNewLimitRangeItemExtension() {
    return new NamedExtensionFluentImpl.LimitRangeItemExtensionNestedImpl();
  }
  public NamedExtensionFluent.LimitRangeItemExtensionNested<A> withNewLimitRangeItemExtensionLike(LimitRangeItem item) {
    return new NamedExtensionFluentImpl.LimitRangeItemExtensionNestedImpl(item);
  }
  public A withSecretProjectionExtension(SecretProjection secretProjectionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (secretProjectionExtension!=null){ this.extension= new SecretProjectionBuilder(secretProjectionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.SecretProjectionExtensionNested<A> withNewSecretProjectionExtension() {
    return new NamedExtensionFluentImpl.SecretProjectionExtensionNestedImpl();
  }
  public NamedExtensionFluent.SecretProjectionExtensionNested<A> withNewSecretProjectionExtensionLike(SecretProjection item) {
    return new NamedExtensionFluentImpl.SecretProjectionExtensionNestedImpl(item);
  }
  public A withGetOptionsExtension(GetOptions getOptionsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (getOptionsExtension!=null){ this.extension= new GetOptionsBuilder(getOptionsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.GetOptionsExtensionNested<A> withNewGetOptionsExtension() {
    return new NamedExtensionFluentImpl.GetOptionsExtensionNestedImpl();
  }
  public NamedExtensionFluent.GetOptionsExtensionNested<A> withNewGetOptionsExtensionLike(GetOptions item) {
    return new NamedExtensionFluentImpl.GetOptionsExtensionNestedImpl(item);
  }
  public A withNewGetOptionsExtension(String apiVersion,String kind,String resourceVersion) {
    return (A)withGetOptionsExtension(new GetOptions(apiVersion, kind, resourceVersion));
  }
  public A withGlusterfsVolumeSourceExtension(GlusterfsVolumeSource glusterfsVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (glusterfsVolumeSourceExtension!=null){ this.extension= new GlusterfsVolumeSourceBuilder(glusterfsVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.GlusterfsVolumeSourceExtensionNested<A> withNewGlusterfsVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.GlusterfsVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.GlusterfsVolumeSourceExtensionNested<A> withNewGlusterfsVolumeSourceExtensionLike(GlusterfsVolumeSource item) {
    return new NamedExtensionFluentImpl.GlusterfsVolumeSourceExtensionNestedImpl(item);
  }
  public A withNewGlusterfsVolumeSourceExtension(String endpoints,String path,Boolean readOnly) {
    return (A)withGlusterfsVolumeSourceExtension(new GlusterfsVolumeSource(endpoints, path, readOnly));
  }
  public A withManagedFieldsEntryExtension(ManagedFieldsEntry managedFieldsEntryExtension) {
    _visitables.get("extension").remove(this.extension);
    if (managedFieldsEntryExtension!=null){ this.extension= new ManagedFieldsEntryBuilder(managedFieldsEntryExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ManagedFieldsEntryExtensionNested<A> withNewManagedFieldsEntryExtension() {
    return new NamedExtensionFluentImpl.ManagedFieldsEntryExtensionNestedImpl();
  }
  public NamedExtensionFluent.ManagedFieldsEntryExtensionNested<A> withNewManagedFieldsEntryExtensionLike(ManagedFieldsEntry item) {
    return new NamedExtensionFluentImpl.ManagedFieldsEntryExtensionNestedImpl(item);
  }
  public A withNamespaceStatusExtension(NamespaceStatus namespaceStatusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (namespaceStatusExtension!=null){ this.extension= new NamespaceStatusBuilder(namespaceStatusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NamespaceStatusExtensionNested<A> withNewNamespaceStatusExtension() {
    return new NamedExtensionFluentImpl.NamespaceStatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.NamespaceStatusExtensionNested<A> withNewNamespaceStatusExtensionLike(NamespaceStatus item) {
    return new NamedExtensionFluentImpl.NamespaceStatusExtensionNestedImpl(item);
  }
  public A withSecretEnvSourceExtension(SecretEnvSource secretEnvSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (secretEnvSourceExtension!=null){ this.extension= new SecretEnvSourceBuilder(secretEnvSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.SecretEnvSourceExtensionNested<A> withNewSecretEnvSourceExtension() {
    return new NamedExtensionFluentImpl.SecretEnvSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.SecretEnvSourceExtensionNested<A> withNewSecretEnvSourceExtensionLike(SecretEnvSource item) {
    return new NamedExtensionFluentImpl.SecretEnvSourceExtensionNestedImpl(item);
  }
  public A withNewSecretEnvSourceExtension(String name,Boolean optional) {
    return (A)withSecretEnvSourceExtension(new SecretEnvSource(name, optional));
  }
  public A withServiceAccountExtension(ServiceAccount serviceAccountExtension) {
    _visitables.get("extension").remove(this.extension);
    if (serviceAccountExtension!=null){ this.extension= new ServiceAccountBuilder(serviceAccountExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ServiceAccountExtensionNested<A> withNewServiceAccountExtension() {
    return new NamedExtensionFluentImpl.ServiceAccountExtensionNestedImpl();
  }
  public NamedExtensionFluent.ServiceAccountExtensionNested<A> withNewServiceAccountExtensionLike(ServiceAccount item) {
    return new NamedExtensionFluentImpl.ServiceAccountExtensionNestedImpl(item);
  }
  public A withAWSElasticBlockStoreVolumeSourceExtension(AWSElasticBlockStoreVolumeSource aWSElasticBlockStoreVolumeSourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (aWSElasticBlockStoreVolumeSourceExtension!=null){ this.extension= new AWSElasticBlockStoreVolumeSourceBuilder(aWSElasticBlockStoreVolumeSourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.AWSElasticBlockStoreVolumeSourceExtensionNested<A> withNewAWSElasticBlockStoreVolumeSourceExtension() {
    return new NamedExtensionFluentImpl.AWSElasticBlockStoreVolumeSourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.AWSElasticBlockStoreVolumeSourceExtensionNested<A> withNewAWSElasticBlockStoreVolumeSourceExtensionLike(AWSElasticBlockStoreVolumeSource item) {
    return new NamedExtensionFluentImpl.AWSElasticBlockStoreVolumeSourceExtensionNestedImpl(item);
  }
  public A withNewAWSElasticBlockStoreVolumeSourceExtension(String fsType,Integer partition,Boolean readOnly,String volumeID) {
    return (A)withAWSElasticBlockStoreVolumeSourceExtension(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
  }
  public A withPodIPExtension(PodIP podIPExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podIPExtension!=null){ this.extension= new PodIPBuilder(podIPExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodIPExtensionNested<A> withNewPodIPExtension() {
    return new NamedExtensionFluentImpl.PodIPExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodIPExtensionNested<A> withNewPodIPExtensionLike(PodIP item) {
    return new NamedExtensionFluentImpl.PodIPExtensionNestedImpl(item);
  }
  public A withNewPodIPExtension(String ip) {
    return (A)withPodIPExtension(new PodIP(ip));
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NamedExtensionFluentImpl that = (NamedExtensionFluentImpl) o;
    if (extension != null ? !extension.equals(that.extension) :that.extension != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(extension,  name,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (extension != null) { sb.append("extension:"); sb.append(extension + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class PatchExtensionNestedImpl<N> extends PatchFluentImpl<NamedExtensionFluent.PatchExtensionNested<N>> implements NamedExtensionFluent.PatchExtensionNested<N>,Nested<N>{
    PatchExtensionNestedImpl(Patch item) {
      this.builder = new PatchBuilder(this, item);
    }
    PatchExtensionNestedImpl() {
      this.builder = new PatchBuilder(this);
    }
    PatchBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPatchExtension() {
      return and();
    }
    
  }
  class LimitRangeExtensionNestedImpl<N> extends LimitRangeFluentImpl<NamedExtensionFluent.LimitRangeExtensionNested<N>> implements NamedExtensionFluent.LimitRangeExtensionNested<N>,Nested<N>{
    LimitRangeExtensionNestedImpl(LimitRange item) {
      this.builder = new LimitRangeBuilder(this, item);
    }
    LimitRangeExtensionNestedImpl() {
      this.builder = new LimitRangeBuilder(this);
    }
    LimitRangeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endLimitRangeExtension() {
      return and();
    }
    
  }
  class APIGroupListExtensionNestedImpl<N> extends APIGroupListFluentImpl<NamedExtensionFluent.APIGroupListExtensionNested<N>> implements NamedExtensionFluent.APIGroupListExtensionNested<N>,Nested<N>{
    APIGroupListExtensionNestedImpl(APIGroupList item) {
      this.builder = new APIGroupListBuilder(this, item);
    }
    APIGroupListExtensionNestedImpl() {
      this.builder = new APIGroupListBuilder(this);
    }
    APIGroupListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAPIGroupListExtension() {
      return and();
    }
    
  }
  class PortStatusExtensionNestedImpl<N> extends PortStatusFluentImpl<NamedExtensionFluent.PortStatusExtensionNested<N>> implements NamedExtensionFluent.PortStatusExtensionNested<N>,Nested<N>{
    PortStatusExtensionNestedImpl(PortStatus item) {
      this.builder = new PortStatusBuilder(this, item);
    }
    PortStatusExtensionNestedImpl() {
      this.builder = new PortStatusBuilder(this);
    }
    PortStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPortStatusExtension() {
      return and();
    }
    
  }
  class PodTemplateSpecExtensionNestedImpl<N> extends PodTemplateSpecFluentImpl<NamedExtensionFluent.PodTemplateSpecExtensionNested<N>> implements NamedExtensionFluent.PodTemplateSpecExtensionNested<N>,Nested<N>{
    PodTemplateSpecExtensionNestedImpl(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecExtensionNestedImpl() {
      this.builder = new PodTemplateSpecBuilder(this);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodTemplateSpecExtension() {
      return and();
    }
    
  }
  class CSIPersistentVolumeSourceExtensionNestedImpl<N> extends CSIPersistentVolumeSourceFluentImpl<NamedExtensionFluent.CSIPersistentVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.CSIPersistentVolumeSourceExtensionNested<N>,Nested<N>{
    CSIPersistentVolumeSourceExtensionNestedImpl(CSIPersistentVolumeSource item) {
      this.builder = new CSIPersistentVolumeSourceBuilder(this, item);
    }
    CSIPersistentVolumeSourceExtensionNestedImpl() {
      this.builder = new CSIPersistentVolumeSourceBuilder(this);
    }
    CSIPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endCSIPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  class AuthInfoExtensionNestedImpl<N> extends AuthInfoFluentImpl<NamedExtensionFluent.AuthInfoExtensionNested<N>> implements NamedExtensionFluent.AuthInfoExtensionNested<N>,Nested<N>{
    AuthInfoExtensionNestedImpl(AuthInfo item) {
      this.builder = new AuthInfoBuilder(this, item);
    }
    AuthInfoExtensionNestedImpl() {
      this.builder = new AuthInfoBuilder(this);
    }
    AuthInfoBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAuthInfoExtension() {
      return and();
    }
    
  }
  class APIServiceExtensionNestedImpl<N> extends APIServiceFluentImpl<NamedExtensionFluent.APIServiceExtensionNested<N>> implements NamedExtensionFluent.APIServiceExtensionNested<N>,Nested<N>{
    APIServiceExtensionNestedImpl(APIService item) {
      this.builder = new APIServiceBuilder(this, item);
    }
    APIServiceExtensionNestedImpl() {
      this.builder = new APIServiceBuilder(this);
    }
    APIServiceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAPIServiceExtension() {
      return and();
    }
    
  }
  class ResourceRequirementsExtensionNestedImpl<N> extends ResourceRequirementsFluentImpl<NamedExtensionFluent.ResourceRequirementsExtensionNested<N>> implements NamedExtensionFluent.ResourceRequirementsExtensionNested<N>,Nested<N>{
    ResourceRequirementsExtensionNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsExtensionNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endResourceRequirementsExtension() {
      return and();
    }
    
  }
  class ConfigMapKeySelectorExtensionNestedImpl<N> extends ConfigMapKeySelectorFluentImpl<NamedExtensionFluent.ConfigMapKeySelectorExtensionNested<N>> implements NamedExtensionFluent.ConfigMapKeySelectorExtensionNested<N>,Nested<N>{
    ConfigMapKeySelectorExtensionNestedImpl(ConfigMapKeySelector item) {
      this.builder = new ConfigMapKeySelectorBuilder(this, item);
    }
    ConfigMapKeySelectorExtensionNestedImpl() {
      this.builder = new ConfigMapKeySelectorBuilder(this);
    }
    ConfigMapKeySelectorBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endConfigMapKeySelectorExtension() {
      return and();
    }
    
  }
  class HostPathVolumeSourceExtensionNestedImpl<N> extends HostPathVolumeSourceFluentImpl<NamedExtensionFluent.HostPathVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.HostPathVolumeSourceExtensionNested<N>,Nested<N>{
    HostPathVolumeSourceExtensionNestedImpl(HostPathVolumeSource item) {
      this.builder = new HostPathVolumeSourceBuilder(this, item);
    }
    HostPathVolumeSourceExtensionNestedImpl() {
      this.builder = new HostPathVolumeSourceBuilder(this);
    }
    HostPathVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endHostPathVolumeSourceExtension() {
      return and();
    }
    
  }
  class PersistentVolumeClaimListExtensionNestedImpl<N> extends PersistentVolumeClaimListFluentImpl<NamedExtensionFluent.PersistentVolumeClaimListExtensionNested<N>> implements NamedExtensionFluent.PersistentVolumeClaimListExtensionNested<N>,Nested<N>{
    PersistentVolumeClaimListExtensionNestedImpl(PersistentVolumeClaimList item) {
      this.builder = new PersistentVolumeClaimListBuilder(this, item);
    }
    PersistentVolumeClaimListExtensionNestedImpl() {
      this.builder = new PersistentVolumeClaimListBuilder(this);
    }
    PersistentVolumeClaimListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimListExtension() {
      return and();
    }
    
  }
  class NamedContextExtensionNestedImpl<N> extends NamedContextFluentImpl<NamedExtensionFluent.NamedContextExtensionNested<N>> implements NamedExtensionFluent.NamedContextExtensionNested<N>,Nested<N>{
    NamedContextExtensionNestedImpl(NamedContext item) {
      this.builder = new NamedContextBuilder(this, item);
    }
    NamedContextExtensionNestedImpl() {
      this.builder = new NamedContextBuilder(this);
    }
    NamedContextBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNamedContextExtension() {
      return and();
    }
    
  }
  class ConfigExtensionNestedImpl<N> extends ConfigFluentImpl<NamedExtensionFluent.ConfigExtensionNested<N>> implements NamedExtensionFluent.ConfigExtensionNested<N>,Nested<N>{
    ConfigExtensionNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigExtensionNestedImpl() {
      this.builder = new ConfigBuilder(this);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endConfigExtension() {
      return and();
    }
    
  }
  class AffinityExtensionNestedImpl<N> extends AffinityFluentImpl<NamedExtensionFluent.AffinityExtensionNested<N>> implements NamedExtensionFluent.AffinityExtensionNested<N>,Nested<N>{
    AffinityExtensionNestedImpl(Affinity item) {
      this.builder = new AffinityBuilder(this, item);
    }
    AffinityExtensionNestedImpl() {
      this.builder = new AffinityBuilder(this);
    }
    AffinityBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAffinityExtension() {
      return and();
    }
    
  }
  class PodResourceClaimExtensionNestedImpl<N> extends PodResourceClaimFluentImpl<NamedExtensionFluent.PodResourceClaimExtensionNested<N>> implements NamedExtensionFluent.PodResourceClaimExtensionNested<N>,Nested<N>{
    PodResourceClaimExtensionNestedImpl(PodResourceClaim item) {
      this.builder = new PodResourceClaimBuilder(this, item);
    }
    PodResourceClaimExtensionNestedImpl() {
      this.builder = new PodResourceClaimBuilder(this);
    }
    PodResourceClaimBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodResourceClaimExtension() {
      return and();
    }
    
  }
  class ReplicationControllerStatusExtensionNestedImpl<N> extends ReplicationControllerStatusFluentImpl<NamedExtensionFluent.ReplicationControllerStatusExtensionNested<N>> implements NamedExtensionFluent.ReplicationControllerStatusExtensionNested<N>,Nested<N>{
    ReplicationControllerStatusExtensionNestedImpl(ReplicationControllerStatus item) {
      this.builder = new ReplicationControllerStatusBuilder(this, item);
    }
    ReplicationControllerStatusExtensionNestedImpl() {
      this.builder = new ReplicationControllerStatusBuilder(this);
    }
    ReplicationControllerStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endReplicationControllerStatusExtension() {
      return and();
    }
    
  }
  class APIServiceStatusExtensionNestedImpl<N> extends APIServiceStatusFluentImpl<NamedExtensionFluent.APIServiceStatusExtensionNested<N>> implements NamedExtensionFluent.APIServiceStatusExtensionNested<N>,Nested<N>{
    APIServiceStatusExtensionNestedImpl(APIServiceStatus item) {
      this.builder = new APIServiceStatusBuilder(this, item);
    }
    APIServiceStatusExtensionNestedImpl() {
      this.builder = new APIServiceStatusBuilder(this);
    }
    APIServiceStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAPIServiceStatusExtension() {
      return and();
    }
    
  }
  class MicroTimeExtensionNestedImpl<N> extends MicroTimeFluentImpl<NamedExtensionFluent.MicroTimeExtensionNested<N>> implements NamedExtensionFluent.MicroTimeExtensionNested<N>,Nested<N>{
    MicroTimeExtensionNestedImpl(MicroTime item) {
      this.builder = new MicroTimeBuilder(this, item);
    }
    MicroTimeExtensionNestedImpl() {
      this.builder = new MicroTimeBuilder(this);
    }
    MicroTimeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endMicroTimeExtension() {
      return and();
    }
    
  }
  class LifecycleExtensionNestedImpl<N> extends LifecycleFluentImpl<NamedExtensionFluent.LifecycleExtensionNested<N>> implements NamedExtensionFluent.LifecycleExtensionNested<N>,Nested<N>{
    LifecycleExtensionNestedImpl(Lifecycle item) {
      this.builder = new LifecycleBuilder(this, item);
    }
    LifecycleExtensionNestedImpl() {
      this.builder = new LifecycleBuilder(this);
    }
    LifecycleBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endLifecycleExtension() {
      return and();
    }
    
  }
  class PortworxVolumeSourceExtensionNestedImpl<N> extends PortworxVolumeSourceFluentImpl<NamedExtensionFluent.PortworxVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.PortworxVolumeSourceExtensionNested<N>,Nested<N>{
    PortworxVolumeSourceExtensionNestedImpl(PortworxVolumeSource item) {
      this.builder = new PortworxVolumeSourceBuilder(this, item);
    }
    PortworxVolumeSourceExtensionNestedImpl() {
      this.builder = new PortworxVolumeSourceBuilder(this);
    }
    PortworxVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPortworxVolumeSourceExtension() {
      return and();
    }
    
  }
  class EventSourceExtensionNestedImpl<N> extends EventSourceFluentImpl<NamedExtensionFluent.EventSourceExtensionNested<N>> implements NamedExtensionFluent.EventSourceExtensionNested<N>,Nested<N>{
    EventSourceExtensionNestedImpl(EventSource item) {
      this.builder = new EventSourceBuilder(this, item);
    }
    EventSourceExtensionNestedImpl() {
      this.builder = new EventSourceBuilder(this);
    }
    EventSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEventSourceExtension() {
      return and();
    }
    
  }
  class GRPCActionExtensionNestedImpl<N> extends GRPCActionFluentImpl<NamedExtensionFluent.GRPCActionExtensionNested<N>> implements NamedExtensionFluent.GRPCActionExtensionNested<N>,Nested<N>{
    GRPCActionExtensionNestedImpl(GRPCAction item) {
      this.builder = new GRPCActionBuilder(this, item);
    }
    GRPCActionExtensionNestedImpl() {
      this.builder = new GRPCActionBuilder(this);
    }
    GRPCActionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endGRPCActionExtension() {
      return and();
    }
    
  }
  class AzureFileVolumeSourceExtensionNestedImpl<N> extends AzureFileVolumeSourceFluentImpl<NamedExtensionFluent.AzureFileVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.AzureFileVolumeSourceExtensionNested<N>,Nested<N>{
    AzureFileVolumeSourceExtensionNestedImpl(AzureFileVolumeSource item) {
      this.builder = new AzureFileVolumeSourceBuilder(this, item);
    }
    AzureFileVolumeSourceExtensionNestedImpl() {
      this.builder = new AzureFileVolumeSourceBuilder(this);
    }
    AzureFileVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAzureFileVolumeSourceExtension() {
      return and();
    }
    
  }
  class ResourceClaimExtensionNestedImpl<N> extends ResourceClaimFluentImpl<NamedExtensionFluent.ResourceClaimExtensionNested<N>> implements NamedExtensionFluent.ResourceClaimExtensionNested<N>,Nested<N>{
    ResourceClaimExtensionNestedImpl(ResourceClaim item) {
      this.builder = new ResourceClaimBuilder(this, item);
    }
    ResourceClaimExtensionNestedImpl() {
      this.builder = new ResourceClaimBuilder(this);
    }
    ResourceClaimBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endResourceClaimExtension() {
      return and();
    }
    
  }
  class ComponentConditionExtensionNestedImpl<N> extends ComponentConditionFluentImpl<NamedExtensionFluent.ComponentConditionExtensionNested<N>> implements NamedExtensionFluent.ComponentConditionExtensionNested<N>,Nested<N>{
    ComponentConditionExtensionNestedImpl(ComponentCondition item) {
      this.builder = new ComponentConditionBuilder(this, item);
    }
    ComponentConditionExtensionNestedImpl() {
      this.builder = new ComponentConditionBuilder(this);
    }
    ComponentConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endComponentConditionExtension() {
      return and();
    }
    
  }
  class EnvVarExtensionNestedImpl<N> extends EnvVarFluentImpl<NamedExtensionFluent.EnvVarExtensionNested<N>> implements NamedExtensionFluent.EnvVarExtensionNested<N>,Nested<N>{
    EnvVarExtensionNestedImpl(EnvVar item) {
      this.builder = new EnvVarBuilder(this, item);
    }
    EnvVarExtensionNestedImpl() {
      this.builder = new EnvVarBuilder(this);
    }
    EnvVarBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEnvVarExtension() {
      return and();
    }
    
  }
  class ReplicationControllerSpecExtensionNestedImpl<N> extends ReplicationControllerSpecFluentImpl<NamedExtensionFluent.ReplicationControllerSpecExtensionNested<N>> implements NamedExtensionFluent.ReplicationControllerSpecExtensionNested<N>,Nested<N>{
    ReplicationControllerSpecExtensionNestedImpl(ReplicationControllerSpec item) {
      this.builder = new ReplicationControllerSpecBuilder(this, item);
    }
    ReplicationControllerSpecExtensionNestedImpl() {
      this.builder = new ReplicationControllerSpecBuilder(this);
    }
    ReplicationControllerSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endReplicationControllerSpecExtension() {
      return and();
    }
    
  }
  class LoadBalancerIngressExtensionNestedImpl<N> extends LoadBalancerIngressFluentImpl<NamedExtensionFluent.LoadBalancerIngressExtensionNested<N>> implements NamedExtensionFluent.LoadBalancerIngressExtensionNested<N>,Nested<N>{
    LoadBalancerIngressExtensionNestedImpl(LoadBalancerIngress item) {
      this.builder = new LoadBalancerIngressBuilder(this, item);
    }
    LoadBalancerIngressExtensionNestedImpl() {
      this.builder = new LoadBalancerIngressBuilder(this);
    }
    LoadBalancerIngressBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endLoadBalancerIngressExtension() {
      return and();
    }
    
  }
  class AttachedVolumeExtensionNestedImpl<N> extends AttachedVolumeFluentImpl<NamedExtensionFluent.AttachedVolumeExtensionNested<N>> implements NamedExtensionFluent.AttachedVolumeExtensionNested<N>,Nested<N>{
    AttachedVolumeExtensionNestedImpl(AttachedVolume item) {
      this.builder = new AttachedVolumeBuilder(this, item);
    }
    AttachedVolumeExtensionNestedImpl() {
      this.builder = new AttachedVolumeBuilder(this);
    }
    AttachedVolumeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAttachedVolumeExtension() {
      return and();
    }
    
  }
  class LocalObjectReferenceExtensionNestedImpl<N> extends LocalObjectReferenceFluentImpl<NamedExtensionFluent.LocalObjectReferenceExtensionNested<N>> implements NamedExtensionFluent.LocalObjectReferenceExtensionNested<N>,Nested<N>{
    LocalObjectReferenceExtensionNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceExtensionNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endLocalObjectReferenceExtension() {
      return and();
    }
    
  }
  class NamedAuthInfoExtensionNestedImpl<N> extends NamedAuthInfoFluentImpl<NamedExtensionFluent.NamedAuthInfoExtensionNested<N>> implements NamedExtensionFluent.NamedAuthInfoExtensionNested<N>,Nested<N>{
    NamedAuthInfoExtensionNestedImpl(NamedAuthInfo item) {
      this.builder = new NamedAuthInfoBuilder(this, item);
    }
    NamedAuthInfoExtensionNestedImpl() {
      this.builder = new NamedAuthInfoBuilder(this);
    }
    NamedAuthInfoBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNamedAuthInfoExtension() {
      return and();
    }
    
  }
  class EmptyDirVolumeSourceExtensionNestedImpl<N> extends EmptyDirVolumeSourceFluentImpl<NamedExtensionFluent.EmptyDirVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.EmptyDirVolumeSourceExtensionNested<N>,Nested<N>{
    EmptyDirVolumeSourceExtensionNestedImpl(EmptyDirVolumeSource item) {
      this.builder = new EmptyDirVolumeSourceBuilder(this, item);
    }
    EmptyDirVolumeSourceExtensionNestedImpl() {
      this.builder = new EmptyDirVolumeSourceBuilder(this);
    }
    EmptyDirVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEmptyDirVolumeSourceExtension() {
      return and();
    }
    
  }
  class PodSpecExtensionNestedImpl<N> extends PodSpecFluentImpl<NamedExtensionFluent.PodSpecExtensionNested<N>> implements NamedExtensionFluent.PodSpecExtensionNested<N>,Nested<N>{
    PodSpecExtensionNestedImpl(PodSpec item) {
      this.builder = new PodSpecBuilder(this, item);
    }
    PodSpecExtensionNestedImpl() {
      this.builder = new PodSpecBuilder(this);
    }
    PodSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodSpecExtension() {
      return and();
    }
    
  }
  class ServerAddressByClientCIDRExtensionNestedImpl<N> extends ServerAddressByClientCIDRFluentImpl<NamedExtensionFluent.ServerAddressByClientCIDRExtensionNested<N>> implements NamedExtensionFluent.ServerAddressByClientCIDRExtensionNested<N>,Nested<N>{
    ServerAddressByClientCIDRExtensionNestedImpl(ServerAddressByClientCIDR item) {
      this.builder = new ServerAddressByClientCIDRBuilder(this, item);
    }
    ServerAddressByClientCIDRExtensionNestedImpl() {
      this.builder = new ServerAddressByClientCIDRBuilder(this);
    }
    ServerAddressByClientCIDRBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endServerAddressByClientCIDRExtension() {
      return and();
    }
    
  }
  class AzureDiskVolumeSourceExtensionNestedImpl<N> extends AzureDiskVolumeSourceFluentImpl<NamedExtensionFluent.AzureDiskVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.AzureDiskVolumeSourceExtensionNested<N>,Nested<N>{
    AzureDiskVolumeSourceExtensionNestedImpl(AzureDiskVolumeSource item) {
      this.builder = new AzureDiskVolumeSourceBuilder(this, item);
    }
    AzureDiskVolumeSourceExtensionNestedImpl() {
      this.builder = new AzureDiskVolumeSourceBuilder(this);
    }
    AzureDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAzureDiskVolumeSourceExtension() {
      return and();
    }
    
  }
  class PreconditionsExtensionNestedImpl<N> extends PreconditionsFluentImpl<NamedExtensionFluent.PreconditionsExtensionNested<N>> implements NamedExtensionFluent.PreconditionsExtensionNested<N>,Nested<N>{
    PreconditionsExtensionNestedImpl(Preconditions item) {
      this.builder = new PreconditionsBuilder(this, item);
    }
    PreconditionsExtensionNestedImpl() {
      this.builder = new PreconditionsBuilder(this);
    }
    PreconditionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPreconditionsExtension() {
      return and();
    }
    
  }
  class InfoExtensionNestedImpl<N> extends InfoFluentImpl<NamedExtensionFluent.InfoExtensionNested<N>> implements NamedExtensionFluent.InfoExtensionNested<N>,Nested<N>{
    InfoExtensionNestedImpl(Info item) {
      this.builder = new InfoBuilder(this, item);
    }
    InfoExtensionNestedImpl() {
      this.builder = new InfoBuilder(this);
    }
    InfoBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endInfoExtension() {
      return and();
    }
    
  }
  class CephFSVolumeSourceExtensionNestedImpl<N> extends CephFSVolumeSourceFluentImpl<NamedExtensionFluent.CephFSVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.CephFSVolumeSourceExtensionNested<N>,Nested<N>{
    CephFSVolumeSourceExtensionNestedImpl(CephFSVolumeSource item) {
      this.builder = new CephFSVolumeSourceBuilder(this, item);
    }
    CephFSVolumeSourceExtensionNestedImpl() {
      this.builder = new CephFSVolumeSourceBuilder(this);
    }
    CephFSVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endCephFSVolumeSourceExtension() {
      return and();
    }
    
  }
  class EphemeralContainerExtensionNestedImpl<N> extends EphemeralContainerFluentImpl<NamedExtensionFluent.EphemeralContainerExtensionNested<N>> implements NamedExtensionFluent.EphemeralContainerExtensionNested<N>,Nested<N>{
    EphemeralContainerExtensionNestedImpl(EphemeralContainer item) {
      this.builder = new EphemeralContainerBuilder(this, item);
    }
    EphemeralContainerExtensionNestedImpl() {
      this.builder = new EphemeralContainerBuilder(this);
    }
    EphemeralContainerBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEphemeralContainerExtension() {
      return and();
    }
    
  }
  class NodeConditionExtensionNestedImpl<N> extends NodeConditionFluentImpl<NamedExtensionFluent.NodeConditionExtensionNested<N>> implements NamedExtensionFluent.NodeConditionExtensionNested<N>,Nested<N>{
    NodeConditionExtensionNestedImpl(NodeCondition item) {
      this.builder = new NodeConditionBuilder(this, item);
    }
    NodeConditionExtensionNestedImpl() {
      this.builder = new NodeConditionBuilder(this);
    }
    NodeConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNodeConditionExtension() {
      return and();
    }
    
  }
  class EndpointSubsetExtensionNestedImpl<N> extends EndpointSubsetFluentImpl<NamedExtensionFluent.EndpointSubsetExtensionNested<N>> implements NamedExtensionFluent.EndpointSubsetExtensionNested<N>,Nested<N>{
    EndpointSubsetExtensionNestedImpl(EndpointSubset item) {
      this.builder = new EndpointSubsetBuilder(this, item);
    }
    EndpointSubsetExtensionNestedImpl() {
      this.builder = new EndpointSubsetBuilder(this);
    }
    EndpointSubsetBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEndpointSubsetExtension() {
      return and();
    }
    
  }
  class LocalVolumeSourceExtensionNestedImpl<N> extends LocalVolumeSourceFluentImpl<NamedExtensionFluent.LocalVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.LocalVolumeSourceExtensionNested<N>,Nested<N>{
    LocalVolumeSourceExtensionNestedImpl(LocalVolumeSource item) {
      this.builder = new LocalVolumeSourceBuilder(this, item);
    }
    LocalVolumeSourceExtensionNestedImpl() {
      this.builder = new LocalVolumeSourceBuilder(this);
    }
    LocalVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endLocalVolumeSourceExtension() {
      return and();
    }
    
  }
  class ServiceReferenceExtensionNestedImpl<N> extends ServiceReferenceFluentImpl<NamedExtensionFluent.ServiceReferenceExtensionNested<N>> implements NamedExtensionFluent.ServiceReferenceExtensionNested<N>,Nested<N>{
    ServiceReferenceExtensionNestedImpl(ServiceReference item) {
      this.builder = new ServiceReferenceBuilder(this, item);
    }
    ServiceReferenceExtensionNestedImpl() {
      this.builder = new ServiceReferenceBuilder(this);
    }
    ServiceReferenceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endServiceReferenceExtension() {
      return and();
    }
    
  }
  class ServiceStatusExtensionNestedImpl<N> extends ServiceStatusFluentImpl<NamedExtensionFluent.ServiceStatusExtensionNested<N>> implements NamedExtensionFluent.ServiceStatusExtensionNested<N>,Nested<N>{
    ServiceStatusExtensionNestedImpl(ServiceStatus item) {
      this.builder = new ServiceStatusBuilder(this, item);
    }
    ServiceStatusExtensionNestedImpl() {
      this.builder = new ServiceStatusBuilder(this);
    }
    ServiceStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endServiceStatusExtension() {
      return and();
    }
    
  }
  class TaintExtensionNestedImpl<N> extends TaintFluentImpl<NamedExtensionFluent.TaintExtensionNested<N>> implements NamedExtensionFluent.TaintExtensionNested<N>,Nested<N>{
    TaintExtensionNestedImpl(Taint item) {
      this.builder = new TaintBuilder(this, item);
    }
    TaintExtensionNestedImpl() {
      this.builder = new TaintBuilder(this);
    }
    TaintBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endTaintExtension() {
      return and();
    }
    
  }
  class PatchOptionsExtensionNestedImpl<N> extends PatchOptionsFluentImpl<NamedExtensionFluent.PatchOptionsExtensionNested<N>> implements NamedExtensionFluent.PatchOptionsExtensionNested<N>,Nested<N>{
    PatchOptionsExtensionNestedImpl(PatchOptions item) {
      this.builder = new PatchOptionsBuilder(this, item);
    }
    PatchOptionsExtensionNestedImpl() {
      this.builder = new PatchOptionsBuilder(this);
    }
    PatchOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPatchOptionsExtension() {
      return and();
    }
    
  }
  class ConfigMapNodeConfigSourceExtensionNestedImpl<N> extends ConfigMapNodeConfigSourceFluentImpl<NamedExtensionFluent.ConfigMapNodeConfigSourceExtensionNested<N>> implements NamedExtensionFluent.ConfigMapNodeConfigSourceExtensionNested<N>,Nested<N>{
    ConfigMapNodeConfigSourceExtensionNestedImpl(ConfigMapNodeConfigSource item) {
      this.builder = new ConfigMapNodeConfigSourceBuilder(this, item);
    }
    ConfigMapNodeConfigSourceExtensionNestedImpl() {
      this.builder = new ConfigMapNodeConfigSourceBuilder(this);
    }
    ConfigMapNodeConfigSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endConfigMapNodeConfigSourceExtension() {
      return and();
    }
    
  }
  class HTTPGetActionExtensionNestedImpl<N> extends HTTPGetActionFluentImpl<NamedExtensionFluent.HTTPGetActionExtensionNested<N>> implements NamedExtensionFluent.HTTPGetActionExtensionNested<N>,Nested<N>{
    HTTPGetActionExtensionNestedImpl(HTTPGetAction item) {
      this.builder = new HTTPGetActionBuilder(this, item);
    }
    HTTPGetActionExtensionNestedImpl() {
      this.builder = new HTTPGetActionBuilder(this);
    }
    HTTPGetActionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endHTTPGetActionExtension() {
      return and();
    }
    
  }
  class GlusterfsPersistentVolumeSourceExtensionNestedImpl<N> extends GlusterfsPersistentVolumeSourceFluentImpl<NamedExtensionFluent.GlusterfsPersistentVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.GlusterfsPersistentVolumeSourceExtensionNested<N>,Nested<N>{
    GlusterfsPersistentVolumeSourceExtensionNestedImpl(GlusterfsPersistentVolumeSource item) {
      this.builder = new GlusterfsPersistentVolumeSourceBuilder(this, item);
    }
    GlusterfsPersistentVolumeSourceExtensionNestedImpl() {
      this.builder = new GlusterfsPersistentVolumeSourceBuilder(this);
    }
    GlusterfsPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endGlusterfsPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  class DownwardAPIVolumeSourceExtensionNestedImpl<N> extends DownwardAPIVolumeSourceFluentImpl<NamedExtensionFluent.DownwardAPIVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.DownwardAPIVolumeSourceExtensionNested<N>,Nested<N>{
    DownwardAPIVolumeSourceExtensionNestedImpl(DownwardAPIVolumeSource item) {
      this.builder = new DownwardAPIVolumeSourceBuilder(this, item);
    }
    DownwardAPIVolumeSourceExtensionNestedImpl() {
      this.builder = new DownwardAPIVolumeSourceBuilder(this);
    }
    DownwardAPIVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endDownwardAPIVolumeSourceExtension() {
      return and();
    }
    
  }
  class ISCSIPersistentVolumeSourceExtensionNestedImpl<N> extends ISCSIPersistentVolumeSourceFluentImpl<NamedExtensionFluent.ISCSIPersistentVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.ISCSIPersistentVolumeSourceExtensionNested<N>,Nested<N>{
    ISCSIPersistentVolumeSourceExtensionNestedImpl(ISCSIPersistentVolumeSource item) {
      this.builder = new ISCSIPersistentVolumeSourceBuilder(this, item);
    }
    ISCSIPersistentVolumeSourceExtensionNestedImpl() {
      this.builder = new ISCSIPersistentVolumeSourceBuilder(this);
    }
    ISCSIPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endISCSIPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  class WindowsSecurityContextOptionsExtensionNestedImpl<N> extends WindowsSecurityContextOptionsFluentImpl<NamedExtensionFluent.WindowsSecurityContextOptionsExtensionNested<N>> implements NamedExtensionFluent.WindowsSecurityContextOptionsExtensionNested<N>,Nested<N>{
    WindowsSecurityContextOptionsExtensionNestedImpl(WindowsSecurityContextOptions item) {
      this.builder = new WindowsSecurityContextOptionsBuilder(this, item);
    }
    WindowsSecurityContextOptionsExtensionNestedImpl() {
      this.builder = new WindowsSecurityContextOptionsBuilder(this);
    }
    WindowsSecurityContextOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endWindowsSecurityContextOptionsExtension() {
      return and();
    }
    
  }
  class CreateOptionsExtensionNestedImpl<N> extends CreateOptionsFluentImpl<NamedExtensionFluent.CreateOptionsExtensionNested<N>> implements NamedExtensionFluent.CreateOptionsExtensionNested<N>,Nested<N>{
    CreateOptionsExtensionNestedImpl(CreateOptions item) {
      this.builder = new CreateOptionsBuilder(this, item);
    }
    CreateOptionsExtensionNestedImpl() {
      this.builder = new CreateOptionsBuilder(this);
    }
    CreateOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endCreateOptionsExtension() {
      return and();
    }
    
  }
  class EnvFromSourceExtensionNestedImpl<N> extends EnvFromSourceFluentImpl<NamedExtensionFluent.EnvFromSourceExtensionNested<N>> implements NamedExtensionFluent.EnvFromSourceExtensionNested<N>,Nested<N>{
    EnvFromSourceExtensionNestedImpl(EnvFromSource item) {
      this.builder = new EnvFromSourceBuilder(this, item);
    }
    EnvFromSourceExtensionNestedImpl() {
      this.builder = new EnvFromSourceBuilder(this);
    }
    EnvFromSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEnvFromSourceExtension() {
      return and();
    }
    
  }
  class NamespaceSpecExtensionNestedImpl<N> extends NamespaceSpecFluentImpl<NamedExtensionFluent.NamespaceSpecExtensionNested<N>> implements NamedExtensionFluent.NamespaceSpecExtensionNested<N>,Nested<N>{
    NamespaceSpecExtensionNestedImpl(NamespaceSpec item) {
      this.builder = new NamespaceSpecBuilder(this, item);
    }
    NamespaceSpecExtensionNestedImpl() {
      this.builder = new NamespaceSpecBuilder(this);
    }
    NamespaceSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNamespaceSpecExtension() {
      return and();
    }
    
  }
  class TypeMetaExtensionNestedImpl<N> extends TypeMetaFluentImpl<NamedExtensionFluent.TypeMetaExtensionNested<N>> implements NamedExtensionFluent.TypeMetaExtensionNested<N>,Nested<N>{
    TypeMetaExtensionNestedImpl(TypeMeta item) {
      this.builder = new TypeMetaBuilder(this, item);
    }
    TypeMetaExtensionNestedImpl() {
      this.builder = new TypeMetaBuilder(this);
    }
    TypeMetaBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endTypeMetaExtension() {
      return and();
    }
    
  }
  class RootPathsExtensionNestedImpl<N> extends RootPathsFluentImpl<NamedExtensionFluent.RootPathsExtensionNested<N>> implements NamedExtensionFluent.RootPathsExtensionNested<N>,Nested<N>{
    RootPathsExtensionNestedImpl(RootPaths item) {
      this.builder = new RootPathsBuilder(this, item);
    }
    RootPathsExtensionNestedImpl() {
      this.builder = new RootPathsBuilder(this);
    }
    RootPathsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endRootPathsExtension() {
      return and();
    }
    
  }
  class ListMetaExtensionNestedImpl<N> extends ListMetaFluentImpl<NamedExtensionFluent.ListMetaExtensionNested<N>> implements NamedExtensionFluent.ListMetaExtensionNested<N>,Nested<N>{
    ListMetaExtensionNestedImpl(ListMeta item) {
      this.builder = new ListMetaBuilder(this, item);
    }
    ListMetaExtensionNestedImpl() {
      this.builder = new ListMetaBuilder(this);
    }
    ListMetaBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endListMetaExtension() {
      return and();
    }
    
  }
  class SecretReferenceExtensionNestedImpl<N> extends SecretReferenceFluentImpl<NamedExtensionFluent.SecretReferenceExtensionNested<N>> implements NamedExtensionFluent.SecretReferenceExtensionNested<N>,Nested<N>{
    SecretReferenceExtensionNestedImpl(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    SecretReferenceExtensionNestedImpl() {
      this.builder = new SecretReferenceBuilder(this);
    }
    SecretReferenceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endSecretReferenceExtension() {
      return and();
    }
    
  }
  class APIGroupExtensionNestedImpl<N> extends APIGroupFluentImpl<NamedExtensionFluent.APIGroupExtensionNested<N>> implements NamedExtensionFluent.APIGroupExtensionNested<N>,Nested<N>{
    APIGroupExtensionNestedImpl(APIGroup item) {
      this.builder = new APIGroupBuilder(this, item);
    }
    APIGroupExtensionNestedImpl() {
      this.builder = new APIGroupBuilder(this);
    }
    APIGroupBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAPIGroupExtension() {
      return and();
    }
    
  }
  class FlexVolumeSourceExtensionNestedImpl<N> extends FlexVolumeSourceFluentImpl<NamedExtensionFluent.FlexVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.FlexVolumeSourceExtensionNested<N>,Nested<N>{
    FlexVolumeSourceExtensionNestedImpl(FlexVolumeSource item) {
      this.builder = new FlexVolumeSourceBuilder(this, item);
    }
    FlexVolumeSourceExtensionNestedImpl() {
      this.builder = new FlexVolumeSourceBuilder(this);
    }
    FlexVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endFlexVolumeSourceExtension() {
      return and();
    }
    
  }
  class PersistentVolumeClaimTemplateExtensionNestedImpl<N> extends PersistentVolumeClaimTemplateFluentImpl<NamedExtensionFluent.PersistentVolumeClaimTemplateExtensionNested<N>> implements NamedExtensionFluent.PersistentVolumeClaimTemplateExtensionNested<N>,Nested<N>{
    PersistentVolumeClaimTemplateExtensionNestedImpl(PersistentVolumeClaimTemplate item) {
      this.builder = new PersistentVolumeClaimTemplateBuilder(this, item);
    }
    PersistentVolumeClaimTemplateExtensionNestedImpl() {
      this.builder = new PersistentVolumeClaimTemplateBuilder(this);
    }
    PersistentVolumeClaimTemplateBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimTemplateExtension() {
      return and();
    }
    
  }
  class ISCSIVolumeSourceExtensionNestedImpl<N> extends ISCSIVolumeSourceFluentImpl<NamedExtensionFluent.ISCSIVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.ISCSIVolumeSourceExtensionNested<N>,Nested<N>{
    ISCSIVolumeSourceExtensionNestedImpl(ISCSIVolumeSource item) {
      this.builder = new ISCSIVolumeSourceBuilder(this, item);
    }
    ISCSIVolumeSourceExtensionNestedImpl() {
      this.builder = new ISCSIVolumeSourceBuilder(this);
    }
    ISCSIVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endISCSIVolumeSourceExtension() {
      return and();
    }
    
  }
  class SecretKeySelectorExtensionNestedImpl<N> extends SecretKeySelectorFluentImpl<NamedExtensionFluent.SecretKeySelectorExtensionNested<N>> implements NamedExtensionFluent.SecretKeySelectorExtensionNested<N>,Nested<N>{
    SecretKeySelectorExtensionNestedImpl(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorExtensionNestedImpl() {
      this.builder = new SecretKeySelectorBuilder(this);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endSecretKeySelectorExtension() {
      return and();
    }
    
  }
  class RBDVolumeSourceExtensionNestedImpl<N> extends RBDVolumeSourceFluentImpl<NamedExtensionFluent.RBDVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.RBDVolumeSourceExtensionNested<N>,Nested<N>{
    RBDVolumeSourceExtensionNestedImpl(RBDVolumeSource item) {
      this.builder = new RBDVolumeSourceBuilder(this, item);
    }
    RBDVolumeSourceExtensionNestedImpl() {
      this.builder = new RBDVolumeSourceBuilder(this);
    }
    RBDVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endRBDVolumeSourceExtension() {
      return and();
    }
    
  }
  class NodeConfigStatusExtensionNestedImpl<N> extends NodeConfigStatusFluentImpl<NamedExtensionFluent.NodeConfigStatusExtensionNested<N>> implements NamedExtensionFluent.NodeConfigStatusExtensionNested<N>,Nested<N>{
    NodeConfigStatusExtensionNestedImpl(NodeConfigStatus item) {
      this.builder = new NodeConfigStatusBuilder(this, item);
    }
    NodeConfigStatusExtensionNestedImpl() {
      this.builder = new NodeConfigStatusBuilder(this);
    }
    NodeConfigStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNodeConfigStatusExtension() {
      return and();
    }
    
  }
  class ResourceQuotaListExtensionNestedImpl<N> extends ResourceQuotaListFluentImpl<NamedExtensionFluent.ResourceQuotaListExtensionNested<N>> implements NamedExtensionFluent.ResourceQuotaListExtensionNested<N>,Nested<N>{
    ResourceQuotaListExtensionNestedImpl(ResourceQuotaList item) {
      this.builder = new ResourceQuotaListBuilder(this, item);
    }
    ResourceQuotaListExtensionNestedImpl() {
      this.builder = new ResourceQuotaListBuilder(this);
    }
    ResourceQuotaListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endResourceQuotaListExtension() {
      return and();
    }
    
  }
  class QuobyteVolumeSourceExtensionNestedImpl<N> extends QuobyteVolumeSourceFluentImpl<NamedExtensionFluent.QuobyteVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.QuobyteVolumeSourceExtensionNested<N>,Nested<N>{
    QuobyteVolumeSourceExtensionNestedImpl(QuobyteVolumeSource item) {
      this.builder = new QuobyteVolumeSourceBuilder(this, item);
    }
    QuobyteVolumeSourceExtensionNestedImpl() {
      this.builder = new QuobyteVolumeSourceBuilder(this);
    }
    QuobyteVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endQuobyteVolumeSourceExtension() {
      return and();
    }
    
  }
  class APIResourceExtensionNestedImpl<N> extends APIResourceFluentImpl<NamedExtensionFluent.APIResourceExtensionNested<N>> implements NamedExtensionFluent.APIResourceExtensionNested<N>,Nested<N>{
    APIResourceExtensionNestedImpl(APIResource item) {
      this.builder = new APIResourceBuilder(this, item);
    }
    APIResourceExtensionNestedImpl() {
      this.builder = new APIResourceBuilder(this);
    }
    APIResourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAPIResourceExtension() {
      return and();
    }
    
  }
  class ResourceQuotaStatusExtensionNestedImpl<N> extends ResourceQuotaStatusFluentImpl<NamedExtensionFluent.ResourceQuotaStatusExtensionNested<N>> implements NamedExtensionFluent.ResourceQuotaStatusExtensionNested<N>,Nested<N>{
    ResourceQuotaStatusExtensionNestedImpl(ResourceQuotaStatus item) {
      this.builder = new ResourceQuotaStatusBuilder(this, item);
    }
    ResourceQuotaStatusExtensionNestedImpl() {
      this.builder = new ResourceQuotaStatusBuilder(this);
    }
    ResourceQuotaStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endResourceQuotaStatusExtension() {
      return and();
    }
    
  }
  class RawExtensionNestedImpl<N> extends RawExtensionFluentImpl<NamedExtensionFluent.RawExtensionNested<N>> implements NamedExtensionFluent.RawExtensionNested<N>,Nested<N>{
    RawExtensionNestedImpl(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionNestedImpl() {
      this.builder = new RawExtensionBuilder(this);
    }
    RawExtensionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endRawExtension() {
      return and();
    }
    
  }
  class ConfigMapProjectionExtensionNestedImpl<N> extends ConfigMapProjectionFluentImpl<NamedExtensionFluent.ConfigMapProjectionExtensionNested<N>> implements NamedExtensionFluent.ConfigMapProjectionExtensionNested<N>,Nested<N>{
    ConfigMapProjectionExtensionNestedImpl(ConfigMapProjection item) {
      this.builder = new ConfigMapProjectionBuilder(this, item);
    }
    ConfigMapProjectionExtensionNestedImpl() {
      this.builder = new ConfigMapProjectionBuilder(this);
    }
    ConfigMapProjectionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endConfigMapProjectionExtension() {
      return and();
    }
    
  }
  class ScopedResourceSelectorRequirementExtensionNestedImpl<N> extends ScopedResourceSelectorRequirementFluentImpl<NamedExtensionFluent.ScopedResourceSelectorRequirementExtensionNested<N>> implements NamedExtensionFluent.ScopedResourceSelectorRequirementExtensionNested<N>,Nested<N>{
    ScopedResourceSelectorRequirementExtensionNestedImpl(ScopedResourceSelectorRequirement item) {
      this.builder = new ScopedResourceSelectorRequirementBuilder(this, item);
    }
    ScopedResourceSelectorRequirementExtensionNestedImpl() {
      this.builder = new ScopedResourceSelectorRequirementBuilder(this);
    }
    ScopedResourceSelectorRequirementBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endScopedResourceSelectorRequirementExtension() {
      return and();
    }
    
  }
  class NamespaceExtensionNestedImpl<N> extends NamespaceFluentImpl<NamedExtensionFluent.NamespaceExtensionNested<N>> implements NamedExtensionFluent.NamespaceExtensionNested<N>,Nested<N>{
    NamespaceExtensionNestedImpl(Namespace item) {
      this.builder = new NamespaceBuilder(this, item);
    }
    NamespaceExtensionNestedImpl() {
      this.builder = new NamespaceBuilder(this);
    }
    NamespaceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNamespaceExtension() {
      return and();
    }
    
  }
  class GroupVersionKindExtensionNestedImpl<N> extends GroupVersionKindFluentImpl<NamedExtensionFluent.GroupVersionKindExtensionNested<N>> implements NamedExtensionFluent.GroupVersionKindExtensionNested<N>,Nested<N>{
    GroupVersionKindExtensionNestedImpl(GroupVersionKind item) {
      this.builder = new GroupVersionKindBuilder(this, item);
    }
    GroupVersionKindExtensionNestedImpl() {
      this.builder = new GroupVersionKindBuilder(this);
    }
    GroupVersionKindBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endGroupVersionKindExtension() {
      return and();
    }
    
  }
  class ContainerStateTerminatedExtensionNestedImpl<N> extends ContainerStateTerminatedFluentImpl<NamedExtensionFluent.ContainerStateTerminatedExtensionNested<N>> implements NamedExtensionFluent.ContainerStateTerminatedExtensionNested<N>,Nested<N>{
    ContainerStateTerminatedExtensionNestedImpl(ContainerStateTerminated item) {
      this.builder = new ContainerStateTerminatedBuilder(this, item);
    }
    ContainerStateTerminatedExtensionNestedImpl() {
      this.builder = new ContainerStateTerminatedBuilder(this);
    }
    ContainerStateTerminatedBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endContainerStateTerminatedExtension() {
      return and();
    }
    
  }
  class LimitRangeSpecExtensionNestedImpl<N> extends LimitRangeSpecFluentImpl<NamedExtensionFluent.LimitRangeSpecExtensionNested<N>> implements NamedExtensionFluent.LimitRangeSpecExtensionNested<N>,Nested<N>{
    LimitRangeSpecExtensionNestedImpl(LimitRangeSpec item) {
      this.builder = new LimitRangeSpecBuilder(this, item);
    }
    LimitRangeSpecExtensionNestedImpl() {
      this.builder = new LimitRangeSpecBuilder(this);
    }
    LimitRangeSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endLimitRangeSpecExtension() {
      return and();
    }
    
  }
  class ProjectedVolumeSourceExtensionNestedImpl<N> extends ProjectedVolumeSourceFluentImpl<NamedExtensionFluent.ProjectedVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.ProjectedVolumeSourceExtensionNested<N>,Nested<N>{
    ProjectedVolumeSourceExtensionNestedImpl(ProjectedVolumeSource item) {
      this.builder = new ProjectedVolumeSourceBuilder(this, item);
    }
    ProjectedVolumeSourceExtensionNestedImpl() {
      this.builder = new ProjectedVolumeSourceBuilder(this);
    }
    ProjectedVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endProjectedVolumeSourceExtension() {
      return and();
    }
    
  }
  class PodOSExtensionNestedImpl<N> extends PodOSFluentImpl<NamedExtensionFluent.PodOSExtensionNested<N>> implements NamedExtensionFluent.PodOSExtensionNested<N>,Nested<N>{
    PodOSExtensionNestedImpl(PodOS item) {
      this.builder = new PodOSBuilder(this, item);
    }
    PodOSExtensionNestedImpl() {
      this.builder = new PodOSBuilder(this);
    }
    PodOSBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodOSExtension() {
      return and();
    }
    
  }
  class PersistentVolumeClaimStatusExtensionNestedImpl<N> extends PersistentVolumeClaimStatusFluentImpl<NamedExtensionFluent.PersistentVolumeClaimStatusExtensionNested<N>> implements NamedExtensionFluent.PersistentVolumeClaimStatusExtensionNested<N>,Nested<N>{
    PersistentVolumeClaimStatusExtensionNestedImpl(PersistentVolumeClaimStatus item) {
      this.builder = new PersistentVolumeClaimStatusBuilder(this, item);
    }
    PersistentVolumeClaimStatusExtensionNestedImpl() {
      this.builder = new PersistentVolumeClaimStatusBuilder(this);
    }
    PersistentVolumeClaimStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimStatusExtension() {
      return and();
    }
    
  }
  class ContainerStateExtensionNestedImpl<N> extends ContainerStateFluentImpl<NamedExtensionFluent.ContainerStateExtensionNested<N>> implements NamedExtensionFluent.ContainerStateExtensionNested<N>,Nested<N>{
    ContainerStateExtensionNestedImpl(ContainerState item) {
      this.builder = new ContainerStateBuilder(this, item);
    }
    ContainerStateExtensionNestedImpl() {
      this.builder = new ContainerStateBuilder(this);
    }
    ContainerStateBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endContainerStateExtension() {
      return and();
    }
    
  }
  class ServiceSpecExtensionNestedImpl<N> extends ServiceSpecFluentImpl<NamedExtensionFluent.ServiceSpecExtensionNested<N>> implements NamedExtensionFluent.ServiceSpecExtensionNested<N>,Nested<N>{
    ServiceSpecExtensionNestedImpl(ServiceSpec item) {
      this.builder = new ServiceSpecBuilder(this, item);
    }
    ServiceSpecExtensionNestedImpl() {
      this.builder = new ServiceSpecBuilder(this);
    }
    ServiceSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endServiceSpecExtension() {
      return and();
    }
    
  }
  class ServiceAccountTokenProjectionExtensionNestedImpl<N> extends ServiceAccountTokenProjectionFluentImpl<NamedExtensionFluent.ServiceAccountTokenProjectionExtensionNested<N>> implements NamedExtensionFluent.ServiceAccountTokenProjectionExtensionNested<N>,Nested<N>{
    ServiceAccountTokenProjectionExtensionNestedImpl(ServiceAccountTokenProjection item) {
      this.builder = new ServiceAccountTokenProjectionBuilder(this, item);
    }
    ServiceAccountTokenProjectionExtensionNestedImpl() {
      this.builder = new ServiceAccountTokenProjectionBuilder(this);
    }
    ServiceAccountTokenProjectionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endServiceAccountTokenProjectionExtension() {
      return and();
    }
    
  }
  class PhotonPersistentDiskVolumeSourceExtensionNestedImpl<N> extends PhotonPersistentDiskVolumeSourceFluentImpl<NamedExtensionFluent.PhotonPersistentDiskVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.PhotonPersistentDiskVolumeSourceExtensionNested<N>,Nested<N>{
    PhotonPersistentDiskVolumeSourceExtensionNestedImpl(PhotonPersistentDiskVolumeSource item) {
      this.builder = new PhotonPersistentDiskVolumeSourceBuilder(this, item);
    }
    PhotonPersistentDiskVolumeSourceExtensionNestedImpl() {
      this.builder = new PhotonPersistentDiskVolumeSourceBuilder(this);
    }
    PhotonPersistentDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPhotonPersistentDiskVolumeSourceExtension() {
      return and();
    }
    
  }
  class ContainerExtensionNestedImpl<N> extends ContainerFluentImpl<NamedExtensionFluent.ContainerExtensionNested<N>> implements NamedExtensionFluent.ContainerExtensionNested<N>,Nested<N>{
    ContainerExtensionNestedImpl(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerExtensionNestedImpl() {
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endContainerExtension() {
      return and();
    }
    
  }
  class NodeSpecExtensionNestedImpl<N> extends NodeSpecFluentImpl<NamedExtensionFluent.NodeSpecExtensionNested<N>> implements NamedExtensionFluent.NodeSpecExtensionNested<N>,Nested<N>{
    NodeSpecExtensionNestedImpl(NodeSpec item) {
      this.builder = new NodeSpecBuilder(this, item);
    }
    NodeSpecExtensionNestedImpl() {
      this.builder = new NodeSpecBuilder(this);
    }
    NodeSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNodeSpecExtension() {
      return and();
    }
    
  }
  class TypedLocalObjectReferenceExtensionNestedImpl<N> extends TypedLocalObjectReferenceFluentImpl<NamedExtensionFluent.TypedLocalObjectReferenceExtensionNested<N>> implements NamedExtensionFluent.TypedLocalObjectReferenceExtensionNested<N>,Nested<N>{
    TypedLocalObjectReferenceExtensionNestedImpl(TypedLocalObjectReference item) {
      this.builder = new TypedLocalObjectReferenceBuilder(this, item);
    }
    TypedLocalObjectReferenceExtensionNestedImpl() {
      this.builder = new TypedLocalObjectReferenceBuilder(this);
    }
    TypedLocalObjectReferenceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endTypedLocalObjectReferenceExtension() {
      return and();
    }
    
  }
  class FieldsV1ExtensionNestedImpl<N> extends FieldsV1FluentImpl<NamedExtensionFluent.FieldsV1ExtensionNested<N>> implements NamedExtensionFluent.FieldsV1ExtensionNested<N>,Nested<N>{
    FieldsV1ExtensionNestedImpl(FieldsV1 item) {
      this.builder = new FieldsV1Builder(this, item);
    }
    FieldsV1ExtensionNestedImpl() {
      this.builder = new FieldsV1Builder(this);
    }
    FieldsV1Builder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endFieldsV1Extension() {
      return and();
    }
    
  }
  class SecretListExtensionNestedImpl<N> extends SecretListFluentImpl<NamedExtensionFluent.SecretListExtensionNested<N>> implements NamedExtensionFluent.SecretListExtensionNested<N>,Nested<N>{
    SecretListExtensionNestedImpl(SecretList item) {
      this.builder = new SecretListBuilder(this, item);
    }
    SecretListExtensionNestedImpl() {
      this.builder = new SecretListBuilder(this);
    }
    SecretListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endSecretListExtension() {
      return and();
    }
    
  }
  class NodeAddressExtensionNestedImpl<N> extends NodeAddressFluentImpl<NamedExtensionFluent.NodeAddressExtensionNested<N>> implements NamedExtensionFluent.NodeAddressExtensionNested<N>,Nested<N>{
    NodeAddressExtensionNestedImpl(NodeAddress item) {
      this.builder = new NodeAddressBuilder(this, item);
    }
    NodeAddressExtensionNestedImpl() {
      this.builder = new NodeAddressBuilder(this);
    }
    NodeAddressBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNodeAddressExtension() {
      return and();
    }
    
  }
  class PodAffinityExtensionNestedImpl<N> extends PodAffinityFluentImpl<NamedExtensionFluent.PodAffinityExtensionNested<N>> implements NamedExtensionFluent.PodAffinityExtensionNested<N>,Nested<N>{
    PodAffinityExtensionNestedImpl(PodAffinity item) {
      this.builder = new PodAffinityBuilder(this, item);
    }
    PodAffinityExtensionNestedImpl() {
      this.builder = new PodAffinityBuilder(this);
    }
    PodAffinityBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodAffinityExtension() {
      return and();
    }
    
  }
  class ExecEnvVarExtensionNestedImpl<N> extends ExecEnvVarFluentImpl<NamedExtensionFluent.ExecEnvVarExtensionNested<N>> implements NamedExtensionFluent.ExecEnvVarExtensionNested<N>,Nested<N>{
    ExecEnvVarExtensionNestedImpl(ExecEnvVar item) {
      this.builder = new ExecEnvVarBuilder(this, item);
    }
    ExecEnvVarExtensionNestedImpl() {
      this.builder = new ExecEnvVarBuilder(this);
    }
    ExecEnvVarBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endExecEnvVarExtension() {
      return and();
    }
    
  }
  class ServiceExtensionNestedImpl<N> extends ServiceFluentImpl<NamedExtensionFluent.ServiceExtensionNested<N>> implements NamedExtensionFluent.ServiceExtensionNested<N>,Nested<N>{
    ServiceExtensionNestedImpl(Service item) {
      this.builder = new ServiceBuilder(this, item);
    }
    ServiceExtensionNestedImpl() {
      this.builder = new ServiceBuilder(this);
    }
    ServiceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endServiceExtension() {
      return and();
    }
    
  }
  class EventSeriesExtensionNestedImpl<N> extends EventSeriesFluentImpl<NamedExtensionFluent.EventSeriesExtensionNested<N>> implements NamedExtensionFluent.EventSeriesExtensionNested<N>,Nested<N>{
    EventSeriesExtensionNestedImpl(EventSeries item) {
      this.builder = new EventSeriesBuilder(this, item);
    }
    EventSeriesExtensionNestedImpl() {
      this.builder = new EventSeriesBuilder(this);
    }
    EventSeriesBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEventSeriesExtension() {
      return and();
    }
    
  }
  class PodConditionExtensionNestedImpl<N> extends PodConditionFluentImpl<NamedExtensionFluent.PodConditionExtensionNested<N>> implements NamedExtensionFluent.PodConditionExtensionNested<N>,Nested<N>{
    PodConditionExtensionNestedImpl(PodCondition item) {
      this.builder = new PodConditionBuilder(this, item);
    }
    PodConditionExtensionNestedImpl() {
      this.builder = new PodConditionBuilder(this);
    }
    PodConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodConditionExtension() {
      return and();
    }
    
  }
  class TopologySpreadConstraintExtensionNestedImpl<N> extends TopologySpreadConstraintFluentImpl<NamedExtensionFluent.TopologySpreadConstraintExtensionNested<N>> implements NamedExtensionFluent.TopologySpreadConstraintExtensionNested<N>,Nested<N>{
    TopologySpreadConstraintExtensionNestedImpl(TopologySpreadConstraint item) {
      this.builder = new TopologySpreadConstraintBuilder(this, item);
    }
    TopologySpreadConstraintExtensionNestedImpl() {
      this.builder = new TopologySpreadConstraintBuilder(this);
    }
    TopologySpreadConstraintBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endTopologySpreadConstraintExtension() {
      return and();
    }
    
  }
  class ExecActionExtensionNestedImpl<N> extends ExecActionFluentImpl<NamedExtensionFluent.ExecActionExtensionNested<N>> implements NamedExtensionFluent.ExecActionExtensionNested<N>,Nested<N>{
    ExecActionExtensionNestedImpl(ExecAction item) {
      this.builder = new ExecActionBuilder(this, item);
    }
    ExecActionExtensionNestedImpl() {
      this.builder = new ExecActionBuilder(this);
    }
    ExecActionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endExecActionExtension() {
      return and();
    }
    
  }
  class ContainerImageExtensionNestedImpl<N> extends ContainerImageFluentImpl<NamedExtensionFluent.ContainerImageExtensionNested<N>> implements NamedExtensionFluent.ContainerImageExtensionNested<N>,Nested<N>{
    ContainerImageExtensionNestedImpl(ContainerImage item) {
      this.builder = new ContainerImageBuilder(this, item);
    }
    ContainerImageExtensionNestedImpl() {
      this.builder = new ContainerImageBuilder(this);
    }
    ContainerImageBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endContainerImageExtension() {
      return and();
    }
    
  }
  class GroupKindExtensionNestedImpl<N> extends GroupKindFluentImpl<NamedExtensionFluent.GroupKindExtensionNested<N>> implements NamedExtensionFluent.GroupKindExtensionNested<N>,Nested<N>{
    GroupKindExtensionNestedImpl(GroupKind item) {
      this.builder = new GroupKindBuilder(this, item);
    }
    GroupKindExtensionNestedImpl() {
      this.builder = new GroupKindBuilder(this);
    }
    GroupKindBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endGroupKindExtension() {
      return and();
    }
    
  }
  class ReplicationControllerExtensionNestedImpl<N> extends ReplicationControllerFluentImpl<NamedExtensionFluent.ReplicationControllerExtensionNested<N>> implements NamedExtensionFluent.ReplicationControllerExtensionNested<N>,Nested<N>{
    ReplicationControllerExtensionNestedImpl(ReplicationController item) {
      this.builder = new ReplicationControllerBuilder(this, item);
    }
    ReplicationControllerExtensionNestedImpl() {
      this.builder = new ReplicationControllerBuilder(this);
    }
    ReplicationControllerBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endReplicationControllerExtension() {
      return and();
    }
    
  }
  class NodeStatusExtensionNestedImpl<N> extends NodeStatusFluentImpl<NamedExtensionFluent.NodeStatusExtensionNested<N>> implements NamedExtensionFluent.NodeStatusExtensionNested<N>,Nested<N>{
    NodeStatusExtensionNestedImpl(NodeStatus item) {
      this.builder = new NodeStatusBuilder(this, item);
    }
    NodeStatusExtensionNestedImpl() {
      this.builder = new NodeStatusBuilder(this);
    }
    NodeStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNodeStatusExtension() {
      return and();
    }
    
  }
  class ConfigMapListExtensionNestedImpl<N> extends ConfigMapListFluentImpl<NamedExtensionFluent.ConfigMapListExtensionNested<N>> implements NamedExtensionFluent.ConfigMapListExtensionNested<N>,Nested<N>{
    ConfigMapListExtensionNestedImpl(ConfigMapList item) {
      this.builder = new ConfigMapListBuilder(this, item);
    }
    ConfigMapListExtensionNestedImpl() {
      this.builder = new ConfigMapListBuilder(this);
    }
    ConfigMapListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endConfigMapListExtension() {
      return and();
    }
    
  }
  class NodeSelectorExtensionNestedImpl<N> extends NodeSelectorFluentImpl<NamedExtensionFluent.NodeSelectorExtensionNested<N>> implements NamedExtensionFluent.NodeSelectorExtensionNested<N>,Nested<N>{
    NodeSelectorExtensionNestedImpl(NodeSelector item) {
      this.builder = new NodeSelectorBuilder(this, item);
    }
    NodeSelectorExtensionNestedImpl() {
      this.builder = new NodeSelectorBuilder(this);
    }
    NodeSelectorBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNodeSelectorExtension() {
      return and();
    }
    
  }
  class TolerationExtensionNestedImpl<N> extends TolerationFluentImpl<NamedExtensionFluent.TolerationExtensionNested<N>> implements NamedExtensionFluent.TolerationExtensionNested<N>,Nested<N>{
    TolerationExtensionNestedImpl(Toleration item) {
      this.builder = new TolerationBuilder(this, item);
    }
    TolerationExtensionNestedImpl() {
      this.builder = new TolerationBuilder(this);
    }
    TolerationBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endTolerationExtension() {
      return and();
    }
    
  }
  class CephFSPersistentVolumeSourceExtensionNestedImpl<N> extends CephFSPersistentVolumeSourceFluentImpl<NamedExtensionFluent.CephFSPersistentVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.CephFSPersistentVolumeSourceExtensionNested<N>,Nested<N>{
    CephFSPersistentVolumeSourceExtensionNestedImpl(CephFSPersistentVolumeSource item) {
      this.builder = new CephFSPersistentVolumeSourceBuilder(this, item);
    }
    CephFSPersistentVolumeSourceExtensionNestedImpl() {
      this.builder = new CephFSPersistentVolumeSourceBuilder(this);
    }
    CephFSPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endCephFSPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  class PersistentVolumeClaimConditionExtensionNestedImpl<N> extends PersistentVolumeClaimConditionFluentImpl<NamedExtensionFluent.PersistentVolumeClaimConditionExtensionNested<N>> implements NamedExtensionFluent.PersistentVolumeClaimConditionExtensionNested<N>,Nested<N>{
    PersistentVolumeClaimConditionExtensionNestedImpl(PersistentVolumeClaimCondition item) {
      this.builder = new PersistentVolumeClaimConditionBuilder(this, item);
    }
    PersistentVolumeClaimConditionExtensionNestedImpl() {
      this.builder = new PersistentVolumeClaimConditionBuilder(this);
    }
    PersistentVolumeClaimConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimConditionExtension() {
      return and();
    }
    
  }
  class PreferredSchedulingTermExtensionNestedImpl<N> extends PreferredSchedulingTermFluentImpl<NamedExtensionFluent.PreferredSchedulingTermExtensionNested<N>> implements NamedExtensionFluent.PreferredSchedulingTermExtensionNested<N>,Nested<N>{
    PreferredSchedulingTermExtensionNestedImpl(PreferredSchedulingTerm item) {
      this.builder = new PreferredSchedulingTermBuilder(this, item);
    }
    PreferredSchedulingTermExtensionNestedImpl() {
      this.builder = new PreferredSchedulingTermBuilder(this);
    }
    PreferredSchedulingTermBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPreferredSchedulingTermExtension() {
      return and();
    }
    
  }
  class PersistentVolumeListExtensionNestedImpl<N> extends PersistentVolumeListFluentImpl<NamedExtensionFluent.PersistentVolumeListExtensionNested<N>> implements NamedExtensionFluent.PersistentVolumeListExtensionNested<N>,Nested<N>{
    PersistentVolumeListExtensionNestedImpl(PersistentVolumeList item) {
      this.builder = new PersistentVolumeListBuilder(this, item);
    }
    PersistentVolumeListExtensionNestedImpl() {
      this.builder = new PersistentVolumeListBuilder(this);
    }
    PersistentVolumeListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeListExtension() {
      return and();
    }
    
  }
  class PodSchedulingGateExtensionNestedImpl<N> extends PodSchedulingGateFluentImpl<NamedExtensionFluent.PodSchedulingGateExtensionNested<N>> implements NamedExtensionFluent.PodSchedulingGateExtensionNested<N>,Nested<N>{
    PodSchedulingGateExtensionNestedImpl(PodSchedulingGate item) {
      this.builder = new PodSchedulingGateBuilder(this, item);
    }
    PodSchedulingGateExtensionNestedImpl() {
      this.builder = new PodSchedulingGateBuilder(this);
    }
    PodSchedulingGateBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodSchedulingGateExtension() {
      return and();
    }
    
  }
  class PodDNSConfigOptionExtensionNestedImpl<N> extends PodDNSConfigOptionFluentImpl<NamedExtensionFluent.PodDNSConfigOptionExtensionNested<N>> implements NamedExtensionFluent.PodDNSConfigOptionExtensionNested<N>,Nested<N>{
    PodDNSConfigOptionExtensionNestedImpl(PodDNSConfigOption item) {
      this.builder = new PodDNSConfigOptionBuilder(this, item);
    }
    PodDNSConfigOptionExtensionNestedImpl() {
      this.builder = new PodDNSConfigOptionBuilder(this);
    }
    PodDNSConfigOptionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodDNSConfigOptionExtension() {
      return and();
    }
    
  }
  class GCEPersistentDiskVolumeSourceExtensionNestedImpl<N> extends GCEPersistentDiskVolumeSourceFluentImpl<NamedExtensionFluent.GCEPersistentDiskVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.GCEPersistentDiskVolumeSourceExtensionNested<N>,Nested<N>{
    GCEPersistentDiskVolumeSourceExtensionNestedImpl(GCEPersistentDiskVolumeSource item) {
      this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
    }
    GCEPersistentDiskVolumeSourceExtensionNestedImpl() {
      this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
    }
    GCEPersistentDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endGCEPersistentDiskVolumeSourceExtension() {
      return and();
    }
    
  }
  class APIServiceConditionExtensionNestedImpl<N> extends APIServiceConditionFluentImpl<NamedExtensionFluent.APIServiceConditionExtensionNested<N>> implements NamedExtensionFluent.APIServiceConditionExtensionNested<N>,Nested<N>{
    APIServiceConditionExtensionNestedImpl(APIServiceCondition item) {
      this.builder = new APIServiceConditionBuilder(this, item);
    }
    APIServiceConditionExtensionNestedImpl() {
      this.builder = new APIServiceConditionBuilder(this);
    }
    APIServiceConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAPIServiceConditionExtension() {
      return and();
    }
    
  }
  class EventListExtensionNestedImpl<N> extends EventListFluentImpl<NamedExtensionFluent.EventListExtensionNested<N>> implements NamedExtensionFluent.EventListExtensionNested<N>,Nested<N>{
    EventListExtensionNestedImpl(EventList item) {
      this.builder = new EventListBuilder(this, item);
    }
    EventListExtensionNestedImpl() {
      this.builder = new EventListBuilder(this);
    }
    EventListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEventListExtension() {
      return and();
    }
    
  }
  class PodReadinessGateExtensionNestedImpl<N> extends PodReadinessGateFluentImpl<NamedExtensionFluent.PodReadinessGateExtensionNested<N>> implements NamedExtensionFluent.PodReadinessGateExtensionNested<N>,Nested<N>{
    PodReadinessGateExtensionNestedImpl(PodReadinessGate item) {
      this.builder = new PodReadinessGateBuilder(this, item);
    }
    PodReadinessGateExtensionNestedImpl() {
      this.builder = new PodReadinessGateBuilder(this);
    }
    PodReadinessGateBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodReadinessGateExtension() {
      return and();
    }
    
  }
  class ContainerStateWaitingExtensionNestedImpl<N> extends ContainerStateWaitingFluentImpl<NamedExtensionFluent.ContainerStateWaitingExtensionNested<N>> implements NamedExtensionFluent.ContainerStateWaitingExtensionNested<N>,Nested<N>{
    ContainerStateWaitingExtensionNestedImpl(ContainerStateWaiting item) {
      this.builder = new ContainerStateWaitingBuilder(this, item);
    }
    ContainerStateWaitingExtensionNestedImpl() {
      this.builder = new ContainerStateWaitingBuilder(this);
    }
    ContainerStateWaitingBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endContainerStateWaitingExtension() {
      return and();
    }
    
  }
  class VolumeMountExtensionNestedImpl<N> extends VolumeMountFluentImpl<NamedExtensionFluent.VolumeMountExtensionNested<N>> implements NamedExtensionFluent.VolumeMountExtensionNested<N>,Nested<N>{
    VolumeMountExtensionNestedImpl(VolumeMount item) {
      this.builder = new VolumeMountBuilder(this, item);
    }
    VolumeMountExtensionNestedImpl() {
      this.builder = new VolumeMountBuilder(this);
    }
    VolumeMountBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endVolumeMountExtension() {
      return and();
    }
    
  }
  class NamespaceConditionExtensionNestedImpl<N> extends NamespaceConditionFluentImpl<NamedExtensionFluent.NamespaceConditionExtensionNested<N>> implements NamedExtensionFluent.NamespaceConditionExtensionNested<N>,Nested<N>{
    NamespaceConditionExtensionNestedImpl(NamespaceCondition item) {
      this.builder = new NamespaceConditionBuilder(this, item);
    }
    NamespaceConditionExtensionNestedImpl() {
      this.builder = new NamespaceConditionBuilder(this);
    }
    NamespaceConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNamespaceConditionExtension() {
      return and();
    }
    
  }
  class LabelSelectorExtensionNestedImpl<N> extends LabelSelectorFluentImpl<NamedExtensionFluent.LabelSelectorExtensionNested<N>> implements NamedExtensionFluent.LabelSelectorExtensionNested<N>,Nested<N>{
    LabelSelectorExtensionNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorExtensionNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endLabelSelectorExtension() {
      return and();
    }
    
  }
  class StatusCauseExtensionNestedImpl<N> extends StatusCauseFluentImpl<NamedExtensionFluent.StatusCauseExtensionNested<N>> implements NamedExtensionFluent.StatusCauseExtensionNested<N>,Nested<N>{
    StatusCauseExtensionNestedImpl(StatusCause item) {
      this.builder = new StatusCauseBuilder(this, item);
    }
    StatusCauseExtensionNestedImpl() {
      this.builder = new StatusCauseBuilder(this);
    }
    StatusCauseBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endStatusCauseExtension() {
      return and();
    }
    
  }
  class NamedClusterExtensionNestedImpl<N> extends NamedClusterFluentImpl<NamedExtensionFluent.NamedClusterExtensionNested<N>> implements NamedExtensionFluent.NamedClusterExtensionNested<N>,Nested<N>{
    NamedClusterExtensionNestedImpl(NamedCluster item) {
      this.builder = new NamedClusterBuilder(this, item);
    }
    NamedClusterExtensionNestedImpl() {
      this.builder = new NamedClusterBuilder(this);
    }
    NamedClusterBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNamedClusterExtension() {
      return and();
    }
    
  }
  class StatusDetailsExtensionNestedImpl<N> extends StatusDetailsFluentImpl<NamedExtensionFluent.StatusDetailsExtensionNested<N>> implements NamedExtensionFluent.StatusDetailsExtensionNested<N>,Nested<N>{
    StatusDetailsExtensionNestedImpl(StatusDetails item) {
      this.builder = new StatusDetailsBuilder(this, item);
    }
    StatusDetailsExtensionNestedImpl() {
      this.builder = new StatusDetailsBuilder(this);
    }
    StatusDetailsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endStatusDetailsExtension() {
      return and();
    }
    
  }
  class DownwardAPIVolumeFileExtensionNestedImpl<N> extends DownwardAPIVolumeFileFluentImpl<NamedExtensionFluent.DownwardAPIVolumeFileExtensionNested<N>> implements NamedExtensionFluent.DownwardAPIVolumeFileExtensionNested<N>,Nested<N>{
    DownwardAPIVolumeFileExtensionNestedImpl(DownwardAPIVolumeFile item) {
      this.builder = new DownwardAPIVolumeFileBuilder(this, item);
    }
    DownwardAPIVolumeFileExtensionNestedImpl() {
      this.builder = new DownwardAPIVolumeFileBuilder(this);
    }
    DownwardAPIVolumeFileBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endDownwardAPIVolumeFileExtension() {
      return and();
    }
    
  }
  class SeccompProfileExtensionNestedImpl<N> extends SeccompProfileFluentImpl<NamedExtensionFluent.SeccompProfileExtensionNested<N>> implements NamedExtensionFluent.SeccompProfileExtensionNested<N>,Nested<N>{
    SeccompProfileExtensionNestedImpl(SeccompProfile item) {
      this.builder = new SeccompProfileBuilder(this, item);
    }
    SeccompProfileExtensionNestedImpl() {
      this.builder = new SeccompProfileBuilder(this);
    }
    SeccompProfileBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endSeccompProfileExtension() {
      return and();
    }
    
  }
  class SysctlExtensionNestedImpl<N> extends SysctlFluentImpl<NamedExtensionFluent.SysctlExtensionNested<N>> implements NamedExtensionFluent.SysctlExtensionNested<N>,Nested<N>{
    SysctlExtensionNestedImpl(Sysctl item) {
      this.builder = new SysctlBuilder(this, item);
    }
    SysctlExtensionNestedImpl() {
      this.builder = new SysctlBuilder(this);
    }
    SysctlBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endSysctlExtension() {
      return and();
    }
    
  }
  class DeleteOptionsExtensionNestedImpl<N> extends DeleteOptionsFluentImpl<NamedExtensionFluent.DeleteOptionsExtensionNested<N>> implements NamedExtensionFluent.DeleteOptionsExtensionNested<N>,Nested<N>{
    DeleteOptionsExtensionNestedImpl(DeleteOptions item) {
      this.builder = new DeleteOptionsBuilder(this, item);
    }
    DeleteOptionsExtensionNestedImpl() {
      this.builder = new DeleteOptionsBuilder(this);
    }
    DeleteOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endDeleteOptionsExtension() {
      return and();
    }
    
  }
  class StatusExtensionNestedImpl<N> extends StatusFluentImpl<NamedExtensionFluent.StatusExtensionNested<N>> implements NamedExtensionFluent.StatusExtensionNested<N>,Nested<N>{
    StatusExtensionNestedImpl(Status item) {
      this.builder = new StatusBuilder(this, item);
    }
    StatusExtensionNestedImpl() {
      this.builder = new StatusBuilder(this);
    }
    StatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endStatusExtension() {
      return and();
    }
    
  }
  class ContainerStatusExtensionNestedImpl<N> extends ContainerStatusFluentImpl<NamedExtensionFluent.ContainerStatusExtensionNested<N>> implements NamedExtensionFluent.ContainerStatusExtensionNested<N>,Nested<N>{
    ContainerStatusExtensionNestedImpl(ContainerStatus item) {
      this.builder = new ContainerStatusBuilder(this, item);
    }
    ContainerStatusExtensionNestedImpl() {
      this.builder = new ContainerStatusBuilder(this);
    }
    ContainerStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endContainerStatusExtension() {
      return and();
    }
    
  }
  class PodTemplateExtensionNestedImpl<N> extends PodTemplateFluentImpl<NamedExtensionFluent.PodTemplateExtensionNested<N>> implements NamedExtensionFluent.PodTemplateExtensionNested<N>,Nested<N>{
    PodTemplateExtensionNestedImpl(PodTemplate item) {
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateExtensionNestedImpl() {
      this.builder = new PodTemplateBuilder(this);
    }
    PodTemplateBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodTemplateExtension() {
      return and();
    }
    
  }
  class ConfigMapEnvSourceExtensionNestedImpl<N> extends ConfigMapEnvSourceFluentImpl<NamedExtensionFluent.ConfigMapEnvSourceExtensionNested<N>> implements NamedExtensionFluent.ConfigMapEnvSourceExtensionNested<N>,Nested<N>{
    ConfigMapEnvSourceExtensionNestedImpl(ConfigMapEnvSource item) {
      this.builder = new ConfigMapEnvSourceBuilder(this, item);
    }
    ConfigMapEnvSourceExtensionNestedImpl() {
      this.builder = new ConfigMapEnvSourceBuilder(this);
    }
    ConfigMapEnvSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endConfigMapEnvSourceExtension() {
      return and();
    }
    
  }
  class NodeSelectorRequirementExtensionNestedImpl<N> extends NodeSelectorRequirementFluentImpl<NamedExtensionFluent.NodeSelectorRequirementExtensionNested<N>> implements NamedExtensionFluent.NodeSelectorRequirementExtensionNested<N>,Nested<N>{
    NodeSelectorRequirementExtensionNestedImpl(NodeSelectorRequirement item) {
      this.builder = new NodeSelectorRequirementBuilder(this, item);
    }
    NodeSelectorRequirementExtensionNestedImpl() {
      this.builder = new NodeSelectorRequirementBuilder(this);
    }
    NodeSelectorRequirementBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNodeSelectorRequirementExtension() {
      return and();
    }
    
  }
  class TCPSocketActionExtensionNestedImpl<N> extends TCPSocketActionFluentImpl<NamedExtensionFluent.TCPSocketActionExtensionNested<N>> implements NamedExtensionFluent.TCPSocketActionExtensionNested<N>,Nested<N>{
    TCPSocketActionExtensionNestedImpl(TCPSocketAction item) {
      this.builder = new TCPSocketActionBuilder(this, item);
    }
    TCPSocketActionExtensionNestedImpl() {
      this.builder = new TCPSocketActionBuilder(this);
    }
    TCPSocketActionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endTCPSocketActionExtension() {
      return and();
    }
    
  }
  class EventExtensionNestedImpl<N> extends EventFluentImpl<NamedExtensionFluent.EventExtensionNested<N>> implements NamedExtensionFluent.EventExtensionNested<N>,Nested<N>{
    EventExtensionNestedImpl(Event item) {
      this.builder = new EventBuilder(this, item);
    }
    EventExtensionNestedImpl() {
      this.builder = new EventBuilder(this);
    }
    EventBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEventExtension() {
      return and();
    }
    
  }
  class PreferencesExtensionNestedImpl<N> extends PreferencesFluentImpl<NamedExtensionFluent.PreferencesExtensionNested<N>> implements NamedExtensionFluent.PreferencesExtensionNested<N>,Nested<N>{
    PreferencesExtensionNestedImpl(Preferences item) {
      this.builder = new PreferencesBuilder(this, item);
    }
    PreferencesExtensionNestedImpl() {
      this.builder = new PreferencesBuilder(this);
    }
    PreferencesBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPreferencesExtension() {
      return and();
    }
    
  }
  class ObjectFieldSelectorExtensionNestedImpl<N> extends ObjectFieldSelectorFluentImpl<NamedExtensionFluent.ObjectFieldSelectorExtensionNested<N>> implements NamedExtensionFluent.ObjectFieldSelectorExtensionNested<N>,Nested<N>{
    ObjectFieldSelectorExtensionNestedImpl(ObjectFieldSelector item) {
      this.builder = new ObjectFieldSelectorBuilder(this, item);
    }
    ObjectFieldSelectorExtensionNestedImpl() {
      this.builder = new ObjectFieldSelectorBuilder(this);
    }
    ObjectFieldSelectorBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endObjectFieldSelectorExtension() {
      return and();
    }
    
  }
  class PodTemplateListExtensionNestedImpl<N> extends PodTemplateListFluentImpl<NamedExtensionFluent.PodTemplateListExtensionNested<N>> implements NamedExtensionFluent.PodTemplateListExtensionNested<N>,Nested<N>{
    PodTemplateListExtensionNestedImpl(PodTemplateList item) {
      this.builder = new PodTemplateListBuilder(this, item);
    }
    PodTemplateListExtensionNestedImpl() {
      this.builder = new PodTemplateListBuilder(this);
    }
    PodTemplateListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodTemplateListExtension() {
      return and();
    }
    
  }
  class PersistentVolumeExtensionNestedImpl<N> extends PersistentVolumeFluentImpl<NamedExtensionFluent.PersistentVolumeExtensionNested<N>> implements NamedExtensionFluent.PersistentVolumeExtensionNested<N>,Nested<N>{
    PersistentVolumeExtensionNestedImpl(PersistentVolume item) {
      this.builder = new PersistentVolumeBuilder(this, item);
    }
    PersistentVolumeExtensionNestedImpl() {
      this.builder = new PersistentVolumeBuilder(this);
    }
    PersistentVolumeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeExtension() {
      return and();
    }
    
  }
  class CinderVolumeSourceExtensionNestedImpl<N> extends CinderVolumeSourceFluentImpl<NamedExtensionFluent.CinderVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.CinderVolumeSourceExtensionNested<N>,Nested<N>{
    CinderVolumeSourceExtensionNestedImpl(CinderVolumeSource item) {
      this.builder = new CinderVolumeSourceBuilder(this, item);
    }
    CinderVolumeSourceExtensionNestedImpl() {
      this.builder = new CinderVolumeSourceBuilder(this);
    }
    CinderVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endCinderVolumeSourceExtension() {
      return and();
    }
    
  }
  class EndpointAddressExtensionNestedImpl<N> extends EndpointAddressFluentImpl<NamedExtensionFluent.EndpointAddressExtensionNested<N>> implements NamedExtensionFluent.EndpointAddressExtensionNested<N>,Nested<N>{
    EndpointAddressExtensionNestedImpl(EndpointAddress item) {
      this.builder = new EndpointAddressBuilder(this, item);
    }
    EndpointAddressExtensionNestedImpl() {
      this.builder = new EndpointAddressBuilder(this);
    }
    EndpointAddressBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEndpointAddressExtension() {
      return and();
    }
    
  }
  class NodeConfigSourceExtensionNestedImpl<N> extends NodeConfigSourceFluentImpl<NamedExtensionFluent.NodeConfigSourceExtensionNested<N>> implements NamedExtensionFluent.NodeConfigSourceExtensionNested<N>,Nested<N>{
    NodeConfigSourceExtensionNestedImpl(NodeConfigSource item) {
      this.builder = new NodeConfigSourceBuilder(this, item);
    }
    NodeConfigSourceExtensionNestedImpl() {
      this.builder = new NodeConfigSourceBuilder(this);
    }
    NodeConfigSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNodeConfigSourceExtension() {
      return and();
    }
    
  }
  class VsphereVirtualDiskVolumeSourceExtensionNestedImpl<N> extends VsphereVirtualDiskVolumeSourceFluentImpl<NamedExtensionFluent.VsphereVirtualDiskVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.VsphereVirtualDiskVolumeSourceExtensionNested<N>,Nested<N>{
    VsphereVirtualDiskVolumeSourceExtensionNestedImpl(VsphereVirtualDiskVolumeSource item) {
      this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this, item);
    }
    VsphereVirtualDiskVolumeSourceExtensionNestedImpl() {
      this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this);
    }
    VsphereVirtualDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endVsphereVirtualDiskVolumeSourceExtension() {
      return and();
    }
    
  }
  class ObjectMetaExtensionNestedImpl<N> extends ObjectMetaFluentImpl<NamedExtensionFluent.ObjectMetaExtensionNested<N>> implements NamedExtensionFluent.ObjectMetaExtensionNested<N>,Nested<N>{
    ObjectMetaExtensionNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaExtensionNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endObjectMetaExtension() {
      return and();
    }
    
  }
  class PersistentVolumeClaimExtensionNestedImpl<N> extends PersistentVolumeClaimFluentImpl<NamedExtensionFluent.PersistentVolumeClaimExtensionNested<N>> implements NamedExtensionFluent.PersistentVolumeClaimExtensionNested<N>,Nested<N>{
    PersistentVolumeClaimExtensionNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimExtensionNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimExtension() {
      return and();
    }
    
  }
  class LabelSelectorRequirementExtensionNestedImpl<N> extends LabelSelectorRequirementFluentImpl<NamedExtensionFluent.LabelSelectorRequirementExtensionNested<N>> implements NamedExtensionFluent.LabelSelectorRequirementExtensionNested<N>,Nested<N>{
    LabelSelectorRequirementExtensionNestedImpl(LabelSelectorRequirement item) {
      this.builder = new LabelSelectorRequirementBuilder(this, item);
    }
    LabelSelectorRequirementExtensionNestedImpl() {
      this.builder = new LabelSelectorRequirementBuilder(this);
    }
    LabelSelectorRequirementBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endLabelSelectorRequirementExtension() {
      return and();
    }
    
  }
  class GitRepoVolumeSourceExtensionNestedImpl<N> extends GitRepoVolumeSourceFluentImpl<NamedExtensionFluent.GitRepoVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.GitRepoVolumeSourceExtensionNested<N>,Nested<N>{
    GitRepoVolumeSourceExtensionNestedImpl(GitRepoVolumeSource item) {
      this.builder = new GitRepoVolumeSourceBuilder(this, item);
    }
    GitRepoVolumeSourceExtensionNestedImpl() {
      this.builder = new GitRepoVolumeSourceBuilder(this);
    }
    GitRepoVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endGitRepoVolumeSourceExtension() {
      return and();
    }
    
  }
  class GenericKubernetesResourceExtensionNestedImpl<N> extends GenericKubernetesResourceFluentImpl<NamedExtensionFluent.GenericKubernetesResourceExtensionNested<N>> implements NamedExtensionFluent.GenericKubernetesResourceExtensionNested<N>,Nested<N>{
    GenericKubernetesResourceExtensionNestedImpl(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceExtensionNestedImpl() {
      this.builder = new GenericKubernetesResourceBuilder(this);
    }
    GenericKubernetesResourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endGenericKubernetesResourceExtension() {
      return and();
    }
    
  }
  class EndpointsListExtensionNestedImpl<N> extends EndpointsListFluentImpl<NamedExtensionFluent.EndpointsListExtensionNested<N>> implements NamedExtensionFluent.EndpointsListExtensionNested<N>,Nested<N>{
    EndpointsListExtensionNestedImpl(EndpointsList item) {
      this.builder = new EndpointsListBuilder(this, item);
    }
    EndpointsListExtensionNestedImpl() {
      this.builder = new EndpointsListBuilder(this);
    }
    EndpointsListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEndpointsListExtension() {
      return and();
    }
    
  }
  class GroupVersionResourceExtensionNestedImpl<N> extends GroupVersionResourceFluentImpl<NamedExtensionFluent.GroupVersionResourceExtensionNested<N>> implements NamedExtensionFluent.GroupVersionResourceExtensionNested<N>,Nested<N>{
    GroupVersionResourceExtensionNestedImpl(GroupVersionResource item) {
      this.builder = new GroupVersionResourceBuilder(this, item);
    }
    GroupVersionResourceExtensionNestedImpl() {
      this.builder = new GroupVersionResourceBuilder(this);
    }
    GroupVersionResourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endGroupVersionResourceExtension() {
      return and();
    }
    
  }
  class CinderPersistentVolumeSourceExtensionNestedImpl<N> extends CinderPersistentVolumeSourceFluentImpl<NamedExtensionFluent.CinderPersistentVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.CinderPersistentVolumeSourceExtensionNested<N>,Nested<N>{
    CinderPersistentVolumeSourceExtensionNestedImpl(CinderPersistentVolumeSource item) {
      this.builder = new CinderPersistentVolumeSourceBuilder(this, item);
    }
    CinderPersistentVolumeSourceExtensionNestedImpl() {
      this.builder = new CinderPersistentVolumeSourceBuilder(this);
    }
    CinderPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endCinderPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  class TopologySelectorTermExtensionNestedImpl<N> extends TopologySelectorTermFluentImpl<NamedExtensionFluent.TopologySelectorTermExtensionNested<N>> implements NamedExtensionFluent.TopologySelectorTermExtensionNested<N>,Nested<N>{
    TopologySelectorTermExtensionNestedImpl(TopologySelectorTerm item) {
      this.builder = new TopologySelectorTermBuilder(this, item);
    }
    TopologySelectorTermExtensionNestedImpl() {
      this.builder = new TopologySelectorTermBuilder(this);
    }
    TopologySelectorTermBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endTopologySelectorTermExtension() {
      return and();
    }
    
  }
  class OwnerReferenceExtensionNestedImpl<N> extends OwnerReferenceFluentImpl<NamedExtensionFluent.OwnerReferenceExtensionNested<N>> implements NamedExtensionFluent.OwnerReferenceExtensionNested<N>,Nested<N>{
    OwnerReferenceExtensionNestedImpl(OwnerReference item) {
      this.builder = new OwnerReferenceBuilder(this, item);
    }
    OwnerReferenceExtensionNestedImpl() {
      this.builder = new OwnerReferenceBuilder(this);
    }
    OwnerReferenceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endOwnerReferenceExtension() {
      return and();
    }
    
  }
  class StorageOSPersistentVolumeSourceExtensionNestedImpl<N> extends StorageOSPersistentVolumeSourceFluentImpl<NamedExtensionFluent.StorageOSPersistentVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.StorageOSPersistentVolumeSourceExtensionNested<N>,Nested<N>{
    StorageOSPersistentVolumeSourceExtensionNestedImpl(StorageOSPersistentVolumeSource item) {
      this.builder = new StorageOSPersistentVolumeSourceBuilder(this, item);
    }
    StorageOSPersistentVolumeSourceExtensionNestedImpl() {
      this.builder = new StorageOSPersistentVolumeSourceBuilder(this);
    }
    StorageOSPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endStorageOSPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  class EphemeralVolumeSourceExtensionNestedImpl<N> extends EphemeralVolumeSourceFluentImpl<NamedExtensionFluent.EphemeralVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.EphemeralVolumeSourceExtensionNested<N>,Nested<N>{
    EphemeralVolumeSourceExtensionNestedImpl(EphemeralVolumeSource item) {
      this.builder = new EphemeralVolumeSourceBuilder(this, item);
    }
    EphemeralVolumeSourceExtensionNestedImpl() {
      this.builder = new EphemeralVolumeSourceBuilder(this);
    }
    EphemeralVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEphemeralVolumeSourceExtension() {
      return and();
    }
    
  }
  class ReplicationControllerConditionExtensionNestedImpl<N> extends ReplicationControllerConditionFluentImpl<NamedExtensionFluent.ReplicationControllerConditionExtensionNested<N>> implements NamedExtensionFluent.ReplicationControllerConditionExtensionNested<N>,Nested<N>{
    ReplicationControllerConditionExtensionNestedImpl(ReplicationControllerCondition item) {
      this.builder = new ReplicationControllerConditionBuilder(this, item);
    }
    ReplicationControllerConditionExtensionNestedImpl() {
      this.builder = new ReplicationControllerConditionBuilder(this);
    }
    ReplicationControllerConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endReplicationControllerConditionExtension() {
      return and();
    }
    
  }
  class PodAntiAffinityExtensionNestedImpl<N> extends PodAntiAffinityFluentImpl<NamedExtensionFluent.PodAntiAffinityExtensionNested<N>> implements NamedExtensionFluent.PodAntiAffinityExtensionNested<N>,Nested<N>{
    PodAntiAffinityExtensionNestedImpl(PodAntiAffinity item) {
      this.builder = new PodAntiAffinityBuilder(this, item);
    }
    PodAntiAffinityExtensionNestedImpl() {
      this.builder = new PodAntiAffinityBuilder(this);
    }
    PodAntiAffinityBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodAntiAffinityExtension() {
      return and();
    }
    
  }
  class SecurityContextExtensionNestedImpl<N> extends SecurityContextFluentImpl<NamedExtensionFluent.SecurityContextExtensionNested<N>> implements NamedExtensionFluent.SecurityContextExtensionNested<N>,Nested<N>{
    SecurityContextExtensionNestedImpl(SecurityContext item) {
      this.builder = new SecurityContextBuilder(this, item);
    }
    SecurityContextExtensionNestedImpl() {
      this.builder = new SecurityContextBuilder(this);
    }
    SecurityContextBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endSecurityContextExtension() {
      return and();
    }
    
  }
  class ReplicationControllerListExtensionNestedImpl<N> extends ReplicationControllerListFluentImpl<NamedExtensionFluent.ReplicationControllerListExtensionNested<N>> implements NamedExtensionFluent.ReplicationControllerListExtensionNested<N>,Nested<N>{
    ReplicationControllerListExtensionNestedImpl(ReplicationControllerList item) {
      this.builder = new ReplicationControllerListBuilder(this, item);
    }
    ReplicationControllerListExtensionNestedImpl() {
      this.builder = new ReplicationControllerListBuilder(this);
    }
    ReplicationControllerListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endReplicationControllerListExtension() {
      return and();
    }
    
  }
  class ConfigMapVolumeSourceExtensionNestedImpl<N> extends ConfigMapVolumeSourceFluentImpl<NamedExtensionFluent.ConfigMapVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.ConfigMapVolumeSourceExtensionNested<N>,Nested<N>{
    ConfigMapVolumeSourceExtensionNestedImpl(ConfigMapVolumeSource item) {
      this.builder = new ConfigMapVolumeSourceBuilder(this, item);
    }
    ConfigMapVolumeSourceExtensionNestedImpl() {
      this.builder = new ConfigMapVolumeSourceBuilder(this);
    }
    ConfigMapVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endConfigMapVolumeSourceExtension() {
      return and();
    }
    
  }
  class ContainerStateRunningExtensionNestedImpl<N> extends ContainerStateRunningFluentImpl<NamedExtensionFluent.ContainerStateRunningExtensionNested<N>> implements NamedExtensionFluent.ContainerStateRunningExtensionNested<N>,Nested<N>{
    ContainerStateRunningExtensionNestedImpl(ContainerStateRunning item) {
      this.builder = new ContainerStateRunningBuilder(this, item);
    }
    ContainerStateRunningExtensionNestedImpl() {
      this.builder = new ContainerStateRunningBuilder(this);
    }
    ContainerStateRunningBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endContainerStateRunningExtension() {
      return and();
    }
    
  }
  class ComponentStatusListExtensionNestedImpl<N> extends ComponentStatusListFluentImpl<NamedExtensionFluent.ComponentStatusListExtensionNested<N>> implements NamedExtensionFluent.ComponentStatusListExtensionNested<N>,Nested<N>{
    ComponentStatusListExtensionNestedImpl(ComponentStatusList item) {
      this.builder = new ComponentStatusListBuilder(this, item);
    }
    ComponentStatusListExtensionNestedImpl() {
      this.builder = new ComponentStatusListBuilder(this);
    }
    ComponentStatusListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endComponentStatusListExtension() {
      return and();
    }
    
  }
  class FlockerVolumeSourceExtensionNestedImpl<N> extends FlockerVolumeSourceFluentImpl<NamedExtensionFluent.FlockerVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.FlockerVolumeSourceExtensionNested<N>,Nested<N>{
    FlockerVolumeSourceExtensionNestedImpl(FlockerVolumeSource item) {
      this.builder = new FlockerVolumeSourceBuilder(this, item);
    }
    FlockerVolumeSourceExtensionNestedImpl() {
      this.builder = new FlockerVolumeSourceBuilder(this);
    }
    FlockerVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endFlockerVolumeSourceExtension() {
      return and();
    }
    
  }
  class ScaleIOVolumeSourceExtensionNestedImpl<N> extends ScaleIOVolumeSourceFluentImpl<NamedExtensionFluent.ScaleIOVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.ScaleIOVolumeSourceExtensionNested<N>,Nested<N>{
    ScaleIOVolumeSourceExtensionNestedImpl(ScaleIOVolumeSource item) {
      this.builder = new ScaleIOVolumeSourceBuilder(this, item);
    }
    ScaleIOVolumeSourceExtensionNestedImpl() {
      this.builder = new ScaleIOVolumeSourceBuilder(this);
    }
    ScaleIOVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endScaleIOVolumeSourceExtension() {
      return and();
    }
    
  }
  class LimitRangeListExtensionNestedImpl<N> extends LimitRangeListFluentImpl<NamedExtensionFluent.LimitRangeListExtensionNested<N>> implements NamedExtensionFluent.LimitRangeListExtensionNested<N>,Nested<N>{
    LimitRangeListExtensionNestedImpl(LimitRangeList item) {
      this.builder = new LimitRangeListBuilder(this, item);
    }
    LimitRangeListExtensionNestedImpl() {
      this.builder = new LimitRangeListBuilder(this);
    }
    LimitRangeListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endLimitRangeListExtension() {
      return and();
    }
    
  }
  class PodExecOptionsExtensionNestedImpl<N> extends PodExecOptionsFluentImpl<NamedExtensionFluent.PodExecOptionsExtensionNested<N>> implements NamedExtensionFluent.PodExecOptionsExtensionNested<N>,Nested<N>{
    PodExecOptionsExtensionNestedImpl(PodExecOptions item) {
      this.builder = new PodExecOptionsBuilder(this, item);
    }
    PodExecOptionsExtensionNestedImpl() {
      this.builder = new PodExecOptionsBuilder(this);
    }
    PodExecOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodExecOptionsExtension() {
      return and();
    }
    
  }
  class ProbeExtensionNestedImpl<N> extends ProbeFluentImpl<NamedExtensionFluent.ProbeExtensionNested<N>> implements NamedExtensionFluent.ProbeExtensionNested<N>,Nested<N>{
    ProbeExtensionNestedImpl(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeExtensionNestedImpl() {
      this.builder = new ProbeBuilder(this);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endProbeExtension() {
      return and();
    }
    
  }
  class UpdateOptionsExtensionNestedImpl<N> extends UpdateOptionsFluentImpl<NamedExtensionFluent.UpdateOptionsExtensionNested<N>> implements NamedExtensionFluent.UpdateOptionsExtensionNested<N>,Nested<N>{
    UpdateOptionsExtensionNestedImpl(UpdateOptions item) {
      this.builder = new UpdateOptionsBuilder(this, item);
    }
    UpdateOptionsExtensionNestedImpl() {
      this.builder = new UpdateOptionsBuilder(this);
    }
    UpdateOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endUpdateOptionsExtension() {
      return and();
    }
    
  }
  class EndpointsExtensionNestedImpl<N> extends EndpointsFluentImpl<NamedExtensionFluent.EndpointsExtensionNested<N>> implements NamedExtensionFluent.EndpointsExtensionNested<N>,Nested<N>{
    EndpointsExtensionNestedImpl(Endpoints item) {
      this.builder = new EndpointsBuilder(this, item);
    }
    EndpointsExtensionNestedImpl() {
      this.builder = new EndpointsBuilder(this);
    }
    EndpointsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEndpointsExtension() {
      return and();
    }
    
  }
  class NamedExtensionNestedImpl<N> extends NamedExtensionFluentImpl<NamedExtensionFluent.NamedExtensionNested<N>> implements NamedExtensionFluent.NamedExtensionNested<N>,Nested<N>{
    NamedExtensionNestedImpl(NamedExtension item) {
      this.builder = new NamedExtensionBuilder(this, item);
    }
    NamedExtensionNestedImpl() {
      this.builder = new NamedExtensionBuilder(this);
    }
    NamedExtensionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNamedExtension() {
      return and();
    }
    
  }
  class AzureFilePersistentVolumeSourceExtensionNestedImpl<N> extends AzureFilePersistentVolumeSourceFluentImpl<NamedExtensionFluent.AzureFilePersistentVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.AzureFilePersistentVolumeSourceExtensionNested<N>,Nested<N>{
    AzureFilePersistentVolumeSourceExtensionNestedImpl(AzureFilePersistentVolumeSource item) {
      this.builder = new AzureFilePersistentVolumeSourceBuilder(this, item);
    }
    AzureFilePersistentVolumeSourceExtensionNestedImpl() {
      this.builder = new AzureFilePersistentVolumeSourceBuilder(this);
    }
    AzureFilePersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAzureFilePersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  class APIResourceListExtensionNestedImpl<N> extends APIResourceListFluentImpl<NamedExtensionFluent.APIResourceListExtensionNested<N>> implements NamedExtensionFluent.APIResourceListExtensionNested<N>,Nested<N>{
    APIResourceListExtensionNestedImpl(APIResourceList item) {
      this.builder = new APIResourceListBuilder(this, item);
    }
    APIResourceListExtensionNestedImpl() {
      this.builder = new APIResourceListBuilder(this);
    }
    APIResourceListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAPIResourceListExtension() {
      return and();
    }
    
  }
  class APIServiceListExtensionNestedImpl<N> extends APIServiceListFluentImpl<NamedExtensionFluent.APIServiceListExtensionNested<N>> implements NamedExtensionFluent.APIServiceListExtensionNested<N>,Nested<N>{
    APIServiceListExtensionNestedImpl(APIServiceList item) {
      this.builder = new APIServiceListBuilder(this, item);
    }
    APIServiceListExtensionNestedImpl() {
      this.builder = new APIServiceListBuilder(this);
    }
    APIServiceListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAPIServiceListExtension() {
      return and();
    }
    
  }
  class SecretVolumeSourceExtensionNestedImpl<N> extends SecretVolumeSourceFluentImpl<NamedExtensionFluent.SecretVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.SecretVolumeSourceExtensionNested<N>,Nested<N>{
    SecretVolumeSourceExtensionNestedImpl(SecretVolumeSource item) {
      this.builder = new SecretVolumeSourceBuilder(this, item);
    }
    SecretVolumeSourceExtensionNestedImpl() {
      this.builder = new SecretVolumeSourceBuilder(this);
    }
    SecretVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endSecretVolumeSourceExtension() {
      return and();
    }
    
  }
  class PodExtensionNestedImpl<N> extends PodFluentImpl<NamedExtensionFluent.PodExtensionNested<N>> implements NamedExtensionFluent.PodExtensionNested<N>,Nested<N>{
    PodExtensionNestedImpl(Pod item) {
      this.builder = new PodBuilder(this, item);
    }
    PodExtensionNestedImpl() {
      this.builder = new PodBuilder(this);
    }
    PodBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodExtension() {
      return and();
    }
    
  }
  class ClientIPConfigExtensionNestedImpl<N> extends ClientIPConfigFluentImpl<NamedExtensionFluent.ClientIPConfigExtensionNested<N>> implements NamedExtensionFluent.ClientIPConfigExtensionNested<N>,Nested<N>{
    ClientIPConfigExtensionNestedImpl(ClientIPConfig item) {
      this.builder = new ClientIPConfigBuilder(this, item);
    }
    ClientIPConfigExtensionNestedImpl() {
      this.builder = new ClientIPConfigBuilder(this);
    }
    ClientIPConfigBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endClientIPConfigExtension() {
      return and();
    }
    
  }
  class ContextExtensionNestedImpl<N> extends ContextFluentImpl<NamedExtensionFluent.ContextExtensionNested<N>> implements NamedExtensionFluent.ContextExtensionNested<N>,Nested<N>{
    ContextExtensionNestedImpl(Context item) {
      this.builder = new ContextBuilder(this, item);
    }
    ContextExtensionNestedImpl() {
      this.builder = new ContextBuilder(this);
    }
    ContextBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endContextExtension() {
      return and();
    }
    
  }
  class NodeAffinityExtensionNestedImpl<N> extends NodeAffinityFluentImpl<NamedExtensionFluent.NodeAffinityExtensionNested<N>> implements NamedExtensionFluent.NodeAffinityExtensionNested<N>,Nested<N>{
    NodeAffinityExtensionNestedImpl(NodeAffinity item) {
      this.builder = new NodeAffinityBuilder(this, item);
    }
    NodeAffinityExtensionNestedImpl() {
      this.builder = new NodeAffinityBuilder(this);
    }
    NodeAffinityBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNodeAffinityExtension() {
      return and();
    }
    
  }
  class ConfigMapExtensionNestedImpl<N> extends ConfigMapFluentImpl<NamedExtensionFluent.ConfigMapExtensionNested<N>> implements NamedExtensionFluent.ConfigMapExtensionNested<N>,Nested<N>{
    ConfigMapExtensionNestedImpl(ConfigMap item) {
      this.builder = new ConfigMapBuilder(this, item);
    }
    ConfigMapExtensionNestedImpl() {
      this.builder = new ConfigMapBuilder(this);
    }
    ConfigMapBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endConfigMapExtension() {
      return and();
    }
    
  }
  class ContainerPortExtensionNestedImpl<N> extends ContainerPortFluentImpl<NamedExtensionFluent.ContainerPortExtensionNested<N>> implements NamedExtensionFluent.ContainerPortExtensionNested<N>,Nested<N>{
    ContainerPortExtensionNestedImpl(ContainerPort item) {
      this.builder = new ContainerPortBuilder(this, item);
    }
    ContainerPortExtensionNestedImpl() {
      this.builder = new ContainerPortBuilder(this);
    }
    ContainerPortBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endContainerPortExtension() {
      return and();
    }
    
  }
  class ConditionExtensionNestedImpl<N> extends ConditionFluentImpl<NamedExtensionFluent.ConditionExtensionNested<N>> implements NamedExtensionFluent.ConditionExtensionNested<N>,Nested<N>{
    ConditionExtensionNestedImpl(Condition item) {
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionExtensionNestedImpl() {
      this.builder = new ConditionBuilder(this);
    }
    ConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endConditionExtension() {
      return and();
    }
    
  }
  class PodListExtensionNestedImpl<N> extends PodListFluentImpl<NamedExtensionFluent.PodListExtensionNested<N>> implements NamedExtensionFluent.PodListExtensionNested<N>,Nested<N>{
    PodListExtensionNestedImpl(PodList item) {
      this.builder = new PodListBuilder(this, item);
    }
    PodListExtensionNestedImpl() {
      this.builder = new PodListBuilder(this);
    }
    PodListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodListExtension() {
      return and();
    }
    
  }
  class FCVolumeSourceExtensionNestedImpl<N> extends FCVolumeSourceFluentImpl<NamedExtensionFluent.FCVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.FCVolumeSourceExtensionNested<N>,Nested<N>{
    FCVolumeSourceExtensionNestedImpl(FCVolumeSource item) {
      this.builder = new FCVolumeSourceBuilder(this, item);
    }
    FCVolumeSourceExtensionNestedImpl() {
      this.builder = new FCVolumeSourceBuilder(this);
    }
    FCVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endFCVolumeSourceExtension() {
      return and();
    }
    
  }
  class ResourceFieldSelectorExtensionNestedImpl<N> extends ResourceFieldSelectorFluentImpl<NamedExtensionFluent.ResourceFieldSelectorExtensionNested<N>> implements NamedExtensionFluent.ResourceFieldSelectorExtensionNested<N>,Nested<N>{
    ResourceFieldSelectorExtensionNestedImpl(ResourceFieldSelector item) {
      this.builder = new ResourceFieldSelectorBuilder(this, item);
    }
    ResourceFieldSelectorExtensionNestedImpl() {
      this.builder = new ResourceFieldSelectorBuilder(this);
    }
    ResourceFieldSelectorBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endResourceFieldSelectorExtension() {
      return and();
    }
    
  }
  class PersistentVolumeClaimSpecExtensionNestedImpl<N> extends PersistentVolumeClaimSpecFluentImpl<NamedExtensionFluent.PersistentVolumeClaimSpecExtensionNested<N>> implements NamedExtensionFluent.PersistentVolumeClaimSpecExtensionNested<N>,Nested<N>{
    PersistentVolumeClaimSpecExtensionNestedImpl(PersistentVolumeClaimSpec item) {
      this.builder = new PersistentVolumeClaimSpecBuilder(this, item);
    }
    PersistentVolumeClaimSpecExtensionNestedImpl() {
      this.builder = new PersistentVolumeClaimSpecBuilder(this);
    }
    PersistentVolumeClaimSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimSpecExtension() {
      return and();
    }
    
  }
  class LoadBalancerStatusExtensionNestedImpl<N> extends LoadBalancerStatusFluentImpl<NamedExtensionFluent.LoadBalancerStatusExtensionNested<N>> implements NamedExtensionFluent.LoadBalancerStatusExtensionNested<N>,Nested<N>{
    LoadBalancerStatusExtensionNestedImpl(LoadBalancerStatus item) {
      this.builder = new LoadBalancerStatusBuilder(this, item);
    }
    LoadBalancerStatusExtensionNestedImpl() {
      this.builder = new LoadBalancerStatusBuilder(this);
    }
    LoadBalancerStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endLoadBalancerStatusExtension() {
      return and();
    }
    
  }
  class PodSecurityContextExtensionNestedImpl<N> extends PodSecurityContextFluentImpl<NamedExtensionFluent.PodSecurityContextExtensionNested<N>> implements NamedExtensionFluent.PodSecurityContextExtensionNested<N>,Nested<N>{
    PodSecurityContextExtensionNestedImpl(PodSecurityContext item) {
      this.builder = new PodSecurityContextBuilder(this, item);
    }
    PodSecurityContextExtensionNestedImpl() {
      this.builder = new PodSecurityContextBuilder(this);
    }
    PodSecurityContextBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodSecurityContextExtension() {
      return and();
    }
    
  }
  class ScopeSelectorExtensionNestedImpl<N> extends ScopeSelectorFluentImpl<NamedExtensionFluent.ScopeSelectorExtensionNested<N>> implements NamedExtensionFluent.ScopeSelectorExtensionNested<N>,Nested<N>{
    ScopeSelectorExtensionNestedImpl(ScopeSelector item) {
      this.builder = new ScopeSelectorBuilder(this, item);
    }
    ScopeSelectorExtensionNestedImpl() {
      this.builder = new ScopeSelectorBuilder(this);
    }
    ScopeSelectorBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endScopeSelectorExtension() {
      return and();
    }
    
  }
  class DownwardAPIProjectionExtensionNestedImpl<N> extends DownwardAPIProjectionFluentImpl<NamedExtensionFluent.DownwardAPIProjectionExtensionNested<N>> implements NamedExtensionFluent.DownwardAPIProjectionExtensionNested<N>,Nested<N>{
    DownwardAPIProjectionExtensionNestedImpl(DownwardAPIProjection item) {
      this.builder = new DownwardAPIProjectionBuilder(this, item);
    }
    DownwardAPIProjectionExtensionNestedImpl() {
      this.builder = new DownwardAPIProjectionBuilder(this);
    }
    DownwardAPIProjectionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endDownwardAPIProjectionExtension() {
      return and();
    }
    
  }
  class PodAffinityTermExtensionNestedImpl<N> extends PodAffinityTermFluentImpl<NamedExtensionFluent.PodAffinityTermExtensionNested<N>> implements NamedExtensionFluent.PodAffinityTermExtensionNested<N>,Nested<N>{
    PodAffinityTermExtensionNestedImpl(PodAffinityTerm item) {
      this.builder = new PodAffinityTermBuilder(this, item);
    }
    PodAffinityTermExtensionNestedImpl() {
      this.builder = new PodAffinityTermBuilder(this);
    }
    PodAffinityTermBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodAffinityTermExtension() {
      return and();
    }
    
  }
  class APIServiceSpecExtensionNestedImpl<N> extends APIServiceSpecFluentImpl<NamedExtensionFluent.APIServiceSpecExtensionNested<N>> implements NamedExtensionFluent.APIServiceSpecExtensionNested<N>,Nested<N>{
    APIServiceSpecExtensionNestedImpl(APIServiceSpec item) {
      this.builder = new APIServiceSpecBuilder(this, item);
    }
    APIServiceSpecExtensionNestedImpl() {
      this.builder = new APIServiceSpecBuilder(this);
    }
    APIServiceSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAPIServiceSpecExtension() {
      return and();
    }
    
  }
  class ServicePortExtensionNestedImpl<N> extends ServicePortFluentImpl<NamedExtensionFluent.ServicePortExtensionNested<N>> implements NamedExtensionFluent.ServicePortExtensionNested<N>,Nested<N>{
    ServicePortExtensionNestedImpl(ServicePort item) {
      this.builder = new ServicePortBuilder(this, item);
    }
    ServicePortExtensionNestedImpl() {
      this.builder = new ServicePortBuilder(this);
    }
    ServicePortBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endServicePortExtension() {
      return and();
    }
    
  }
  class GroupVersionForDiscoveryExtensionNestedImpl<N> extends GroupVersionForDiscoveryFluentImpl<NamedExtensionFluent.GroupVersionForDiscoveryExtensionNested<N>> implements NamedExtensionFluent.GroupVersionForDiscoveryExtensionNested<N>,Nested<N>{
    GroupVersionForDiscoveryExtensionNestedImpl(GroupVersionForDiscovery item) {
      this.builder = new GroupVersionForDiscoveryBuilder(this, item);
    }
    GroupVersionForDiscoveryExtensionNestedImpl() {
      this.builder = new GroupVersionForDiscoveryBuilder(this);
    }
    GroupVersionForDiscoveryBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endGroupVersionForDiscoveryExtension() {
      return and();
    }
    
  }
  class ClaimSourceExtensionNestedImpl<N> extends ClaimSourceFluentImpl<NamedExtensionFluent.ClaimSourceExtensionNested<N>> implements NamedExtensionFluent.ClaimSourceExtensionNested<N>,Nested<N>{
    ClaimSourceExtensionNestedImpl(ClaimSource item) {
      this.builder = new ClaimSourceBuilder(this, item);
    }
    ClaimSourceExtensionNestedImpl() {
      this.builder = new ClaimSourceBuilder(this);
    }
    ClaimSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endClaimSourceExtension() {
      return and();
    }
    
  }
  class PersistentVolumeClaimSourceExtensionNestedImpl<N> extends PersistentVolumeClaimVolumeSourceFluentImpl<NamedExtensionFluent.PersistentVolumeClaimSourceExtensionNested<N>> implements NamedExtensionFluent.PersistentVolumeClaimSourceExtensionNested<N>,Nested<N>{
    PersistentVolumeClaimSourceExtensionNestedImpl(PersistentVolumeClaimVolumeSource item) {
      this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this, item);
    }
    PersistentVolumeClaimSourceExtensionNestedImpl() {
      this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this);
    }
    PersistentVolumeClaimVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimSourceExtension() {
      return and();
    }
    
  }
  class SessionAffinityConfigExtensionNestedImpl<N> extends SessionAffinityConfigFluentImpl<NamedExtensionFluent.SessionAffinityConfigExtensionNested<N>> implements NamedExtensionFluent.SessionAffinityConfigExtensionNested<N>,Nested<N>{
    SessionAffinityConfigExtensionNestedImpl(SessionAffinityConfig item) {
      this.builder = new SessionAffinityConfigBuilder(this, item);
    }
    SessionAffinityConfigExtensionNestedImpl() {
      this.builder = new SessionAffinityConfigBuilder(this);
    }
    SessionAffinityConfigBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endSessionAffinityConfigExtension() {
      return and();
    }
    
  }
  class ServiceAccountListExtensionNestedImpl<N> extends ServiceAccountListFluentImpl<NamedExtensionFluent.ServiceAccountListExtensionNested<N>> implements NamedExtensionFluent.ServiceAccountListExtensionNested<N>,Nested<N>{
    ServiceAccountListExtensionNestedImpl(ServiceAccountList item) {
      this.builder = new ServiceAccountListBuilder(this, item);
    }
    ServiceAccountListExtensionNestedImpl() {
      this.builder = new ServiceAccountListBuilder(this);
    }
    ServiceAccountListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endServiceAccountListExtension() {
      return and();
    }
    
  }
  class ComponentStatusExtensionNestedImpl<N> extends ComponentStatusFluentImpl<NamedExtensionFluent.ComponentStatusExtensionNested<N>> implements NamedExtensionFluent.ComponentStatusExtensionNested<N>,Nested<N>{
    ComponentStatusExtensionNestedImpl(ComponentStatus item) {
      this.builder = new ComponentStatusBuilder(this, item);
    }
    ComponentStatusExtensionNestedImpl() {
      this.builder = new ComponentStatusBuilder(this);
    }
    ComponentStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endComponentStatusExtension() {
      return and();
    }
    
  }
  class DaemonEndpointExtensionNestedImpl<N> extends DaemonEndpointFluentImpl<NamedExtensionFluent.DaemonEndpointExtensionNested<N>> implements NamedExtensionFluent.DaemonEndpointExtensionNested<N>,Nested<N>{
    DaemonEndpointExtensionNestedImpl(DaemonEndpoint item) {
      this.builder = new DaemonEndpointBuilder(this, item);
    }
    DaemonEndpointExtensionNestedImpl() {
      this.builder = new DaemonEndpointBuilder(this);
    }
    DaemonEndpointBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endDaemonEndpointExtension() {
      return and();
    }
    
  }
  class KeyToPathExtensionNestedImpl<N> extends KeyToPathFluentImpl<NamedExtensionFluent.KeyToPathExtensionNested<N>> implements NamedExtensionFluent.KeyToPathExtensionNested<N>,Nested<N>{
    KeyToPathExtensionNestedImpl(KeyToPath item) {
      this.builder = new KeyToPathBuilder(this, item);
    }
    KeyToPathExtensionNestedImpl() {
      this.builder = new KeyToPathBuilder(this);
    }
    KeyToPathBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endKeyToPathExtension() {
      return and();
    }
    
  }
  class FlexPersistentVolumeSourceExtensionNestedImpl<N> extends FlexPersistentVolumeSourceFluentImpl<NamedExtensionFluent.FlexPersistentVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.FlexPersistentVolumeSourceExtensionNested<N>,Nested<N>{
    FlexPersistentVolumeSourceExtensionNestedImpl(FlexPersistentVolumeSource item) {
      this.builder = new FlexPersistentVolumeSourceBuilder(this, item);
    }
    FlexPersistentVolumeSourceExtensionNestedImpl() {
      this.builder = new FlexPersistentVolumeSourceBuilder(this);
    }
    FlexPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endFlexPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  class NamespaceListExtensionNestedImpl<N> extends NamespaceListFluentImpl<NamedExtensionFluent.NamespaceListExtensionNested<N>> implements NamedExtensionFluent.NamespaceListExtensionNested<N>,Nested<N>{
    NamespaceListExtensionNestedImpl(NamespaceList item) {
      this.builder = new NamespaceListBuilder(this, item);
    }
    NamespaceListExtensionNestedImpl() {
      this.builder = new NamespaceListBuilder(this);
    }
    NamespaceListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNamespaceListExtension() {
      return and();
    }
    
  }
  class PodDNSConfigExtensionNestedImpl<N> extends PodDNSConfigFluentImpl<NamedExtensionFluent.PodDNSConfigExtensionNested<N>> implements NamedExtensionFluent.PodDNSConfigExtensionNested<N>,Nested<N>{
    PodDNSConfigExtensionNestedImpl(PodDNSConfig item) {
      this.builder = new PodDNSConfigBuilder(this, item);
    }
    PodDNSConfigExtensionNestedImpl() {
      this.builder = new PodDNSConfigBuilder(this);
    }
    PodDNSConfigBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodDNSConfigExtension() {
      return and();
    }
    
  }
  class NodeListExtensionNestedImpl<N> extends NodeListFluentImpl<NamedExtensionFluent.NodeListExtensionNested<N>> implements NamedExtensionFluent.NodeListExtensionNested<N>,Nested<N>{
    NodeListExtensionNestedImpl(NodeList item) {
      this.builder = new NodeListBuilder(this, item);
    }
    NodeListExtensionNestedImpl() {
      this.builder = new NodeListBuilder(this);
    }
    NodeListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNodeListExtension() {
      return and();
    }
    
  }
  class BindingExtensionNestedImpl<N> extends BindingFluentImpl<NamedExtensionFluent.BindingExtensionNested<N>> implements NamedExtensionFluent.BindingExtensionNested<N>,Nested<N>{
    BindingExtensionNestedImpl(Binding item) {
      this.builder = new BindingBuilder(this, item);
    }
    BindingExtensionNestedImpl() {
      this.builder = new BindingBuilder(this);
    }
    BindingBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endBindingExtension() {
      return and();
    }
    
  }
  class EnvVarSourceExtensionNestedImpl<N> extends EnvVarSourceFluentImpl<NamedExtensionFluent.EnvVarSourceExtensionNested<N>> implements NamedExtensionFluent.EnvVarSourceExtensionNested<N>,Nested<N>{
    EnvVarSourceExtensionNestedImpl(EnvVarSource item) {
      this.builder = new EnvVarSourceBuilder(this, item);
    }
    EnvVarSourceExtensionNestedImpl() {
      this.builder = new EnvVarSourceBuilder(this);
    }
    EnvVarSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEnvVarSourceExtension() {
      return and();
    }
    
  }
  class VolumeProjectionExtensionNestedImpl<N> extends VolumeProjectionFluentImpl<NamedExtensionFluent.VolumeProjectionExtensionNested<N>> implements NamedExtensionFluent.VolumeProjectionExtensionNested<N>,Nested<N>{
    VolumeProjectionExtensionNestedImpl(VolumeProjection item) {
      this.builder = new VolumeProjectionBuilder(this, item);
    }
    VolumeProjectionExtensionNestedImpl() {
      this.builder = new VolumeProjectionBuilder(this);
    }
    VolumeProjectionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endVolumeProjectionExtension() {
      return and();
    }
    
  }
  class ResourceQuotaExtensionNestedImpl<N> extends ResourceQuotaFluentImpl<NamedExtensionFluent.ResourceQuotaExtensionNested<N>> implements NamedExtensionFluent.ResourceQuotaExtensionNested<N>,Nested<N>{
    ResourceQuotaExtensionNestedImpl(ResourceQuota item) {
      this.builder = new ResourceQuotaBuilder(this, item);
    }
    ResourceQuotaExtensionNestedImpl() {
      this.builder = new ResourceQuotaBuilder(this);
    }
    ResourceQuotaBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endResourceQuotaExtension() {
      return and();
    }
    
  }
  class SecretExtensionNestedImpl<N> extends SecretFluentImpl<NamedExtensionFluent.SecretExtensionNested<N>> implements NamedExtensionFluent.SecretExtensionNested<N>,Nested<N>{
    SecretExtensionNestedImpl(Secret item) {
      this.builder = new SecretBuilder(this, item);
    }
    SecretExtensionNestedImpl() {
      this.builder = new SecretBuilder(this);
    }
    SecretBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endSecretExtension() {
      return and();
    }
    
  }
  class ServiceListExtensionNestedImpl<N> extends ServiceListFluentImpl<NamedExtensionFluent.ServiceListExtensionNested<N>> implements NamedExtensionFluent.ServiceListExtensionNested<N>,Nested<N>{
    ServiceListExtensionNestedImpl(ServiceList item) {
      this.builder = new ServiceListBuilder(this, item);
    }
    ServiceListExtensionNestedImpl() {
      this.builder = new ServiceListBuilder(this);
    }
    ServiceListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endServiceListExtension() {
      return and();
    }
    
  }
  class VolumeNodeAffinityExtensionNestedImpl<N> extends VolumeNodeAffinityFluentImpl<NamedExtensionFluent.VolumeNodeAffinityExtensionNested<N>> implements NamedExtensionFluent.VolumeNodeAffinityExtensionNested<N>,Nested<N>{
    VolumeNodeAffinityExtensionNestedImpl(VolumeNodeAffinity item) {
      this.builder = new VolumeNodeAffinityBuilder(this, item);
    }
    VolumeNodeAffinityExtensionNestedImpl() {
      this.builder = new VolumeNodeAffinityBuilder(this);
    }
    VolumeNodeAffinityBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endVolumeNodeAffinityExtension() {
      return and();
    }
    
  }
  class ResourceQuotaSpecExtensionNestedImpl<N> extends ResourceQuotaSpecFluentImpl<NamedExtensionFluent.ResourceQuotaSpecExtensionNested<N>> implements NamedExtensionFluent.ResourceQuotaSpecExtensionNested<N>,Nested<N>{
    ResourceQuotaSpecExtensionNestedImpl(ResourceQuotaSpec item) {
      this.builder = new ResourceQuotaSpecBuilder(this, item);
    }
    ResourceQuotaSpecExtensionNestedImpl() {
      this.builder = new ResourceQuotaSpecBuilder(this);
    }
    ResourceQuotaSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endResourceQuotaSpecExtension() {
      return and();
    }
    
  }
  class NodeSelectorTermExtensionNestedImpl<N> extends NodeSelectorTermFluentImpl<NamedExtensionFluent.NodeSelectorTermExtensionNested<N>> implements NamedExtensionFluent.NodeSelectorTermExtensionNested<N>,Nested<N>{
    NodeSelectorTermExtensionNestedImpl(NodeSelectorTerm item) {
      this.builder = new NodeSelectorTermBuilder(this, item);
    }
    NodeSelectorTermExtensionNestedImpl() {
      this.builder = new NodeSelectorTermBuilder(this);
    }
    NodeSelectorTermBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNodeSelectorTermExtension() {
      return and();
    }
    
  }
  class ScaleIOPersistentVolumeSourceExtensionNestedImpl<N> extends ScaleIOPersistentVolumeSourceFluentImpl<NamedExtensionFluent.ScaleIOPersistentVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.ScaleIOPersistentVolumeSourceExtensionNested<N>,Nested<N>{
    ScaleIOPersistentVolumeSourceExtensionNestedImpl(ScaleIOPersistentVolumeSource item) {
      this.builder = new ScaleIOPersistentVolumeSourceBuilder(this, item);
    }
    ScaleIOPersistentVolumeSourceExtensionNestedImpl() {
      this.builder = new ScaleIOPersistentVolumeSourceBuilder(this);
    }
    ScaleIOPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endScaleIOPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  class ListOptionsExtensionNestedImpl<N> extends ListOptionsFluentImpl<NamedExtensionFluent.ListOptionsExtensionNested<N>> implements NamedExtensionFluent.ListOptionsExtensionNested<N>,Nested<N>{
    ListOptionsExtensionNestedImpl(ListOptions item) {
      this.builder = new ListOptionsBuilder(this, item);
    }
    ListOptionsExtensionNestedImpl() {
      this.builder = new ListOptionsBuilder(this);
    }
    ListOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endListOptionsExtension() {
      return and();
    }
    
  }
  class WeightedPodAffinityTermExtensionNestedImpl<N> extends WeightedPodAffinityTermFluentImpl<NamedExtensionFluent.WeightedPodAffinityTermExtensionNested<N>> implements NamedExtensionFluent.WeightedPodAffinityTermExtensionNested<N>,Nested<N>{
    WeightedPodAffinityTermExtensionNestedImpl(WeightedPodAffinityTerm item) {
      this.builder = new WeightedPodAffinityTermBuilder(this, item);
    }
    WeightedPodAffinityTermExtensionNestedImpl() {
      this.builder = new WeightedPodAffinityTermBuilder(this);
    }
    WeightedPodAffinityTermBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endWeightedPodAffinityTermExtension() {
      return and();
    }
    
  }
  class TypedObjectReferenceExtensionNestedImpl<N> extends TypedObjectReferenceFluentImpl<NamedExtensionFluent.TypedObjectReferenceExtensionNested<N>> implements NamedExtensionFluent.TypedObjectReferenceExtensionNested<N>,Nested<N>{
    TypedObjectReferenceExtensionNestedImpl(TypedObjectReference item) {
      this.builder = new TypedObjectReferenceBuilder(this, item);
    }
    TypedObjectReferenceExtensionNestedImpl() {
      this.builder = new TypedObjectReferenceBuilder(this);
    }
    TypedObjectReferenceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endTypedObjectReferenceExtension() {
      return and();
    }
    
  }
  class NodeSystemInfoExtensionNestedImpl<N> extends NodeSystemInfoFluentImpl<NamedExtensionFluent.NodeSystemInfoExtensionNested<N>> implements NamedExtensionFluent.NodeSystemInfoExtensionNested<N>,Nested<N>{
    NodeSystemInfoExtensionNestedImpl(NodeSystemInfo item) {
      this.builder = new NodeSystemInfoBuilder(this, item);
    }
    NodeSystemInfoExtensionNestedImpl() {
      this.builder = new NodeSystemInfoBuilder(this);
    }
    NodeSystemInfoBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNodeSystemInfoExtension() {
      return and();
    }
    
  }
  class TopologySelectorLabelRequirementExtensionNestedImpl<N> extends TopologySelectorLabelRequirementFluentImpl<NamedExtensionFluent.TopologySelectorLabelRequirementExtensionNested<N>> implements NamedExtensionFluent.TopologySelectorLabelRequirementExtensionNested<N>,Nested<N>{
    TopologySelectorLabelRequirementExtensionNestedImpl(TopologySelectorLabelRequirement item) {
      this.builder = new TopologySelectorLabelRequirementBuilder(this, item);
    }
    TopologySelectorLabelRequirementExtensionNestedImpl() {
      this.builder = new TopologySelectorLabelRequirementBuilder(this);
    }
    TopologySelectorLabelRequirementBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endTopologySelectorLabelRequirementExtension() {
      return and();
    }
    
  }
  class RBDPersistentVolumeSourceExtensionNestedImpl<N> extends RBDPersistentVolumeSourceFluentImpl<NamedExtensionFluent.RBDPersistentVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.RBDPersistentVolumeSourceExtensionNested<N>,Nested<N>{
    RBDPersistentVolumeSourceExtensionNestedImpl(RBDPersistentVolumeSource item) {
      this.builder = new RBDPersistentVolumeSourceBuilder(this, item);
    }
    RBDPersistentVolumeSourceExtensionNestedImpl() {
      this.builder = new RBDPersistentVolumeSourceBuilder(this);
    }
    RBDPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endRBDPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  class AuthProviderConfigExtensionNestedImpl<N> extends AuthProviderConfigFluentImpl<NamedExtensionFluent.AuthProviderConfigExtensionNested<N>> implements NamedExtensionFluent.AuthProviderConfigExtensionNested<N>,Nested<N>{
    AuthProviderConfigExtensionNestedImpl(AuthProviderConfig item) {
      this.builder = new AuthProviderConfigBuilder(this, item);
    }
    AuthProviderConfigExtensionNestedImpl() {
      this.builder = new AuthProviderConfigBuilder(this);
    }
    AuthProviderConfigBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAuthProviderConfigExtension() {
      return and();
    }
    
  }
  class SELinuxOptionsExtensionNestedImpl<N> extends SELinuxOptionsFluentImpl<NamedExtensionFluent.SELinuxOptionsExtensionNested<N>> implements NamedExtensionFluent.SELinuxOptionsExtensionNested<N>,Nested<N>{
    SELinuxOptionsExtensionNestedImpl(SELinuxOptions item) {
      this.builder = new SELinuxOptionsBuilder(this, item);
    }
    SELinuxOptionsExtensionNestedImpl() {
      this.builder = new SELinuxOptionsBuilder(this);
    }
    SELinuxOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endSELinuxOptionsExtension() {
      return and();
    }
    
  }
  class HostAliasExtensionNestedImpl<N> extends HostAliasFluentImpl<NamedExtensionFluent.HostAliasExtensionNested<N>> implements NamedExtensionFluent.HostAliasExtensionNested<N>,Nested<N>{
    HostAliasExtensionNestedImpl(HostAlias item) {
      this.builder = new HostAliasBuilder(this, item);
    }
    HostAliasExtensionNestedImpl() {
      this.builder = new HostAliasBuilder(this);
    }
    HostAliasBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endHostAliasExtension() {
      return and();
    }
    
  }
  class NodeDaemonEndpointsExtensionNestedImpl<N> extends NodeDaemonEndpointsFluentImpl<NamedExtensionFluent.NodeDaemonEndpointsExtensionNested<N>> implements NamedExtensionFluent.NodeDaemonEndpointsExtensionNested<N>,Nested<N>{
    NodeDaemonEndpointsExtensionNestedImpl(NodeDaemonEndpoints item) {
      this.builder = new NodeDaemonEndpointsBuilder(this, item);
    }
    NodeDaemonEndpointsExtensionNestedImpl() {
      this.builder = new NodeDaemonEndpointsBuilder(this);
    }
    NodeDaemonEndpointsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNodeDaemonEndpointsExtension() {
      return and();
    }
    
  }
  class VolumeDeviceExtensionNestedImpl<N> extends VolumeDeviceFluentImpl<NamedExtensionFluent.VolumeDeviceExtensionNested<N>> implements NamedExtensionFluent.VolumeDeviceExtensionNested<N>,Nested<N>{
    VolumeDeviceExtensionNestedImpl(VolumeDevice item) {
      this.builder = new VolumeDeviceBuilder(this, item);
    }
    VolumeDeviceExtensionNestedImpl() {
      this.builder = new VolumeDeviceBuilder(this);
    }
    VolumeDeviceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endVolumeDeviceExtension() {
      return and();
    }
    
  }
  class CSIVolumeSourceExtensionNestedImpl<N> extends CSIVolumeSourceFluentImpl<NamedExtensionFluent.CSIVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.CSIVolumeSourceExtensionNested<N>,Nested<N>{
    CSIVolumeSourceExtensionNestedImpl(CSIVolumeSource item) {
      this.builder = new CSIVolumeSourceBuilder(this, item);
    }
    CSIVolumeSourceExtensionNestedImpl() {
      this.builder = new CSIVolumeSourceBuilder(this);
    }
    CSIVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endCSIVolumeSourceExtension() {
      return and();
    }
    
  }
  class PersistentVolumeSpecExtensionNestedImpl<N> extends PersistentVolumeSpecFluentImpl<NamedExtensionFluent.PersistentVolumeSpecExtensionNested<N>> implements NamedExtensionFluent.PersistentVolumeSpecExtensionNested<N>,Nested<N>{
    PersistentVolumeSpecExtensionNestedImpl(PersistentVolumeSpec item) {
      this.builder = new PersistentVolumeSpecBuilder(this, item);
    }
    PersistentVolumeSpecExtensionNestedImpl() {
      this.builder = new PersistentVolumeSpecBuilder(this);
    }
    PersistentVolumeSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeSpecExtension() {
      return and();
    }
    
  }
  class NodeExtensionNestedImpl<N> extends NodeFluentImpl<NamedExtensionFluent.NodeExtensionNested<N>> implements NamedExtensionFluent.NodeExtensionNested<N>,Nested<N>{
    NodeExtensionNestedImpl(Node item) {
      this.builder = new NodeBuilder(this, item);
    }
    NodeExtensionNestedImpl() {
      this.builder = new NodeBuilder(this);
    }
    NodeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNodeExtension() {
      return and();
    }
    
  }
  class LifecycleHandlerExtensionNestedImpl<N> extends LifecycleHandlerFluentImpl<NamedExtensionFluent.LifecycleHandlerExtensionNested<N>> implements NamedExtensionFluent.LifecycleHandlerExtensionNested<N>,Nested<N>{
    LifecycleHandlerExtensionNestedImpl(LifecycleHandler item) {
      this.builder = new LifecycleHandlerBuilder(this, item);
    }
    LifecycleHandlerExtensionNestedImpl() {
      this.builder = new LifecycleHandlerBuilder(this);
    }
    LifecycleHandlerBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endLifecycleHandlerExtension() {
      return and();
    }
    
  }
  class VolumeExtensionNestedImpl<N> extends VolumeFluentImpl<NamedExtensionFluent.VolumeExtensionNested<N>> implements NamedExtensionFluent.VolumeExtensionNested<N>,Nested<N>{
    VolumeExtensionNestedImpl(Volume item) {
      this.builder = new VolumeBuilder(this, item);
    }
    VolumeExtensionNestedImpl() {
      this.builder = new VolumeBuilder(this);
    }
    VolumeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endVolumeExtension() {
      return and();
    }
    
  }
  class ClusterExtensionNestedImpl<N> extends ClusterFluentImpl<NamedExtensionFluent.ClusterExtensionNested<N>> implements NamedExtensionFluent.ClusterExtensionNested<N>,Nested<N>{
    ClusterExtensionNestedImpl(Cluster item) {
      this.builder = new ClusterBuilder(this, item);
    }
    ClusterExtensionNestedImpl() {
      this.builder = new ClusterBuilder(this);
    }
    ClusterBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endClusterExtension() {
      return and();
    }
    
  }
  class NFSVolumeSourceExtensionNestedImpl<N> extends NFSVolumeSourceFluentImpl<NamedExtensionFluent.NFSVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.NFSVolumeSourceExtensionNested<N>,Nested<N>{
    NFSVolumeSourceExtensionNestedImpl(NFSVolumeSource item) {
      this.builder = new NFSVolumeSourceBuilder(this, item);
    }
    NFSVolumeSourceExtensionNestedImpl() {
      this.builder = new NFSVolumeSourceBuilder(this);
    }
    NFSVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNFSVolumeSourceExtension() {
      return and();
    }
    
  }
  class StorageOSVolumeSourceExtensionNestedImpl<N> extends StorageOSVolumeSourceFluentImpl<NamedExtensionFluent.StorageOSVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.StorageOSVolumeSourceExtensionNested<N>,Nested<N>{
    StorageOSVolumeSourceExtensionNestedImpl(StorageOSVolumeSource item) {
      this.builder = new StorageOSVolumeSourceBuilder(this, item);
    }
    StorageOSVolumeSourceExtensionNestedImpl() {
      this.builder = new StorageOSVolumeSourceBuilder(this);
    }
    StorageOSVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endStorageOSVolumeSourceExtension() {
      return and();
    }
    
  }
  class PodStatusExtensionNestedImpl<N> extends PodStatusFluentImpl<NamedExtensionFluent.PodStatusExtensionNested<N>> implements NamedExtensionFluent.PodStatusExtensionNested<N>,Nested<N>{
    PodStatusExtensionNestedImpl(PodStatus item) {
      this.builder = new PodStatusBuilder(this, item);
    }
    PodStatusExtensionNestedImpl() {
      this.builder = new PodStatusBuilder(this);
    }
    PodStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodStatusExtension() {
      return and();
    }
    
  }
  class KubernetesListExtensionNestedImpl<N> extends KubernetesListFluentImpl<NamedExtensionFluent.KubernetesListExtensionNested<N>> implements NamedExtensionFluent.KubernetesListExtensionNested<N>,Nested<N>{
    KubernetesListExtensionNestedImpl(KubernetesList item) {
      this.builder = new KubernetesListBuilder(this, item);
    }
    KubernetesListExtensionNestedImpl() {
      this.builder = new KubernetesListBuilder(this);
    }
    KubernetesListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endKubernetesListExtension() {
      return and();
    }
    
  }
  class ExecConfigExtensionNestedImpl<N> extends ExecConfigFluentImpl<NamedExtensionFluent.ExecConfigExtensionNested<N>> implements NamedExtensionFluent.ExecConfigExtensionNested<N>,Nested<N>{
    ExecConfigExtensionNestedImpl(ExecConfig item) {
      this.builder = new ExecConfigBuilder(this, item);
    }
    ExecConfigExtensionNestedImpl() {
      this.builder = new ExecConfigBuilder(this);
    }
    ExecConfigBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endExecConfigExtension() {
      return and();
    }
    
  }
  class PersistentVolumeStatusExtensionNestedImpl<N> extends PersistentVolumeStatusFluentImpl<NamedExtensionFluent.PersistentVolumeStatusExtensionNested<N>> implements NamedExtensionFluent.PersistentVolumeStatusExtensionNested<N>,Nested<N>{
    PersistentVolumeStatusExtensionNestedImpl(PersistentVolumeStatus item) {
      this.builder = new PersistentVolumeStatusBuilder(this, item);
    }
    PersistentVolumeStatusExtensionNestedImpl() {
      this.builder = new PersistentVolumeStatusBuilder(this);
    }
    PersistentVolumeStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeStatusExtension() {
      return and();
    }
    
  }
  class EndpointPortExtensionNestedImpl<N> extends EndpointPortFluentImpl<NamedExtensionFluent.EndpointPortExtensionNested<N>> implements NamedExtensionFluent.EndpointPortExtensionNested<N>,Nested<N>{
    EndpointPortExtensionNestedImpl(EndpointPort item) {
      this.builder = new EndpointPortBuilder(this, item);
    }
    EndpointPortExtensionNestedImpl() {
      this.builder = new EndpointPortBuilder(this);
    }
    EndpointPortBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEndpointPortExtension() {
      return and();
    }
    
  }
  class HTTPHeaderExtensionNestedImpl<N> extends HTTPHeaderFluentImpl<NamedExtensionFluent.HTTPHeaderExtensionNested<N>> implements NamedExtensionFluent.HTTPHeaderExtensionNested<N>,Nested<N>{
    HTTPHeaderExtensionNestedImpl(HTTPHeader item) {
      this.builder = new HTTPHeaderBuilder(this, item);
    }
    HTTPHeaderExtensionNestedImpl() {
      this.builder = new HTTPHeaderBuilder(this);
    }
    HTTPHeaderBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endHTTPHeaderExtension() {
      return and();
    }
    
  }
  class CapabilitiesExtensionNestedImpl<N> extends CapabilitiesFluentImpl<NamedExtensionFluent.CapabilitiesExtensionNested<N>> implements NamedExtensionFluent.CapabilitiesExtensionNested<N>,Nested<N>{
    CapabilitiesExtensionNestedImpl(Capabilities item) {
      this.builder = new CapabilitiesBuilder(this, item);
    }
    CapabilitiesExtensionNestedImpl() {
      this.builder = new CapabilitiesBuilder(this);
    }
    CapabilitiesBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endCapabilitiesExtension() {
      return and();
    }
    
  }
  class ObjectReferenceExtensionNestedImpl<N> extends ObjectReferenceFluentImpl<NamedExtensionFluent.ObjectReferenceExtensionNested<N>> implements NamedExtensionFluent.ObjectReferenceExtensionNested<N>,Nested<N>{
    ObjectReferenceExtensionNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceExtensionNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endObjectReferenceExtension() {
      return and();
    }
    
  }
  class WatchEventExtensionNestedImpl<N> extends WatchEventFluentImpl<NamedExtensionFluent.WatchEventExtensionNested<N>> implements NamedExtensionFluent.WatchEventExtensionNested<N>,Nested<N>{
    WatchEventExtensionNestedImpl(WatchEvent item) {
      this.builder = new WatchEventBuilder(this, item);
    }
    WatchEventExtensionNestedImpl() {
      this.builder = new WatchEventBuilder(this);
    }
    WatchEventBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endWatchEventExtension() {
      return and();
    }
    
  }
  class LimitRangeItemExtensionNestedImpl<N> extends LimitRangeItemFluentImpl<NamedExtensionFluent.LimitRangeItemExtensionNested<N>> implements NamedExtensionFluent.LimitRangeItemExtensionNested<N>,Nested<N>{
    LimitRangeItemExtensionNestedImpl(LimitRangeItem item) {
      this.builder = new LimitRangeItemBuilder(this, item);
    }
    LimitRangeItemExtensionNestedImpl() {
      this.builder = new LimitRangeItemBuilder(this);
    }
    LimitRangeItemBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endLimitRangeItemExtension() {
      return and();
    }
    
  }
  class SecretProjectionExtensionNestedImpl<N> extends SecretProjectionFluentImpl<NamedExtensionFluent.SecretProjectionExtensionNested<N>> implements NamedExtensionFluent.SecretProjectionExtensionNested<N>,Nested<N>{
    SecretProjectionExtensionNestedImpl(SecretProjection item) {
      this.builder = new SecretProjectionBuilder(this, item);
    }
    SecretProjectionExtensionNestedImpl() {
      this.builder = new SecretProjectionBuilder(this);
    }
    SecretProjectionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endSecretProjectionExtension() {
      return and();
    }
    
  }
  class GetOptionsExtensionNestedImpl<N> extends GetOptionsFluentImpl<NamedExtensionFluent.GetOptionsExtensionNested<N>> implements NamedExtensionFluent.GetOptionsExtensionNested<N>,Nested<N>{
    GetOptionsExtensionNestedImpl(GetOptions item) {
      this.builder = new GetOptionsBuilder(this, item);
    }
    GetOptionsExtensionNestedImpl() {
      this.builder = new GetOptionsBuilder(this);
    }
    GetOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endGetOptionsExtension() {
      return and();
    }
    
  }
  class GlusterfsVolumeSourceExtensionNestedImpl<N> extends GlusterfsVolumeSourceFluentImpl<NamedExtensionFluent.GlusterfsVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.GlusterfsVolumeSourceExtensionNested<N>,Nested<N>{
    GlusterfsVolumeSourceExtensionNestedImpl(GlusterfsVolumeSource item) {
      this.builder = new GlusterfsVolumeSourceBuilder(this, item);
    }
    GlusterfsVolumeSourceExtensionNestedImpl() {
      this.builder = new GlusterfsVolumeSourceBuilder(this);
    }
    GlusterfsVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endGlusterfsVolumeSourceExtension() {
      return and();
    }
    
  }
  class ManagedFieldsEntryExtensionNestedImpl<N> extends ManagedFieldsEntryFluentImpl<NamedExtensionFluent.ManagedFieldsEntryExtensionNested<N>> implements NamedExtensionFluent.ManagedFieldsEntryExtensionNested<N>,Nested<N>{
    ManagedFieldsEntryExtensionNestedImpl(ManagedFieldsEntry item) {
      this.builder = new ManagedFieldsEntryBuilder(this, item);
    }
    ManagedFieldsEntryExtensionNestedImpl() {
      this.builder = new ManagedFieldsEntryBuilder(this);
    }
    ManagedFieldsEntryBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endManagedFieldsEntryExtension() {
      return and();
    }
    
  }
  class NamespaceStatusExtensionNestedImpl<N> extends NamespaceStatusFluentImpl<NamedExtensionFluent.NamespaceStatusExtensionNested<N>> implements NamedExtensionFluent.NamespaceStatusExtensionNested<N>,Nested<N>{
    NamespaceStatusExtensionNestedImpl(NamespaceStatus item) {
      this.builder = new NamespaceStatusBuilder(this, item);
    }
    NamespaceStatusExtensionNestedImpl() {
      this.builder = new NamespaceStatusBuilder(this);
    }
    NamespaceStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNamespaceStatusExtension() {
      return and();
    }
    
  }
  class SecretEnvSourceExtensionNestedImpl<N> extends SecretEnvSourceFluentImpl<NamedExtensionFluent.SecretEnvSourceExtensionNested<N>> implements NamedExtensionFluent.SecretEnvSourceExtensionNested<N>,Nested<N>{
    SecretEnvSourceExtensionNestedImpl(SecretEnvSource item) {
      this.builder = new SecretEnvSourceBuilder(this, item);
    }
    SecretEnvSourceExtensionNestedImpl() {
      this.builder = new SecretEnvSourceBuilder(this);
    }
    SecretEnvSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endSecretEnvSourceExtension() {
      return and();
    }
    
  }
  class ServiceAccountExtensionNestedImpl<N> extends ServiceAccountFluentImpl<NamedExtensionFluent.ServiceAccountExtensionNested<N>> implements NamedExtensionFluent.ServiceAccountExtensionNested<N>,Nested<N>{
    ServiceAccountExtensionNestedImpl(ServiceAccount item) {
      this.builder = new ServiceAccountBuilder(this, item);
    }
    ServiceAccountExtensionNestedImpl() {
      this.builder = new ServiceAccountBuilder(this);
    }
    ServiceAccountBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endServiceAccountExtension() {
      return and();
    }
    
  }
  class AWSElasticBlockStoreVolumeSourceExtensionNestedImpl<N> extends AWSElasticBlockStoreVolumeSourceFluentImpl<NamedExtensionFluent.AWSElasticBlockStoreVolumeSourceExtensionNested<N>> implements NamedExtensionFluent.AWSElasticBlockStoreVolumeSourceExtensionNested<N>,Nested<N>{
    AWSElasticBlockStoreVolumeSourceExtensionNestedImpl(AWSElasticBlockStoreVolumeSource item) {
      this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
    }
    AWSElasticBlockStoreVolumeSourceExtensionNestedImpl() {
      this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
    }
    AWSElasticBlockStoreVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAWSElasticBlockStoreVolumeSourceExtension() {
      return and();
    }
    
  }
  class PodIPExtensionNestedImpl<N> extends PodIPFluentImpl<NamedExtensionFluent.PodIPExtensionNested<N>> implements NamedExtensionFluent.PodIPExtensionNested<N>,Nested<N>{
    PodIPExtensionNestedImpl(PodIP item) {
      this.builder = new PodIPBuilder(this, item);
    }
    PodIPExtensionNestedImpl() {
      this.builder = new PodIPBuilder(this);
    }
    PodIPBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodIPExtension() {
      return and();
    }
    
  }
  
}